/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.html;

import com.ecc.ide.builder.Messages;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.html.Browser;
import com.ecc.ide.editor.visualhtml.VisualHtmlFramePanel;
import com.ecc.ide.editor.visualhtml.VisualHtmlSaver;
import com.ecc.ide.editor.visualhtml.XMLToHtmlConvertor;
import com.ecc.ide.editorprofile.EditorProfile;
import java.io.File;
import java.io.FileWriter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class JSPEditPanel
extends Composite {
    Browser browser;
    private VisualHtmlFramePanel visualPanel;
    private XMLNode xmlContent;
    private String rootPath;
    private XMLNode jsFunctionNode;
    private XMLNode dataDictionary;
    private EditorProfile dataProfile;
    private EditorProfile jspFileProfile;
    private XMLNode currentJspNode = null;
    private XMLNode externResourceNode;

    public void setVisualHtmlSaver(VisualHtmlSaver saver) {
        this.visualPanel.setVisualHtmlSaver(saver);
    }

    public JSPEditPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        final TabFolder tabFolder = new TabFolder((Composite)this, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSPEditPanel.this.tabItemChanged(tabFolder.getSelectionIndex());
            }
        });
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("HTMLJSPDefinePanel.design"));
        this.visualPanel = new VisualHtmlFramePanel((Composite)tabFolder, 0);
        tabItem.setControl((Control)this.visualPanel);
        TabItem tabItem_1 = new TabItem(tabFolder, 0);
        tabItem_1.setText(Messages.getString("HTMLJSPDefinePanel.preview"));
        this.browser = new Browser((Composite)tabFolder, 0);
        tabItem_1.setControl((Control)this.browser);
    }

    private void tabItemChanged(int idx) {
        if (idx == 0) {
            return;
        }
        this.previewJSP();
    }

    private void previewJSP() {
        try {
            String classify = null;
            String trxCode = null;
            try {
                trxCode = this.xmlContent.getParent().getParent().getAttrValue("trxCode");
                classify = this.xmlContent.getParent().getParent().getAttrValue("classify");
            }
            catch (Exception exception) {
                // empty catch block
            }
            XMLToHtmlConvertor convertor = new XMLToHtmlConvertor();
            XMLToHtmlConvertor.isPreview = true;
            convertor.setClassify(classify);
            convertor.setJSFunctionNode(this.jsFunctionNode);
            convertor.setRootPath(String.valueOf(this.rootPath) + "/WebContent");
            convertor.setClientOpId(trxCode);
            String htmlContent = convertor.convertXMLNodeToHtml(this.xmlContent);
            String aFileName = "tempFile.jsp";
            String filePath = classify != null && classify.length() > 0 ? String.valueOf(this.rootPath) + "/WebContent/" + classify : String.valueOf(this.rootPath) + "/WebContent";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            FileWriter fw1 = new FileWriter(String.valueOf(filePath) + "/" + aFileName);
            fw1.write(htmlContent);
            fw1.close();
            this.browser.setUrl("file://" + filePath + "/" + aFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setJSPFileEditorProfile(EditorProfile profile) {
        this.jspFileProfile = profile;
        this.visualPanel.setEditorProfile(profile);
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataProfile = profile;
        this.visualPanel.setDataEditorProfile(profile);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.visualPanel.setDataDictionary(node);
    }

    public void setPatternNode(XMLNode node) {
        this.visualPanel.setPatternNode(node);
    }

    public void setPatternProfile(EditorProfile profile) {
        this.visualPanel.setPatternProfile(profile);
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
        this.visualPanel.setRootPath(rootPath);
    }

    public void setJSFunctionNode(XMLNode node) {
        this.jsFunctionNode = node;
        this.visualPanel.setJSFunctionNode(node);
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
        try {
            this.visualPanel.setXMLContent(this.xmlContent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLNode getExternResource() {
        return this.externResourceNode;
    }

    public void setExternResource(XMLNode node) {
        this.visualPanel.setExternResource(node);
        this.externResourceNode = node;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

