/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.html;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.Messages;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.html.JSPEditPanel;
import com.ecc.ide.editor.visualhtml.VisualHtmlSaver;
import com.ecc.ide.editor.visualhtml.XMLToHtmlConvertor;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import com.swtdesigner.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewHTMLJSPDefinePanel
extends Composite {
    protected IProject project;
    private String rootPath;
    private Text templeteText;
    private Text documentText;
    private Text jspFileText;
    private Table jspListTable;
    private XMLNode jsFunctionNode;
    private boolean isJSPPreview = false;
    private int[] weights;
    private XMLNode dataDictionary;
    private EditorProfile dataProfile;
    private EditorProfile jspFileProfile;
    private XMLNode xmlContent;
    private XMLNode currentJspNode = null;
    private XMLNode patternNode;
    private EditorProfile patternProfile;
    private BuildProblemReporter reporter;
    private XMLNode externResourceNode;
    private String htmlTrxFileName;
    static /* synthetic */ Class class$0;

    public void setJSPFileEditorProfile(EditorProfile profile) {
        this.jspFileProfile = profile;
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataProfile = profile;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setPatternNode(XMLNode node) {
        this.patternNode = node;
    }

    public void setPatternProfile(EditorProfile profile) {
        this.patternProfile = profile;
    }

    public NewHTMLJSPDefinePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        this.weights = new int[2];
        this.weights[0] = 1;
        this.weights[1] = 3;
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite.setLayout((Layout)gridLayout_1);
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("HTMLJSPDefinePanel.JSPFileName__2"));
        this.jspFileText = new Text(composite, 2048);
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 230;
        gridData_4.horizontalSpan = 3;
        this.jspFileText.setLayoutData((Object)gridData_4);
        Label label_2 = new Label(composite, 0);
        label_2.setText(Messages.getString("HTMLJSPDefinePanel.Templete__1"));
        this.templeteText = new Text(composite, 2048);
        this.templeteText.setText("dftTemplete.tmp");
        GridData gridData = new GridData(768);
        this.templeteText.setLayoutData((Object)gridData);
        Button button_1 = new Button(composite, 0);
        button_1.setText(">>");
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.selectTemplete();
            }
        });
        Button button_4 = new Button(composite, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.createNewJSPTemplet();
            }
        });
        button_4.setLayoutData((Object)new GridData());
        button_4.setToolTipText(Messages.getString("create_new_JSP_Templet"));
        button_4.setText(Messages.getString("create"));
        Label label_3 = new Label(composite, 0);
        label_3.setText(Messages.getString("HTMLJSPDefinePanel.Document__3"));
        this.documentText = new Text(composite, 2818);
        GridData gridData_6 = new GridData(776);
        gridData_6.heightHint = 40;
        gridData_6.horizontalSpan = 4;
        this.documentText.setLayoutData((Object)gridData_6);
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_7 = new GridData(768);
        gridData_7.horizontalSpan = 4;
        composite_2.setLayoutData((Object)gridData_7);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_2);
        Button button = new Button(composite_2, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.addNewJSPFile();
            }
        });
        button.setText(Messages.getString("HTMLJSPDefinePanel.create_4"));
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.deleteSelectedJSPFile();
            }
        });
        button_2.setText(Messages.getString("HTMLJSPDefinePanel.delete_5"));
        Button button_3 = new Button(composite_2, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.updateSelectedJSP();
            }
        });
        button_3.setText(Messages.getString("HTMLJSPDefinePanel.Update_1"));
        Label label = new Label(composite, 0);
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 4;
        label.setLayoutData((Object)gridData_2);
        label.setText(Messages.getString("JSP_List"));
        this.jspListTable = new Table(composite, 67584);
        this.jspListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.setActivateJSP();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.editJSP(NewHTMLJSPDefinePanel.this.currentJspNode);
            }
        });
        GridData gridData_3 = new GridData(1808);
        gridData_3.horizontalSpan = 4;
        this.jspListTable.setLayoutData((Object)gridData_3);
        this.jspListTable.setLinesVisible(true);
        this.jspListTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.jspListTable, 0);
        tableColumn.setWidth(163);
        tableColumn.setText(Messages.getString("HTMLJSPDefinePanel.JSP_FileName_7"));
        TableColumn tableColumn_2 = new TableColumn(this.jspListTable, 0);
        tableColumn_2.setWidth(256);
        tableColumn_2.setText(Messages.getString("HTMLJSPDefinePanel.document__8"));
        Menu popupmenu = new Menu((Control)this.jspListTable);
        MenuItem newMenuItem = new MenuItem(popupmenu, 64);
        newMenuItem.setText(Messages.getString("Open_with"));
        Menu newMenu = new Menu(popupmenu);
        newMenuItem.setMenu(newMenu);
        MenuItem menuItem_2 = new MenuItem(newMenu, 0);
        menuItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.editJSP(NewHTMLJSPDefinePanel.this.currentJspNode);
            }
        });
        menuItem_2.setText(Messages.getString("System_Editor"));
        MenuItem menuItem_3 = new MenuItem(newMenu, 0);
        menuItem_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm((Shell)NewHTMLJSPDefinePanel.this.getShell(), (String)"Be sure...", (String)Messages.getString("JSP_Edit_MSG"))) {
                    NewHTMLJSPDefinePanel.this.visualEdit(NewHTMLJSPDefinePanel.this.currentJspNode);
                }
            }
        });
        menuItem_3.setText(Messages.getString("IDE_Visual_Editor"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_4 = new MenuItem(popupmenu, 0);
        menuItem_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHTMLJSPDefinePanel.this.deleteSelectedJSPFile();
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.editor.xml.XMLContentPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        menuItem_4.setImage(ResourceManager.getImage(clazz, "/images/delete_edit.gif"));
        menuItem_4.setText(Messages.getString("XMLContentPanel.Delete_8"));
        this.jspListTable.setMenu(popupmenu);
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode jspNode = (XMLNode)childs.elementAt(i);
            if ("jsp".equals(jspNode.getNodeName())) {
                TableItem item = new TableItem(this.jspListTable, 0);
                item.setText(jspNode.getAttrValue("fileName"));
                if (jspNode.getDocument() != null) {
                    item.setText(1, jspNode.getDocument());
                }
                item.setData((Object)jspNode);
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.jspListTable.setSelection(0);
            this.setActivateJSP();
        }
    }

    private void setActivateJSP() {
        TableItem[] items = this.jspListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (node == this.currentJspNode) {
            return;
        }
        this.currentJspNode = node;
        this.jspFileText.setText(node.getAttrValue("fileName"));
        if (node.getDocument() != null) {
            this.documentText.setText(node.getDocument());
        } else {
            this.documentText.setText("");
        }
        if (node.getAttrValue("templetFile") != null) {
            this.templeteText.setText(node.getAttrValue("templetFile"));
        } else {
            this.templeteText.setText("");
        }
    }

    private void addNewJSPFile() {
        String jspFileName = this.jspFileText.getText();
        String templeteName = this.templeteText.getText();
        int idx = jspFileName.toLowerCase().indexOf(".jsp");
        if (jspFileName.length() == 0 || idx == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_input_proper_JSPFileName_2"));
            return;
        }
        if (idx != jspFileName.length() - 4) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_input_proper_JSPFileName_2"));
            return;
        }
        if (templeteName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_select_the_jsp_templete_!_4"));
            return;
        }
        String classify = this.xmlContent.getParent().getAttrValue("classify");
        if (this.xmlContent == null) {
            return;
        }
        Vector childs = this.xmlContent.getChilds();
        int i = 0;
        while (childs != null && i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (jspFileName.equalsIgnoreCase(aNode.getAttrValue("fileName"))) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_3"), (String)Messages.getString("HTMLJSPDefinePanel.duplicated_jspFileName_4"));
                return;
            }
            ++i;
        }
        if (this.checkDuplicatedJSPFileName(jspFileName)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.JSP_file_was_exisit_!_2"));
            return;
        }
        XMLNode jspNode = null;
        String templetFileName = templeteName;
        if ("dftTemplete.tmp".equals(templeteName)) {
            templetFileName = String.valueOf(this.rootPath) + "/designFiles/htmlTrxs/" + templeteName;
            templeteName = "htmlTrxs/" + templeteName;
        } else {
            templetFileName = String.valueOf(this.rootPath) + "/designFiles/" + templeteName;
        }
        try {
            XMLLoader loader = new XMLLoader();
            XMLElementObjectMaker maker = new XMLElementObjectMaker();
            loader.addObjectMaker((ObjectMaker)maker);
            jspNode = (XMLNode)loader.loadXMLFile(templetFileName);
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)(String.valueOf(Messages.getString("HTMLJSPDefinePanel.Invalid_templete_file_!_n_7")) + e));
            return;
        }
        if (jspNode == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Invalid_templete_file_!_8"));
            return;
        }
        jspNode.setAttrValue("fileName", this.jspFileText.getText());
        jspNode.setAttrValue("name", this.jspFileText.getText());
        jspNode.setDocument(this.documentText.getText());
        jspNode.setAttrValue("templetFile", templeteName);
        this.xmlContent.add(jspNode);
        TableItem item = new TableItem(this.jspListTable, 0);
        item.setText(this.jspFileText.getText());
        item.setText(1, this.documentText.getText());
        item.setData((Object)jspNode);
        this.visualEdit(jspNode);
        this.editJSP(jspNode);
    }

    private void updateSelectedJSP() {
        TableItem[] items = this.jspListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        String jspFileName = this.jspFileText.getText();
        int idx = jspFileName.toLowerCase().indexOf(".jsp");
        if (jspFileName.length() == 0 || idx == -1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_input_proper_JSPFileName_2"));
            return;
        }
        if (idx != jspFileName.length() - 4) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)Messages.getString("HTMLJSPDefinePanel.Please_input_proper_JSPFileName_2"));
            return;
        }
        Vector childs = this.xmlContent.getChilds();
        int i = 0;
        while (childs != null && i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (jspFileName.equalsIgnoreCase(aNode.getAttrValue("fileName")) && aNode != node) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_3"), (String)Messages.getString("HTMLJSPDefinePanel.duplicated_jspFileName_4"));
                return;
            }
            ++i;
        }
        jspFileName.equalsIgnoreCase(node.getAttrValue("fileName"));
        String docStr = this.documentText.getText();
        node.setAttrValue("fileName", jspFileName);
        node.setAttrValue("name", jspFileName);
        node.setDocument(docStr);
        items[0].setText(jspFileName);
        items[0].setText(1, docStr);
    }

    private void updateJSPTemplet() {
        TableItem[] items = this.jspListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Are_you_sure..._7"), (String)Messages.getString("HTMLJSPDefinePanel.Aure_you_sure_to_update_content_from_Templet__nit_will_delete_all_changes_to_templet._8"))) {
            return;
        }
        String templetFile = this.templeteText.getText();
        String orgTmpFile = node.getAttrValue("templetFile");
        if (templetFile.length() == 0) {
            templetFile = orgTmpFile;
        }
        if (templetFile == null) {
            return;
        }
        this.updateJSPFromTemplet(templetFile);
        node.setAttrValue("templetFile", templetFile);
    }

    private void updateJSPFromTemplet(String templetFile) {
        XMLNode aNode;
        XMLNode templetNode;
        TableItem[] items = this.jspListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (templetFile == null) {
            return;
        }
        String templetFileName = String.valueOf(this.rootPath) + "/designFiles/" + templetFile;
        try {
            XMLLoader loader = new XMLLoader();
            XMLElementObjectMaker maker = new XMLElementObjectMaker();
            loader.addObjectMaker((ObjectMaker)maker);
            templetNode = (XMLNode)loader.loadXMLFile(templetFileName);
        }
        catch (Exception e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_1"), (String)(String.valueOf(Messages.getString("HTMLJSPDefinePanel.Invalid_templete_file_!_n_7")) + e));
            return;
        }
        Vector childs = (Vector)node.getChilds().clone();
        int i = 0;
        while (i < childs.size()) {
            aNode = (XMLNode)childs.elementAt(i);
            if ("true".equals(aNode.getAttrValue("fromTemplet"))) {
                node.remove(aNode);
            }
            ++i;
        }
        i = 0;
        while (i < templetNode.getChilds().size()) {
            try {
                aNode = (XMLNode)templetNode.getChilds().elementAt(i);
                node.getChilds().insertElementAt(aNode, i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.currentJspNode = null;
        this.setActivateJSP();
    }

    private void deleteSelectedJSPFile() {
        TableItem[] items = this.jspListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Warning_5"), (String)Messages.getString("HTMLJSPDefinePanel.Are_you_sure_to_delete_the_selected_jsp_define__6"))) {
            return;
        }
        this.deleteJSPFile(node.getAttrValue("fileName"));
        this.xmlContent.remove(node);
        items[0].dispose();
        this.jspFileText.setText("");
        this.documentText.setText("");
    }

    private void selectTemplete() {
        String[] extensions = new String[]{"*.tmp"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        if (this.rootPath != null) {
            fileDialog.setFilterPath(String.valueOf(this.rootPath) + "/designFiles");
        } else {
            fileDialog.setFilterPath("./designFiles");
        }
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        fileName = fileName.replace('\\', '/');
        String relPath = String.valueOf(this.rootPath) + "/designFiles/";
        if (!this.checkPath(relPath, fileName)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("HTMLJSPDefinePanel.Error_13"), (String)Messages.getString("HTMLJSPDefinePanel.Please_select_the_JSP_file_from___designFiles___under_project__s_workspace_path_!_14"));
            return;
        }
        int idx = relPath.length();
        this.templeteText.setText(fileName.substring(idx));
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    private void createJSPFile(String fileName) {
        try {
            IFile aFile;
            String filePath;
            String classify = this.xmlContent.getParent().getAttrValue("classify");
            if (classify != null && classify.length() > 0) {
                filePath = String.valueOf(this.rootPath) + "/WebContent/" + classify;
                File file = new File(filePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                filePath = String.valueOf(this.rootPath) + "/WebContent";
            }
            if ((aFile = this.project.getFile(String.valueOf(filePath) + "/" + fileName)).exists()) {
                aFile.setContents((InputStream)new ByteArrayInputStream("empty JSP file!".getBytes()), true, true, null);
            } else {
                aFile.create((InputStream)new ByteArrayInputStream("empty JSP file!".getBytes()), true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteJSPFile(String fileName) {
        try {
            String classify = this.xmlContent.getParent().getAttrValue("classify");
            String filePath = classify != null && classify.length() > 0 ? String.valueOf(this.rootPath) + "/WebContent/" + classify : String.valueOf(this.rootPath) + "/WebContent";
            File file = new File(String.valueOf(filePath) + "/" + fileName);
            file.delete();
            this.project.getFolder("WebContent").refreshLocal(2, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkDuplicatedJSPFileName(String fileName) {
        try {
            String classify = this.xmlContent.getParent().getAttrValue("classify");
            String filePath = classify != null && classify.length() > 0 ? String.valueOf(this.rootPath) + "/WebContent/" + classify : String.valueOf(this.rootPath) + "/WebContent";
            File file = new File(String.valueOf(filePath) + "/" + fileName);
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setJSFunctionNode(XMLNode node) {
        this.jsFunctionNode = node;
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void visualEdit(final XMLNode content) {
        Shell parent = this.getShell();
        final Shell shell = new Shell(parent, 67696);
        shell.setLayout((Layout)new FillLayout());
        String fileName = content.getAttrValue("fileName");
        String classify = this.xmlContent.getParent().getAttrValue("classify");
        String filePath = classify != null && classify.length() > 0 ? "WebContent/" + classify : "WebContent";
        final String ffileName = String.valueOf(filePath) + "/" + fileName;
        shell.setText("JSP Editor -- " + ffileName);
        ContentChangedListener listener = new ContentChangedListener(){

            public void contentChanged(ContentChangedEvent event) {
                try {
                    shell.setText("*JSP Editor -- " + ffileName);
                    content.getParent().fireContentChangedEvent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        content.addContentChangedListener(listener, null, 0);
        JSPEditPanel visualPanel = new JSPEditPanel((Composite)shell, 0);
        visualPanel.setJSPFileEditorProfile(this.jspFileProfile);
        visualPanel.setDataDictionaryEditorProfile(this.dataProfile);
        visualPanel.setDataDictionary(this.dataDictionary);
        visualPanel.setPatternNode(this.patternNode);
        visualPanel.setPatternProfile(this.patternProfile);
        visualPanel.setRootPath(this.rootPath);
        visualPanel.setJSFunctionNode(this.jsFunctionNode);
        visualPanel.setExternResource(this.externResourceNode);
        visualPanel.setVisualHtmlSaver(new VisualHtmlSaver(){

            public void saveFile() {
                NewHTMLJSPDefinePanel.this.saveToJSPFile(content);
                shell.setText("JSP Editor -- " + ffileName);
            }
        });
        try {
            visualPanel.setXMLContent(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Rectangle rect = shell.getDisplay().getBounds();
        rect.x = 20;
        rect.y = 20;
        rect.width -= 40;
        rect.height -= 60;
        shell.setBounds(rect);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        content.removeContentChangedListener(listener);
    }

    private void saveToJSPFile(XMLNode content) {
        try {
            IFile aFile;
            String classify = this.xmlContent.getParent().getAttrValue("classify");
            XMLToHtmlConvertor convertor = new XMLToHtmlConvertor();
            XMLToHtmlConvertor.isPreview = false;
            convertor.setClassify(classify);
            convertor.setJSFunctionNode(this.jsFunctionNode);
            convertor.setRootPath(String.valueOf(this.rootPath) + "/WebContent");
            String trxCode = this.xmlContent.getParent().getAttrValue("trxCode");
            convertor.setClientOpId(trxCode);
            convertor.setHtmlTrxFileName(this.htmlTrxFileName);
            String htmlContent = convertor.convertXMLNodeToHtml(content);
            String aFileName = content.getAttrValue("name");
            String filePath = classify != null && classify.length() > 0 ? "WebContent/" + classify : "WebContent";
            File file = new File(String.valueOf(this.rootPath) + "/" + filePath);
            if (!file.exists()) {
                file.mkdirs();
                this.project.getFolder("WebContent").refreshLocal(2, null);
            }
            if ((aFile = this.project.getFile(String.valueOf(filePath) + "/" + aFileName)).exists()) {
                aFile.setContents((InputStream)new ByteArrayInputStream(htmlContent.getBytes()), true, true, null);
            } else {
                aFile.create((InputStream)new ByteArrayInputStream(htmlContent.getBytes()), true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void editJSP(XMLNode contentNode) {
        if (contentNode == null) {
            return;
        }
        String fileName = contentNode.getAttrValue("fileName");
        String classify = this.xmlContent.getParent().getAttrValue("classify");
        String filePath = classify != null && classify.length() > 0 ? "WebContent/" + classify : "WebContent";
        final String aFileName = String.valueOf(filePath) + "/" + fileName;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IFile file = NewHTMLJSPDefinePanel.this.project.getFile(aFileName);
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.ecc.ide.plugin.editors.jsp.JSPEditor", (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setProject(IProject prj) {
        this.project = prj;
    }

    private void createNewJSPTemplet() {
        try {
            String fileName = this.getJSPTempletFileName();
            if (fileName == null) {
                return;
            }
            String relPath = String.valueOf(this.rootPath) + "/designFiles/";
            String fName = String.valueOf(this.rootPath) + "/" + fileName;
            this.templeteText.setText(fName.substring(relPath.length()));
            IFile file = this.project.getFile(fileName);
            if (!file.exists()) {
                StringBuffer buf = new StringBuffer();
                buf.append("<?xml version=\"1.0\" encoding=\"");
                buf.append(System.getProperty("file.encoding"));
                buf.append("\" ?>\n\n");
                buf.append("<jsp name=\"templete.jsp\" /> \n\n");
                file.create((InputStream)new ByteArrayInputStream(buf.toString().getBytes()), 1, null);
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getJSPTempletFileName() {
        Shell shell = this.getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterExtensions(new String[]{"*.tmp;"});
        String rootPath = this.project.getLocation().toOSString();
        if (rootPath != null) {
            dialog.setFilterPath(rootPath);
        }
        rootPath = rootPath.replace('\\', '/');
        String fileName = null;
        String result = dialog.open();
        if (result != null) {
            fileName = result;
            if (!this.checkPath(rootPath, fileName = fileName.replace('\\', '/'))) {
                fileName = null;
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Please select file from project's workspace path!");
            } else {
                fileName = fileName.substring(rootPath.length());
            }
        }
        return fileName;
    }

    private boolean checkPath(String rootPath, String fileName) {
        int idx = 0;
        int idx1 = rootPath.indexOf(":");
        if (idx1 != -1) {
            char ch1 = rootPath.charAt(0);
            ch1 = Character.toLowerCase(ch1);
            char ch2 = fileName.charAt(0);
            if (ch1 != (ch2 = Character.toLowerCase(ch2))) {
                return false;
            }
            String str1 = rootPath.substring(1);
            String str2 = fileName.substring(1);
            idx = str2.indexOf(str1);
        } else {
            idx = fileName.indexOf(rootPath);
        }
        return idx != -1;
    }

    public XMLNode getExternResource() {
        return this.externResourceNode;
    }

    public void setExternResource(XMLNode node) {
        this.externResourceNode = node;
    }

    public void setHtmlTrxFileName(String htmlTrxFileName) {
        this.htmlTrxFileName = htmlTrxFileName;
    }
}

