/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.jsp;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.jsp.Messages;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TrxMainSettingsPanel
extends Composite {
    private List refJSPList;
    private List refSrvOpList;
    private Text documentText;
    private Text trxNameText;
    private Text trxCodeText;
    private String rootPath;
    private String webContentPath;
    private String jspRootPath;
    private String jspPath;
    private XMLNode xmlContent;

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setWebContentPath(String value) {
        this.webContentPath = value;
    }

    public void setJspRootPath(String value) {
        this.jspRootPath = value;
    }

    public void setJspPath(String value) {
        this.jspPath = value;
    }

    public void setXMLContent(XMLNode node) {
        Vector childs;
        this.xmlContent = node;
        XMLNode jspsNode = node.getChild("jsps");
        String trxName = node.getAttrValue("trxName");
        String trxCode = node.getAttrValue("trxCode");
        String document = node.getDocument();
        if (trxName != null) {
            this.trxNameText.setText(trxName);
        }
        if (trxCode != null) {
            this.trxCodeText.setText(trxCode);
        }
        if (document != null) {
            this.documentText.setText(document);
        }
        if (jspsNode == null) {
            jspsNode = new XMLNode();
            jspsNode.setNodeName("jsps");
            node.add(jspsNode);
            jspsNode.setAttrValue("x", "0");
            jspsNode.setAttrValue("y", "0");
            jspsNode.setAttrValue("width", "900");
            jspsNode.setAttrValue("height", "600");
        }
        if ((childs = jspsNode.getChilds()) == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            String nodeName = aNode.getNodeName();
            if ("refSrvOp".equals(nodeName)) {
                String opName = aNode.getAttrValue("name");
                this.refSrvOpList.add(opName);
                this.refSrvOpList.setData(opName, (Object)aNode);
            } else if ("refJsp".equals(nodeName)) {
                String jspName = aNode.getAttrValue("name");
                this.refJSPList.add(jspName);
                this.refJSPList.setData(jspName, (Object)aNode);
            }
            ++i;
        }
    }

    public TrxMainSettingsPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("HtmlTrxMainPanel.TrxCode__19"));
        this.trxCodeText = new Text(composite, 2048);
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 110;
        this.trxCodeText.setLayoutData((Object)gridData_7);
        this.trxCodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TrxMainSettingsPanel.this.trxCodeText.getText().length() > 0) {
                    TrxMainSettingsPanel.this.xmlContent.setAttrValue("trxCode", TrxMainSettingsPanel.this.trxCodeText.getText());
                } else {
                    TrxMainSettingsPanel.this.xmlContent.setAttrValue("trxCode", null);
                }
            }
        });
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("HtmlTrxMainPanel.TrxName__22"));
        this.trxNameText = new Text(composite, 2048);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 154;
        this.trxNameText.setLayoutData((Object)gridData_2);
        this.trxNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TrxMainSettingsPanel.this.trxNameText.getText().length() > 0) {
                    TrxMainSettingsPanel.this.xmlContent.setAttrValue("trxName", TrxMainSettingsPanel.this.trxNameText.getText());
                } else {
                    TrxMainSettingsPanel.this.xmlContent.setAttrValue("trxName", null);
                }
            }
        });
        Label label_3 = new Label(composite, 0);
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 2;
        label_3.setLayoutData((Object)gridData_3);
        label_3.setText(Messages.getString("HtmlTrxMainPanel.Server_Transaction_reference_23"));
        Label label_4 = new Label(composite, 0);
        GridData gridData_4 = new GridData();
        gridData_4.horizontalSpan = 2;
        label_4.setLayoutData((Object)gridData_4);
        label_4.setText(Messages.getString("HtmlTrxMainPanel.JSPFile_reference_24"));
        this.refSrvOpList = new List(composite, 2048);
        GridData gridData_5 = new GridData(768);
        gridData_5.heightHint = 160;
        gridData_5.horizontalSpan = 2;
        this.refSrvOpList.setLayoutData((Object)gridData_5);
        this.refJSPList = new List(composite, 2048);
        GridData gridData_6 = new GridData(768);
        gridData_6.heightHint = 160;
        gridData_6.horizontalSpan = 2;
        this.refJSPList.setLayoutData((Object)gridData_6);
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData_8 = new GridData(768);
        gridData_8.horizontalSpan = 2;
        composite_1.setLayoutData((Object)gridData_8);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite_1, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxMainSettingsPanel.this.addRefSrvOperation();
            }
        });
        GridData gridData_10 = new GridData();
        gridData_10.widthHint = 80;
        button.setLayoutData((Object)gridData_10);
        button.setText(Messages.getString("HtmlTrxMainPanel.Add_25"));
        Button button_1 = new Button(composite_1, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxMainSettingsPanel.this.deleteRefSrvOperation();
            }
        });
        GridData gridData_11 = new GridData();
        gridData_11.widthHint = 80;
        button_1.setLayoutData((Object)gridData_11);
        button_1.setText(Messages.getString("HtmlTrxMainPanel.Delete_26"));
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_9 = new GridData(768);
        gridData_9.horizontalSpan = 2;
        composite_2.setLayoutData((Object)gridData_9);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_2);
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxMainSettingsPanel.this.addRefJSPFile();
            }
        });
        GridData gridData_12 = new GridData();
        gridData_12.widthHint = 80;
        button_2.setLayoutData((Object)gridData_12);
        button_2.setText(Messages.getString("HtmlTrxMainPanel.Add_27"));
        Button button_3 = new Button(composite_2, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxMainSettingsPanel.this.deleteRefJSPFile();
            }
        });
        GridData gridData_13 = new GridData();
        gridData_13.widthHint = 80;
        button_3.setLayoutData((Object)gridData_13);
        button_3.setText(Messages.getString("HtmlTrxMainPanel.Delete_28"));
        Label label_2 = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label_2.setLayoutData((Object)gridData);
        label_2.setText(Messages.getString("HtmlTrxMainPanel.Document__29"));
        this.documentText = new Text(composite, 2818);
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 4;
        this.documentText.setLayoutData((Object)gridData_1);
        this.documentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TrxMainSettingsPanel.this.xmlContent.setDocument(TrxMainSettingsPanel.this.documentText.getText());
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void addRefSrvOperation() {
        String opName = null;
        String[] extensions = new String[]{"*.mtx"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        System.out.println("RootPath:" + this.rootPath);
        if (this.rootPath != null) {
            fileDialog.setFilterPath(String.valueOf(this.rootPath) + "/designFiles/MCITrxs");
        } else {
            fileDialog.setFilterPath("./designFiles/MCITrxs");
        }
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        try {
            XMLElementObjectMaker maker = new XMLElementObjectMaker();
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)maker);
            XMLNode aNode = (XMLNode)loader.loadXMLFile(fileName);
            if (aNode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide MCI Transaction define file!");
                return;
            }
            String trxCode = aNode.getAttrValue("trxCode");
            if (trxCode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide MCI Transaction define file [trxCode] not defined!");
                return;
            }
            opName = String.valueOf(trxCode) + "SrvOp";
        }
        catch (Exception maker) {
            // empty catch block
        }
        if (opName.length() == 0) {
            return;
        }
        int i = 0;
        while (i < this.refSrvOpList.getItemCount()) {
            if (opName.equals(this.refSrvOpList.getItem(i))) {
                return;
            }
            ++i;
        }
        XMLNode refOpNode = new XMLNode();
        refOpNode.setNodeName("refSrvOp");
        refOpNode.setAttrValue("name", opName);
        fileName = fileName.replace('\\', '/');
        String relPath = this.rootPath;
        if (!this.checkPath(relPath, fileName)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please select the MCI Trx file from project's workspace path!");
            return;
        }
        refOpNode.setAttrValue("fileName", fileName.substring(this.rootPath.length()));
        XMLNode jspsNode = this.xmlContent.getChild("jsps");
        jspsNode.add(refOpNode);
        this.refSrvOpList.add(opName);
        this.refSrvOpList.setData(opName, (Object)refOpNode);
    }

    private void deleteRefSrvOperation() {
        String[] opNames = this.refSrvOpList.getSelection();
        if (opNames.length == 0) {
            return;
        }
        XMLNode refOpNode = (XMLNode)this.refSrvOpList.getData(opNames[0]);
        XMLNode jspsNode = this.xmlContent.getChild("jsps");
        jspsNode.remove(refOpNode);
        this.refSrvOpList.remove(opNames[0]);
    }

    private void addRefJSPFile() {
        String[] extensions = new String[]{"*.jsp"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        System.out.println("RootPath:" + this.rootPath);
        String path = String.valueOf(this.rootPath) + "/" + this.webContentPath;
        if (this.jspRootPath != null && this.jspRootPath.length() > 0) {
            path = String.valueOf(path) + "/" + this.jspRootPath;
        }
        if (this.jspPath != null && this.jspPath.length() > 0) {
            path = String.valueOf(path) + "/" + this.jspPath;
        }
        fileDialog.setFilterPath(path);
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        if (!this.checkPath(path, fileName = fileName.replace('\\', '/'))) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please select the JSP file from project's workspace path!");
            return;
        }
        String relPath = String.valueOf(this.rootPath) + "/" + this.webContentPath;
        String jspName = fileName.substring(relPath.length());
        if (jspName.length() == 0) {
            return;
        }
        int i = 0;
        while (i < this.refJSPList.getItemCount()) {
            if (jspName.equals(this.refJSPList.getItem(i))) {
                return;
            }
            ++i;
        }
        XMLNode refJspNode = new XMLNode();
        refJspNode.setNodeName("refJsp");
        refJspNode.setAttrValue("name", jspName);
        XMLNode jspsNode = this.xmlContent.getChild("jsps");
        jspsNode.add(refJspNode);
        this.refJSPList.add(jspName);
        this.refJSPList.setData(jspName, (Object)refJspNode);
    }

    private void deleteRefJSPFile() {
        String[] jspNames = this.refJSPList.getSelection();
        if (jspNames.length == 0) {
            return;
        }
        XMLNode refJspNode = (XMLNode)this.refJSPList.getData(jspNames[0]);
        XMLNode jspsNode = this.xmlContent.getChild("jsps");
        jspsNode.remove(refJspNode);
        this.refJSPList.remove(jspNames[0]);
    }

    private boolean checkPath(String rootPath, String fileName) {
        int idx = 0;
        int idx1 = rootPath.indexOf(":");
        if (idx1 != -1) {
            char ch1 = rootPath.charAt(0);
            ch1 = Character.toLowerCase(ch1);
            char ch2 = fileName.charAt(0);
            if (ch1 != (ch2 = Character.toLowerCase(ch2))) {
                return false;
            }
            String str1 = rootPath.substring(1);
            String str2 = fileName.substring(1);
            idx = str2.indexOf(str1);
        } else {
            idx = fileName.indexOf(rootPath);
        }
        return idx != -1;
    }
}

