/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import com.ecc.ide.editor.client.teller.ReceiptSelectDialog;
import com.ecc.ide.editor.function.FunctionSelectDialog;
import com.ecc.ide.editor.teller.msr.MSRSelectDialog;
import com.ecc.ide.editor.teller.passbook.PassbookSelectDialog;
import com.ecc.ide.editorprofile.EditorProfile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeviceAccessPropertyPanel
extends Composite {
    private Text documentText;
    private Text deviceFormulaText;
    private Text outputConditionText;
    private Text deviceIDText;
    private Combo deviceTypeCombo;
    private XMLNode deviceAccessNode;
    private XMLNode passbookDefNode;
    private XMLNode msrDefNode;
    private XMLNode receiptDefNode;
    private EditorProfile functionProfile;
    private XMLNode functionNode;

    public DeviceAccessPropertyPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("DeviceAccessPropertyPanel.deviceType"));
        this.deviceTypeCombo = new Combo((Composite)this, 0);
        this.deviceTypeCombo.add(Messages.getString("DeviceAccessPropertyPanel.passbookCover"), 0);
        this.deviceTypeCombo.add(Messages.getString("DeviceAccessPropertyPanel.passbookLine"), 1);
        this.deviceTypeCombo.add(Messages.getString("DeviceAccessPropertyPanel.receipt"), 2);
        this.deviceTypeCombo.add(Messages.getString("DeviceAccessPropertyPanel.MSR"), 3);
        GridData gridData = new GridData();
        gridData.widthHint = 142;
        gridData.horizontalSpan = 2;
        this.deviceTypeCombo.setLayoutData((Object)gridData);
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("DeviceAccessPropertyPanel.deviceId"));
        this.deviceIDText = new Text((Composite)this, 2048);
        this.deviceIDText.setLayoutData((Object)new GridData(768));
        Button button = new Button((Composite)this, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceAccessPropertyPanel.this.selectDeviceId();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 80;
        button.setLayoutData((Object)gridData_2);
        button.setText(Messages.getString("DeviceAccessPropertyPanel.select"));
        Label label_2 = new Label((Composite)this, 0);
        label_2.setLayoutData((Object)new GridData());
        label_2.setText(Messages.getString("DeviceAccessPropertyPanel.outputCondition"));
        this.outputConditionText = new Text((Composite)this, 2048);
        this.outputConditionText.setLayoutData((Object)new GridData(768));
        Button button_1 = new Button((Composite)this, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceAccessPropertyPanel.this.editOutputConditionFormula();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 80;
        button_1.setLayoutData((Object)gridData_3);
        button_1.setText(Messages.getString("DeviceAccessPropertyPanel.function"));
        Label label_3 = new Label((Composite)this, 0);
        label_3.setText(Messages.getString("DeviceAccessPropertyPanel.idFormula"));
        this.deviceFormulaText = new Text((Composite)this, 2048);
        this.deviceFormulaText.setLayoutData((Object)new GridData(768));
        Button button_2 = new Button((Composite)this, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceAccessPropertyPanel.this.editDeviceIdFormula();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_2.setLayoutData((Object)gridData_4);
        button_2.setText(Messages.getString("DeviceAccessPropertyPanel.function"));
        Label label_4 = new Label((Composite)this, 0);
        label_4.setText(Messages.getString("DeviceAccessPropertyPanel.document"));
        this.documentText = new Text((Composite)this, 2818);
        GridData gridData_1 = new GridData(768);
        gridData_1.heightHint = 55;
        gridData_1.widthHint = 137;
        gridData_1.horizontalSpan = 3;
        this.documentText.setLayoutData((Object)gridData_1);
    }

    private void selectDeviceId() {
        int idx = this.deviceTypeCombo.getSelectionIndex();
        if (idx == 0 || idx == 1) {
            PassbookSelectDialog dlg = new PassbookSelectDialog(this.getShell(), 0);
            dlg.setPassbookDefNode(this.passbookDefNode);
            String deviceId = (String)dlg.open();
            if (deviceId != null) {
                this.deviceIDText.setText(deviceId);
            }
        } else if (idx == 2) {
            ReceiptSelectDialog dlg = new ReceiptSelectDialog(this.getShell(), 0);
            dlg.setReceiptDefNode(this.receiptDefNode);
            String deviceId = (String)dlg.open();
            if (deviceId != null) {
                this.deviceIDText.setText(deviceId);
            }
        } else if (idx == 3) {
            MSRSelectDialog dlg = new MSRSelectDialog(this.getShell(), 0);
            dlg.setMsrDefNode(this.msrDefNode);
            String deviceId = (String)dlg.open();
            if (deviceId != null) {
                this.deviceIDText.setText(deviceId);
            }
        }
    }

    private void editOutputConditionFormula() {
        FunctionSelectDialog dlg = new FunctionSelectDialog(this.getShell(), 0);
        dlg.setProfile(this.functionProfile);
        dlg.setFunctionNode(this.functionNode);
        String functionStr = (String)dlg.open();
        if (functionStr != null) {
            this.outputConditionText.insert(functionStr);
        }
    }

    private void editDeviceIdFormula() {
        FunctionSelectDialog dlg = new FunctionSelectDialog(this.getShell(), 0);
        dlg.setProfile(this.functionProfile);
        dlg.setFunctionNode(this.functionNode);
        String functionStr = (String)dlg.open();
        if (functionStr != null) {
            this.outputConditionText.insert(functionStr);
        }
    }

    public void setDeviceAccessNode(XMLNode node) {
        this.deviceAccessNode = node;
        if (this.deviceAccessNode.getAttrValue("type") != null) {
            String type = this.deviceAccessNode.getAttrValue("type");
            if ("passbookCover".equals(type)) {
                this.deviceTypeCombo.select(0);
            } else if ("passbookLine".equals(type)) {
                this.deviceTypeCombo.select(1);
            } else if ("receipt".equals(type)) {
                this.deviceTypeCombo.select(2);
            } else if ("MSR".equals(type)) {
                this.deviceTypeCombo.select(3);
            }
        }
        if (this.deviceAccessNode.getAttrValue("refId") != null) {
            this.deviceIDText.setText(this.deviceAccessNode.getAttrValue("refId"));
        }
        if (this.deviceAccessNode.getAttrValue("condition") != null) {
            this.outputConditionText.setText(this.deviceAccessNode.getAttrValue("condition"));
        }
        if (this.deviceAccessNode.getAttrValue("deviceIDFormula") != null) {
            this.deviceFormulaText.setText(this.deviceAccessNode.getAttrValue("deviceIDFormula"));
        }
        if (this.deviceAccessNode.getDocument() != null) {
            this.documentText.setText(this.deviceAccessNode.getDocument());
        }
    }

    public XMLNode getDeviceAccessNode() {
        String[] types = new String[]{"passbookCover", "passbookLine", "receipt", "MSR"};
        String type = "receipt";
        if (this.deviceTypeCombo.getSelectionIndex() != -1) {
            type = types[this.deviceTypeCombo.getSelectionIndex()];
        }
        this.deviceAccessNode.setAttrValue("type", type);
        this.deviceAccessNode.setAttrValue("refId", this.deviceIDText.getText());
        this.deviceAccessNode.setAttrValue("condition", this.outputConditionText.getText());
        this.deviceAccessNode.setAttrValue("deviceIDFormula", this.deviceFormulaText.getText());
        this.deviceAccessNode.setDocument(this.documentText.getText());
        return this.deviceAccessNode;
    }

    public void setMsrDefNode(XMLNode msrDefNode) {
        this.msrDefNode = msrDefNode;
    }

    public void setPassbookDefNode(XMLNode passbookDefNode) {
        this.passbookDefNode = passbookDefNode;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setFunctionNode(XMLNode functionNode) {
        this.functionNode = functionNode;
    }

    public void setFunctionProfile(EditorProfile functionProfile) {
        this.functionProfile = functionProfile;
    }

    public void setReceiptDefNode(XMLNode node) {
        this.receiptDefNode = node;
    }
}

