/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import com.ecc.ide.editor.client.teller.ServerDataPanel;
import com.ecc.ide.editor.client.teller.ViewFormulaEditorPanel;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LinkBeanEditPanel
extends Composite {
    private Text trxCodeText;
    private Combo linkEventCombo;
    private Combo linkPointCombo;
    private XMLNode refDataNode;
    private XMLNode trxDataNode;
    private XMLNode dataDictionary;
    private EditorProfile viewProfile;
    private XMLNode viewNode;
    private String trxFileName;
    private String rootPath;
    private XMLNode functionNode;
    private XMLNode linkBeanNode;
    private boolean linkToTrx = true;
    private ServerDataPanel linkOutDataPanel;
    private ServerDataPanel linkInDataPanel;
    private ViewFormulaEditorPanel formulaPanel;
    private Composite LinkTrxComposite;
    private Button needInputViewButton;
    private Button needOutputViewButton;
    private Button linkToFormulaButton;
    private Button linkToTrxButton;
    final StackLayout stackLayout;

    public LinkBeanEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("LinkBeanEditPanel.LinkPoint__1"));
        this.linkPointCombo = new Combo((Composite)this, 0);
        this.linkPointCombo.setLayoutData((Object)new GridData(768));
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("LinkBeanEditPanel.LinkEvent__2"));
        this.linkEventCombo = new Combo((Composite)this, 0);
        this.linkEventCombo.setItems(new String[]{"VALUECHANGED", "OUT", "SELECT", "OPENED", "ALLFIELDOUT", "KEYPRESSED", "BEFORESUBMIT", "AFTERSUBMIT", "BEFORECLOSE"});
        this.linkToTrxButton = new Button((Composite)this, 16);
        this.linkToTrxButton.setSelection(true);
        this.linkToTrxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkBeanEditPanel.this.LinkTrxComposite.setVisible(true);
                LinkBeanEditPanel.this.formulaPanel.setVisible(false);
                LinkBeanEditPanel.this.linkToTrx = true;
            }
        });
        this.linkToTrxButton.setText(Messages.getString("LinkBeanEditPanel.Link_To_Transaction_3"));
        this.linkToFormulaButton = new Button((Composite)this, 16);
        this.linkToFormulaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkBeanEditPanel.this.LinkTrxComposite.setVisible(false);
                LinkBeanEditPanel.this.formulaPanel.setVisible(true);
                LinkBeanEditPanel.this.linkToTrx = false;
            }
        });
        this.linkToFormulaButton.setText(Messages.getString("LinkBeanEditPanel.Link_to_Formula_4"));
        Composite composite = new Composite((Composite)this, 0);
        this.stackLayout = new StackLayout();
        composite.setLayout((Layout)this.stackLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        composite.setLayoutData((Object)gridData);
        this.LinkTrxComposite = new Composite(composite, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        this.LinkTrxComposite.setLayout((Layout)gridLayout_1);
        Label label_5 = new Label(this.LinkTrxComposite, 0);
        label_5.setText(Messages.getString("LinkBeanEditPanel.TransactionCode__5"));
        this.trxCodeText = new Text(this.LinkTrxComposite, 2048);
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 120;
        this.trxCodeText.setLayoutData((Object)gridData_3);
        Button button_4 = new Button(this.LinkTrxComposite, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkBeanEditPanel.this.selectLinkTaskCode();
            }
        });
        button_4.setText(">>");
        Label label_2 = new Label(this.LinkTrxComposite, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 3;
        label_2.setLayoutData((Object)gridData_1);
        label_2.setText(Messages.getString("LinkBeanEditPanel.Link_Mode__6"));
        this.needInputViewButton = new Button(this.LinkTrxComposite, 32);
        this.needInputViewButton.setText(Messages.getString("LinkBeanEditPanel.Need_Input_View_7"));
        this.needOutputViewButton = new Button(this.LinkTrxComposite, 32);
        this.needOutputViewButton.setText(Messages.getString("LinkBeanEditPanel.Need_output_View_8"));
        SashForm sashForm = new SashForm(this.LinkTrxComposite, 0);
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        composite_1.setLayout((Layout)new GridLayout());
        Label label_3 = new Label(composite_1, 0);
        label_3.setText(Messages.getString("LinkBeanEditPanel.Link_out_data__9"));
        this.linkOutDataPanel = new ServerDataPanel(composite_1, 0);
        this.linkOutDataPanel.setLayoutData(new GridData(1808));
        Composite composite_2 = new Composite((Composite)sashForm, 0);
        composite_2.setLayout((Layout)new GridLayout());
        Label label_4 = new Label(composite_2, 0);
        label_4.setText(Messages.getString("LinkBeanEditPanel.Link_in_Data__10"));
        this.linkInDataPanel = new ServerDataPanel(composite_2, 0);
        this.linkInDataPanel.setLayoutData(new GridData(1808));
        sashForm.setWeights(new int[]{1, 1});
        GridData gridData_2 = new GridData(1808);
        gridData_2.horizontalSpan = 3;
        sashForm.setLayoutData((Object)gridData_2);
        this.formulaPanel = new ViewFormulaEditorPanel(composite, 0);
        this.stackLayout.topControl = this.LinkTrxComposite;
        this.setSize(600, 480);
    }

    public void initialize() {
        if (this.formulaPanel == null) {
            return;
        }
        if (this.viewNode != null) {
            this.linkPointCombo.add("View [Current View]");
            this.loadViewXMLContent(this.viewNode);
        }
        this.formulaPanel.setViewEditorProfile(this.viewProfile);
        this.formulaPanel.setFunctionXMLNode(this.functionNode);
        this.formulaPanel.setViewXMLContent(this.viewNode);
    }

    private void selectLinkTaskCode() {
        Object opName = null;
        String[] extensions = new String[]{"*.ttx"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        System.out.println("RootPath:" + this.rootPath);
        if (this.rootPath != null) {
            fileDialog.setFilterPath(String.valueOf(this.rootPath) + "/designFiles/TellerTrxs");
        } else {
            fileDialog.setFilterPath("./designFiles/MCITrxs");
        }
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        this.loadTrxFileInfo(fileName);
        fileName = fileName.replace('\\', '/');
        int idx = fileName.indexOf(this.rootPath);
        if (idx != -1) {
            this.trxFileName = fileName.substring(this.rootPath.length());
            if (this.linkBeanNode != null) {
                this.linkBeanNode.setAttrValue("trxFileName", this.trxFileName);
            }
        }
    }

    private void loadTrxFileInfo(String fileName) {
        try {
            XMLElementObjectMaker maker = new XMLElementObjectMaker();
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)maker);
            XMLNode aNode = (XMLNode)loader.loadXMLFile(fileName);
            if (aNode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("LinkBeanEditPanel.Error_11"), (String)Messages.getString("LinkBeanEditPanel.Invalide_Teller_Transaction_define_file_!_12"));
                return;
            }
            String trxCode = aNode.getAttrValue("trxCode");
            if (trxCode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("LinkBeanEditPanel.Error_13"), (String)Messages.getString("LinkBeanEditPanel.Invalide_Teller_Transaction_define_file_[trxCode]_not_defined_!_14"));
                return;
            }
            this.trxCodeText.setText(trxCode);
            XMLNode datasNode = aNode.getChild("datas");
            if (datasNode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("LinkBeanEditPanel.Error_15"), (String)Messages.getString("LinkBeanEditPanel.Invalide_Teller_Transaction_define_file_[trxCode]_not_defined_!_16"));
                return;
            }
            this.refDataNode = datasNode;
            MyDataProvider outDataProvider = new MyDataProvider(this.refDataNode, this.dataDictionary);
            this.linkInDataPanel.setDataProvider(outDataProvider);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath.replace('\\', '/');
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.linkInDataPanel.setDataDictionary(node);
        this.linkOutDataPanel.setDataDictionary(node);
    }

    public void setViewXMLContent(XMLNode node) {
        this.viewNode = node;
        this.formulaPanel.setViewXMLContent(node);
        this.linkPointCombo.add("View [Current View]");
        this.loadViewXMLContent(node);
    }

    private void loadViewXMLContent(XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            String nodeName;
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!("#text".equals(aNode.getNodeName()) || (nodeName = aNode.getNodeName()).equals("LinkBean") || nodeName.equals("Label") || nodeName.equals("OperationPanel"))) {
                this.linkPointCombo.add(String.valueOf(aNode.getAttrValue("name")) + " [" + aNode.getNodeName() + "]");
                this.loadViewXMLContent(aNode);
            }
            ++i;
        }
    }

    public void setFunctionNode(XMLNode node) {
        this.functionNode = node;
        this.formulaPanel.setFunctionXMLNode(node);
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.formulaPanel.setFunctionProfile(profile);
    }

    public void setViewEditorProfile(EditorProfile profile) {
        this.viewProfile = profile;
        this.formulaPanel.setViewEditorProfile(profile);
    }

    public void setLinkBeanNode(XMLNode node) {
        this.linkBeanNode = node;
        if (node.getAttrValue("linkFormula") != null) {
            this.formulaPanel.setFormulaStr(node.getAttrValue("linkFormula"));
            this.linkToTrx = false;
            this.linkToFormulaButton.setSelection(true);
            this.linkToTrxButton.setSelection(false);
            this.formulaPanel.setVisible(true);
            this.LinkTrxComposite.setVisible(false);
            this.stackLayout.topControl = this.formulaPanel;
        } else {
            String linkMode;
            String trxCode = this.linkBeanNode.getAttrValue("linkTaskCode");
            if (trxCode != null) {
                this.trxCodeText.setText(trxCode);
            }
            this.trxFileName = this.linkBeanNode.getAttrValue("trxFileName");
            if (this.trxFileName != null) {
                this.loadTrxFileInfo(String.valueOf(this.rootPath) + "/" + this.trxFileName);
            }
            if ("INPUT_SELECT".equals(linkMode = this.linkBeanNode.getAttrValue("linkTaskMode"))) {
                this.needInputViewButton.setSelection(true);
                this.needOutputViewButton.setSelection(true);
            } else if ("INPUT_NOSELECT".equals(linkMode)) {
                this.needOutputViewButton.setSelection(true);
            } else if ("NOINPUT_SELECT".equals(linkMode)) {
                this.needInputViewButton.setSelection(true);
            }
        }
        this.loadLinkBeanInfo();
        String linkPoint = node.getAttrValue("linkPoint");
        if (linkPoint == null) {
            return;
        }
        int idx = linkPoint.indexOf(46);
        if (idx == -1) {
            node.setAttrValue("linkPoint", null);
            return;
        }
        String linkOutComponent = linkPoint.substring(0, idx);
        String event = linkPoint.substring(idx + 1);
        this.linkEventCombo.setText(event);
        String[] items = this.linkPointCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].indexOf(linkOutComponent) != -1) {
                this.linkPointCombo.setText(items[i]);
                break;
            }
            ++i;
        }
    }

    private void loadLinkBeanInfo() {
        if (this.linkBeanNode == null) {
            return;
        }
        if (this.linkInDataPanel == null) {
            return;
        }
        XMLNode inNode = this.linkBeanNode.getChild("linkInData");
        if (inNode == null) {
            inNode = new XMLNode();
            inNode.setNodeName("linkInData");
            this.linkBeanNode.add(inNode);
        }
        this.linkInDataPanel.setDataNode(inNode);
        XMLNode outNode = this.linkBeanNode.getChild("linkOutData");
        if (outNode == null) {
            outNode = new XMLNode();
            outNode.setNodeName("linkOutData");
            this.linkBeanNode.add(outNode);
        }
        this.linkOutDataPanel.setDataNode(outNode);
    }

    public void setTrxDataNode(XMLNode node) {
        this.trxDataNode = node;
        MyDataProvider inDataProvider = new MyDataProvider(this.trxDataNode, this.dataDictionary);
        this.linkOutDataPanel.setDataProvider(inDataProvider);
    }

    public String getLinkOutComponent() {
        String str = this.linkPointCombo.getText();
        if (str.length() == 0) {
            return str;
        }
        int idx = str.indexOf(91);
        if (idx != -1) {
            return str.substring(0, idx - 1);
        }
        return str;
    }

    public String getLinkOutEvent() {
        return this.linkEventCombo.getText();
    }

    public boolean getIsLinkToTrx() {
        return this.linkToTrx;
    }

    public String getTrxCode() {
        return this.trxCodeText.getText();
    }

    public boolean getIsHaveOutView() {
        return this.needOutputViewButton.getSelection();
    }

    public boolean getIsHaveInView() {
        return this.needInputViewButton.getSelection();
    }

    public String getFormulaStr() {
        return this.formulaPanel.getFormulaStr();
    }

    public void dispose() {
        super.dispose();
    }

    public void doFinalize() {
        XMLNode node = this.linkBeanNode;
        node.setAttrValue("linkPoint", String.valueOf(this.getLinkOutComponent()) + "." + this.getLinkOutEvent());
        if (this.linkToTrx) {
            node.setAttrValue("linkTaskCode", this.getTrxCode());
            String linkMode = "NOINPUT";
            boolean haveInView = this.getIsHaveInView();
            boolean haveOutView = this.getIsHaveOutView();
            if (haveInView && haveOutView) {
                linkMode = "INPUT_SELECT";
            }
            if (haveInView && !haveOutView) {
                linkMode = "INPUT_NOSELECT";
            }
            if (!haveInView && haveOutView) {
                linkMode = "NOINPUT_SELECT";
            }
            node.setAttrValue("linkTaskMode", linkMode);
            node.setAttrValue("linkFormula", null);
        } else {
            XMLNode outNode;
            node.setAttrValue("linkTaskCode", null);
            node.setAttrValue("linkTaskMode", null);
            node.setAttrValue("linkFormula", this.getFormulaStr());
            XMLNode inNode = node.getChild("linkInData");
            if (inNode != null) {
                node.remove(inNode);
            }
            if ((outNode = node.getChild("linkOutData")) != null) {
                node.remove(outNode);
            }
        }
    }

    protected void checkSubclass() {
    }

    class MyDataProvider
    implements DataProvider {
        Vector datas = new Vector();

        public MyDataProvider(XMLNode datasNode, XMLNode dataDictionary) {
            if (datasNode.getChilds() == null) {
                return;
            }
            int i = 0;
            while (i < datasNode.getChilds().size()) {
                String dataId;
                XMLNode dataNode;
                XMLNode aNode = (XMLNode)datasNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName()) && (dataNode = dataDictionary.findChildNode(dataId = aNode.getAttrValue("refId"))) != null) {
                    this.datas.addElement(dataNode);
                }
                ++i;
            }
        }

        public Vector getDatas() {
            return this.datas;
        }
    }
}

