/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.flow.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ReceiptSelectPanel
extends Composite {
    private Text templeteText;
    private Table table;
    private Text descText;
    private Text receiptIdText;
    private String rootPath;
    private EditorProfile editorProfile;
    private XMLNode contentNode;
    private XMLNode curReceiptNode;
    private XMLNode dataDictionary;
    private BuildProblemReporter reporter;

    public ReceiptSelectPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Composite composite_1 = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout);
        Label label = new Label(composite_1, 0);
        label.setText(Messages.getString("TellerReceiptDefinePanel.ReceiptID__1"));
        this.receiptIdText = new Text(composite_1, 2048);
        GridData gridData_9 = new GridData(768);
        gridData_9.horizontalSpan = 3;
        this.receiptIdText.setLayoutData((Object)gridData_9);
        Label label_3 = new Label(composite_1, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData_1);
        label_3.setText(Messages.getString("TellerReceiptDefinePanel.Document__4"));
        this.descText = new Text(composite_1, 2818);
        GridData gridData_2 = new GridData(768);
        gridData_2.heightHint = 50;
        gridData_2.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_2);
        this.table = new Table(composite_1, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReceiptSelectPanel.this.setActivateReceipt();
            }
        });
        GridData gridData_7 = new GridData(1808);
        gridData_7.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData_7);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(101);
        tableColumn.setText(Messages.getString("TellerReceiptDefinePanel.Receipt_ID_7"));
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(314);
        tableColumn_3.setText(Messages.getString("TellerReceiptDefinePanel.Document_9"));
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setXMLContent(XMLNode node) {
        this.contentNode = node;
        this.table.removeAll();
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode viewNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(viewNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(viewNode.getAttrValue("id"));
                item.setData((Object)viewNode);
                if (viewNode.getDocument() != null) {
                    item.setText(1, viewNode.getDocument());
                }
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.table.setSelection(0);
            this.setActivateReceipt();
        }
    }

    private void setActivateReceipt() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        if (this.curReceiptNode == node) {
            return;
        }
        this.curReceiptNode = node;
        this.receiptIdText.setText(node.getAttrValue("id"));
        if (node.getDocument() != null) {
            this.descText.setText(node.getDocument());
        } else {
            this.descText.setText("");
        }
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (this.reporter != null) {
            this.reporter.reportProblem(type, msg, location, fileName, e);
        } else {
            System.out.println("[" + type + "]" + msg + ":" + location);
        }
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getSelectedReceiptId() {
        if (this.curReceiptNode != null) {
            return this.curReceiptNode.getAttrValue("id");
        }
        return null;
    }
}

