/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editor.transaction.DataSelectDialog;
import java.util.Vector;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ServerDataPanel
extends Composite {
    TableTree reqTableTree;
    private DataProvider dataProvider;
    private XMLNode dataNode;
    private XMLNode dataDictionary;
    private XMLNode activateNode;
    private TableTreeItem activateItem;
    private BuildProblemReporter reporter;

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataNode(XMLNode node) {
        this.dataNode = node;
        this.reqTableTree.removeAll();
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                XMLNode dataNode;
                String refId = aNode.getAttrValue("refId");
                TableTreeItem item = new TableTreeItem(this.reqTableTree, 0);
                item.setText(refId);
                if (aNode == this.activateNode) {
                    this.activateItem = item;
                }
                if (this.dataDictionary != null && (dataNode = this.dataDictionary.findChildNode(refId)) != null) {
                    if (dataNode.getAttrValue("label") != null) {
                        item.setText(1, dataNode.getAttrValue("label"));
                    }
                    if (dataNode.getAttrValue("desc") != null) {
                        item.setText(2, dataNode.getAttrValue("label"));
                    }
                }
                item.setData((Object)aNode);
                this.addRefData(item, aNode);
            }
            ++i;
        }
    }

    private void addRefData(TableTreeItem item, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                String refId = aNode.getAttrValue("refId");
                TableTreeItem aItem = new TableTreeItem(item, 0);
                aItem.setText(refId);
                if (aNode == this.activateNode) {
                    this.activateItem = aItem;
                }
                aItem.setData((Object)aNode);
                this.addRefData(aItem, aNode);
            }
            ++i;
        }
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public ServerDataPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Label label_1 = new Label((Composite)this, 0);
        label_1.setLayoutData((Object)new GridData(768));
        label_1.setText(Messages.getString("ServerDataPanel.Datas__7"));
        this.reqTableTree = new TableTree((Composite)this, 67584);
        Table table = this.reqTableTree.getTable();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerDataPanel.this.setActivateDataItem();
            }
        });
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tableColumn_2 = new TableColumn(table, 0);
        tableColumn_2.setWidth(69);
        tableColumn_2.setText(Messages.getString("ServerDataPanel.DataID_8"));
        TableColumn tableColumn_3 = new TableColumn(table, 0);
        tableColumn_3.setWidth(75);
        tableColumn_3.setText(Messages.getString("ServerDataPanel.DataName_9"));
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(80);
        tableColumn.setText(Messages.getString("ServerDataPanel.Description_10"));
        GridData gridData_2 = new GridData(1808);
        this.reqTableTree.setLayoutData((Object)gridData_2);
        Composite composite_1 = new Composite((Composite)this, 0);
        composite_1.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout);
        Button button = new Button(composite_1, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerDataPanel.this.addReqData();
            }
        });
        button.setText(Messages.getString("ServerDataPanel.Add_11"));
        Button button_1 = new Button(composite_1, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerDataPanel.this.deleteReqData();
            }
        });
        button_1.setText(Messages.getString("ServerDataPanel.Delete_12"));
        Button button_2 = new Button(composite_1, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerDataPanel.this.moveUpSelectedData();
            }
        });
        button_2.setText(Messages.getString("ServerDataPanel.Up_7"));
        Button button_3 = new Button(composite_1, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerDataPanel.this.moveDownSelectedData();
            }
        });
        button_3.setText(Messages.getString("ServerDataPanel.Down_8"));
    }

    private void addReqData() {
        if (this.dataNode == null) {
            return;
        }
        Vector selectDatas = this.selectData();
        if (selectDatas != null) {
            int i = 0;
            while (i < selectDatas.size()) {
                XMLNode node = (XMLNode)selectDatas.elementAt(i);
                if (!"#text".equals(node.getNodeName())) {
                    TableTreeItem item = new TableTreeItem(this.reqTableTree, 0);
                    item.setText(node.getAttrValue("id"));
                    if (node.getAttrValue("label") != null) {
                        item.setText(1, node.getAttrValue("label"));
                    }
                    XMLNode refNode = new XMLNode();
                    if (!node.getNodeName().equals("dataCollection")) {
                        refNode.setNodeName("refData");
                    } else {
                        refNode.setNodeName("refColl");
                    }
                    refNode.setAttrValue("refId", node.getAttrValue("id"));
                    this.dataNode.add(refNode);
                    item.setData((Object)refNode);
                    this.addDataElement(item, node, refNode);
                }
                ++i;
            }
        }
    }

    private void addDataElement(TableTreeItem item, XMLNode node, XMLNode refNode) {
        Vector childs = node.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                TableTreeItem aItem = new TableTreeItem(item, 0);
                aItem.setText(aNode.getAttrValue("id"));
                if (aNode.getAttrValue("label") != null) {
                    aItem.setText(1, aNode.getAttrValue("label"));
                }
                XMLNode aRefNode = new XMLNode();
                if (!aNode.getNodeName().equals("dataCollection")) {
                    aRefNode.setNodeName("refData");
                } else {
                    aRefNode.setNodeName("refColl");
                }
                aRefNode.setAttrValue("refId", aNode.getAttrValue("id"));
                refNode.add(aRefNode);
                aItem.setData((Object)refNode);
                this.addDataElement(aItem, aNode, aRefNode);
            }
            ++i;
        }
    }

    private void deleteReqData() {
        try {
            TableTreeItem[] selects = this.reqTableTree.getSelection();
            if (selects.length == 0) {
                return;
            }
            int i = 0;
            while (i < selects.length) {
                TableTreeItem item = selects[i];
                XMLNode refNode = (XMLNode)item.getData();
                TableTreeItem parent = item.getParentItem();
                if (parent != null) {
                    XMLNode parentNode = (XMLNode)parent.getData();
                    parentNode.remove(refNode);
                } else {
                    this.dataNode.remove(refNode);
                }
                int idx = this.reqTableTree.indexOf(item);
                if (idx != -1) {
                    item.dispose();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setActivateDataItem() {
        TableTreeItem[] selects = this.reqTableTree.getSelection();
        if (selects.length != 1) {
            return;
        }
    }

    private Vector selectData() {
        DataSelectDialog dlg = new DataSelectDialog(this.getShell(), 0);
        if (this.dataProvider != null) {
            dlg.setDatas(this.dataProvider.getDatas());
        }
        Vector result = (Vector)dlg.open();
        return result;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (this.reporter != null) {
            this.reporter.reportProblem(type, msg, location, fileName, e);
        } else {
            System.out.println("[" + type + "]" + msg + ":" + location);
        }
    }

    private void moveUpSelectedData() {
        try {
            TableTreeItem[] items = this.reqTableTree.getSelection();
            if (items.length != 1) {
                return;
            }
            XMLNode node = (XMLNode)items[0].getData();
            XMLNode pNode = node.getParent();
            int idx = pNode.getChilds().indexOf(node);
            if (idx == 0) {
                return;
            }
            pNode.adjustNodeOrder(node, idx - 1);
            this.activateNode = node;
            this.activateItem = null;
            this.setDataNode(this.dataNode);
            if (this.activateItem != null) {
                TableTreeItem[] anItems = new TableTreeItem[]{this.activateItem};
                this.reqTableTree.setSelection(anItems);
                this.reqTableTree.showItem(this.activateItem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void moveDownSelectedData() {
        try {
            TableTreeItem[] items = this.reqTableTree.getSelection();
            if (items.length != 1) {
                return;
            }
            XMLNode node = (XMLNode)items[0].getData();
            XMLNode pNode = node.getParent();
            int idx = pNode.getChilds().indexOf(node);
            if (idx == pNode.getChilds().size() - 1) {
                return;
            }
            pNode.adjustNodeOrder(node, idx + 1);
            this.activateNode = node;
            this.activateItem = null;
            this.setDataNode(this.dataNode);
            if (this.activateItem != null) {
                TableTreeItem[] anItems = new TableTreeItem[]{this.activateItem};
                this.reqTableTree.setSelection(anItems);
                this.reqTableTree.showItem(this.activateItem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLayout((Layout)new GridLayout());
    }
}

