/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TaskTreePanel
extends Composite {
    private TreeItem root;
    private XMLNode taskNode;
    private Tree taskTree;

    public TaskTreePanel(Composite parent, int style) {
        super(parent, style);
        try {
            this.setLayout((Layout)new FillLayout());
            this.taskTree = new Tree((Composite)this, 2048);
            this.root = new TreeItem(this.taskTree, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTaskNode(XMLNode taskNode) {
        this.taskNode = taskNode;
        this.buildTaskTree(this.root, taskNode);
    }

    private void buildTaskTree(TreeItem item, XMLNode node) {
        if (node == null) {
            return;
        }
        String name = node.getNodeName();
        if ("TaskModel".equals(name)) {
            item.setData((Object)"");
            item.setText(Messages.getString("TaskTreePanel.TaskModel_3"));
            int i = 0;
            while (i < node.getChilds().size()) {
                TreeItem childItem = new TreeItem(item, 0);
                XMLNode childNode = (XMLNode)node.getChilds().elementAt(i);
                this.buildTaskTree(childItem, childNode);
                ++i;
            }
        }
        if ("TaskGroup".equals(name)) {
            String code = node.getAttrValue("id");
            if (code == null) {
                code = node.getAttrValue("description");
            }
            if (code == null) {
                code = "";
            }
            item.setData((Object)"");
            item.setText(String.valueOf(Messages.getString("TaskTreePanel.Group___9")) + code);
            int i = 0;
            while (i < node.getChilds().size()) {
                TreeItem childItem = new TreeItem(item, 0);
                XMLNode childNode = (XMLNode)node.getChilds().elementAt(i);
                this.buildTaskTree(childItem, childNode);
                ++i;
            }
        }
        if ("TaskInfo".equals(name)) {
            String code = node.getAttrValue("id");
            if (code == null) {
                code = node.getAttrValue("transactionCode");
            }
            if (code == null) {
                code = "";
            }
            item.setData((Object)code);
            String taskName = node.getAttrValue("name");
            if (taskName == null) {
                taskName = "";
            }
            String text = String.valueOf(Messages.getString("TaskTreePanel.TASK___16")) + code + " " + taskName;
            String status = node.getAttrValue("status");
            if (status == null) {
                status = "";
            }
            if (status.length() > 0) {
                text = String.valueOf(text) + " [" + status + "]";
            }
            item.setText(text);
        }
    }

    public String getSelectTask() {
        TreeItem item = this.taskTree.getSelection()[0];
        if (item != null) {
            return (String)item.getData();
        }
        return "";
    }
}

