/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.flow.Messages;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualTellerFramePanel;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TellerReceiptDefinePanel
extends Composite {
    private Text templeteText;
    private Table table;
    private Text descText;
    private Text conditionText;
    private Text receiptIdText;
    private String rootPath;
    private int[] weights;
    private VisualTellerFramePanel visualReceiptPanel;
    private EditorProfile editorProfile;
    private XMLNode contentNode;
    private XMLNode curReceiptNode;
    private XMLNode dataDictionary;
    private BuildProblemReporter reporter;

    public void setDataProvider(DataProvider dataProvider) {
        this.visualReceiptPanel.setDataProvider(dataProvider);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.visualReceiptPanel.setDataDictionary(node);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.visualReceiptPanel.setDataEditorProfile(profile);
    }

    public void setReceiptEditorProfile(EditorProfile profile) {
        this.editorProfile = profile;
        this.visualReceiptPanel.setEditorProfile(profile);
    }

    public TellerReceiptDefinePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        final SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout);
        Label label = new Label(composite_1, 0);
        label.setText(Messages.getString("TellerReceiptDefinePanel.ReceiptID__1"));
        this.receiptIdText = new Text(composite_1, 2048);
        GridData gridData_9 = new GridData(768);
        gridData_9.horizontalSpan = 3;
        this.receiptIdText.setLayoutData((Object)gridData_9);
        Label label_2 = new Label(composite_1, 0);
        label_2.setText(Messages.getString("TellerReceiptDefinePanel.Templete__1"));
        this.templeteText = new Text(composite_1, 2048);
        GridData gridData_11 = new GridData(768);
        gridData_11.horizontalSpan = 2;
        this.templeteText.setLayoutData((Object)gridData_11);
        Button button_4 = new Button(composite_1, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerReceiptDefinePanel.this.selectTemplete();
            }
        });
        button_4.setText(">>");
        Label label_3 = new Label(composite_1, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData_1);
        label_3.setText(Messages.getString("TellerReceiptDefinePanel.Document__4"));
        this.descText = new Text(composite_1, 2818);
        GridData gridData_2 = new GridData(768);
        gridData_2.heightHint = 50;
        gridData_2.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_2);
        Composite composite_2 = new Composite(composite_1, 0);
        GridData gridData_3 = new GridData(256);
        gridData_3.horizontalSpan = 4;
        composite_2.setLayoutData((Object)gridData_3);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_1);
        Button button_1 = new Button(composite_2, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerReceiptDefinePanel.this.createNewReceipt();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("TellerReceiptDefinePanel.Create_5"));
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerReceiptDefinePanel.this.deleteCurrentReceipt();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        button_2.setLayoutData((Object)gridData_5);
        button_2.setText(Messages.getString("TellerReceiptDefinePanel.Delete_6"));
        Button button_3 = new Button(composite_2, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerReceiptDefinePanel.this.updateCurrentReceipt();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 80;
        button_3.setLayoutData((Object)gridData_6);
        button_3.setText(Messages.getString("TellerReceiptDefinePanel.Update_1"));
        this.table = new Table(composite_1, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerReceiptDefinePanel.this.setActivateReceipt();
            }
        });
        GridData gridData_7 = new GridData(1808);
        gridData_7.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData_7);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(101);
        tableColumn.setText(Messages.getString("TellerReceiptDefinePanel.Receipt_ID_7"));
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(314);
        tableColumn_3.setText(Messages.getString("TellerReceiptDefinePanel.Document_9"));
        CTabFolder tabFolder = new CTabFolder((Composite)sashForm, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                int[] ws = sashForm.getWeights();
                if (ws[0] == 0) {
                    sashForm.setWeights(TellerReceiptDefinePanel.this.weights);
                    TellerReceiptDefinePanel.this.layout(true);
                } else {
                    int[] nArray = new int[2];
                    nArray[1] = 400;
                    sashForm.setWeights(nArray);
                    TellerReceiptDefinePanel.this.layout(true);
                    ((TellerReceiptDefinePanel)TellerReceiptDefinePanel.this).weights[0] = ws[0];
                    ((TellerReceiptDefinePanel)TellerReceiptDefinePanel.this).weights[1] = ws[1];
                }
            }
        });
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("visualDesign"));
        this.visualReceiptPanel = new VisualTellerFramePanel((Composite)tabFolder, 0);
        this.visualReceiptPanel.setShowRule(true);
        tabItem.setControl((Control)this.visualReceiptPanel);
        tabFolder.setSelection(0);
        this.visualReceiptPanel.setAcceptableComponentNames("Receipt");
        this.visualReceiptPanel.setLabelMap("label", "ReceiptLabel");
        this.visualReceiptPanel.setLabelMap("text", "ReceiptText");
        this.weights = new int[2];
        this.weights[0] = 1;
        this.weights[1] = 4;
        sashForm.setWeights(this.weights);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setXMLContent(XMLNode node) {
        this.contentNode = node;
        this.table.removeAll();
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode viewNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(viewNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(viewNode.getAttrValue("id"));
                item.setData((Object)viewNode);
                if (viewNode.getDocument() != null) {
                    item.setText(1, viewNode.getDocument());
                }
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.table.setSelection(0);
            this.setActivateReceipt();
        } else {
            try {
                this.visualReceiptPanel.setXMLContent(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createNewReceipt() {
        String receiptId = this.receiptIdText.getText();
        if (!this.checkReceiptName(receiptId)) {
            return;
        }
        if (this.contentNode.getChilds() != null && this.contentNode.findChildNode(receiptId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerReceiptDefinePanel.Warning_18"), (String)Messages.getString("TellerReceiptDefinePanel.Duplicated_Receipt_ID_19"));
            return;
        }
        XMLNode receiptNode = new XMLNode();
        receiptNode.setNodeName("receipt");
        receiptNode.setAttrValue("id", receiptId);
        receiptNode.setDocument(this.descText.getText());
        XMLNode viewDataNode = new XMLNode();
        viewDataNode.setNodeName("datas");
        receiptNode.add(viewDataNode);
        XMLNode receiptDefNode = new XMLNode();
        receiptDefNode.setNodeName("receiptDef");
        receiptNode.add(receiptDefNode);
        XMLNode receipt = null;
        if (this.templeteText.getText().length() == 0) {
            receipt = new XMLNode();
        } else {
            try {
                XMLLoader loader = new XMLLoader();
                XMLElementObjectMaker maker = new XMLElementObjectMaker();
                loader.addObjectMaker((ObjectMaker)maker);
                receipt = (XMLNode)loader.loadXMLFile(this.templeteText.getText());
            }
            catch (Exception e) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerReceiptDefinePanel.warning_3"), (String)(String.valueOf(Messages.getString("TellerReceiptDefinePanel.Invalid_templete_file_!_n_4")) + e));
                return;
            }
            if (receipt == null || !"Receipt".equals(receipt.getNodeName())) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerReceiptDefinePanel.warning_5"), (String)Messages.getString("TellerReceiptDefinePanel.Invalid_templete_file_!_6"));
                return;
            }
        }
        receipt.setNodeName("Receipt");
        receipt.setAttrValue("name", "Receipt");
        receipt.setAttrValue("x", "35");
        receipt.setAttrValue("y", "35");
        receipt.setAttrValue("width", "200");
        receipt.setAttrValue("height", "100");
        receiptDefNode.add(receipt);
        this.contentNode.add(receiptNode);
        TableItem item = new TableItem(this.table, 0);
        item.setText(receiptId);
        item.setText(1, this.descText.getText());
        item.setData((Object)receiptNode);
    }

    private void updateCurrentReceipt() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        String receiptId = this.receiptIdText.getText();
        if (!this.checkReceiptName(receiptId)) {
            return;
        }
        XMLNode aNode = this.contentNode.findChildNode(receiptId);
        if (aNode != null && aNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerReceiptDefinePanel.Warning_18"), (String)Messages.getString("TellerReceiptDefinePanel.Duplicated_Receipt_ID_19"));
            return;
        }
        node.setAttrValue("id", receiptId);
        node.setDocument(this.descText.getText());
        selects[0].setText(receiptId);
        selects[0].setText(1, this.descText.getText());
    }

    private void setActivateReceipt() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        if (this.curReceiptNode == node) {
            return;
        }
        try {
            this.visualReceiptPanel.setXMLContent(node.getChild("receiptDef").getChild("Receipt"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.curReceiptNode = node;
        this.receiptIdText.setText(node.getAttrValue("id"));
        if (node.getDocument() != null) {
            this.descText.setText(node.getDocument());
        } else {
            this.descText.setText("");
        }
    }

    private void deleteCurrentReceipt() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("TellerReceiptDefinePanel.Are_your_sure..._42"), (String)Messages.getString("TellerReceiptDefinePanel.Are_you_sure_to_delete_the_receipt_define__43"))) {
            XMLNode receiptNode = (XMLNode)items[0].getData();
            this.contentNode.remove(receiptNode);
            items[0].dispose();
            if (this.table.getItemCount() > 0) {
                this.table.setSelection(0);
                this.setActivateReceipt();
            } else {
                try {
                    this.visualReceiptPanel.setXMLContent(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (this.reporter != null) {
            this.reporter.reportProblem(type, msg, location, fileName, e);
        } else {
            System.out.println("[" + type + "]" + msg + ":" + location);
        }
    }

    public void setPatternNode(XMLNode node) {
        this.visualReceiptPanel.setPatternNode(node);
    }

    public void setFunctionNode(XMLNode node) {
        this.visualReceiptPanel.setFunctionNode(node);
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.visualReceiptPanel.setFunctionProfile(profile);
    }

    public void setPatternProfile(EditorProfile profile) {
        this.visualReceiptPanel.setPatternProfile(profile);
    }

    private void selectTemplete() {
        String[] extensions = new String[]{"*.xml"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        if (this.rootPath != null) {
            fileDialog.setFilterPath(String.valueOf(this.rootPath) + "/designFiles");
        } else {
            fileDialog.setFilterPath("./designFiles");
        }
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        fileName = fileName.replace('\\', '/');
        String relPath = String.valueOf(this.rootPath) + "/designFiles/";
        this.templeteText.setText(fileName);
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
        this.visualReceiptPanel.setRootPath(rootPath);
    }

    private boolean checkReceiptName(String name) {
        if (name.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Warning_18"), (String)Messages.getString("TellerViewDefinePanel.Please_input_proper_View_ID_!_19"));
            return false;
        }
        String tmp = name.toLowerCase();
        if (!tmp.endsWith(".xml")) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Warning_18"), (String)Messages.getString("TellerReceiptDefinePanel.The_view_id_should_end_with___.xml___!_2"));
            return false;
        }
        return true;
    }
}

