/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.WrapperOwner;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import com.ecc.ide.editor.client.teller.ServerDataPanel;
import com.ecc.ide.editor.client.teller.TaskPropertyWrapper;
import com.ecc.ide.editor.client.teller.TellerReceiptDefinePanel;
import com.ecc.ide.editor.client.teller.TellerTrxDeviceAccessPanel;
import com.ecc.ide.editor.client.teller.TellerViewDefinePanel;
import com.ecc.ide.editor.client.teller.TransactionLinkPanel;
import com.ecc.ide.editor.data.DataDicSelectPanel;
import com.ecc.ide.editor.flow.TrxFlowPanel;
import com.ecc.ide.editor.format.FormatsEditPanel;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class TellerTrxMainPanel
extends Composite
implements DataProvider,
WrapperOwner {
    private Text text;
    private Text serverTrxCodeText;
    private Text trxNameText;
    private Text trxCodeText;
    private Button refReqHeadButton = null;
    private Button refRepHeadButton = null;
    private String rootPath;
    private XMLNode dataDictionary;
    private XMLNode patternNode;
    private XMLNode functionNode;
    private EditorProfile functionProfile;
    private XMLNode taskNode;
    private XMLNode channelSettings;
    private EditorProfile dataProfile;
    private EditorProfile viewEditorProfile;
    private EditorProfile receiptProfile;
    private XMLNode xmlContent;
    private TrxFlowPanel trxFlowPanel;
    private DataDicSelectPanel dataDicSelectPanel;
    private TellerViewDefinePanel tellerViewDefinePanel;
    private TellerReceiptDefinePanel tellerReceiptDefinePanel;
    private ServerDataPanel reqServerDataPanel;
    private ServerDataPanel repServerDataPanel;
    private TransactionLinkPanel trxLinkPanel;
    private TellerTrxDeviceAccessPanel devicePanel;
    private FormatsEditPanel fmtPanel;
    private EditorBeanPropertyPanel taskPropertyPanel;
    private EditorProfile taskPropertyProfile;
    private BuildProblemReporter reporter;

    public void setPackageTypeNode(XMLNode node) {
        this.fmtPanel.setPkgTypeXMLNode(node);
    }

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataProfile = profile;
        this.dataDicSelectPanel.setDataDictionaryEditorProfile(profile);
        this.tellerViewDefinePanel.setDataEditorProfile(profile);
        this.tellerReceiptDefinePanel.setDataEditorProfile(profile);
        this.fmtPanel.setDataDictionaryEditorProfile(profile);
    }

    public void setViewEditorProfile(EditorProfile profile) {
        this.viewEditorProfile = profile;
        this.tellerViewDefinePanel.setViewEditorProfile(profile);
    }

    public void setReceiptEditorProfile(EditorProfile profile) {
        this.receiptProfile = profile;
        this.tellerReceiptDefinePanel.setReceiptEditorProfile(profile);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.dataDicSelectPanel.setDataDictionary(node);
        this.tellerViewDefinePanel.setDataDictionary(node);
        this.tellerReceiptDefinePanel.setDataDictionary(node);
        this.repServerDataPanel.setDataDictionary(node);
        this.reqServerDataPanel.setDataDictionary(node);
        this.trxLinkPanel.setDataDictionary(node);
        this.fmtPanel.setDataDictionary(node);
    }

    public void setCommonFlowNode(XMLNode flowNode) {
        this.trxFlowPanel.setCommonFlowNode(flowNode);
    }

    public TellerTrxMainPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText(Messages.getString("TellerTrxMainPanel.Transaction_Defines_1"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        composite.setLayout((Layout)gridLayout);
        tabItem1.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("TellerTrxMainPanel.TransactionCode__2"));
        this.trxCodeText = new Text(composite, 2048);
        GridData gridData = new GridData();
        this.trxCodeText.setLayoutData((Object)gridData);
        this.trxCodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TellerTrxMainPanel.this.trxCodeText.getText().length() > 0) {
                    TellerTrxMainPanel.this.xmlContent.setAttrValue("trxCode", TellerTrxMainPanel.this.trxCodeText.getText());
                } else {
                    TellerTrxMainPanel.this.xmlContent.setAttrValue("trxCode", null);
                }
            }
        });
        Label label_2 = new Label(composite, 0);
        label_2.setText(Messages.getString("TellerTrxMainPanel.ServerTrxCode__5"));
        this.serverTrxCodeText = new Text(composite, 2048);
        this.serverTrxCodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TellerTrxMainPanel.this.serverTrxCodeText.getText().length() > 0) {
                    TellerTrxMainPanel.this.xmlContent.setAttrValue("srvTrxCode", TellerTrxMainPanel.this.serverTrxCodeText.getText());
                } else {
                    TellerTrxMainPanel.this.xmlContent.setAttrValue("srvTrxCode", null);
                }
            }
        });
        Button button = new Button(composite, 0);
        button.setText(">>");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TellerTrxMainPanel.this.selectServerTrxCode();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("TellerTrxMainPanel.TransactionName__8"));
        this.trxNameText = new Text(composite, 2048);
        GridData gridData_1 = new GridData(768);
        gridData_1.widthHint = 281;
        gridData_1.horizontalSpan = 4;
        this.trxNameText.setLayoutData((Object)gridData_1);
        this.trxNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TellerTrxMainPanel.this.trxNameText.getText().length() > 0) {
                    TellerTrxMainPanel.this.xmlContent.setAttrValue("trxName", TellerTrxMainPanel.this.trxNameText.getText());
                } else {
                    TellerTrxMainPanel.this.xmlContent.setAttrValue("trxName", null);
                }
            }
        });
        Label label_7 = new Label(composite, 0);
        GridData gridData_8 = new GridData();
        gridData_8.horizontalSpan = 5;
        label_7.setLayoutData((Object)gridData_8);
        label_7.setText(Messages.getString("TellerTrxMainPanel.Document__12"));
        this.text = new Text(composite, 2818);
        GridData gridData_9 = new GridData(768);
        gridData_9.heightHint = 100;
        gridData_9.horizontalSpan = 5;
        this.text.setLayoutData((Object)gridData_9);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TellerTrxMainPanel.this.xmlContent.setDocument(TellerTrxMainPanel.this.text.getText());
            }
        });
        Label label_8 = new Label(composite, 0);
        GridData gridData_11 = new GridData(514);
        gridData_11.horizontalSpan = 5;
        label_8.setText(Messages.getString("TellerTrxMainPanel.Task_property__11"));
        label_8.setLayoutData((Object)gridData_11);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2560);
        GridData sgridData = new GridData(1808);
        sgridData.horizontalSpan = 5;
        scrolledComposite.setLayoutData((Object)sgridData);
        this.taskPropertyPanel = new EditorBeanPropertyPanel((Composite)scrolledComposite, 2048);
        scrolledComposite.setContent((Control)this.taskPropertyPanel);
        TabItem tabItem_2 = new TabItem(tabFolder, 0);
        tabItem_2.setText(Messages.getString("TellerTrxMainPanel.TransactionDatas_15"));
        this.dataDicSelectPanel = new DataDicSelectPanel((Composite)tabFolder, true, true, 0);
        tabItem_2.setControl((Control)this.dataDicSelectPanel);
        this.dataDicSelectPanel.setAccessMode(new String[]{"common", "session", "private"});
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("TellerTrxMainPanel.View_Defines_16"));
        this.tellerViewDefinePanel = new TellerViewDefinePanel((Composite)tabFolder, 0);
        tabItem.setControl((Control)this.tellerViewDefinePanel);
        this.tellerViewDefinePanel.setDataProvider(this);
        TabItem tabItem_6 = new TabItem(tabFolder, 0);
        tabItem_6.setText(Messages.getString("TellerTrxMainPanel.Receipts_17"));
        this.tellerReceiptDefinePanel = new TellerReceiptDefinePanel((Composite)tabFolder, 0);
        tabItem_6.setControl((Control)this.tellerReceiptDefinePanel);
        this.tellerReceiptDefinePanel.setDataProvider(this);
        TabItem tabItem_1 = new TabItem(tabFolder, 0);
        tabItem_1.setText(Messages.getString("TellerTrxMainPanel.Trx_Flow_define_18"));
        this.trxFlowPanel = new TrxFlowPanel((Composite)tabFolder, 0);
        tabItem_1.setControl((Control)this.trxFlowPanel);
        TabItem tabItem_3 = new TabItem(tabFolder, 0);
        tabItem_3.setText(Messages.getString("TellerTrxMainPanel.ServerAccess_19"));
        Composite composite_2 = new Composite((Composite)tabFolder, 0);
        composite_2.setLayout((Layout)new FillLayout());
        tabItem_3.setControl((Control)composite_2);
        TabFolder tabFolder_1 = new TabFolder(composite_2, 0);
        TabItem tabItem_4 = new TabItem(tabFolder_1, 0);
        tabItem_4.setText(Messages.getString("TellerTrxMainPanel.Request_20"));
        Composite sComp = new Composite((Composite)tabFolder_1, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.marginWidth = 0;
        sComp.setLayout((Layout)gridLayout_1);
        tabItem_4.setControl((Control)sComp);
        this.refReqHeadButton = new Button(sComp, 32);
        this.refReqHeadButton.setText(Messages.getString("TellerTrxMainPanel.Refer_to_request_Head_21"));
        this.refReqHeadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TellerTrxMainPanel.this.xmlContent.getChild("srvRequest").setAttrValue("refToHead", String.valueOf(TellerTrxMainPanel.this.refReqHeadButton.getSelection()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.reqServerDataPanel = new ServerDataPanel(sComp, 0);
        this.reqServerDataPanel.setLayoutData(new GridData(1808));
        this.reqServerDataPanel.setDataProvider(this);
        TabItem tabItem_5 = new TabItem(tabFolder_1, 0);
        tabItem_5.setText(Messages.getString("TellerTrxMainPanel.Reply_26"));
        Composite cComp = new Composite((Composite)tabFolder_1, 0);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.marginWidth = 0;
        cComp.setLayout((Layout)gridLayout_2);
        tabItem_5.setControl((Control)cComp);
        this.refRepHeadButton = new Button(cComp, 32);
        this.refRepHeadButton.setText(Messages.getString("TellerTrxMainPanel.Refer_to_reply_head_27"));
        this.refRepHeadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TellerTrxMainPanel.this.xmlContent.getChild("srvReply").setAttrValue("refToHead", String.valueOf(TellerTrxMainPanel.this.refRepHeadButton.getSelection()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.repServerDataPanel = new ServerDataPanel(cComp, 0);
        this.repServerDataPanel.setLayoutData(new GridData(1808));
        this.repServerDataPanel.setDataProvider(this);
        TabItem tabItem9 = new TabItem(tabFolder, 0);
        tabItem9.setText(Messages.getString("TellerTrxMainPanel.TransactionLink_1"));
        this.trxLinkPanel = new TransactionLinkPanel((Composite)tabFolder, 0);
        tabItem9.setControl((Control)this.trxLinkPanel);
        this.trxLinkPanel.setDataProvider(this);
        TabItem tabItem10 = new TabItem(tabFolder, 0);
        tabItem10.setText(Messages.getString("TellerTrxMainPanel.Formats_1"));
        this.fmtPanel = new FormatsEditPanel((Composite)tabFolder, 0);
        this.fmtPanel.setDataProvider(this);
        tabItem10.setControl((Control)this.fmtPanel);
        TabItem tabItem11 = new TabItem(tabFolder, 0);
        tabItem11.setText(Messages.getString("TellerTrxMainPanel.deviceAccess"));
        this.devicePanel = new TellerTrxDeviceAccessPanel((Composite)tabFolder, 0);
        tabItem11.setControl((Control)this.devicePanel);
    }

    public void setFlowEditorProfile(EditorProfile profile) {
        this.trxFlowPanel.setFlowEditorProfile(profile);
    }

    public void setStateEditorProfile(EditorProfile profile) {
        this.trxFlowPanel.setStateEditorProfile(profile);
    }

    public void setCommonStates(XMLNode states) {
        this.trxFlowPanel.setCommonStates(states);
    }

    public void setCommonStateMachine(XMLNode node) {
        this.trxFlowPanel.setCommonStateMachine(node);
    }

    public void setStateMachineEditorProfile(EditorProfile profile) {
        this.trxFlowPanel.setStateMachineEditorProfile(profile);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(Messages.getString("TellerTrxMainPanel.Data_Dictionary_Test_Frame_32"));
        TellerTrxMainPanel test = new TellerTrxMainPanel((Composite)shell, 2048);
        XMLNode node = new XMLNode();
        node.setNodeName("TellerClientTrx");
        try {
            String fileName = "/profiles/dataDictionaryEditorProfile.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile aDataProfile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            test.setDataDictionaryEditorProfile(aDataProfile);
            EditorProfile viewProfile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/viewEditorProfile.xml");
            test.setViewEditorProfile(viewProfile);
            EditorProfile receiptProfile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/receiptEditorProfile.xml");
            test.setReceiptEditorProfile(receiptProfile);
            EditorProfile flowProfile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/cltActionProfile.xml");
            test.setFlowEditorProfile(flowProfile);
            XMLLoader xmlLoader1 = new XMLLoader();
            xmlLoader1.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode anode = (XMLNode)xmlLoader1.loadXMLFile("/dataDictionary.xml");
            test.setDataDictionary(anode);
            XMLNode flowNode = (XMLNode)xmlLoader1.loadXMLFile("/clientFlow.xml");
            test.setCommonFlowNode(flowNode);
            test.setXMLContent(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        try {
            FileWriter fw = new FileWriter("/view.xml");
            StringBuffer strBuf = new StringBuffer();
            node.toXMLContent(0, strBuf);
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector getDatas() {
        XMLNode datasNode = this.xmlContent.getChild("datas");
        return datasNode.getChilds();
    }

    public void setXMLContent(XMLNode node) {
        XMLNode trxLinksNode;
        XMLNode srvRep;
        XMLNode property;
        this.xmlContent = node;
        if (node.getAttrValue("trxCode") != null) {
            this.trxCodeText.setText(node.getAttrValue("trxCode"));
        }
        if (node.getAttrValue("trxName") != null) {
            this.trxNameText.setText(node.getAttrValue("trxName"));
        }
        if (node.getDocument() != null) {
            this.text.setText(node.getDocument());
        }
        if (node.getAttrValue("srvTrxCode") != null) {
            this.serverTrxCodeText.setText(node.getAttrValue("srvTrxCode"));
        }
        if ((property = node.getChild("TaskProperty")) == null) {
            property = new XMLNode();
            property.setNodeName("TaskProperty");
            node.add(property);
        }
        TaskPropertyWrapper wrapper = new TaskPropertyWrapper(property, this.taskPropertyProfile.getElement("TaskProperty"));
        wrapper.setWrapperOwner(this);
        this.taskPropertyPanel.showWrapperProperties(wrapper);
        XMLNode datas = node.getChild("datas");
        if (datas == null) {
            datas = new XMLNode();
            datas.setNodeName("datas");
            node.add(datas);
        }
        this.dataDicSelectPanel.setDataXMLNode(datas);
        this.trxFlowPanel.setTrxNode(node);
        this.devicePanel.setTellerTrxNode(node);
        XMLNode srvReq = node.getChild("srvRequest");
        if (srvReq == null) {
            srvReq = new XMLNode();
            srvReq.setNodeName("srvRequest");
            node.add(srvReq);
        }
        this.reqServerDataPanel.setDataNode(srvReq);
        if ("true".equals(srvReq.getAttrValue("refToHead"))) {
            this.refReqHeadButton.setSelection(true);
        }
        if ((srvRep = node.getChild("srvReply")) == null) {
            srvRep = new XMLNode();
            srvRep.setNodeName("srvReply");
            node.add(srvRep);
        }
        if ("true".equals(srvRep.getAttrValue("refToHead"))) {
            this.refRepHeadButton.setSelection(true);
        }
        if ((trxLinksNode = node.getChild("trxLinks")) == null) {
            trxLinksNode = new XMLNode();
            trxLinksNode.setNodeName("trxLinks");
            node.add(trxLinksNode);
        }
        this.trxLinkPanel.setXMLContent(trxLinksNode);
        this.repServerDataPanel.setDataNode(srvRep);
        XMLNode views = node.getChild("views");
        if (views == null) {
            views = new XMLNode();
            views.setNodeName("views");
            node.add(views);
        }
        this.tellerViewDefinePanel.setXMLContent(views);
        XMLNode receipts = node.getChild("receipts");
        if (receipts == null) {
            receipts = new XMLNode();
            receipts.setNodeName("receipts");
            node.add(receipts);
        }
        this.tellerReceiptDefinePanel.setXMLContent(receipts);
        this.devicePanel.setReceiptDefNode(receipts);
        XMLNode fmtsNode = this.xmlContent.getChild("formats");
        if (fmtsNode == null) {
            fmtsNode = new XMLNode();
            fmtsNode.setNodeName("formats");
            this.xmlContent.add(fmtsNode);
        }
        this.fmtPanel.setFormatSettings(fmtsNode);
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
        this.tellerViewDefinePanel.setProblemReporter(reporter);
        this.tellerReceiptDefinePanel.setProblemReporter(reporter);
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (this.reporter != null) {
            this.reporter.reportProblem(type, msg, location, fileName, e);
        } else {
            System.out.println("[" + type + "]" + msg + ":" + location);
        }
    }

    public void setPatternNode(XMLNode node) {
        this.patternNode = node;
        this.tellerViewDefinePanel.setPatternNode(node);
        this.tellerReceiptDefinePanel.setPatternNode(node);
    }

    public void setFunctionNode(XMLNode node) {
        this.functionNode = node;
        this.tellerViewDefinePanel.setFunctionNode(node);
        this.tellerReceiptDefinePanel.setFunctionNode(node);
        this.devicePanel.setFunctionNode(node);
    }

    public XMLNode getFunctionNode() {
        return this.functionNode;
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.functionProfile = profile;
        this.tellerReceiptDefinePanel.setFunctionProfile(profile);
        this.tellerViewDefinePanel.setFunctionProfile(profile);
        this.devicePanel.setFunctionProfile(profile);
    }

    public void setMSRDefNode(XMLNode node) {
        this.devicePanel.setMsrDefNode(node);
    }

    public void setPassbookDefNode(XMLNode node) {
        this.devicePanel.setPassbookDefNode(node);
    }

    public EditorProfile getFunctionProfile() {
        return this.functionProfile;
    }

    public void setPatternProfile(EditorProfile profile) {
        this.tellerReceiptDefinePanel.setPatternProfile(profile);
        this.tellerViewDefinePanel.setPatternProfile(profile);
    }

    public void setTaskPropertyProfile(EditorProfile profile) {
        this.taskPropertyProfile = profile;
    }

    public void setTaskNode(XMLNode node) {
        this.taskNode = node;
        this.tellerViewDefinePanel.setTaskNode(node);
    }

    public void setRootPath(String path) {
        this.rootPath = path;
        this.trxLinkPanel.setRootPath(path);
        this.tellerViewDefinePanel.setRootPath(path);
        this.tellerReceiptDefinePanel.setRootPath(path);
    }

    private void selectServerTrxCode() {
        Object opName = null;
        String[] extensions = new String[]{"*.mtx"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        System.out.println("RootPath:" + this.rootPath);
        if (this.rootPath != null) {
            fileDialog.setFilterPath(String.valueOf(this.rootPath) + "/designFiles/MCITrxs");
        } else {
            fileDialog.setFilterPath("./designFiles/MCITrxs");
        }
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        boolean copySrvData = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Be sure", (String)Messages.getString("TellerTrxMainPanel.Do_you_want_to_copy_the_server_TrxData_define_to_this_trx__5"));
        try {
            XMLElementObjectMaker maker = new XMLElementObjectMaker();
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)maker);
            XMLNode aNode = (XMLNode)loader.loadXMLFile(fileName);
            if (aNode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide MCI Transaction define file!");
                return;
            }
            String trxCode = aNode.getAttrValue("trxCode");
            if (trxCode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide MCI Transaction define file [trxCode] not defined!");
                return;
            }
            this.serverTrxCodeText.setText(trxCode);
            if (!copySrvData) {
                return;
            }
            XMLNode datas = this.xmlContent.getChild("datas");
            if (datas == null) {
                datas = new XMLNode();
                datas.setNodeName("datas");
                this.xmlContent.add(datas);
            }
            XMLNode srvDatas = aNode.getChild("datas");
            int i = 0;
            while (i < srvDatas.getChilds().size()) {
                XMLNode refNode = (XMLNode)srvDatas.getChilds().elementAt(i);
                if (!"#text".equals(refNode.getNodeName())) {
                    String refId = refNode.getAttrValue("refId");
                    boolean isDuplicate = false;
                    int k = 0;
                    while (k < datas.getChilds().size()) {
                        String refId1;
                        XMLNode node1 = (XMLNode)datas.getChilds().elementAt(k);
                        if (!"#text".equals(node1.getNodeName()) && (refId1 = node1.getAttrValue("refId")).equals(refId)) {
                            isDuplicate = true;
                            break;
                        }
                        ++k;
                    }
                    if (!isDuplicate) {
                        XMLNode rNode = (XMLNode)refNode.clone();
                        datas.add(rNode);
                    }
                }
                ++i;
            }
            this.dataDicSelectPanel.setDataXMLNode(datas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void editorFocusGained() {
        this.trxFlowPanel.editorFocusGained();
    }

    public void setPkgTypeXMLNode(XMLNode node) {
        this.fmtPanel.setPkgTypeXMLNode(node);
    }

    public XMLNode getDataDictionary() {
        return this.dataDictionary;
    }

    public EditorProfile getDataEditorProfile() {
        return this.dataProfile;
    }

    public XMLNode getCommonServiceNode() {
        return null;
    }

    public XMLNode getSelfDefineNode() {
        return this.xmlContent;
    }

    public XMLNode getExternResource() {
        return null;
    }

    public XMLNode getDataType() {
        return null;
    }

    public XMLNode getDataTypeDef() {
        return null;
    }

    public XMLNode getChannelSettings() {
        return this.channelSettings;
    }

    public void setChannelSettings(XMLNode channelSettings) {
        this.channelSettings = channelSettings;
    }
}

