/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.flow.Messages;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualTellerFramePanel;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TellerViewDefinePanel
extends Composite {
    private Table table;
    private Text descText;
    private Combo viewTypeCombo;
    private Text viewIdText;
    int[] weights;
    private VisualTellerFramePanel visualViewPanel;
    private EditorProfile editorProfile;
    private XMLNode contentNode;
    private XMLNode curViewNode;
    private Text templeteText;
    private String rootPath;
    private XMLNode dataDictionary;
    private XMLNode patternNode;
    private XMLNode functionNode;
    private XMLNode taskNode;
    private DataProvider dataProvider;
    private BuildProblemReporter reporter;

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.visualViewPanel.setDataProvider(dataProvider);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.visualViewPanel.setDataDictionary(node);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.visualViewPanel.setDataEditorProfile(profile);
    }

    public void setViewEditorProfile(EditorProfile profile) {
        this.editorProfile = profile;
        this.visualViewPanel.setEditorProfile(profile);
    }

    public TellerViewDefinePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        final SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout);
        Label label = new Label(composite_1, 0);
        label.setText(Messages.getString("TellerViewDefinePanel.ViewID__1"));
        this.viewIdText = new Text(composite_1, 2048);
        GridData gridData_9 = new GridData(768);
        gridData_9.horizontalSpan = 3;
        this.viewIdText.setLayoutData((Object)gridData_9);
        Label label_2 = new Label(composite_1, 0);
        label_2.setText(Messages.getString("TellerViewDefinePanel.ViewType__2"));
        this.viewTypeCombo = new Combo(composite_1, 0);
        this.viewTypeCombo.setItems(new String[]{Messages.getString("TellerViewDefinePanel.Input_View_3"), Messages.getString("TellerViewDefinePanel.Output_View_4"), Messages.getString("TellerViewDefinePanel.In/Out_View_5"), "Other"});
        GridData gridData_10 = new GridData();
        gridData_10.horizontalSpan = 3;
        this.viewTypeCombo.setLayoutData((Object)gridData_10);
        Label label_21 = new Label(composite_1, 0);
        label_21.setText(Messages.getString("TellerViewDefinePanel.Templete__1"));
        this.templeteText = new Text(composite_1, 2048);
        GridData gridData_11 = new GridData(768);
        gridData_11.horizontalSpan = 2;
        this.templeteText.setLayoutData((Object)gridData_11);
        Button button_4 = new Button(composite_1, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerViewDefinePanel.this.selectTemplete();
            }
        });
        button_4.setText(">>");
        Label label_3 = new Label(composite_1, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData_1);
        label_3.setText(Messages.getString("TellerViewDefinePanel.Document__6"));
        this.descText = new Text(composite_1, 2818);
        GridData gridData_2 = new GridData(768);
        gridData_2.heightHint = 50;
        gridData_2.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_2);
        Composite composite_2 = new Composite(composite_1, 0);
        GridData gridData_3 = new GridData(256);
        gridData_3.horizontalSpan = 4;
        composite_2.setLayoutData((Object)gridData_3);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_1);
        Button button_1 = new Button(composite_2, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerViewDefinePanel.this.createNewView();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("TellerViewDefinePanel.Create_7"));
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerViewDefinePanel.this.deleteCurrentView();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        button_2.setLayoutData((Object)gridData_5);
        button_2.setText(Messages.getString("TellerViewDefinePanel.Delete_8"));
        Button button_3 = new Button(composite_2, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerViewDefinePanel.this.updateCurrentView();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 80;
        button_3.setLayoutData((Object)gridData_6);
        button_3.setText(Messages.getString("TellerViewDefinePanel.Update_1"));
        this.table = new Table(composite_1, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerViewDefinePanel.this.setActivateView();
            }
        });
        GridData gridData_7 = new GridData(1808);
        gridData_7.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData_7);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(63);
        tableColumn.setText(Messages.getString("TellerViewDefinePanel.View_ID_9"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(79);
        tableColumn_1.setText(Messages.getString("TellerViewDefinePanel.View_Type_10"));
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(280);
        tableColumn_3.setText(Messages.getString("TellerViewDefinePanel.Document_11"));
        CTabFolder tabFolder = new CTabFolder((Composite)sashForm, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                int[] ws = sashForm.getWeights();
                if (ws[0] == 0) {
                    sashForm.setWeights(TellerViewDefinePanel.this.weights);
                    TellerViewDefinePanel.this.layout(true);
                } else {
                    int[] nArray = new int[2];
                    nArray[1] = 400;
                    sashForm.setWeights(nArray);
                    TellerViewDefinePanel.this.layout(true);
                    TellerViewDefinePanel.this.weights[0] = ws[0];
                    TellerViewDefinePanel.this.weights[1] = ws[1];
                }
            }
        });
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("visualDesign"));
        this.visualViewPanel = new VisualTellerFramePanel((Composite)tabFolder, 0);
        tabItem.setControl((Control)this.visualViewPanel);
        tabFolder.setSelection(0);
        this.visualViewPanel.setAcceptableComponentNames("OperationPanel");
        this.visualViewPanel.setLabelMap("label", "Label");
        this.visualViewPanel.setLabelMap("text", "TextField");
        this.weights = new int[2];
        this.weights[0] = 1;
        this.weights[1] = 4;
        sashForm.setWeights(this.weights);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setXMLContent(XMLNode node) {
        this.contentNode = node;
        this.table.removeAll();
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode viewNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(viewNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(viewNode.getAttrValue("id"));
                item.setData((Object)viewNode);
                if (viewNode.getAttrValue("viewType") != null) {
                    item.setText(1, viewNode.getAttrValue("viewType"));
                }
                if (viewNode.getDocument() != null) {
                    item.setText(2, viewNode.getDocument());
                }
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.table.setSelection(0);
            this.setActivateView();
        }
    }

    private void createNewView() {
        String viewId = this.viewIdText.getText();
        if (!this.checkViewName(viewId)) {
            return;
        }
        if (this.contentNode.getChilds() != null && this.contentNode.findChildNode(viewId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Warning_20"), (String)Messages.getString("TellerViewDefinePanel.Duplicated_View_ID_!_21"));
            return;
        }
        XMLNode viewNode = new XMLNode();
        viewNode.setNodeName("view");
        viewNode.setAttrValue("id", viewId);
        XMLNode viewDataNode = new XMLNode();
        viewDataNode.setNodeName("datas");
        viewNode.add(viewDataNode);
        viewNode.setAttrValue("viewType", this.viewTypeCombo.getText());
        viewNode.setDocument(this.descText.getText());
        XMLNode viewDefNode = new XMLNode();
        viewDefNode.setNodeName("viewDef");
        viewNode.add(viewDefNode);
        XMLNode view = null;
        if (this.templeteText.getText().length() == 0) {
            view = new XMLNode();
        } else {
            try {
                XMLLoader loader = new XMLLoader();
                XMLElementObjectMaker maker = new XMLElementObjectMaker();
                loader.addObjectMaker((ObjectMaker)maker);
                view = (XMLNode)loader.loadXMLFile(this.templeteText.getText());
            }
            catch (Exception e) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.warning_3"), (String)(String.valueOf(Messages.getString("TellerViewDefinePanel.Invalid_templete_file_!_n_4")) + e));
                return;
            }
            if (view == null || !"OperationPanel".equals(view.getNodeName())) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.warning_5"), (String)Messages.getString("TellerViewDefinePanel.Invalid_templete_file_!_6"));
                return;
            }
        }
        view.setNodeName("OperationPanel");
        view.setAttrValue("name", "OperationPanel");
        view.setAttrValue("x", "25");
        view.setAttrValue("y", "25");
        view.setAttrValue("width", "600");
        view.setAttrValue("height", "400");
        viewDefNode.add(view);
        this.contentNode.add(viewNode);
        TableItem item = new TableItem(this.table, 0);
        item.setText(viewId);
        item.setText(1, this.viewTypeCombo.getText());
        item.setText(2, this.descText.getText());
        item.setData((Object)viewNode);
    }

    private void setActivateView() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        if (this.curViewNode == node) {
            return;
        }
        try {
            this.visualViewPanel.setXMLContent(node.getChild("viewDef").getChild("OperationPanel"));
            this.curViewNode = node;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.viewIdText.setText(node.getAttrValue("id"));
        if (node.getAttrValue("viewType") != null) {
            this.viewTypeCombo.setText(node.getAttrValue("viewType"));
        } else {
            this.viewTypeCombo.setText("");
        }
        if (node.getDocument() != null) {
            this.descText.setText(node.getDocument());
        } else {
            this.descText.setText("");
        }
    }

    private void updateCurrentView() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        String viewId = this.viewIdText.getText();
        if (!this.checkViewName(viewId)) {
            return;
        }
        XMLNode aNode = this.contentNode.findChildNode(viewId);
        if (aNode != null && aNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Warning_20"), (String)Messages.getString("TellerViewDefinePanel.Duplicated_View_ID_!_21"));
            return;
        }
        node.setAttrValue("id", viewId);
        node.setAttrValue("viewType", this.viewTypeCombo.getText());
        node.setDocument(this.descText.getText());
        selects[0].setText(viewId);
        selects[0].setText(1, this.viewTypeCombo.getText());
        selects[0].setText(2, this.descText.getText());
    }

    private void deleteCurrentView() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Are_your_sure..._48"), (String)Messages.getString("TellerViewDefinePanel.Are_you_sure_to_delete_the_view_define__49"))) {
            XMLNode viewNode = (XMLNode)items[0].getData();
            this.contentNode.remove(viewNode);
            items[0].dispose();
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(0);
            this.setActivateView();
        } else {
            try {
                this.visualViewPanel.setXMLContent(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (this.reporter != null) {
            this.reporter.reportProblem(type, msg, location, fileName, e);
        } else {
            System.out.println("[" + type + "]" + msg + ":" + location);
        }
    }

    public void setPatternNode(XMLNode node) {
        this.patternNode = node;
        this.visualViewPanel.setPatternNode(node);
    }

    public void setFunctionNode(XMLNode node) {
        this.functionNode = node;
        this.visualViewPanel.setFunctionNode(this.functionNode);
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.visualViewPanel.setFunctionProfile(profile);
    }

    public void setPatternProfile(EditorProfile profile) {
        this.visualViewPanel.setPatternProfile(profile);
    }

    public void setTaskNode(XMLNode node) {
        this.taskNode = node;
        this.visualViewPanel.setTaskNode(this.taskNode);
    }

    public void setRootPath(String path) {
        this.rootPath = path;
        this.visualViewPanel.setRootPath(path);
    }

    private void selectTemplete() {
        String[] extensions = new String[]{"*.xml"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        if (this.rootPath != null) {
            fileDialog.setFilterPath(String.valueOf(this.rootPath) + "/designFiles");
        } else {
            fileDialog.setFilterPath("./designFiles");
        }
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        fileName = fileName.replace('\\', '/');
        String relPath = String.valueOf(this.rootPath) + "/designFiles/";
        this.templeteText.setText(fileName);
    }

    private boolean checkViewName(String name) {
        if (name.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Warning_18"), (String)Messages.getString("TellerViewDefinePanel.Please_input_proper_View_ID_!_19"));
            return false;
        }
        String tmp = name.toLowerCase();
        if (!tmp.endsWith(".xml")) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Warning_18"), (String)Messages.getString("TellerViewDefinePanel.The_view_id_should_end_with___.xml___!_2"));
            return false;
        }
        return true;
    }
}

