/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.client.teller;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import com.ecc.ide.editor.client.teller.ServerDataPanel;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TransactionLinkPanel
extends Composite
implements DataProvider {
    private Combo linkTypeSelector;
    private Text documentText;
    private Text conditionText;
    private Text trxCodeText;
    private Table table;
    private ServerDataPanel linkOutDataPanel;
    private ServerDataPanel linkInDataPanel;
    private XMLNode dataDictionary;
    private String rootPath;
    private Hashtable refDataNodes = new Hashtable();
    private String trxFileName;
    private XMLNode xmlContent;

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public TransactionLinkPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 512);
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        composite_1.setLayout((Layout)new FillLayout());
        SashForm sashForm_1 = new SashForm(composite_1, 0);
        Composite composite_2 = new Composite((Composite)sashForm_1, 0);
        composite_2.setLayout((Layout)new GridLayout());
        Label label_1 = new Label(composite_2, 0);
        label_1.setText(Messages.getString("TransactionLinkPanel.Link_Trancation_List__1"));
        this.table = new Table(composite_2, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionLinkPanel.this.setActivateTask();
            }
        });
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(117);
        tableColumn.setText(Messages.getString("TransactionLinkPanel.Transaction_Code_2"));
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(100);
        tableColumn_3.setText(Messages.getString("TransactionLinkPanel.Link_Type_3"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("TransactionLinkPanel.Condition_4"));
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("TransactionLinkPanel.Document_5"));
        Composite composite_3 = new Composite((Composite)sashForm_1, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite_3.setLayout((Layout)gridLayout);
        Label label_2 = new Label(composite_3, 0);
        label_2.setText(Messages.getString("TransactionLinkPanel.Trasction_Code__6"));
        this.trxCodeText = new Text(composite_3, 2056);
        this.trxCodeText.setLayoutData((Object)new GridData(768));
        Button button = new Button(composite_3, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionLinkPanel.this.selectLinkTaskCode();
            }
        });
        button.setText(">>");
        Label label_5 = new Label(composite_3, 0);
        label_5.setText(Messages.getString("TransactionLinkPanel.Link_Type__8"));
        this.linkTypeSelector = new Combo(composite_3, 0);
        this.linkTypeSelector.setItems(new String[]{Messages.getString("TransactionLinkPanel.Condition_Link_9"), Messages.getString("TransactionLinkPanel.Selection_link_10")});
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 103;
        gridData_3.horizontalSpan = 2;
        this.linkTypeSelector.setLayoutData((Object)gridData_3);
        Label label_3 = new Label(composite_3, 0);
        label_3.setText(Messages.getString("TransactionLinkPanel.Condition__11"));
        this.conditionText = new Text(composite_3, 2048);
        this.conditionText.setLayoutData((Object)new GridData(768));
        Button button_1 = new Button(composite_3, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionLinkPanel.this.editConditionStr();
            }
        });
        button_1.setText(">>");
        Label label_4 = new Label(composite_3, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label_4.setLayoutData((Object)gridData);
        label_4.setText(Messages.getString("TransactionLinkPanel.Document__13"));
        this.documentText = new Text(composite_3, 2818);
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 3;
        this.documentText.setLayoutData((Object)gridData_1);
        Composite composite_4 = new Composite(composite_3, 0);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 3;
        composite_4.setLayoutData((Object)gridData_2);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_4.setLayout((Layout)gridLayout_1);
        Button button_2 = new Button(composite_4, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionLinkPanel.this.createNewLinkTask();
            }
        });
        button_2.setText(Messages.getString("TransactionLinkPanel.Create_14"));
        Button button_3 = new Button(composite_4, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionLinkPanel.this.deleteLinkTask();
            }
        });
        button_3.setText(Messages.getString("TransactionLinkPanel.Delete_15"));
        Button button_4 = new Button(composite_4, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionLinkPanel.this.updateLinkTask();
            }
        });
        button_4.setText(Messages.getString("TransactionLinkPanel.Update_16"));
        sashForm_1.setWeights(new int[]{1, 1});
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new FillLayout());
        SashForm sashForm_2 = new SashForm(composite, 0);
        Composite composite_5 = new Composite((Composite)sashForm_2, 0);
        composite_5.setLayout((Layout)new GridLayout());
        Label label = new Label(composite_5, 0);
        label.setText(Messages.getString("TransactionLinkPanel.Link_Out_Data__17"));
        this.linkOutDataPanel = new ServerDataPanel(composite_5, 0);
        this.linkOutDataPanel.setLayoutData(new GridData(1808));
        Composite composite_6 = new Composite((Composite)sashForm_2, 0);
        composite_6.setLayout((Layout)new GridLayout());
        Label label_6 = new Label(composite_6, 0);
        label_6.setText(Messages.getString("TransactionLinkPanel.Link_In_Data__18"));
        this.linkInDataPanel = new ServerDataPanel(composite_6, 0);
        this.linkInDataPanel.setLayoutData(new GridData(1808));
        this.linkInDataPanel.setDataProvider(this);
        sashForm_2.setWeights(new int[]{1, 1});
        sashForm.setWeights(new int[]{1, 1});
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
        this.table.removeAll();
        Vector childs = node.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(aNode.getAttrValue("id"));
                String linkType = aNode.getAttrValue("linkType");
                if (linkType.equals("SELECT")) {
                    item.setText(1, Messages.getString("TransactionLinkPanel.Selection_link_10"));
                } else {
                    item.setText(1, Messages.getString("TransactionLinkPanel.Condition_Link_9"));
                }
                if (aNode.getAttrValue("condition") != null) {
                    item.setText(2, aNode.getAttrValue("condition"));
                }
                if (aNode.getDocument() != null) {
                    item.setText(3, aNode.getDocument());
                }
                item.setData((Object)aNode);
            }
            ++i;
        }
    }

    private void createNewLinkTask() {
        String trxCode = this.trxCodeText.getText();
        if (trxCode.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TransactionLinkPanel.Warning_25"), (String)Messages.getString("TransactionLinkPanel.Please_select_a_proper_link_to_Trx_!_26"));
            return;
        }
        if (this.xmlContent.findChildNode(trxCode) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TransactionLinkPanel.Warning_27"), (String)Messages.getString("TransactionLinkPanel.You_have_still_link_to_this_trx_code_!_28"));
            return;
        }
        String linkType = this.linkTypeSelector.getText();
        if (linkType.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TransactionLinkPanel.Warning_29"), (String)Messages.getString("TransactionLinkPanel.Please_select_a_proper_link_type_!_30"));
            return;
        }
        int idx = this.linkTypeSelector.getSelectionIndex();
        linkType = idx == 0 ? "CONDITION" : "SELECT";
        String condition = this.conditionText.getText();
        XMLNode node = new XMLNode();
        node.setNodeName("trxLink");
        node.setAttrValue("id", trxCode);
        node.setAttrValue("trxCode", trxCode);
        node.setAttrValue("linkType", linkType);
        node.setAttrValue("condition", condition);
        node.setAttrValue("trxFileName", this.trxFileName);
        node.setDocument(this.documentText.getText());
        TableItem item = new TableItem(this.table, 0);
        item.setText(trxCode);
        item.setText(1, this.linkTypeSelector.getText());
        item.setText(2, condition);
        item.setText(3, this.documentText.getText());
        item.setData((Object)node);
        this.xmlContent.add(node);
        XMLNode linkOutNode = new XMLNode();
        linkOutNode.setNodeName("linkOutData");
        node.add(linkOutNode);
        XMLNode linkInNode = new XMLNode();
        linkInNode.setNodeName("linkInData");
        node.add(linkInNode);
        this.linkInDataPanel.setDataNode(linkInNode);
        this.linkOutDataPanel.setDataNode(linkOutNode);
    }

    private void deleteLinkTask() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("TransactionLinkPanel.Warning_40"), (String)Messages.getString("TransactionLinkPanel.Are_you_sure_to_delete_the_selected_linkTask__41"))) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        items[0].dispose();
        this.xmlContent.remove(node);
        this.linkInDataPanel.setDataNode(null);
        this.linkOutDataPanel.setDataNode(null);
        this.trxCodeText.setText("");
        this.conditionText.setText("");
        this.documentText.setText("");
    }

    private void updateLinkTask() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        String condition = this.conditionText.getText();
        String trxCode = this.trxCodeText.getText();
        if (trxCode.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TransactionLinkPanel.Warning_45"), (String)Messages.getString("TransactionLinkPanel.Please_select_a_proper_trxCode_to_link_to_!_46"));
            return;
        }
        XMLNode aNode = this.xmlContent.findChildNode(trxCode);
        if (aNode != null && aNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TransactionLinkPanel.Warning_47"), (String)Messages.getString("TransactionLinkPanel.You_have_still_link_to_this_trxCode_!_48"));
            return;
        }
        String linkType = this.linkTypeSelector.getText();
        if (linkType.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TransactionLinkPanel.Warning_29"), (String)Messages.getString("TransactionLinkPanel.Please_select_a_proper_link_type_!_30"));
            return;
        }
        int idx = this.linkTypeSelector.getSelectionIndex();
        linkType = idx == 0 ? "CONDITION" : "SELECT";
        node.setAttrValue("id", trxCode);
        node.setAttrValue("trxCode", trxCode);
        node.setAttrValue("condition", condition);
        node.setAttrValue("linkType", linkType);
        node.setAttrValue("desc", this.documentText.getText());
        node.setAttrValue("trxFileName", this.trxFileName);
        items[0].setText(trxCode);
        items[0].setText(1, this.linkTypeSelector.getText());
        items[0].setText(2, condition);
        items[0].setText(3, this.documentText.getText());
    }

    private void setActivateTask() {
        XMLNode linkInNode;
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        this.trxCodeText.setText(node.getAttrValue("id"));
        String linkType = node.getAttrValue("linkType");
        if ("CONDITION".equals(linkType)) {
            this.linkTypeSelector.setText(Messages.getString("TransactionLinkPanel.Condition_Link_9"));
        } else {
            this.linkTypeSelector.setText(Messages.getString("TransactionLinkPanel.Selection_link_10"));
        }
        if (node.getAttrValue("desc") != null) {
            this.documentText.setText(node.getAttrValue("desc"));
        } else {
            this.documentText.setText("");
        }
        if (node.getAttrValue("condition") != null) {
            this.conditionText.setText(node.getAttrValue("condition"));
        } else {
            this.conditionText.setText("");
        }
        this.trxFileName = node.getAttrValue("trxFileName");
        XMLNode linkOutNode = node.getChild("linkOutData");
        if (linkOutNode == null) {
            linkOutNode = new XMLNode();
            linkOutNode.setNodeName("linkOutData");
            node.add(linkOutNode);
        }
        if ((linkInNode = node.getChild("linkInData")) == null) {
            linkInNode = new XMLNode();
            linkInNode.setNodeName("linkInData");
            node.add(linkInNode);
        }
        this.linkInDataPanel.setDataNode(linkInNode);
        this.linkOutDataPanel.setDataNode(linkOutNode);
    }

    private void selectLinkTaskCode() {
        Object opName = null;
        String[] extensions = new String[]{"*.ttx"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        System.out.println("RootPath:" + this.rootPath);
        if (this.rootPath != null) {
            fileDialog.setFilterPath(String.valueOf(this.rootPath) + "/designFiles/TellerTrxs");
        } else {
            fileDialog.setFilterPath("./designFiles/MCITrxs");
        }
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        this.loadTrxFileInfo(fileName);
    }

    private void editConditionStr() {
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.linkOutDataPanel.setDataProvider(dataProvider);
    }

    private void loadTrxFileInfo(String fileName) {
        try {
            int idx;
            XMLElementObjectMaker maker = new XMLElementObjectMaker();
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)maker);
            XMLNode aNode = (XMLNode)loader.loadXMLFile(fileName);
            if (aNode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide Teller Transaction define file!");
                return;
            }
            String trxCode = aNode.getAttrValue("trxCode");
            if (trxCode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide Teller Transaction define file [trxCode] not defined!");
                return;
            }
            this.trxCodeText.setText(trxCode);
            XMLNode datasNode = aNode.getChild("datas");
            if (datasNode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide Teller Transaction define file [trxCode] not defined!");
                return;
            }
            if (this.rootPath != null && (idx = fileName.indexOf(this.rootPath)) != -1) {
                this.trxFileName = fileName.substring(idx + 1 + this.rootPath.length());
            }
            this.refDataNodes.put(trxCode, datasNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.linkInDataPanel.setDataDictionary(node);
        this.linkOutDataPanel.setDataDictionary(node);
    }

    public Vector getDatas() {
        String trxCode = this.trxCodeText.getText();
        if (trxCode == null) {
            return null;
        }
        XMLNode datasNode = (XMLNode)this.refDataNodes.get(trxCode);
        if (datasNode == null) {
            XMLNode node = this.xmlContent.findChildNode(trxCode);
            if (node == null) {
                return null;
            }
            String fileName = String.valueOf(this.rootPath) + "/" + node.getAttrValue("trxFileName");
            this.loadTrxFileInfo(fileName);
            datasNode = (XMLNode)this.refDataNodes.get(trxCode);
        }
        if (datasNode != null) {
            Vector<XMLNode> datas = new Vector<XMLNode>();
            if (datasNode.getChilds() == null) {
                return datas;
            }
            int i = 0;
            while (i < datasNode.getChilds().size()) {
                String dataId;
                XMLNode dataNode;
                XMLNode aNode = (XMLNode)datasNode.getChilds().elementAt(i);
                if (!"#text".equals(aNode.getNodeName()) && (dataNode = this.dataDictionary.findChildNode(dataId = aNode.getAttrValue("refId"))) != null) {
                    datas.addElement(dataNode);
                }
                ++i;
            }
            return datas;
        }
        return null;
    }
}

