/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.data;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import com.ecc.ide.editor.data.RefDataWrapper;
import java.util.Vector;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class CommonDataPanel
extends Composite {
    private Text dataIDText;
    private XMLNode dataDictionary;
    private XMLNode channelSettings;
    private TableTree tableTree;

    public void setDataIDText(Text text) {
        this.dataIDText = text;
    }

    public CommonDataPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.tableTree = new TableTree((Composite)this, 67586);
        Table table = this.tableTree.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonDataPanel.this.setActivateItem();
            }
        });
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(111);
        tableColumn.setText(Messages.getString("DataDicSelectPanel.DataID_9"));
        TableColumn tableColumn_1 = new TableColumn(table, 0);
        tableColumn_1.setWidth(114);
        tableColumn_1.setText(Messages.getString("DataDicSelectPanel.DataName_10"));
        TableColumn tableColumn_2 = new TableColumn(table, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("DataDicSelectPanel.DataType_11"));
        TableColumn tableColumn_3 = new TableColumn(table, 0);
        tableColumn_3.setWidth(132);
        tableColumn_3.setText(Messages.getString("DataDictionaryPanel.Access_Mode_3"));
        TableColumn tableColumn_5 = new TableColumn(table, 0);
        tableColumn_5.setWidth(100);
        tableColumn_5.setText(Messages.getString("DataDicSelectPanel.Initial_Value_3"));
        TableColumn tableColumn_4 = new TableColumn(table, 0);
        tableColumn_4.setWidth(100);
        tableColumn_4.setText(Messages.getString("DataDicSelectPanel.Description_12"));
    }

    private void setActivateItem() {
        if (this.dataIDText == null) {
            return;
        }
        TableTreeItem[] items = this.tableTree.getSelection();
        if (items.length != 1) {
            return;
        }
        if (items[0].getParentItem() != null) {
            XMLNode node = (XMLNode)items[0].getData();
            this.dataIDText.setText(node.getAttrValue("id"));
            return;
        }
        RefDataWrapper refWrapper = (RefDataWrapper)items[0].getData();
        XMLNode curNode = refWrapper.getRefDataNode();
        if (curNode != null) {
            this.dataIDText.setText(curNode.getAttrValue("refId"));
        } else {
            curNode = refWrapper.getDataNode();
            this.dataIDText.setText(curNode.getAttrValue("id"));
        }
    }

    public void setDataXMLNode(XMLNode datasNode, String accessPrefix) {
        if (datasNode.getChilds() == null) {
            return;
        }
        Vector childs = (Vector)datasNode.getChilds().clone();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                String refId = aNode.getAttrValue("refId");
                String access = aNode.getAttrValue("access");
                access = access == null ? String.valueOf(accessPrefix) + ":" : String.valueOf(accessPrefix) + ":" + access;
                XMLNode dataNode = this.dataDictionary.findChildNode(refId);
                if (dataNode == null) {
                    System.out.println(String.valueOf(Messages.getString("DataDicSelectPanel.Warning__the_node_in_MCI_TrxDefine_File_refer_to_an_not_defined_Data___2")) + aNode.toString());
                } else {
                    RefDataWrapper refWrapper = new RefDataWrapper(dataNode, aNode, null);
                    TableTreeItem item = new TableTreeItem(this.tableTree, 0);
                    item.setText(dataNode.getAttrValue("id"));
                    if (dataNode.getAttrValue("label") != null) {
                        item.setText(1, dataNode.getAttrValue("label"));
                    }
                    item.setText(2, dataNode.getNodeName());
                    item.setText(3, access);
                    String dfValue = aNode.getAttrValue("defaultValue");
                    if (dfValue == null) {
                        dfValue = "";
                    }
                    item.setText(4, dfValue);
                    if (dataNode.getAttrValue("desc") != null) {
                        item.setText(5, dataNode.getAttrValue("desc"));
                    }
                    item.setData((Object)refWrapper);
                    if ("dataCollection".equals(dataNode.getNodeName())) {
                        this.addDataElement(item, dataNode);
                    }
                }
            }
            ++i;
        }
    }

    private void addDataElement(TableTreeItem item, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                XMLNode dataNode;
                String id = aNode.getAttrValue("id");
                if (id == null) {
                    id = aNode.getAttrValue("refId");
                }
                if ((dataNode = this.dataDictionary.findChildNode(id)) == null) {
                    System.out.println(String.valueOf(Messages.getString("DataDicSelectPanel.Warning__the_node_in_MCI_TrxDefine_File_refer_to_an_not_defined_Data___24")) + aNode.toString());
                }
                TableTreeItem aItem = new TableTreeItem(item, 0);
                aItem.setText(id);
                if (dataNode != null && dataNode.getAttrValue("label") != null) {
                    aItem.setText(1, dataNode.getAttrValue("label"));
                } else if (aNode.getAttrValue("label") != null) {
                    aItem.setText(1, aNode.getAttrValue("label"));
                }
                if (dataNode != null) {
                    aItem.setText(2, dataNode.getNodeName());
                } else {
                    aItem.setText(2, aNode.getNodeName());
                }
                if (dataNode != null && dataNode.getAttrValue("desc") != null) {
                    aItem.setText(4, dataNode.getAttrValue("desc"));
                } else if (aNode.getAttrValue("desc") != null) {
                    aItem.setText(4, aNode.getAttrValue("desc"));
                }
                aItem.setData((Object)aNode);
                if (aNode.getChilds() != null && aNode.getChilds().size() > 0) {
                    this.addDataElement(aItem, aNode);
                }
            }
            ++i;
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.addDictionaryCommonData(node);
    }

    private void addDictionaryCommonData(XMLNode node) {
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode dataNode = (XMLNode)node.getChilds().elementAt(i);
            String nodeName = dataNode.getNodeName();
            if ("dataElement".equals(nodeName) || "dataCollection".equals(nodeName)) {
                String access = dataNode.getAttrValue("access");
                if ("common".equals(access)) {
                    RefDataWrapper refWrapper = new RefDataWrapper(dataNode, null, null);
                    TableTreeItem item = new TableTreeItem(this.tableTree, 0);
                    item.setText(dataNode.getAttrValue("id"));
                    if (dataNode.getAttrValue("label") != null) {
                        item.setText(1, dataNode.getAttrValue("label"));
                    }
                    item.setText(2, dataNode.getNodeName());
                    item.setText(3, access);
                    String dfValue = dataNode.getAttrValue("defaultValue");
                    if (dfValue == null) {
                        dfValue = "";
                    }
                    item.setText(4, dfValue);
                    if (dataNode.getAttrValue("desc") != null) {
                        item.setText(5, dataNode.getAttrValue("desc"));
                    }
                    item.setData((Object)refWrapper);
                    if ("dataCollection".equals(dataNode.getNodeName())) {
                        this.addDataElement(item, dataNode);
                    }
                }
            } else if ("dataGroup".equals(nodeName)) {
                this.addDictionaryCommonData(dataNode);
            }
            ++i;
        }
    }

    public void setChannelSettings(XMLNode node) {
        this.channelSettings = node;
        if (node == null) {
            return;
        }
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode channelNode = (XMLNode)node.getChilds().elementAt(i);
            XMLNode dataNodes = channelNode.getChild("sessionDatas");
            if (dataNodes != null) {
                this.setDataXMLNode(dataNodes, "channel[" + channelNode.getAttrValue("id") + "]");
            }
            ++i;
        }
    }

    public Vector getSelectedDatas() {
        TableTreeItem[] selects = this.tableTree.getSelection();
        Vector<XMLNode> retValues = new Vector<XMLNode>();
        if (selects != null) {
            int i = 0;
            while (i < selects.length) {
                RefDataWrapper refWrapper = (RefDataWrapper)selects[i].getData();
                retValues.addElement(refWrapper.getDataNode());
                ++i;
            }
        }
        return retValues;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

