/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.data;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.Messages;
import java.util.Vector;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class DataCollectionSelectPanel
extends Composite {
    private TableTree tableTree;
    private Text collectionNameText;
    private String iCollName;

    public DataCollectionSelectPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("DataCollectionSelectPanel.DataCollection_ID__1"));
        this.collectionNameText = new Text((Composite)this, 2048);
        this.collectionNameText.setLayoutData((Object)new GridData(768));
        Label label_1 = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label_1.setLayoutData((Object)gridData);
        label_1.setText(Messages.getString("DataCollectionSelectPanel.Data_Collection_List__2"));
        this.tableTree = new TableTree((Composite)this, 67584);
        Table table = this.tableTree.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataCollectionSelectPanel.this.setActiveCollection();
            }
        });
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("DataCollectionSelectPanel.DataID_3"));
        TableColumn tableColumn_1 = new TableColumn(table, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("DataCollectionSelectPanel.Data_Name_4"));
        TableColumn tableColumn_2 = new TableColumn(table, 0);
        tableColumn_2.setWidth(269);
        tableColumn_2.setText(Messages.getString("DataCollectionSelectPanel.Document_5"));
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 2;
        this.tableTree.setLayoutData((Object)gridData_1);
        this.setSize(600, 400);
    }

    public void setDataDictionary(XMLNode node) {
        this.addDataElementToContent(null, node);
    }

    public String getCollectionName() {
        return this.iCollName;
    }

    public void addDataElementToContent(TableTreeItem pItem, XMLNode node) {
        try {
            if (pItem == null) {
                Vector childs = node.getChilds();
                int i = 0;
                while (i < childs.size()) {
                    XMLNode aNode = (XMLNode)childs.elementAt(i);
                    if (!aNode.getNodeName().equals("DataTypes")) {
                        if (aNode.getNodeName().equals("dataGroup")) {
                            this.addDataElementToContent(null, aNode);
                        } else if (aNode.getNodeName().equals("dataCollection")) {
                            TableTreeItem aItem = new TableTreeItem(this.tableTree, 0);
                            aItem.setText(0, aNode.getAttrValue("id"));
                            if (aNode.getAttrValue("label") != null) {
                                aItem.setText(1, aNode.getAttrValue("label"));
                            }
                            if (aNode.getAttrValue("desc") != null) {
                                aItem.setText(2, aNode.getNodeName());
                            }
                            aItem.setData((Object)aNode);
                            this.addDataElementToContent(aItem, aNode);
                        }
                    }
                    ++i;
                }
            } else {
                Vector childs = node.getChilds();
                int i = 0;
                while (i < childs.size()) {
                    XMLNode aNode = (XMLNode)childs.elementAt(i);
                    if (!"#text".equals(aNode.getNodeName())) {
                        TableTreeItem aItem = new TableTreeItem(pItem, 0);
                        aItem.setText(0, aNode.getAttrValue("id"));
                        if (aNode.getAttrValue("label") != null) {
                            aItem.setText(1, aNode.getAttrValue("label"));
                        }
                        if (aNode.getAttrValue("desc") != null) {
                            aItem.setText(2, aNode.getNodeName());
                        }
                        aItem.setData((Object)aNode);
                        this.addDataElementToContent(aItem, aNode);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setActiveCollection() {
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length <= 0) {
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        XMLNode aNode = (XMLNode)selectedItem.getData();
        if (selectItems[0].getParentItem() == null) {
            String dataId = aNode.getAttrValue("id");
            this.collectionNameText.setText(dataId);
            this.iCollName = dataId;
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

