/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.data;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.data.TrxDataPanel;
import com.ecc.ide.editor.data.TrxDataPanelActivityListener;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.Messages;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataDicSelectPanel
extends Composite
implements TrxDataPanelActivityListener {
    private DropTarget dropTarget;
    private Combo accessModeCombo;
    private Text initialValueText;
    private Text groupNameText;
    private Text groupIdText;
    final Button updateGrpButton;
    private Button setButton;
    private XMLNode dataDictionary;
    private XMLNode datasNode;
    Vector datas = new Vector();
    private XMLNode curNode;
    private TableTreeItem curItem;
    private TrxDataPanel dataPanel;
    private boolean editable = false;
    private boolean access = true;
    private EditorProfile dataEditorProfile;

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
        this.dataPanel.setDataDictionaryEditorProfile(profile);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.dataPanel.setDataDictionary(node);
    }

    public void setDataXMLNode(XMLNode datasNode) {
        this.datasNode = datasNode;
        this.dataPanel.setDataXMLNode(datasNode);
    }

    public DataDicSelectPanel(Composite parent, boolean editable, boolean access, int style) {
        super(parent, style);
        this.editable = editable;
        this.access = access;
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Label label_6 = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        label_6.setLayoutData((Object)gridData);
        label_6.setText("\u6570\u636e\u5b9a\u4e49");
        this.dataPanel = new TrxDataPanel(this, 0, access);
        GridData gridData_2 = new GridData(1808);
        this.dataPanel.setLayoutData(gridData_2);
        this.dataPanel.setItemActivityListener(this);
        Composite composite_1 = new Composite((Composite)this, 0);
        composite_1.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 6;
        composite_1.setLayout((Layout)gridLayout_1);
        Label label = new Label(composite_1, 0);
        label.setText(Messages.getString("DataDicSelectPanel.Initial_Value__4"));
        this.initialValueText = new Text(composite_1, 2048);
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 60;
        this.initialValueText.setLayoutData((Object)gridData_4);
        Label label_1 = new Label(composite_1, 0);
        label_1.setText(String.valueOf(Messages.getString("DataDictionaryPanel.Access_Mode_3")) + ":");
        label_1.setVisible(access);
        this.accessModeCombo = new Combo(composite_1, 0);
        this.setButton = new Button(composite_1, 0);
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDicSelectPanel.this.setInitialValue();
            }
        });
        this.setButton.setText(Messages.getString("DataDicSelectPanel.Set_5"));
        GridData gridData_5 = new GridData();
        gridData_5.horizontalSpan = 2;
        this.setButton.setLayoutData((Object)gridData_5);
        Composite composite_3 = new Composite((Composite)this, 0);
        composite_3.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 7;
        composite_3.setLayout((Layout)gridLayout_3);
        Label grpIdLabel = new Label(composite_3, 0);
        grpIdLabel.setText(Messages.getString("DataDicSelectPanel.GroupIDLabel"));
        this.groupIdText = new Text(composite_3, 2048);
        GridData gridDataGrpTxt = new GridData();
        gridDataGrpTxt.widthHint = 60;
        this.groupIdText.setLayoutData((Object)gridDataGrpTxt);
        Label grpNameLabel = new Label(composite_3, 0);
        grpNameLabel.setText(String.valueOf(Messages.getString("DataDicSelectPanel.GroupNameLabel")) + ":");
        this.groupNameText = new Text(composite_3, 2048);
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 60;
        this.groupNameText.setLayoutData((Object)gridData_6);
        Button newGrpButton = new Button(composite_3, 0);
        newGrpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDicSelectPanel.this.createNewDataGroup();
            }
        });
        newGrpButton.setText(Messages.getString("DataDicSelectPanel.AddGroupLabel"));
        if (!editable) {
            newGrpButton.setEnabled(editable);
        }
        this.updateGrpButton = new Button(composite_3, 0);
        this.updateGrpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDicSelectPanel.this.updateDataGroup();
            }
        });
        this.updateGrpButton.setText(Messages.getString("DataDicSelectPanel.updateGroupLabel"));
        Button groupSelectDataButton = new Button(composite_3, 0);
        groupSelectDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDicSelectPanel.this.groupSelectedData();
            }
        });
        groupSelectDataButton.setText("\u5206\u7ec4\u9009\u5b9a\u6570\u636e");
        if (!editable) {
            groupSelectDataButton.setEnabled(editable);
        }
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        composite.setLayout((Layout)gridLayout_2);
        Button addButton = new Button(composite, 0);
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 90;
        addButton.setLayoutData((Object)gridData_1);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDicSelectPanel.this.addDataElement();
            }
        });
        addButton.setText("\u4ece\u6570\u636e\u5b57\u5178\u6dfb\u52a0");
        if (!editable) {
            addButton.setEnabled(editable);
        }
        Button removeDataButton = new Button(composite, 0);
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 90;
        removeDataButton.setLayoutData((Object)gridData_3);
        removeDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDicSelectPanel.this.removeDataElement();
            }
        });
        removeDataButton.setText(Messages.getString("DataDicSelectPanel.Remove_14"));
        if (!editable) {
            removeDataButton.setEnabled(editable);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void addDataElement() {
        if (this.datasNode == null) {
            return;
        }
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setProfile(this.dataEditorProfile);
        Vector selectDatas = (Vector)dialog.open();
        if (selectDatas != null) {
            if (this.access) {
                this.dataPanel.addDataRefElement(selectDatas, this.accessModeCombo.getItems()[0]);
            } else {
                this.dataPanel.addDataRefElement(selectDatas, null);
            }
            if (!this.datasNode.getNodeName().equals("CommonData")) {
                Vector commonDatas = dialog.getSelectedCommonDatas();
                if (commonDatas == null) {
                    return;
                }
                this.dataPanel.addCommonDataRef(commonDatas);
            }
        }
    }

    private void addDataElement(Vector dragDatas) {
        if (dragDatas != null && dragDatas.size() != 0) {
            if (this.access) {
                this.dataPanel.addDataRefElement(dragDatas, this.accessModeCombo.getItems()[0]);
            } else {
                this.dataPanel.addDataRefElement(dragDatas, null);
            }
        }
    }

    private void removeDataElement() {
        this.dataPanel.removeDataElement();
    }

    private void setInitialValue() {
        String value = this.initialValueText.getText();
        String access = "";
        if (this.accessModeCombo.isVisible()) {
            access = this.accessModeCombo.getText();
        }
        this.dataPanel.setInitialValue(value, access);
    }

    public void itemActivated(XMLNode node) {
        this.setButton.setEnabled(false);
        this.updateGrpButton.setEnabled(false);
        this.initialValueText.setText("");
        this.accessModeCombo.setText("");
        this.groupIdText.setText("");
        this.groupNameText.setText("");
        String nodeName = node.getNodeName();
        if ("refCommData".equals(nodeName)) {
            return;
        }
        if ("dataGroup".equals(nodeName)) {
            String groupId = node.getAttrValue("id");
            String groupName = node.getAttrValue("name");
            if (groupId == null) {
                groupId = "";
            }
            if (groupName == null) {
                groupName = "";
            }
            this.groupIdText.setText(groupId);
            this.groupNameText.setText(groupName);
            if (node.getAttrValue("access") != null && this.access) {
                this.accessModeCombo.setText(node.getAttrValue("access"));
            }
            if (this.editable) {
                this.updateGrpButton.setEnabled(true);
                this.setButton.setEnabled(true);
            }
            return;
        }
        XMLNode pNode = node.getParent();
        if (pNode == null) {
            return;
        }
        String pNodeName = pNode.getNodeName();
        if (pNode != null && ("datas".equals(pNodeName) || "sessionDatas".equals(pNodeName))) {
            XMLNode dataDefNode = this.dataDictionary.findChildNode(node.getAttrValue("refId"));
            if (dataDefNode.getNodeName().equals("collection")) {
                return;
            }
            if (node.getAttrValue("defaultValue") != null) {
                this.initialValueText.setText(node.getAttrValue("defaultValue"));
            }
            if (node.getAttrValue("access") != null && this.access) {
                this.accessModeCombo.setText(node.getAttrValue("access"));
            }
            if (this.editable) {
                this.setButton.setEnabled(true);
            }
            return;
        }
    }

    private void setActivateItem() {
    }

    public void setAccessMode(String[] accessModes) {
        this.accessModeCombo.removeAll();
        int i = 0;
        while (i < accessModes.length) {
            this.accessModeCombo.add(accessModes[i]);
            ++i;
        }
    }

    public void setAccess(boolean access) {
        this.access = access;
        this.accessModeCombo.setEnabled(access);
        this.accessModeCombo.setText("");
    }

    private void createNewDataGroup() {
        String groupId = this.groupIdText.getText();
        String groupName = this.groupNameText.getText();
        if (groupId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostDataPanel.Warning_1"), (String)Messages.getString("DataDicSelectPanel.GroupIdWarrningLabel"));
            return;
        }
        this.dataPanel.createNewDataGroup(groupId, groupName);
    }

    private void updateDataGroup() {
        String groupId = this.groupIdText.getText();
        String groupName = this.groupNameText.getText();
        if (groupId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostDataPanel.Warning_1"), (String)Messages.getString("DataDicSelectPanel.GroupIdWarrningLabel"));
            return;
        }
        this.dataPanel.updateDataGroup(groupId, groupName);
    }

    public Vector getDatas() {
        return this.datas;
    }

    private void groupSelectedData() {
        String groupId = this.groupIdText.getText();
        String groupName = this.groupNameText.getText();
        if (groupId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostDataPanel.Warning_1"), (String)Messages.getString("DataDicSelectPanel.GroupIdWarrningLabel"));
            return;
        }
        if (this.access) {
            this.dataPanel.groupSelectedData(groupId, groupName, this.accessModeCombo.getItems()[0]);
        } else {
            this.dataPanel.groupSelectedData(groupId, groupName);
        }
    }

    public Vector getSelectedDatas() {
        return this.dataPanel.getSelectedDatas();
    }

    public void creatDictDropTarget() {
        this.dropTarget = new DropTarget((Control)this.dataPanel.getTrxDataTableTree(), 3);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.dropTarget.setTransfer(types);
        this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                TextTransfer transfer = TextTransfer.getInstance();
                if (transfer.isSupportedType(event.currentDataType)) {
                    String source = (String)event.data;
                    int idx = source.indexOf(":");
                    if (idx >= 0) {
                        source = source.substring(idx + 1);
                    }
                    Vector dragDatas = DataDicSelectPanel.this.getDragDatas(source);
                    DataDicSelectPanel.this.addDataElement(dragDatas);
                }
            }
        });
    }

    private Vector getDragDatas(String source) {
        Vector<XMLNode> dragDatas = new Vector<XMLNode>();
        if (source == null || source.length() == 0) {
            return null;
        }
        int idx = 0;
        while (source.length() != 0) {
            idx = source.indexOf(";");
            String dataId = source.substring(0, idx);
            source = source.substring(idx + 1);
            XMLNode dragData = this.dataDictionary.findChildNode(dataId);
            if (dragData == null) continue;
            dragDatas.add(dragData);
        }
        return dragDatas;
    }
}

