/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.data;

import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.data.DataElementEditDialog;
import com.ecc.ide.editor.data.DataElementWrapper;
import com.ecc.ide.editor.xml.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.swtdesigner.PalletePanel;
import com.swtdesigner.ResourceManager;
import com.zmc.base.algorithm.QSortAlgorithm;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DataDictionaryEditPanel
extends Composite {
    private Text dataIDText;
    private Text dataNameText;
    private Tree dataTree;
    private Text dataClassifyText;
    private Text documentText;
    private TableTree tableTree;
    private Button newFolderButton;
    private Button deleteFolderButton;
    private Button updateFolderButton;
    private Button locateByIDButton;
    private Button locateByNameButton;
    private Button forwardButton;
    private Button backwordButton;
    private Button newButton;
    private Button deleteButton;
    private Button createToButton;
    private Button refDataButton;
    private Button updateButton;
    private Menu popupmenu;
    private EditorProfile profile;
    int[] weights;
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private XMLNode dataDictionary;
    private XMLNode dataTypeDefNode;
    private XMLNode dataTypesNode;
    private boolean sortAscending = false;
    private Image folderImage = null;
    private XMLNode currentClassifyNode;
    private boolean editable = true;
    TableTreeItem[] dndSelection = null;
    int count = 0;
    MenuItem newMenuItem;
    MenuItem propertyItem;
    private String filterStr;
    private Vector dataClassifies = new Vector();
    static /* synthetic */ Class class$0;

    public void setEditable(boolean value) {
        this.editable = value;
        this.newFolderButton.setEnabled(value);
        this.deleteFolderButton.setEnabled(value);
        this.updateFolderButton.setEnabled(value);
        this.newButton.setEnabled(value);
        this.deleteButton.setEnabled(value);
        this.createToButton.setEnabled(value);
        this.refDataButton.setEnabled(value);
        this.updateButton.setEnabled(value);
        this.popupmenu.setEnabled(value);
    }

    public void setFilterStr(String value) {
        this.filterStr = value;
    }

    public DataDictionaryEditPanel(Composite parent, boolean editable, int style) {
        super(parent, style);
        this.createControls(parent, style, editable, 65538);
    }

    public DataDictionaryEditPanel(Composite parent, int style, boolean editable, int tableStyle) {
        super(parent, style);
        this.createControls(parent, style, editable, tableStyle);
    }

    private void createControls(Composite parent, int style, boolean editable, int tableStyle) {
        Composite dataComposite;
        this.editable = editable;
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        composite.setLayout((Layout)gridLayout_1);
        Label label_2 = new Label(composite, 0);
        GridData gridData_16 = new GridData();
        gridData_16.horizontalSpan = 3;
        label_2.setLayoutData((Object)gridData_16);
        label_2.setText(Messages.getString("DataDictionaryPanel.Data_Defines__16"));
        this.dataTree = new Tree(composite, 2048);
        this.dataTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.setActivateDataClassify();
            }
        });
        GridData gridData_6 = new GridData(1808);
        gridData_6.horizontalSpan = 2;
        this.dataTree.setLayoutData((Object)gridData_6);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("DataDictionaryEditPanel.DataClassify__1"));
        this.dataClassifyText = new Text(composite, 2048);
        this.dataClassifyText.setLayoutData((Object)new GridData(768));
        Label label_1 = new Label(composite, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 2;
        label_1.setLayoutData((Object)gridData_1);
        label_1.setText(Messages.getString("DataDictionaryEditPanel.Document__2"));
        this.documentText = new Text(composite, 2818);
        GridData gridData_3 = new GridData(768);
        gridData_3.heightHint = 60;
        gridData_3.horizontalSpan = 2;
        this.documentText.setLayoutData((Object)gridData_3);
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_7 = new GridData(768);
        gridData_7.horizontalSpan = 2;
        gridData_7.widthHint = 2;
        composite_2.setLayoutData((Object)gridData_7);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_2);
        this.newFolderButton = new Button(composite_2, 0);
        this.newFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.addNewDataClassify();
            }
        });
        GridData gridData_10 = new GridData();
        gridData_10.widthHint = 60;
        this.newFolderButton.setLayoutData((Object)gridData_10);
        this.newFolderButton.setText(Messages.getString("DataDictionaryEditPanel.Add_3"));
        this.deleteFolderButton = new Button(composite_2, 0);
        this.deleteFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.deleteDataClassify();
            }
        });
        GridData gridData_9 = new GridData();
        gridData_9.widthHint = 60;
        this.deleteFolderButton.setLayoutData((Object)gridData_9);
        this.deleteFolderButton.setText(Messages.getString("DataDictionaryEditPanel.Delete_4"));
        this.updateFolderButton = new Button(composite_2, 0);
        this.updateFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.updateDataClassify();
            }
        });
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 60;
        this.updateFolderButton.setLayoutData((Object)gridData_8);
        this.updateFolderButton.setText(Messages.getString("DataDictionaryEditPanel.Update_5"));
        if (editable) {
            final SashForm sashForm_1 = new SashForm((Composite)sashForm, 0);
            dataComposite = new Composite((Composite)sashForm_1, 0);
            Composite stackComposite = new Composite((Composite)sashForm_1, 0);
            final StackLayout stackLayout = new StackLayout();
            stackComposite.setLayout((Layout)stackLayout);
            final Composite beanTreeComposite = new Composite(stackComposite, 0);
            final Composite beanTreeToolComposite = new Composite(stackComposite, 0);
            beanTreeToolComposite.setLayout((Layout)new GridLayout());
            GridLayout gridLayout_5 = new GridLayout();
            gridLayout_5.numColumns = 2;
            beanTreeComposite.setLayout((Layout)gridLayout_5);
            Button hideButton = new Button(beanTreeComposite, 8519684);
            hideButton.setToolTipText(Messages.getString("hide"));
            PalletePanel panel3 = new PalletePanel(beanTreeComposite, 0);
            panel3.setTitle(Messages.getString("Properties"));
            panel3.setLayoutData(new GridData(768));
            Button showButton = new Button(beanTreeToolComposite, 0x804004);
            showButton.setToolTipText(Messages.getString("show"));
            PalletePanel panel4 = new PalletePanel(beanTreeToolComposite, 0);
            panel4.setLayoutData(new GridData(1040));
            panel4.setTitle(Messages.getString("Properties"));
            panel4.setDirection(1);
            hideButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataDictionaryEditPanel.this.weights = sashForm_1.getWeights();
                    Point size = sashForm_1.getSize();
                    int[] ws = new int[]{size.x - 25, 25};
                    stackLayout.topControl = beanTreeToolComposite;
                    sashForm_1.setWeights(ws);
                    sashForm_1.layout(true);
                    DataDictionaryEditPanel.this.layout();
                }
            });
            showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    stackLayout.topControl = beanTreeComposite;
                    sashForm_1.setWeights(DataDictionaryEditPanel.this.weights);
                    sashForm_1.layout(true);
                    DataDictionaryEditPanel.this.layout();
                }
            });
            ScrolledComposite scrolledComposite = new ScrolledComposite(beanTreeComposite, 2560);
            GridData sgridData = new GridData(1808);
            sgridData.horizontalSpan = 2;
            scrolledComposite.setLayoutData((Object)sgridData);
            this.editorBeanPropertyPanel = new EditorBeanPropertyPanel((Composite)scrolledComposite, 0);
            this.editorBeanPropertyPanel.setSize(251, 375);
            scrolledComposite.setContent((Control)this.editorBeanPropertyPanel);
            stackLayout.topControl = beanTreeComposite;
            this.weights = new int[2];
            this.weights[0] = 3;
            this.weights[1] = 1;
            sashForm_1.setWeights(this.weights);
        } else {
            dataComposite = new Composite((Composite)sashForm, 0);
        }
        GridLayout gridLayout = new GridLayout();
        dataComposite.setLayout((Layout)gridLayout);
        Group searchGroup = new Group(dataComposite, 0);
        searchGroup.setLayout((Layout)new GridLayout(5, false));
        searchGroup.setText("\u67e5\u627e\u6570\u636e");
        Label fdLabel = new Label((Composite)searchGroup, 0);
        fdLabel.setText(Messages.getString("DataDictionaryEditPanel.finding"));
        fdLabel.setLayoutData((Object)new GridData());
        this.dataIDText = new Text((Composite)searchGroup, 2048);
        this.dataIDText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DataDictionaryEditPanel.this.filterDatas(DataDictionaryEditPanel.this.dataIDText.getText());
            }
        });
        this.dataIDText.setLayoutData((Object)new GridData(75, -1));
        this.dataIDText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.locateDataDefine();
            }
        });
        this.locateByIDButton = new Button((Composite)searchGroup, 32);
        this.locateByIDButton.setText(Messages.getString("DataDictionaryEditPanel.DataId"));
        this.locateByIDButton.setSelection(true);
        this.locateByNameButton = new Button((Composite)searchGroup, 32);
        this.locateByNameButton.setText(Messages.getString("DataDictionaryEditPanel.DataName"));
        Button searchButton = new Button((Composite)searchGroup, 8);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.locateDataDefine();
            }
        });
        searchButton.setText(Messages.getString("DataDictionaryEditPanel.Search_the_Data_Define_3"));
        searchButton.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
        this.forwardButton = new Button((Composite)searchGroup, 16);
        this.forwardButton.setText(Messages.getString("DataDictionaryEditPanel.forward"));
        this.forwardButton.setSelection(true);
        this.backwordButton = new Button((Composite)searchGroup, 16);
        this.backwordButton.setText(Messages.getString("DataDictionaryEditPanel.backward"));
        this.tableTree = new TableTree(dataComposite, 0x800 | tableStyle);
        this.tableTree.setLayoutData((Object)new GridData(1808));
        Table table = this.tableTree.getTable();
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000009) {
                    DataDictionaryEditPanel.this.createNewData(null);
                } else if (e.keyCode == 127) {
                    DataDictionaryEditPanel.this.deleteSelectedData();
                }
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.setActivateDataItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.updateDataElement();
            }
        });
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn DataIdColumn = new TableColumn(table, 0);
        DataIdColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DataDictionaryEditPanel.this.sortData(0);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        DataIdColumn.setWidth(100);
        DataIdColumn.setText(Messages.getString("DataDictionaryPanel.DataID_17"));
        TableColumn DataLabelColumn = new TableColumn(table, 0);
        DataLabelColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DataDictionaryEditPanel.this.sortData(1);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        DataLabelColumn.setWidth(100);
        DataLabelColumn.setText(Messages.getString("DataDictionaryPanel.DataName_18"));
        TableColumn tableColumn_8 = new TableColumn(table, 0);
        tableColumn_8.setWidth(100);
        tableColumn_8.setText(Messages.getString("DataDictionaryPanel.DataField/Collection_2"));
        tableColumn_8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DataDictionaryEditPanel.this.sortData(2);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        TableColumn DataTypeColumn = new TableColumn(table, 0);
        DataTypeColumn.setWidth(100);
        DataTypeColumn.setText(Messages.getString("DataDictionaryPanel.DataType_19"));
        DataTypeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    DataDictionaryEditPanel.this.sortData(3);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        GridData gridData_5 = new GridData(1808);
        gridData_5.heightHint = 114;
        gridData_5.horizontalSpan = 4;
        table.setLayoutData((Object)gridData_5);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tableColumn_5 = new TableColumn(table, 0);
        tableColumn_5.setWidth(100);
        tableColumn_5.setText(Messages.getString("DataDictionaryPanel.Document_20"));
        Composite composite_1 = new Composite(dataComposite, 0);
        GridData gridData_2 = new GridData(768);
        composite_1.setLayoutData((Object)gridData_2);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 5;
        composite_1.setLayout((Layout)gridLayout_3);
        this.newButton = new Button(composite_1, 0);
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        this.newButton.setLayoutData((Object)gridData_4);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.createNewData(null);
            }
        });
        this.newButton.setText(Messages.getString("DataDictionaryPanel.Create_12"));
        this.deleteButton = new Button(composite_1, 0);
        GridData gridData_18 = new GridData();
        gridData_18.widthHint = 80;
        this.deleteButton.setLayoutData((Object)gridData_18);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.deleteSelectedData();
            }
        });
        this.deleteButton.setText(Messages.getString("DataDictionaryPanel.Delete_13"));
        this.createToButton = new Button(composite_1, 0);
        this.createToButton.setEnabled(false);
        this.createToButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.createNewDataToSelectedDataElement();
            }
        });
        GridData gridData_21 = new GridData();
        gridData_21.widthHint = 80;
        this.createToButton.setLayoutData((Object)gridData_21);
        this.createToButton.setText(Messages.getString("DataDictionaryPanel.Create_To_14"));
        this.refDataButton = new Button(composite_1, 0);
        this.refDataButton.setEnabled(false);
        this.refDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.addReferenceData();
            }
        });
        GridData gridData_22 = new GridData();
        gridData_22.widthHint = 80;
        this.refDataButton.setLayoutData((Object)gridData_22);
        this.refDataButton.setText(Messages.getString("DataDictionaryPanel.ref_to_Datas_15"));
        this.updateButton = new Button(composite_1, 0);
        this.updateButton.setEnabled(false);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.updateDataElement();
            }
        });
        GridData gridData_23 = new GridData();
        gridData_23.widthHint = 80;
        this.updateButton.setLayoutData((Object)gridData_23);
        this.updateButton.setText(Messages.getString("DataDictionaryPanel.update_1"));
        sashForm.setWeights(new int[]{1, 3});
        this.popupmenu = new Menu((Control)table);
        MenuItem menuItem_1 = new MenuItem(this.popupmenu, 0);
        menuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.createNewData(null);
            }
        });
        menuItem_1.setText(Messages.getString("DataDictionaryEditPanel.Create_New_element_1"));
        new MenuItem(this.popupmenu, 2);
        this.newMenuItem = new MenuItem(this.popupmenu, 64);
        this.newMenuItem.setText(Messages.getString("DataDictionaryEditPanel.Add..._2"));
        Menu newMenu = new Menu(this.popupmenu);
        this.newMenuItem.setMenu(newMenu);
        MenuItem menuItem_2 = new MenuItem(newMenu, 0);
        menuItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.addReferenceData();
            }
        });
        menuItem_2.setText(Messages.getString("DataDictionaryEditPanel.Data_reference_3"));
        MenuItem menuItem_3 = new MenuItem(newMenu, 0);
        menuItem_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.createNewDataToSelectedDataElement();
            }
        });
        menuItem_3.setText(Messages.getString("DataDictionaryEditPanel.Data_Collection_4"));
        new MenuItem(this.popupmenu, 2);
        MenuItem menuItem_4 = new MenuItem(this.popupmenu, 0);
        menuItem_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.deleteSelectedData();
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.editor.xml.XMLContentPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        menuItem_4.setImage(ResourceManager.getImage(clazz, "/images/delete_edit.gif"));
        menuItem_4.setText(Messages.getString("XMLContentPanel.Delete_8"));
        new MenuItem(this.popupmenu, 2);
        this.propertyItem = new MenuItem(this.popupmenu, 0);
        this.propertyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryEditPanel.this.updateDataElement();
            }
        });
        this.propertyItem.setText(Messages.getString("DataDictionaryEditPanel.Property_5"));
        table.setMenu(this.popupmenu);
        this.createTableDragSource(this.tableTree);
        this.createTreeDropTarget(this.dataTree);
        this.setEditable(editable);
    }

    private DragSource createTableDragSource(final TableTree table) {
        DragSource dragSource = new DragSource((Control)table.getTable(), 3);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            String sourceNames = null;

            public void dragStart(DragSourceEvent event) {
                TableTreeItem[] items = table.getSelection();
                DataDictionaryEditPanel.this.dndSelection = new TableTreeItem[items.length];
                DataDictionaryEditPanel.this.count = 0;
                int i = 0;
                while (i < items.length) {
                    if (items[i].getParentItem() == null) {
                        DataDictionaryEditPanel.this.dndSelection[DataDictionaryEditPanel.this.count++] = items[i];
                    }
                    ++i;
                }
                this.sourceNames = null;
                event.doit = DataDictionaryEditPanel.this.count > 0;
            }

            public void dragFinished(DragSourceEvent event) {
                DataDictionaryEditPanel.this.dragSourceHandleDragFinished(event, this.sourceNames);
                DataDictionaryEditPanel.this.dndSelection = null;
                this.sourceNames = null;
            }

            public void dragSetData(DragSourceEvent event) {
                if (DataDictionaryEditPanel.this.dndSelection == null || DataDictionaryEditPanel.this.dndSelection.length == 0) {
                    return;
                }
                if (!TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    return;
                }
                this.sourceNames = "";
                int i = 0;
                while (i < DataDictionaryEditPanel.this.count) {
                    XMLNode node = (XMLNode)DataDictionaryEditPanel.this.dndSelection[i].getData();
                    this.sourceNames = String.valueOf(this.sourceNames) + node.getAttrValue("id") + ";";
                    ++i;
                }
                event.data = this.sourceNames;
            }
        });
        return dragSource;
    }

    private DropTarget createTreeDropTarget(final Tree tree) {
        DropTarget dropTarget = new DropTarget((Control)tree, 3);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 0;
                TreeItem item = tree.getItem(tree.toControl(new Point(event.x, event.y)));
                if (item == null) {
                    return;
                }
                XMLNode node = (XMLNode)item.getData();
                if (node != DataDictionaryEditPanel.this.currentClassifyNode) {
                    if (event.detail != 1 && event.detail != 2) {
                        event.detail = 2;
                    }
                    event.feedback |= 0x18;
                }
            }

            public void drop(DropTargetEvent event) {
                boolean isRoot = false;
                XMLNode rootNode = (XMLNode)tree.getItems()[0].getData();
                if (DataDictionaryEditPanel.this.currentClassifyNode == rootNode) {
                    isRoot = true;
                }
                TreeItem item = tree.getItem(tree.toControl(new Point(event.x, event.y)));
                XMLNode classifyNode = (XMLNode)item.getData();
                int i = 0;
                while (i < DataDictionaryEditPanel.this.count) {
                    TableTreeItem anItem = DataDictionaryEditPanel.this.dndSelection[i];
                    XMLNode dataNode = (XMLNode)anItem.getData();
                    dataNode.getParent().remove(dataNode);
                    classifyNode.add(dataNode);
                    if (!isRoot) {
                        anItem.dispose();
                    }
                    ++i;
                }
            }
        });
        return dropTarget;
    }

    private void dragSourceHandleDragFinished(DragSourceEvent event, String sourceNames) {
        if (sourceNames == null) {
            return;
        }
        if (event.detail != 2) {
            return;
        }
    }

    public Object getSelectPosition() {
        return null;
    }

    public Vector getSelectedDatas() {
        Vector<Object> datas = new Vector<Object>();
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length <= 0) {
            return datas;
        }
        int i = 0;
        while (i < selectItems.length) {
            TableTreeItem selectedItem = selectItems[i];
            if (selectedItem.getParentItem() == null) {
                datas.addElement(selectedItem.getData());
            }
            ++i;
        }
        return datas;
    }

    public void addDataElementToContent(TableTreeItem pItem, XMLNode node) {
        try {
            if (pItem == null) {
                Vector childs = node.getChilds();
                int i = 0;
                while (i < childs.size()) {
                    XMLNode aNode = (XMLNode)childs.elementAt(i);
                    if (!(aNode.getNodeName().equals("DataTypes") || aNode.getNodeName().equals("dataGroup") || aNode.getNodeName().equals("#text") || aNode.getNodeName().equals("CommonData") || this.filterStr != null && this.filterStr.indexOf(aNode.getNodeName()) == -1)) {
                        TableTreeItem aItem = new TableTreeItem(this.tableTree, 0);
                        aItem.setText(aNode.getAttrValue("id"));
                        if (aNode.getAttrValue("label") != null) {
                            aItem.setText(1, aNode.getAttrValue("label"));
                        }
                        if ("true".equals(aNode.getAttrValue("isSecureField"))) {
                            aItem.setText(2, String.valueOf(aNode.getNodeName()) + "[SEC]");
                        } else {
                            aItem.setText(2, aNode.getNodeName());
                        }
                        String dataType = aNode.getAttrValue("dataType");
                        if (dataType != null) {
                            aItem.setText(3, dataType);
                        }
                        if (aNode.getAttrValue("desc") != null) {
                            aItem.setText(4, aNode.getAttrValue("desc"));
                        }
                        aItem.setData((Object)aNode);
                        this.addDataElementToContent(aItem, aNode);
                    }
                    ++i;
                }
            } else {
                TableTreeItem item = pItem;
                Vector childs = node.getChilds();
                int i = 0;
                while (i < childs.size()) {
                    XMLNode aNode = (XMLNode)childs.elementAt(i);
                    if (!aNode.getNodeName().equals("#text")) {
                        TableTreeItem aItem = new TableTreeItem(item, 0);
                        String id = aNode.getAttrValue("id");
                        if (id != null) {
                            aItem.setText(0, aNode.getAttrValue("id"));
                        }
                        if (aNode.getAttrValue("label") != null) {
                            aItem.setText(1, aNode.getAttrValue("label"));
                        }
                        if (aNode.getAttrValue("desc") != null) {
                            aItem.setText(5, aNode.getAttrValue("desc"));
                        }
                        if (aNode.getNodeName().equals("refData")) {
                            if (id != null) {
                                aNode.setAttrValue("refId", id);
                                aNode.setAttrValue("id", null);
                            }
                            String refId = aNode.getAttrValue("refId");
                            XMLNode dataNode = this.dataDictionary.findChildNode(refId);
                            aItem.setText(refId);
                            if (dataNode != null) {
                                if (dataNode.getAttrValue("label") != null) {
                                    aItem.setText(1, dataNode.getAttrValue("label"));
                                }
                                aItem.setText(2, dataNode.getNodeName());
                                String dataType = dataNode.getAttrValue("dataType");
                                if (dataType != null) {
                                    aItem.setText(3, dataType);
                                }
                                if (dataNode.getAttrValue("desc") != null) {
                                    aItem.setText(4, dataNode.getAttrValue("desc"));
                                }
                            }
                        }
                        aItem.setData((Object)aNode);
                        this.addDataElementToContent(aItem, aNode);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
        if (profile != null) {
            this.folderImage = profile.getElement("dataDictionary.xml").getImage();
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.dataTypesNode = node.getChild("DataTypes");
        if (this.dataTypesNode == null) {
            this.dataTypesNode = new XMLNode();
            this.dataTypesNode.setNodeName("DataTypes");
            node.add(this.dataTypesNode);
        }
        this.dataTree.removeAll();
        TreeItem item = new TreeItem(this.dataTree, 0);
        item.setData((Object)node);
        item.setText(Messages.getString("DataDictionaryEditPanel.Data_Defines_7"));
        item.setImage(this.folderImage);
        this.dataClassifies.addElement(node);
        this.loadDataDefineTree(item, node);
        this.tableTree.removeAll();
        this.showAllDataElement();
        this.currentClassifyNode = node;
    }

    private void loadDataDefineTree(TreeItem pItem, XMLNode pNode) {
        Vector childs = pNode.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i);
            if (node.getNodeName().equals("dataGroup")) {
                String groupId = node.getAttrValue("name");
                if (groupId == null) {
                    groupId = "unDefined!!";
                }
                TreeItem item = new TreeItem(pItem, 0);
                item.setText(groupId);
                item.setData((Object)node);
                item.setImage(this.folderImage);
                this.dataClassifies.addElement(node);
                this.loadDataDefineTree(item, node);
            }
            ++i;
        }
    }

    public void doInsertDataElement(XMLNode node) {
        if (node == null) {
            return;
        }
        this.currentClassifyNode.add(node);
        TableTreeItem aItem = new TableTreeItem(this.tableTree, 0);
        aItem.setText(node.getAttrValue("id").trim());
        if (node.getAttrValue("label") != null) {
            aItem.setText(1, node.getAttrValue("label"));
        }
        aItem.setText(2, node.getNodeName());
        String dataType = node.getAttrValue("dataType");
        if (dataType != null) {
            aItem.setText(3, dataType);
        }
        if (node.getAttrValue("desc") != null) {
            aItem.setText(4, node.getAttrValue("desc"));
        }
        aItem.setData((Object)node);
        this.tableTree.setSelection(new TableTreeItem[]{aItem});
    }

    private void createNewData(String fieldId) {
        DataElementEditDialog dialog = new DataElementEditDialog(this.getShell(), 0);
        dialog.setProfile(this.profile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setEditor(this);
        dialog.setFieldId(fieldId);
        dialog.setDataTypeDefNode(this.dataTypeDefNode);
        XMLNode node = (XMLNode)dialog.open();
        if (node == null) {
            return;
        }
        this.currentClassifyNode.add(node);
        TableTreeItem aItem = new TableTreeItem(this.tableTree, 0);
        aItem.setText(node.getAttrValue("id"));
        if (node.getAttrValue("label") != null) {
            aItem.setText(1, node.getAttrValue("label"));
        }
        aItem.setText(2, node.getNodeName());
        String dataType = node.getAttrValue("dataType");
        if (dataType != null) {
            aItem.setText(3, dataType);
        }
        if (node.getAttrValue("desc") != null) {
            aItem.setText(4, node.getAttrValue("desc"));
        }
        aItem.setData((Object)node);
        this.tableTree.setSelection(new TableTreeItem[]{aItem});
    }

    private void deleteSelectedData() {
        TableTreeItem[] items = this.tableTree.getSelection();
        if (items.length == 0) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("DataDictionaryEditPanel.Are_you_sure..._10"), (String)Messages.getString("DataDictionaryEditPanel.Be_sure_to_delete_the_selected_data_items__11"))) {
            return;
        }
        try {
            int i = 0;
            while (i < items.length) {
                XMLNode node = (XMLNode)items[i].getData();
                items[i].dispose();
                node.getParent().remove(node);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createNewDataToSelectedDataElement() {
        TableTreeItem[] items = this.tableTree.getSelection();
        if (items.length != 1) {
            return;
        }
        DataElementEditDialog dialog = new DataElementEditDialog(this.getShell(), 0);
        dialog.setProfile(this.profile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setDataTypeDefNode(this.dataTypeDefNode);
        XMLNode aNode = new XMLNode();
        aNode.setNodeName("dataCollection");
        dialog.setXMLNode(aNode);
        XMLNode node = (XMLNode)dialog.open();
        if (node == null) {
            return;
        }
        ((XMLNode)items[0].getData()).add(node);
        TableTreeItem aItem = new TableTreeItem(items[0], 0);
        aItem.setText(node.getAttrValue("id"));
        if (node.getAttrValue("label") != null) {
            aItem.setText(1, node.getAttrValue("label"));
        }
        aItem.setText(2, node.getNodeName());
        String dataType = node.getAttrValue("dataType");
        if (dataType != null) {
            aItem.setText(3, dataType);
        }
        if (node.getAttrValue("desc") != null) {
            aItem.setText(4, node.getAttrValue("desc"));
        }
        aItem.setData((Object)node);
    }

    private void addReferenceData() {
        DataDictionarySelectDialog dlg = new DataDictionarySelectDialog(this.getShell(), 0);
        dlg.setProfile(this.profile);
        dlg.setDataDictionary(this.dataDictionary);
        dlg.setEditable(false);
        dlg.setFilterStr("dataElement");
        Object result = dlg.open();
        if (result != null) {
            TableTreeItem[] selectItems = this.tableTree.getSelection();
            if (selectItems.length != 1) {
                return;
            }
            TableTreeItem pItem = selectItems[0];
            XMLNode pNode = (XMLNode)pItem.getData();
            Vector selectDatas = (Vector)result;
            int i = 0;
            while (i < selectDatas.size()) {
                String id;
                XMLNode node = (XMLNode)selectDatas.elementAt(i);
                if (!"#text".equals(node.getNodeName()) && pNode.getChildNode(id = node.getAttrValue("id")) == null) {
                    XMLNode aNode = new XMLNode();
                    aNode.setNodeName("refData");
                    aNode.setAttrValue("refId", id);
                    pNode.add(aNode);
                    TableTreeItem aItem = new TableTreeItem(pItem, 0);
                    aItem.setText(id);
                    if (node.getAttrValue("label") != null) {
                        aItem.setText(1, node.getAttrValue("label"));
                    }
                    aItem.setData((Object)aNode);
                }
                ++i;
            }
        }
    }

    private void updateDataElement() {
        if (!this.editable) {
            return;
        }
        if (this.currentClassifyNode == null) {
            return;
        }
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length != 1) {
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        String nodeType = ((XMLNode)selectedItem.getData()).getNodeName();
        if (!nodeType.equals("dataCollection") && !nodeType.equals("dataElement")) {
            return;
        }
        DataElementEditDialog dialog = new DataElementEditDialog(this.getShell(), 0);
        dialog.setProfile(this.profile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setXMLNode((XMLNode)selectedItem.getData());
        dialog.setDataTypeDefNode(this.dataTypeDefNode);
        XMLNode node = (XMLNode)dialog.open();
        if (node == null) {
            return;
        }
        TableTreeItem aItem = selectItems[0];
        aItem.setText(node.getAttrValue("id"));
        if (node.getAttrValue("label") != null) {
            aItem.setText(1, node.getAttrValue("label"));
        }
        aItem.setText(2, node.getNodeName());
        String dataType = node.getAttrValue("dataType");
        if (dataType != null) {
            aItem.setText(3, dataType);
        } else {
            aItem.setText(3, "");
        }
        if (node.getAttrValue("desc") != null) {
            aItem.setText(4, node.getAttrValue("desc"));
        }
    }

    private void setActivateDataItem() {
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length != 1) {
            return;
        }
        this.enableButtons();
        if (!this.editable) {
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        XMLNode node = (XMLNode)selectItems[0].getData();
        if (node.getNodeName().equals("dataElement")) {
            String dataTypeId = node.getAttrValue("dataType");
            XMLNode dataTypeNode = this.dataTypeDefNode.findChildNode(dataTypeId);
            if (dataTypeNode != null) {
                Element element = new Element();
                ElementAttribute attr = null;
                XMLNode attrsNode = dataTypeNode.getChild("attributes");
                int i = 0;
                while (i < attrsNode.getChilds().size()) {
                    XMLNode attrNode = (XMLNode)attrsNode.getChilds().elementAt(i);
                    if ("attr".equals(attrNode.getNodeName())) {
                        attr = new ElementAttribute(attrNode);
                        element.addAttribute(attr);
                    }
                    ++i;
                }
                DataElementWrapper aWrapper = new DataElementWrapper(node, element);
                this.editorBeanPropertyPanel.showWrapperProperties(aWrapper);
            } else {
                this.editorBeanPropertyPanel.showWrapperProperties(null);
            }
        } else {
            this.editorBeanPropertyPanel.showWrapperProperties(null);
        }
    }

    private void sortData(int itemIdx) {
        Vector childs;
        if (this.currentClassifyNode == null) {
            return;
        }
        boolean bl = this.sortAscending = !this.sortAscending;
        if (this.currentClassifyNode == this.dataDictionary) {
            childs = new Vector();
            int i = 0;
            while (i < this.dataClassifies.size()) {
                XMLNode aNode = (XMLNode)this.dataClassifies.elementAt(i);
                int k = 0;
                while (k < aNode.getChilds().size()) {
                    childs.addElement(aNode.getChilds().elementAt(k));
                    ++k;
                }
                ++i;
            }
        } else {
            childs = this.currentClassifyNode.getChilds();
        }
        if (childs == null || childs.size() < 2) {
            return;
        }
        String[] dataIds = new String[childs.size()];
        int i = 0;
        while (i < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(node.getNodeName())) {
                dataIds[i] = itemIdx == 0 ? node.getAttrValue("id") : (itemIdx == 1 ? node.getAttrValue("label") : (itemIdx == 2 ? node.getNodeName() : node.getAttrValue("dataType")));
            }
            ++i;
        }
        QSortAlgorithm sorter = new QSortAlgorithm();
        try {
            sorter.sort(dataIds, this.sortAscending, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] position = sorter.getFinalPosition();
        this.tableTree.removeAll();
        int i2 = 0;
        while (i2 < position.length) {
            XMLNode aNode = (XMLNode)childs.elementAt(position[i2]);
            if (!(aNode.getNodeName().equals("DataTypes") || aNode.getNodeName().equals("dataGroup") || "#text".equals(aNode.getNodeName()) || aNode.getNodeName().equals("CommonData") || this.filterStr != null && this.filterStr.indexOf(aNode.getNodeName()) == -1)) {
                TableTreeItem aItem = new TableTreeItem(this.tableTree, 0);
                if (aNode.getAttrValue("id") != null) {
                    aItem.setText(0, aNode.getAttrValue("id"));
                } else {
                    System.out.println("Error data Define:" + aNode);
                }
                if (aNode.getAttrValue("label") != null) {
                    aItem.setText(1, aNode.getAttrValue("label"));
                }
                aItem.setText(2, aNode.getNodeName());
                this.addDataElementToContent(aItem, aNode);
                aItem.setData((Object)aNode);
                String dataType = aNode.getAttrValue("dataType");
                if (dataType != null) {
                    aItem.setText(3, dataType);
                }
                if (aNode.getAttrValue("desc") != null) {
                    aItem.setText(4, aNode.getAttrValue("desc"));
                }
            }
            ++i2;
        }
    }

    private void setActivateDataClassify() {
        TreeItem[] items = this.dataTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (this.currentClassifyNode == node) {
            return;
        }
        this.tableTree.removeAll();
        this.currentClassifyNode = node;
        if (items[0].getParentItem() == null) {
            this.showAllDataElement();
            return;
        }
        try {
            String classifyStr = node.getAttrValue("name");
            if (classifyStr == null) {
                classifyStr = "";
            }
            this.dataClassifyText.setText(classifyStr);
            if (node.getAttrValue("desc") != null) {
                this.documentText.setText(node.getAttrValue("desc"));
            } else {
                this.documentText.setText("");
            }
            this.addDataElementToContent(null, node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addNewDataClassify() {
        TreeItem[] items = this.dataTree.getSelection();
        if (items.length != 1) {
            return;
        }
        String classifyStr = this.dataClassifyText.getText();
        if (classifyStr.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryEditPanel.Warning_19"), (String)Messages.getString("DataDictionaryEditPanel.Please_input_proper_classify_String_!_20"));
            return;
        }
        XMLNode pNode = (XMLNode)items[0].getData();
        XMLNode node = new XMLNode();
        node.setNodeName("dataGroup");
        node.setAttrValue("name", classifyStr);
        node.setAttrValue("desc", this.documentText.getText());
        pNode.add(node);
        this.dataClassifies.addElement(node);
        TreeItem item = new TreeItem(items[0], 0);
        item.setData((Object)node);
        item.setText(classifyStr);
        item.setImage(this.folderImage);
        TreeItem[] sItems = new TreeItem[]{item};
        this.dataTree.setSelection(sItems);
    }

    public void setSelectPosition(Object obj) {
    }

    private void updateDataClassify() {
        TreeItem[] items = this.dataTree.getSelection();
        if (items.length != 1) {
            return;
        }
        if (items[0].getParentItem() == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("DataDictionaryEditPanel.Error_24"), (String)Messages.getString("DataDictionaryEditPanel.You_can__t_change_the_root_classify_!_25"));
            return;
        }
        String classifyStr = this.dataClassifyText.getText();
        if (classifyStr.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryEditPanel.Warning_26"), (String)Messages.getString("DataDictionaryEditPanel.Please_input_proper_classify_String_!_27"));
            return;
        }
        items[0].setText(classifyStr);
        XMLNode node = (XMLNode)items[0].getData();
        node.setAttrValue("name", classifyStr);
        node.setAttrValue("desc", this.documentText.getText());
    }

    private void deleteDataClassify() {
        TreeItem[] items = this.dataTree.getSelection();
        if (items.length != 1) {
            return;
        }
        if (items[0].getParentItem() == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("DataDictionaryEditPanel.Error_30"), (String)Messages.getString("DataDictionaryEditPanel.You_can__t_delete_the_root_classify_!_31"));
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("DataDictionaryEditPanel.Are_you_sure_32"), (String)Messages.getString("DataDictionaryEditPanel.Be_sure_to_delete_the_selecetd_Data_classify_define,_it_will_delete_all_data_element_defined_under_it_!_33"))) {
            return;
        }
        XMLNode pNode = (XMLNode)items[0].getParentItem().getData();
        XMLNode node = (XMLNode)items[0].getData();
        this.dataClassifies.removeElement(node);
        pNode.remove(node);
        items[0].dispose();
        this.tableTree.removeAll();
    }

    private void enableButtons() {
        if (!this.editable) {
            return;
        }
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length != 1) {
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        XMLNode node = (XMLNode)selectItems[0].getData();
        if (node.getNodeName().equals("dataCollection")) {
            this.createToButton.setEnabled(true);
            this.refDataButton.setEnabled(true);
            this.newMenuItem.setEnabled(true);
        } else {
            this.createToButton.setEnabled(false);
            this.refDataButton.setEnabled(false);
            this.newMenuItem.setEnabled(false);
        }
        String nodeType = node.getNodeName();
        if (nodeType.equals("dataCollection") || nodeType.equals("dataElement")) {
            this.updateButton.setEnabled(true);
            this.propertyItem.setEnabled(true);
        } else {
            this.updateButton.setEnabled(false);
            this.propertyItem.setEnabled(false);
        }
    }

    private void showAllDataElement() {
        int i = 0;
        while (i < this.dataClassifies.size()) {
            XMLNode node = (XMLNode)this.dataClassifies.elementAt(i);
            this.addDataElementToContent(null, node);
            ++i;
        }
    }

    private void filterDatas(String idStr) {
    }

    private void locateDataDefine() {
        String aItemStr;
        int i;
        boolean locateByID = this.locateByIDButton.getSelection();
        String idStr = this.dataIDText.getText();
        String locateStr = idStr.toLowerCase();
        if (locateStr.length() == 0) {
            return;
        }
        boolean idx = false;
        boolean findId = this.locateByIDButton.getSelection();
        boolean findName = this.locateByNameButton.getSelection();
        TableTreeItem[] items = this.tableTree.getItems();
        int itemIdx = -1;
        int startIdx = 0;
        TableTreeItem[] sItems = this.tableTree.getSelection();
        if (this.forwardButton.getSelection()) {
            if (sItems != null && sItems.length > 0) {
                startIdx = this.tableTree.indexOf(sItems[0]) + 1;
            }
            i = startIdx;
            while (i < items.length) {
                if (findId && (aItemStr = items[i].getText(0).toLowerCase()) != null && aItemStr.indexOf(locateStr) != -1) {
                    itemIdx = i;
                    break;
                }
                if (findName && (aItemStr = items[i].getText(1).toLowerCase()) != null && aItemStr.indexOf(locateStr) != -1) {
                    itemIdx = i;
                    break;
                }
                ++i;
            }
        } else {
            if (sItems != null && sItems.length > 0) {
                startIdx = this.tableTree.indexOf(sItems[0]) - 1;
            }
            i = startIdx;
            while (i >= 0) {
                if (findId && (aItemStr = items[i].getText(0).toLowerCase()) != null && aItemStr.indexOf(locateStr) != -1) {
                    itemIdx = i;
                    break;
                }
                if (findName && (aItemStr = items[i].getText(1).toLowerCase()) != null && aItemStr.indexOf(locateStr) != -1) {
                    itemIdx = i;
                    break;
                }
                --i;
            }
        }
        if (itemIdx != -1) {
            TableTreeItem[] selItems = new TableTreeItem[]{items[itemIdx]};
            this.tableTree.setSelection(selItems);
        } else {
            try {
                i = 0;
                while (i < sItems.length) {
                    if (((XMLNode)sItems[i].getData()).getAttrValue("id").toLowerCase().equals(idStr.toLowerCase())) {
                        return;
                    }
                    ++i;
                }
                if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"\u8b66\u544a", (String)"\u8be5\u6570\u636e\u4e0d\u5b58\u5728\u662f\u5426\u6dfb\u52a0?")) {
                    this.createNewData(idStr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setDataTypeDefNode(XMLNode node) {
        this.dataTypeDefNode = node;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
        super.checkSubclass();
    }
}

