/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.data;

import com.ecc.ide.editor.Editor;
import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.data.DataElementWrapper;
import com.ecc.ide.editor.data.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import com.zmc.base.algorithm.QSortAlgorithm;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DataDictionaryPanel
extends Composite
implements Editor {
    private Combo dataTypeCombo;
    private Text dataPatternText;
    private Text dataTypeDocument;
    private Text dataFmtText;
    private Text lengthText;
    private Text dataTypeNameText;
    private Text dataTypeIDText;
    private Combo accessCombo;
    private Text documentText;
    private Text dataNameText;
    private Table dataTypeTable;
    private Text dataIDText;
    private Combo dataClassicCombo;
    private TableTree tableTree;
    private Button createToButton;
    private Button refDataButton;
    private Button fixedLenCheckButton;
    private Button updateButton;
    private EditorProfile profile;
    private Vector wrappers = new Vector();
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private XMLNode dataDictionary;
    private XMLNode dataTypesNode;
    private boolean sortAscending = false;

    public DataDictionaryPanel(Composite parent, int style) {
        super(parent, style);
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("DataDictionaryPanel.Data_Elements_1"));
        TabItem tabItem_1 = new TabItem(tabFolder, 0);
        tabItem_1.setText(Messages.getString("DataDictionaryPanel.DataTypeSettings_2"));
        Composite dataComposite = new Composite((Composite)tabFolder, 0);
        tabItem.setControl((Control)dataComposite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        dataComposite.setLayout((Layout)gridLayout);
        Label label_1 = new Label(dataComposite, 0);
        label_1.setText(Messages.getString("DataDictionaryPanel.DataID__3"));
        this.dataIDText = new Text(dataComposite, 2048);
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 3;
        gridData_3.widthHint = 120;
        this.dataIDText.setLayoutData((Object)gridData_3);
        Label label_8 = new Label(dataComposite, 0);
        label_8.setText(Messages.getString("DataDictionaryPanel.Chinese_Name__4"));
        this.dataNameText = new Text(dataComposite, 2048);
        GridData gridData_14 = new GridData(768);
        this.dataNameText.setLayoutData((Object)gridData_14);
        Label label = new Label(dataComposite, 0);
        label.setText(Messages.getString("DataDictionaryPanel.DataClassic__5"));
        this.dataClassicCombo = new Combo(dataComposite, 8);
        this.dataClassicCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.elementTypeChanged();
            }
        });
        GridData gridData_1 = new GridData(768);
        this.dataClassicCombo.setLayoutData((Object)gridData_1);
        Label label_13 = new Label(dataComposite, 0);
        label_13.setText(Messages.getString("DataDictionaryPanel.DataType__6"));
        this.dataTypeCombo = new Combo(dataComposite, 0);
        GridData gridData_25 = new GridData();
        gridData_25.widthHint = 157;
        this.dataTypeCombo.setLayoutData((Object)gridData_25);
        Label label_11 = new Label(dataComposite, 0);
        label_11.setText(Messages.getString("DataDictionaryPanel.Access__7"));
        this.accessCombo = new Combo(dataComposite, 0);
        this.accessCombo.setItems(new String[]{"common", "session", "private"});
        Label label_10 = new Label(dataComposite, 0);
        GridData gridData_19 = new GridData();
        gridData_19.horizontalSpan = 4;
        label_10.setLayoutData((Object)gridData_19);
        label_10.setText(Messages.getString("DataDictionaryPanel.Document_11"));
        this.documentText = new Text(dataComposite, 2818);
        GridData gridData_20 = new GridData(768);
        gridData_20.heightHint = 40;
        gridData_20.horizontalSpan = 4;
        this.documentText.setLayoutData((Object)gridData_20);
        Composite composite_1 = new Composite(dataComposite, 0);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 4;
        composite_1.setLayoutData((Object)gridData_2);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 5;
        composite_1.setLayout((Layout)gridLayout_3);
        Button button = new Button(composite_1, 0);
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button.setLayoutData((Object)gridData_4);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.createNewData();
            }
        });
        button.setText(Messages.getString("DataDictionaryPanel.Create_12"));
        Button button_1 = new Button(composite_1, 0);
        GridData gridData_18 = new GridData();
        gridData_18.widthHint = 80;
        button_1.setLayoutData((Object)gridData_18);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.deleteSelectedData();
            }
        });
        button_1.setText(Messages.getString("DataDictionaryPanel.Delete_13"));
        this.createToButton = new Button(composite_1, 0);
        this.createToButton.setEnabled(false);
        this.createToButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.createNewDataToSelectedDataElement();
            }
        });
        GridData gridData_21 = new GridData();
        gridData_21.widthHint = 80;
        this.createToButton.setLayoutData((Object)gridData_21);
        this.createToButton.setText(Messages.getString("DataDictionaryPanel.Create_To_14"));
        this.refDataButton = new Button(composite_1, 0);
        this.refDataButton.setEnabled(false);
        this.refDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.addReferenceData();
            }
        });
        GridData gridData_22 = new GridData();
        gridData_22.widthHint = 80;
        this.refDataButton.setLayoutData((Object)gridData_22);
        this.refDataButton.setText(Messages.getString("DataDictionaryPanel.ref_to_Datas_15"));
        this.updateButton = new Button(composite_1, 0);
        this.updateButton.setEnabled(false);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.updateDataElement();
            }
        });
        GridData gridData_23 = new GridData();
        gridData_23.widthHint = 80;
        this.updateButton.setLayoutData((Object)gridData_23);
        this.updateButton.setText(Messages.getString("DataDictionaryPanel.update_1"));
        Label label_2 = new Label(dataComposite, 0);
        GridData gridData_16 = new GridData();
        gridData_16.horizontalSpan = 3;
        label_2.setLayoutData((Object)gridData_16);
        label_2.setText(Messages.getString("DataDictionaryPanel.Data_Defines__16"));
        SashForm sashForm = new SashForm(dataComposite, 0);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 128;
        gridData.horizontalSpan = 4;
        sashForm.setLayoutData((Object)gridData);
        this.tableTree = new TableTree((Composite)sashForm, 67586);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)sashForm, 2560);
        this.editorBeanPropertyPanel = new EditorBeanPropertyPanel((Composite)scrolledComposite, 0);
        this.editorBeanPropertyPanel.setSize(223, 345);
        scrolledComposite.setContent((Control)this.editorBeanPropertyPanel);
        sashForm.setWeights(new int[]{300, 200});
        Table table = this.tableTree.getTable();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.setActivateDataItem();
            }
        });
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn DataIdColumn = new TableColumn(table, 0);
        DataIdColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.sortData();
            }
        });
        DataIdColumn.setWidth(100);
        DataIdColumn.setText(Messages.getString("DataDictionaryPanel.DataID_17"));
        TableColumn DataLabelColumn = new TableColumn(table, 0);
        DataLabelColumn.setWidth(100);
        DataLabelColumn.setText(Messages.getString("DataDictionaryPanel.DataName_18"));
        TableColumn tableColumn_8 = new TableColumn(table, 0);
        tableColumn_8.setWidth(100);
        tableColumn_8.setText(Messages.getString("DataDictionaryPanel.DataField/Collection_2"));
        TableColumn tableColumn_7 = new TableColumn(table, 0);
        tableColumn_7.setWidth(100);
        tableColumn_7.setText(Messages.getString("DataDictionaryPanel.Access_Mode_3"));
        TableColumn DataTypeColumn = new TableColumn(table, 0);
        DataTypeColumn.setWidth(100);
        DataTypeColumn.setText(Messages.getString("DataDictionaryPanel.DataType_19"));
        GridData gridData_5 = new GridData(1808);
        gridData_5.heightHint = 114;
        gridData_5.horizontalSpan = 4;
        table.setLayoutData((Object)gridData_5);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tableColumn_5 = new TableColumn(table, 0);
        tableColumn_5.setWidth(100);
        tableColumn_5.setText(Messages.getString("DataDictionaryPanel.Document_20"));
        Composite dataTypeComposite = new Composite((Composite)tabFolder, 0);
        tabItem_1.setControl((Control)dataTypeComposite);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        dataTypeComposite.setLayout((Layout)gridLayout_1);
        Label label_3 = new Label(dataTypeComposite, 0);
        label_3.setText(Messages.getString("DataDictionaryPanel.DataTypeID__21"));
        this.dataTypeIDText = new Text(dataTypeComposite, 2048);
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 128;
        this.dataTypeIDText.setLayoutData((Object)gridData_7);
        Label label_4 = new Label(dataTypeComposite, 0);
        label_4.setText(Messages.getString("DataDictionaryPanel.Name__22"));
        this.dataTypeNameText = new Text(dataTypeComposite, 2048);
        this.dataTypeNameText.setLayoutData((Object)new GridData(768));
        Label label_6 = new Label(dataTypeComposite, 0);
        label_6.setText(Messages.getString("DataDictionaryPanel.Lehgth_23"));
        this.lengthText = new Text(dataTypeComposite, 2048);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 130;
        this.lengthText.setLayoutData((Object)gridData_8);
        Label label_5 = new Label(dataTypeComposite, 0);
        label_5.setText(Messages.getString("DataDictionaryPanel.DataFormat__24"));
        this.dataFmtText = new Text(dataTypeComposite, 2048);
        GridData gridData_9 = new GridData();
        gridData_9.widthHint = 149;
        this.dataFmtText.setLayoutData((Object)gridData_9);
        this.fixedLenCheckButton = new Button(dataTypeComposite, 32);
        GridData gridData_26 = new GridData();
        gridData_26.horizontalSpan = 2;
        this.fixedLenCheckButton.setLayoutData((Object)gridData_26);
        this.fixedLenCheckButton.setText(Messages.getString("DataDictionaryPanel.Fixed_Length_25"));
        Label label_12 = new Label(dataTypeComposite, 0);
        label_12.setText(Messages.getString("DataDictionaryPanel.Pattern__26"));
        this.dataPatternText = new Text(dataTypeComposite, 2048);
        GridData gridData_35 = new GridData(256);
        this.dataPatternText.setLayoutData((Object)gridData_35);
        Label label_7 = new Label(dataTypeComposite, 0);
        label_7.setText(Messages.getString("DataDictionaryPanel.Document_27"));
        this.dataTypeDocument = new Text(dataTypeComposite, 2818);
        GridData gridData_6 = new GridData(768);
        gridData_6.heightHint = 40;
        gridData_6.horizontalSpan = 4;
        this.dataTypeDocument.setLayoutData((Object)gridData_6);
        Composite composite = new Composite(dataTypeComposite, 0);
        GridData gridData_11 = new GridData();
        gridData_11.horizontalSpan = 4;
        composite.setLayoutData((Object)gridData_11);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        composite.setLayout((Layout)gridLayout_2);
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.createNewDataType();
            }
        });
        GridData gridData_12 = new GridData();
        gridData_12.widthHint = 80;
        button_2.setLayoutData((Object)gridData_12);
        button_2.setText(Messages.getString("DataDictionaryPanel.Add_28"));
        Button button_3 = new Button(composite, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.deleteCurDataType();
            }
        });
        GridData gridData_13 = new GridData();
        gridData_13.widthHint = 80;
        button_3.setLayoutData((Object)gridData_13);
        button_3.setText(Messages.getString("DataDictionaryPanel.Remove_29"));
        Button button_4 = new Button(composite, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.updateCurDataType();
            }
        });
        GridData gridData_17 = new GridData();
        gridData_17.widthHint = 80;
        button_4.setLayoutData((Object)gridData_17);
        button_4.setText(Messages.getString("DataDictionaryPanel.Update_30"));
        Label label_9 = new Label(dataTypeComposite, 0);
        GridData gridData_15 = new GridData(256);
        gridData_15.horizontalSpan = 4;
        label_9.setLayoutData((Object)gridData_15);
        label_9.setText(Messages.getString("DataDictionaryPanel.Data_type_defines_31"));
        this.dataTypeTable = new Table(dataTypeComposite, 67584);
        this.dataTypeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDictionaryPanel.this.setActivateDataType();
            }
        });
        this.dataTypeTable.setHeaderVisible(true);
        GridData gridData_10 = new GridData(1808);
        gridData_10.horizontalSpan = 4;
        this.dataTypeTable.setLayoutData((Object)gridData_10);
        TableColumn tableColumn = new TableColumn(this.dataTypeTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("DataDictionaryPanel.DataTypeID_32"));
        TableColumn tableColumn_1 = new TableColumn(this.dataTypeTable, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("DataDictionaryPanel.Name_33"));
        TableColumn tableColumn_3 = new TableColumn(this.dataTypeTable, 0);
        tableColumn_3.setWidth(100);
        tableColumn_3.setText(Messages.getString("DataDictionaryPanel.Length_34"));
        TableColumn tableColumn_2 = new TableColumn(this.dataTypeTable, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("DataDictionaryPanel.DataFormat_35"));
        TableColumn tableColumn_6 = new TableColumn(this.dataTypeTable, 0);
        tableColumn_6.setWidth(100);
        tableColumn_6.setText(Messages.getString("DataDictionaryPanel.Pattern_36"));
        TableColumn tableColumn_4 = new TableColumn(this.dataTypeTable, 0);
        tableColumn_4.setWidth(100);
        tableColumn_4.setText(Messages.getString("DataDictionaryPanel.Document_37"));
        this.setSize(680, 500);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setActivateWrapper(Wrapper wrapper) {
        this.editorBeanPropertyPanel.showWrapperProperties(wrapper);
    }

    public void deleteWrapper(Wrapper wrapper) {
    }

    public void doInsert(Element element) {
    }

    public void loadXMLContent(InputStream in) throws Exception {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLContent(in);
            this.addDataElementToContent(null, node);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.dataTypesNode = node.getChild("DataTypes");
        if (this.dataTypesNode == null) {
            this.dataTypesNode = new XMLNode();
            this.dataTypesNode.setNodeName("DataTypes");
            node.add(this.dataTypesNode);
        }
        this.setDataTypeNode(this.dataTypesNode);
        this.addDataElementToContent(null, node);
    }

    public void loadXMLFile(String xmlFileName) {
        try {
            this.wrappers = new Vector();
            this.tableTree.removeAll();
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(xmlFileName);
            this.addDataElementToContent(null, node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector getSelectedDatas() {
        Vector<XMLNode> datas = new Vector<XMLNode>();
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length <= 0) {
            return datas;
        }
        int i = 0;
        while (i < selectItems.length) {
            TableTreeItem selectedItem = selectItems[i];
            if (selectedItem.getParentItem() == null) {
                DataElementWrapper aWrapper = (DataElementWrapper)selectedItem.getData();
                datas.addElement(aWrapper.xmlNode);
            }
            ++i;
        }
        return datas;
    }

    public void addDataElementToContent(DataElementWrapper wrapper, XMLNode node) {
        try {
            if (wrapper == null) {
                Vector childs = node.getChilds();
                int i = 0;
                while (i < childs.size()) {
                    XMLNode aNode = (XMLNode)childs.elementAt(i);
                    if (!aNode.getNodeName().equals("DataTypes") && !"#text".equals(aNode.getNodeName())) {
                        String dataType;
                        DataElementWrapper aWrapper = new DataElementWrapper(aNode, this.profile);
                        TableTreeItem aItem = new TableTreeItem(this.tableTree, 0);
                        aItem.setText(aNode.getAttrValue("id"));
                        if (aNode.getAttrValue("label") != null) {
                            aItem.setText(1, aNode.getAttrValue("label"));
                        }
                        aWrapper.item = aItem;
                        aItem.setText(2, aNode.getNodeName());
                        String accessMode = aNode.getAttrValue("access");
                        if (accessMode != null) {
                            aItem.setText(3, accessMode);
                        }
                        if ((dataType = aNode.getAttrValue("dataType")) != null) {
                            aItem.setText(4, dataType);
                        }
                        if (aNode.getAttrValue("desc") != null) {
                            aItem.setText(5, aNode.getAttrValue("desc"));
                        }
                        aItem.setData((Object)aWrapper);
                        this.addDataElementToContent(aWrapper, aNode);
                        this.wrappers.addElement(aWrapper);
                    }
                    ++i;
                }
            } else {
                TableTreeItem item = wrapper.item;
                Vector childs = node.getChilds();
                int i = 0;
                while (i < childs.size()) {
                    XMLNode aNode = (XMLNode)childs.elementAt(i);
                    if (!"#text".equals(aNode.getNodeName())) {
                        XMLNode dataNode;
                        DataElementWrapper aWrapper = new DataElementWrapper(aNode, this.profile);
                        TableTreeItem aItem = new TableTreeItem(item, 0);
                        aItem.setText(0, aNode.getAttrValue("id"));
                        if (aNode.getAttrValue("label") != null) {
                            aItem.setText(1, aNode.getAttrValue("label"));
                        }
                        if (aNode.getAttrValue("desc") != null) {
                            aItem.setText(5, aNode.getAttrValue("desc"));
                        }
                        if (aNode.getNodeName().equals("refData") && (dataNode = this.dataDictionary.findChildNode(aNode.getAttrValue("id"))) != null) {
                            String dataType;
                            if (dataNode.getAttrValue("label") != null) {
                                aItem.setText(1, dataNode.getAttrValue("label"));
                            }
                            aWrapper.item = aItem;
                            aItem.setText(2, dataNode.getNodeName());
                            String accessMode = dataNode.getAttrValue("access");
                            if (accessMode != null) {
                                aItem.setText(3, accessMode);
                            }
                            if ((dataType = dataNode.getAttrValue("dataType")) != null) {
                                aItem.setText(4, dataType);
                            }
                            if (dataNode.getAttrValue("desc") != null) {
                                aItem.setText(5, dataNode.getAttrValue("desc"));
                            }
                        }
                        aItem.setImage(0, this.profile.getElement(aNode.getNodeName()).getImage());
                        aWrapper.item = aItem;
                        aItem.setData((Object)aWrapper);
                        this.addDataElementToContent(aWrapper, aNode);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLayout((Layout)new FillLayout());
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
        Vector elementCatalogs = profile.getCagalogs();
        int i = 0;
        while (i < elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)elementCatalogs.elementAt(i);
            if (catalog.getShowInToolPanel()) {
                Vector elements = catalog.getElements();
                int k = 0;
                while (k < elements.size()) {
                    Element element = (Element)elements.elementAt(k);
                    this.dataClassicCombo.add(element.getElementName());
                    ++k;
                }
            }
            ++i;
        }
    }

    public void loadXMLFile(String profileFileName, String contentFileName) throws Exception {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
        EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(profileFileName);
        if (profile != null) {
            this.setEditorProfile(profile);
            this.loadXMLFile(contentFileName);
        }
    }

    private void createNewData() {
        String dataId = this.dataIDText.getText();
        String dataClassic = this.dataClassicCombo.getText();
        if (dataId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_50"), (String)Messages.getString("DataDictionaryPanel.Please_input_the_DataID_filed_!_51"));
            return;
        }
        if (dataClassic.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_52"), (String)Messages.getString("DataDictionaryPanel.Please_select_a_data_field_type_!_53"));
            return;
        }
        XMLNode aNode = this.dataDictionary.findChildNode(dataId);
        if (aNode != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_55"), (String)Messages.getString("DataDictionaryPanel.Duplicated_dataID_!_56"));
            return;
        }
        XMLNode node = new XMLNode();
        node.setNodeName(dataClassic);
        node.setAttrValue("id", dataId);
        node.setAttrValue("label", this.dataNameText.getText());
        node.setAttrValue("access", this.accessCombo.getText());
        node.setAttrValue("desc", this.documentText.getText());
        TableTreeItem aItem = new TableTreeItem(this.tableTree, 0);
        String dataType = this.getDataTypeSelect();
        if (dataType != null) {
            node.setAttrValue("dataType", dataType);
            aItem.setText(4, dataType);
        }
        DataElementWrapper aWrapper = new DataElementWrapper(node, this.profile);
        this.wrappers.addElement(aWrapper);
        aItem.setText(dataId);
        aItem.setText(1, this.dataNameText.getText());
        aItem.setText(2, dataClassic);
        aItem.setText(3, this.accessCombo.getText());
        aItem.setText(5, this.documentText.getText());
        aWrapper.item = aItem;
        aItem.setData((Object)aWrapper);
        this.dataDictionary.add(node);
        TableTreeItem[] items = new TableTreeItem[]{aItem};
        this.tableTree.setSelection(items);
    }

    private void setActivateDataItem() {
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length <= 0) {
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        DataElementWrapper aWrapper = (DataElementWrapper)selectedItem.getData();
        this.setActivateWrapper(aWrapper);
        String dataId = aWrapper.xmlNode.getAttrValue("id");
        String dataClasic = aWrapper.xmlNode.getNodeName();
        int idx = this.dataClassicCombo.indexOf(dataClasic);
        this.dataClassicCombo.select(idx);
        this.dataIDText.setText(dataId);
        String dataName = aWrapper.xmlNode.getAttrValue("label");
        if (dataName != null) {
            this.dataNameText.setText(dataName);
        } else {
            this.dataNameText.setText("");
        }
        String accessStr = aWrapper.xmlNode.getAttrValue("access");
        if (accessStr != null) {
            this.accessCombo.setText(accessStr);
        } else {
            this.accessCombo.setText("");
        }
        String docStr = aWrapper.getAttrValue("desc");
        if (docStr != null) {
            this.documentText.setText(docStr);
        } else {
            this.documentText.setText("");
        }
        String dataType = aWrapper.xmlNode.getAttrValue("dataType");
        this.setDataTypeComboSelect(dataType);
        this.enableButtons();
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(Messages.getString("DataDictionaryPanel.Data_Dictionary_Test_Frame_69"));
        DataDictionaryPanel test = new DataDictionaryPanel((Composite)shell, 2048);
        try {
            String fileName = "/profiles/dataDictionaryEditorProfile.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            if (profile != null) {
                test.setEditorProfile(profile);
                test.loadXMLFile("/dataDictionary.xml");
                if (profile.getTitle() != null) {
                    shell.setText(profile.getTitle());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void deleteSelectedData() {
        TableTreeItem[] selects = this.tableTree.getSelection();
        if (selects.length == 0) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Are_you_sure..._5"), (String)Messages.getString("DataDictionaryPanel.Are_you_sure_to_delete_current_sellected_dataElements__6"))) {
            return;
        }
        int i = 0;
        while (i < selects.length) {
            TableTreeItem item = selects[0];
            XMLNode pNode = this.dataDictionary;
            if (item.getParentItem() != null) {
                pNode = ((DataElementWrapper)item.getParentItem().getData()).xmlNode;
            }
            XMLNode node = ((DataElementWrapper)item.getData()).xmlNode;
            pNode.remove(node);
            item.dispose();
            ++i;
        }
    }

    private void createNewDataToSelectedDataElement() {
        String dataId = this.dataIDText.getText();
        String dataClassic = this.dataClassicCombo.getText();
        if (dataId.length() == 0) {
            return;
        }
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length != 1) {
            return;
        }
        if (!"dataCollection".equals(dataClassic)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_8"), (String)Messages.getString("DataDictionaryPanel.You_can_only_create_dataCollection_to_dataCollection_!_9"));
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        DataElementWrapper curWrapper = (DataElementWrapper)selectedItem.getData();
        XMLNode node = new XMLNode();
        node.setNodeName(dataClassic);
        node.setAttrValue("id", dataId);
        node.setAttrValue("label", this.dataNameText.getText());
        DataElementWrapper aWrapper = new DataElementWrapper(node, this.profile);
        TableTreeItem aItem = new TableTreeItem(selectedItem, 0);
        aItem.setText(0, dataId);
        aItem.setText(1, this.dataNameText.getText());
        aItem.setText(2, dataClassic);
        aWrapper.item = aItem;
        aItem.setData((Object)aWrapper);
        curWrapper.xmlNode.add(node);
    }

    private void addReferenceData() {
        DataDictionarySelectDialog dlg = new DataDictionarySelectDialog(this.getShell(), 0);
        dlg.setProfile(this.profile);
        dlg.setDataDictionary(this.dataDictionary);
        Object result = dlg.open();
        if (result != null) {
            TableTreeItem[] selectItems = this.tableTree.getSelection();
            if (selectItems.length != 1) {
                return;
            }
            TableTreeItem pItem = selectItems[0];
            DataElementWrapper curWrapper = (DataElementWrapper)pItem.getData();
            XMLNode pNode = curWrapper.xmlNode;
            Vector selectDatas = (Vector)result;
            int i = 0;
            while (i < selectDatas.size()) {
                String id;
                XMLNode node = (XMLNode)selectDatas.elementAt(i);
                if (!"#text".equals(node.getNodeName()) && pNode.findChildNode(id = node.getAttrValue("id")) == null) {
                    XMLNode aNode = new XMLNode();
                    aNode.setNodeName("refData");
                    aNode.setAttrValue("id", id);
                    pNode.add(aNode);
                    DataElementWrapper wrapper = new DataElementWrapper(aNode, this.profile);
                    TableTreeItem aItem = new TableTreeItem(pItem, 0);
                    aItem.setText(id);
                    if (node.getAttrValue("label") != null) {
                        aItem.setText(1, node.getAttrValue("label"));
                    }
                    aItem.setData((Object)wrapper);
                }
                ++i;
            }
        }
    }

    private void elementTypeChanged() {
        this.enableButtons();
    }

    private void enableButtons() {
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length != 1) {
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        DataElementWrapper aWrapper = (DataElementWrapper)selectItems[0].getData();
        this.setActivateWrapper(aWrapper);
        if (aWrapper.xmlNode.getNodeName().equals("dataCollection")) {
            this.refDataButton.setEnabled(true);
            String elementType = this.dataClassicCombo.getText();
            if ("dataCollection".equals(elementType)) {
                this.createToButton.setEnabled(true);
            } else {
                this.createToButton.setEnabled(false);
            }
        } else {
            this.createToButton.setEnabled(false);
            this.refDataButton.setEnabled(false);
        }
        String nodeType = aWrapper.xmlNode.getNodeName();
        if (nodeType.equals("dataCollection") || nodeType.equals("dataElement")) {
            this.updateButton.setEnabled(true);
        } else {
            this.updateButton.setEnabled(false);
        }
    }

    private void setDataTypeNode(XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        this.updateDataTypeCombo();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                TableItem item = new TableItem(this.dataTypeTable, 0);
                item.setText(aNode.getAttrValue("id"));
                if (aNode.getAttrValue("name") != null) {
                    item.setText(1, aNode.getAttrValue("name"));
                }
                item.setText(2, aNode.getAttrValue("length"));
                item.setText(3, aNode.getAttrValue("dataFmt"));
                if (aNode.getAttrValue("pattern") != null) {
                    item.setText(4, aNode.getAttrValue("pattern"));
                }
                if (aNode.getAttrValue("desc") != null) {
                    item.setText(4, aNode.getAttrValue("desc"));
                }
                item.setData((Object)aNode);
            }
            ++i;
        }
    }

    private void createNewDataType() {
        String dataTypeIDStr = this.dataTypeIDText.getText();
        if (dataTypeIDStr.length() == 0 || this.dataTypesNode.findChildNode(dataTypeIDStr) != null) {
            return;
        }
        String dataTypeDocStr = this.dataTypeDocument.getText();
        String dataFmtStr = this.dataFmtText.getText();
        String lengthStr = this.lengthText.getText();
        if (dataFmtStr.length() == 0 || lengthStr.length() == 0) {
            return;
        }
        String dataTypeNameStr = this.dataTypeNameText.getText();
        String patternStr = this.dataPatternText.getText();
        XMLNode node = new XMLNode();
        node.setNodeName("DataType");
        node.setAttrValue("id", dataTypeIDStr);
        node.setAttrValue("name", dataTypeNameStr);
        node.setAttrValue("length", lengthStr);
        node.setAttrValue("dataFmt", dataFmtStr);
        node.setAttrValue("pattern", patternStr);
        node.setAttrValue("desc", dataTypeDocStr);
        this.dataTypesNode.add(node);
        TableItem item = new TableItem(this.dataTypeTable, 0);
        item.setText(dataTypeIDStr);
        item.setText(1, dataTypeNameStr);
        item.setText(2, lengthStr);
        item.setText(3, dataFmtStr);
        item.setText(4, patternStr);
        item.setText(5, dataTypeDocStr);
        item.setData((Object)node);
        this.updateDataTypeCombo();
    }

    private void updateCurDataType() {
        TableItem[] selects = this.dataTypeTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        TableItem item = selects[0];
        XMLNode node = (XMLNode)item.getData();
        String dataTypeIDStr = this.dataTypeIDText.getText();
        if (dataTypeIDStr.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warnning_10"), (String)Messages.getString("DataDictionaryPanel.Please_input_proper_DataType_ID_!_11"));
            return;
        }
        XMLNode aNode = this.dataTypesNode.findChildNode(dataTypeIDStr);
        if (aNode != null && aNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warnning_12"), (String)Messages.getString("DataDictionaryPanel.Duplicated_DataType_ID_!_13"));
            return;
        }
        String dataTypeDocStr = this.dataTypeDocument.getText();
        String dataFmtStr = this.dataFmtText.getText();
        String lengthStr = this.lengthText.getText();
        if (dataFmtStr.length() == 0 || lengthStr.length() == 0) {
            return;
        }
        String dataTypeNameStr = this.dataTypeNameText.getText();
        String patternStr = this.dataPatternText.getText();
        node.setAttrValue("id", dataTypeIDStr);
        node.setAttrValue("name", dataTypeNameStr);
        node.setAttrValue("length", lengthStr);
        node.setAttrValue("dataFmt", dataFmtStr);
        node.setAttrValue("pattern", patternStr);
        node.setAttrValue("desc", dataTypeDocStr);
        item.setText(dataTypeIDStr);
        item.setText(1, dataTypeNameStr);
        item.setText(2, lengthStr);
        item.setText(3, dataFmtStr);
        item.setText(4, patternStr);
        item.setText(5, dataTypeDocStr);
        this.updateDataTypeCombo();
    }

    private void deleteCurDataType() {
        TableItem[] selects = this.dataTypeTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Are_you_sure..._14"), (String)Messages.getString("DataDictionaryPanel.Please_make_sure_to_delete_current_data_type_define_!_15"))) {
            return;
        }
        TableItem item = selects[0];
        XMLNode node = (XMLNode)item.getData();
        this.dataTypesNode.remove(node);
        this.dataTypeTable.remove(this.dataTypeTable.indexOf(item));
        this.updateDataTypeCombo();
    }

    private void setActivateDataType() {
        TableItem[] selects = this.dataTypeTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        TableItem item = selects[0];
        XMLNode node = (XMLNode)item.getData();
        this.dataTypeIDText.setText(node.getAttrValue("id"));
        if (node.getAttrValue("name") != null) {
            this.dataTypeNameText.setText(node.getAttrValue("name"));
        } else {
            this.dataTypeNameText.setText("");
        }
        this.lengthText.setText(node.getAttrValue("length"));
        this.dataFmtText.setText(node.getAttrValue("dataFmt"));
        if (node.getAttrValue("pattern") != null) {
            this.dataPatternText.setText(node.getAttrValue("pattern"));
        } else {
            this.dataPatternText.setText("");
        }
        if (node.getAttrValue("desc") != null) {
            this.dataTypeDocument.setText(node.getAttrValue("desc"));
        } else {
            this.dataTypeDocument.setText("");
        }
    }

    private void updateDataTypeCombo() {
        this.dataTypeCombo.removeAll();
        Vector childs = this.dataTypesNode.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(node.getNodeName())) {
                String str = String.valueOf(node.getAttrValue("id")) + " ";
                String name = node.getAttrValue("name");
                if (name != null) {
                    str = String.valueOf(str) + name;
                }
                this.dataTypeCombo.add(str);
            }
            ++i;
        }
    }

    private void setDataTypeComboSelect(String typeId) {
        if (typeId == null || typeId.length() == 0) {
            this.dataTypeCombo.setText("");
            return;
        }
        String str = String.valueOf(typeId) + " ";
        String[] items = this.dataTypeCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].startsWith(str)) {
                this.dataTypeCombo.select(i);
                return;
            }
            ++i;
        }
        this.dataTypeCombo.setText("");
    }

    private String getDataTypeSelect() {
        String text = this.dataTypeCombo.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        int idx = text.indexOf(32);
        if (idx == -1) {
            return null;
        }
        return text.substring(0, idx);
    }

    public void setDataName(String dataName) {
        if (dataName != null) {
            this.dataIDText.setText(dataName);
        }
    }

    private void sortData() {
        this.sortAscending = !this.sortAscending;
        Vector childs = this.dataDictionary.getChilds();
        if (childs == null || childs.size() < 2) {
            return;
        }
        String[] dataIds = new String[childs.size()];
        int i = 0;
        while (i < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(node.getNodeName())) {
                dataIds[i] = node.getAttrValue("id");
            }
            ++i;
        }
        QSortAlgorithm sorter = new QSortAlgorithm();
        try {
            sorter.sort(dataIds, this.sortAscending);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] position = sorter.getFinalPosition();
        this.tableTree.removeAll();
        int i2 = 0;
        while (i2 < position.length) {
            XMLNode aNode = (XMLNode)childs.elementAt(position[i2]);
            if (!aNode.getNodeName().equals("DataTypes") && !"#text".equals(aNode.getNodeName())) {
                DataElementWrapper aWrapper = new DataElementWrapper(aNode, this.profile);
                TableTreeItem aItem = new TableTreeItem(this.tableTree, 0);
                aItem.setText(0, aNode.getAttrValue("id"));
                if (aNode.getAttrValue("label") != null) {
                    aItem.setText(1, aNode.getAttrValue("label"));
                }
                aWrapper.item = aItem;
                aItem.setText(2, aNode.getNodeName());
                if (aNode.getAttrValue("access") != null) {
                    aItem.setText(3, aNode.getAttrValue("access"));
                }
                aItem.setData((Object)aWrapper);
                this.addDataElementToContent(aWrapper, aNode);
                this.wrappers.addElement(aWrapper);
                String dataType = aNode.getAttrValue("dataType");
                if (dataType != null) {
                    aItem.setText(4, dataType);
                }
                if (aNode.getAttrValue("desc") != null) {
                    aItem.setText(5, aNode.getNodeName());
                }
            }
            ++i2;
        }
    }

    private void updateDataElement() {
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length != 1) {
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        DataElementWrapper aWrapper = (DataElementWrapper)selectedItem.getData();
        XMLNode node = aWrapper.xmlNode;
        String dataId = this.dataIDText.getText();
        if (dataId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_50"), (String)Messages.getString("DataDictionaryPanel.Please_input_the_DataID_filed_!_51"));
            return;
        }
        XMLNode aNode = this.dataDictionary.findChildNode(dataId);
        if (aNode != null && aNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_55"), (String)Messages.getString("DataDictionaryPanel.Duplicated_dataID_!_56"));
            return;
        }
        node.setAttrValue("id", dataId);
        node.setAttrValue("label", this.dataNameText.getText());
        node.setAttrValue("dataType", this.dataTypeCombo.getText());
        node.setAttrValue("access", this.accessCombo.getText());
        node.setAttrValue("desc", this.documentText.getText());
        selectedItem.setText(dataId);
        selectedItem.setText(1, this.dataNameText.getText());
        selectedItem.setText(3, this.accessCombo.getText());
        selectedItem.setText(4, this.dataTypeCombo.getText());
        selectedItem.setText(5, this.documentText.getText());
    }

    public void cancelCurrentAction() {
    }

    public void deleteActivateComponent() {
    }

    public String getRootPath() {
        return null;
    }
}

