/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.data;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataElementEditPanel
extends Composite {
    private Text dftValueText;
    private Combo dataTypeCombo;
    private Text dataPatternText;
    private Text dataTypeDocument;
    private Text dataFmtText;
    private Text lengthText;
    private Text dataTypeNameText;
    private Text dataTypeIDText;
    private Text documentText;
    private Text dataNameText;
    private Text dataIDText;
    private Combo dataClassicCombo;
    private Button secureFieldButton;
    private EditorProfile profile;
    private XMLNode dataDictionary;
    private XMLNode dataTypesNode;
    private XMLNode editNode;
    private XMLNode dataTypeDefNode;

    public void setDataTypeDefNode(XMLNode node) {
        this.dataTypeDefNode = node;
        this.dataTypeCombo.removeAll();
        Vector childs = this.dataTypeDefNode.getChilds();
        if (childs == null || childs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                String str = String.valueOf(aNode.getAttrValue("id")) + " ";
                String name = aNode.getAttrValue("name");
                if (name != null) {
                    str = String.valueOf(str) + name;
                }
                this.dataTypeCombo.add(str);
            }
            ++i;
        }
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
        Vector elementCatalogs = profile.getCagalogs();
        int i = 0;
        while (i < elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)elementCatalogs.elementAt(i);
            if (catalog.getShowInToolPanel()) {
                Vector elements = catalog.getElements();
                int k = 0;
                while (k < elements.size()) {
                    Element element = (Element)elements.elementAt(k);
                    this.dataClassicCombo.add(element.getElementName());
                    ++k;
                }
            }
            ++i;
        }
        this.dataClassicCombo.setText("dataElement");
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public DataElementEditPanel(Composite parent, int style, String fieldId) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("DataDictionaryPanel.DataID__3"));
        this.dataIDText = new Text((Composite)this, 2048);
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 110;
        this.dataIDText.setLayoutData((Object)gridData_3);
        if (fieldId != null) {
            this.dataIDText.setText(fieldId);
        }
        Label label_8 = new Label((Composite)this, 0);
        label_8.setText(Messages.getString("DataDictionaryPanel.Chinese_Name__4"));
        this.dataNameText = new Text((Composite)this, 2048);
        GridData gridData_14 = new GridData(768);
        this.dataNameText.setLayoutData((Object)gridData_14);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("DataDictionaryPanel.DataClassic__5"));
        this.dataClassicCombo = new Combo((Composite)this, 8);
        GridData gridData_1 = new GridData(768);
        this.dataClassicCombo.setLayoutData((Object)gridData_1);
        Label label_13 = new Label((Composite)this, 0);
        label_13.setText(Messages.getString("DataDictionaryPanel.DataType__6"));
        this.dataTypeCombo = new Combo((Composite)this, 0);
        GridData gridData_25 = new GridData();
        this.dataTypeCombo.setLayoutData((Object)gridData_25);
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("DataElementEditPanel.DefaultValue__1"));
        this.dftValueText = new Text((Composite)this, 2048);
        Label label_10 = new Label((Composite)this, 0);
        GridData gridData_19 = new GridData();
        gridData_19.horizontalSpan = 4;
        label_10.setLayoutData((Object)gridData_19);
        label_10.setText(Messages.getString("DataDictionaryPanel.Document_11"));
        this.documentText = new Text((Composite)this, 2818);
        GridData gridData_20 = new GridData(768);
        gridData_20.heightHint = 40;
        gridData_20.horizontalSpan = 4;
        this.documentText.setLayoutData((Object)gridData_20);
    }

    private void setDataTypeComboSelect(String typeId) {
        if (typeId == null || typeId.length() == 0) {
            this.dataTypeCombo.setText("");
            return;
        }
        String str = String.valueOf(typeId) + " ";
        String[] items = this.dataTypeCombo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].startsWith(str)) {
                this.dataTypeCombo.setText(items[i]);
                return;
            }
            ++i;
        }
        this.dataTypeCombo.setText("");
    }

    private String getDataTypeSelect() {
        String text = this.dataTypeCombo.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        int idx = text.indexOf(32);
        if (idx == -1) {
            return null;
        }
        return text.substring(0, idx);
    }

    public boolean isOK() {
        String dataId = this.dataIDText.getText();
        String dataClassic = this.dataClassicCombo.getText();
        if (dataId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_50"), (String)Messages.getString("DataDictionaryPanel.Please_input_the_DataID_filed_!_51"));
            return false;
        }
        if (dataClassic.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_52"), (String)Messages.getString("DataDictionaryPanel.Please_select_a_data_field_type_!_53"));
            return false;
        }
        XMLNode aNode = this.dataDictionary.findChildNode(dataId);
        if (this.editNode != null && aNode != null && this.editNode != aNode) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_55"), (String)Messages.getString("DataDictionaryPanel.Duplicated_dataID_!_56"));
            return false;
        }
        if (this.editNode == null && aNode != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Warning_55"), (String)Messages.getString("DataDictionaryPanel.Duplicated_dataID_!_56"));
            return false;
        }
        return true;
    }

    public void setEditNode(XMLNode node) {
        try {
            this.editNode = node;
            this.dataClassicCombo.setText(node.getNodeName());
            this.dataClassicCombo.setEnabled(false);
            this.dataIDText.setText(node.getAttrValue("id"));
            this.dataNameText.setText(node.getAttrValue("label"));
            if (node.getAttrValue("desc") != null) {
                this.documentText.setText(node.getAttrValue("desc"));
            }
            if (node.getAttrValue("defaultValue") != null) {
                this.dftValueText.setText(node.getAttrValue("defaultValue"));
            }
            this.setDataTypeComboSelect(node.getAttrValue("dataType"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XMLNode getEditNode() {
        XMLNode editNode = this.editNode;
        if (editNode == null) {
            editNode = new XMLNode();
        }
        String dataId = this.dataIDText.getText();
        String dataClassic = this.dataClassicCombo.getText();
        editNode.setNodeName(dataClassic);
        editNode.setAttrValue("id", dataId);
        editNode.setAttrValue("label", this.dataNameText.getText());
        editNode.setAttrValue("defaultValue", this.dftValueText.getText());
        editNode.setAttrValue("desc", this.documentText.getText());
        editNode.setAttrValue("dataType", this.getDataTypeSelect());
        return editNode;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

