/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.data;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.TrxDataPanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewDataGroupDialog
extends TitleAreaDialog {
    private EditorProfile dataEditorProfile;
    private XMLNode dataDictionary;
    private XMLNode datasNode;
    private TrxDataPanel dataPanel;
    private Text groupIdText;
    private Text groupNameText;
    private String groupId;
    private String groupName;

    public NewDataGroupDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Group comp = new Group(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setLayout((Layout)new GridLayout(3, false));
        comp.setText("\u5206\u7ec4\u4fe1\u606f");
        this.setTitle("\u7f16\u8f91\u6570\u636e\u5206\u7ec4\u4fe1\u606f");
        Label grpIdLabel = new Label((Composite)comp, 0);
        grpIdLabel.setText(Messages.getString("DataDicSelectPanel.GroupIDLabel"));
        this.groupIdText = new Text((Composite)comp, 2048);
        GridData grpTxtGridData = new GridData(1, 2, false, false, 2, 1);
        grpTxtGridData.widthHint = 120;
        this.groupIdText.setLayoutData((Object)grpTxtGridData);
        if (this.groupId != null) {
            this.groupIdText.setText(this.groupId);
        }
        Label grpNameLabel = new Label((Composite)comp, 0);
        grpNameLabel.setText(String.valueOf(Messages.getString("DataDicSelectPanel.GroupNameLabel")) + ":");
        this.groupNameText = new Text((Composite)comp, 2048);
        this.groupNameText.setLayoutData((Object)grpTxtGridData);
        if (this.groupName != null) {
            this.groupNameText.setText(this.groupName);
        }
        return comp;
    }

    public Shell getShell() {
        Shell shell = super.getShell();
        shell.setText("\u6570\u636e\u5206\u7ec4\u5b9a\u4e49");
        return shell;
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        preferredSize = this.getShell().getDisplay().getBounds();
        preferredSize.x = (preferredSize.width - 680) / 2;
        preferredSize.y = (preferredSize.height - 500) / 3;
        preferredSize.width = 400;
        preferredSize.height = 300;
        return preferredSize;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(0x10 | newShellStyle);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String id = this.groupIdText.getText();
            String name = this.groupNameText.getText();
            if (id.length() == 0) {
                this.setErrorMessage(Messages.getString("DataDicSelectPanel.GroupIdWarrningLabel"));
                return;
            }
            if (!id.equals(this.groupId) && this.datasNode.getChildNode(id) != null) {
                this.setErrorMessage(Messages.getString("DataDicSelectPanel.GroupIdDuplicatedWarrningLabel"));
                return;
            }
            this.groupId = id;
            this.groupName = name;
        }
        super.buttonPressed(buttonId);
    }

    public void setDataDictionary(XMLNode dataDictionary) {
        this.dataDictionary = dataDictionary;
    }

    public void setDataEditorProfile(EditorProfile dataEditorProfile) {
        this.dataEditorProfile = dataEditorProfile;
    }

    public void setDatasNode(XMLNode datasNode) {
        this.datasNode = datasNode;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setSelectedGrp(XMLNode selectedDataNode) {
        if ("dataGroup".equals(selectedDataNode.getNodeName())) {
            this.groupId = selectedDataNode.getAttrValue("id");
            this.groupName = selectedDataNode.getAttrValue("name");
        }
    }
}

