/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.datatype;

import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.WrapperOwner;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import com.ecc.ide.editor.datatype.DataTypeItemWrapper;
import com.ecc.ide.editor.objectEditor.ObjectEditor;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DataTypeDefPanel
extends Composite
implements WrapperOwner {
    private Table DataTypeTable;
    private Text descText;
    private Text dataTypeDefIdText;
    private Combo DataTypeCombo;
    private Text dataTypeNameText;
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private XMLNode dataTypeDefNode;
    private XMLNode dataTypeNode;
    private XMLNode channelSettings;
    private DataTypeItemWrapper curDataTypeDefWrapper;
    private TableItem curItem;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private XMLNode commonServiceNode;
    private XMLNode externResourceNode;

    public void setDataTypeDefNode(XMLNode node) {
        this.dataTypeDefNode = node;
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aDataTypeDef = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aDataTypeDef.getNodeName())) {
                Element element;
                String doc;
                String dataTypeName;
                TableItem item = new TableItem(this.DataTypeTable, 0);
                item.setText(2, aDataTypeDef.getNodeName());
                String id = aDataTypeDef.getAttrValue("id");
                if (id != null) {
                    item.setText(id);
                }
                if ((dataTypeName = aDataTypeDef.getAttrValue("name")) != null) {
                    item.setText(1, dataTypeName);
                }
                if ((doc = aDataTypeDef.getDocument()) != null) {
                    item.setText(3, doc);
                }
                if ((element = this.getDataTypeElement(aDataTypeDef.getNodeName())) != null && element.getImage() != null) {
                    item.setImage(element.getImage());
                }
                DataTypeItemWrapper wrapper = new DataTypeItemWrapper(aDataTypeDef, element, item);
                item.setData((Object)wrapper);
            }
            ++i;
        }
    }

    private Element getDataTypeElement(String typeName) {
        Element element = new Element();
        if (this.dataTypeNode == null) {
            return element;
        }
        XMLNode node = this.dataTypeNode.getChildNode(typeName);
        if (node == null) {
            return element;
        }
        XMLNode attrsNode = node.getChild("attributes");
        if (attrsNode != null) {
            int i = 0;
            while (i < attrsNode.getChilds().size()) {
                XMLNode attrNode = (XMLNode)attrsNode.getChilds().get(i);
                if ("attr".equals(attrNode.getNodeName())) {
                    ElementAttribute attr = new ElementAttribute(attrNode);
                    element.addAttribute(attr);
                }
                ++i;
            }
        }
        return element;
    }

    public void setDataType(XMLNode node) {
        this.dataTypeNode = node;
        this.DataTypeCombo.removeAll();
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode aNode = (XMLNode)node.getChilds().get(i);
            if ("dataType".equals(aNode.getNodeName())) {
                this.DataTypeCombo.add(String.valueOf(aNode.getAttrValue("name")) + "[" + aNode.getAttrValue("id") + "]");
            }
            ++i;
        }
    }

    public DataTypeDefPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("PatternMainPanel.PATTERN_ID_8"));
        this.dataTypeDefIdText = new Text(composite, 2048);
        GridData gridData_7 = new GridData();
        gridData_7.horizontalSpan = 3;
        gridData_7.widthHint = 156;
        this.dataTypeDefIdText.setLayoutData((Object)gridData_7);
        Label labelTypeName = new Label(composite, 0);
        labelTypeName.setText(Messages.getString("PatternMainPanel.dataTypeName"));
        this.dataTypeNameText = new Text(composite, 2048);
        GridData gridData_71 = new GridData();
        gridData_71.horizontalSpan = 3;
        gridData_71.widthHint = 156;
        this.dataTypeNameText.setLayoutData((Object)gridData_71);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("PatternMainPanel.PATTERN_TYPE__9"));
        this.DataTypeCombo = new Combo(composite, 0);
        this.DataTypeCombo.setLayoutData((Object)new GridData(768));
        Label label_3 = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData);
        label_3.setText(Messages.getString("PatternMainPanel.DESCRIPTION_10"));
        this.descText = new Text(composite, 2818);
        GridData gridData_1 = new GridData(768);
        gridData_1.heightHint = 48;
        gridData_1.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_1);
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 4;
        composite_1.setLayoutData((Object)gridData_2);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite_1, 0);
        button.setToolTipText(Messages.getString("PatternMainPanel.Create_new_Service__11"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDefPanel.this.createNewDataTypeDef();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 80;
        button.setLayoutData((Object)gridData_3);
        button.setText(Messages.getString("PatternMainPanel.Create_12"));
        Button button_1 = new Button(composite_1, 0);
        button_1.setToolTipText(Messages.getString("PatternMainPanel.delete_the_selected_pattern_13"));
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDefPanel.this.deleteSelectedDataTypeDef();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("PatternMainPanel.Delete_14"));
        Button button_2 = new Button(composite_1, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDefPanel.this.updateCurDataTypeDef();
            }
        });
        button_2.setToolTipText(Messages.getString("PatternMainPanel.update_the_service_15"));
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        button_2.setLayoutData((Object)gridData_5);
        button_2.setText(Messages.getString("PatternMainPanel.Update_16"));
        Button button_3 = new Button(composite_1, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDefPanel.this.editCurrentPatternItem();
            }
        });
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 80;
        button_3.setLayoutData((Object)gridData_8);
        button_3.setText(Messages.getString("PatternMainPanel.Edit_1"));
        this.DataTypeTable = new Table(composite, 67584);
        GridData gridData_6 = new GridData(4, 4, true, true, 4, 1);
        this.DataTypeTable.setLayoutData((Object)gridData_6);
        this.DataTypeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeDefPanel.this.setActivateDataTypeDef();
            }
        });
        this.DataTypeTable.setHeaderVisible(true);
        this.DataTypeTable.setLinesVisible(true);
        TableColumn tableColumn_1 = new TableColumn(this.DataTypeTable, 0);
        tableColumn_1.setWidth(165);
        tableColumn_1.setText(Messages.getString("PatternMainPanel.Pattern_Id_18"));
        TableColumn tableColumn_2 = new TableColumn(this.DataTypeTable, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("PatternMainPanel.dataTypeName"));
        TableColumn tableColumn = new TableColumn(this.DataTypeTable, 0);
        tableColumn.setWidth(146);
        tableColumn.setText(Messages.getString("PatternMainPanel.Pattern_Type_17"));
        TableColumn tableColumn_4 = new TableColumn(this.DataTypeTable, 0);
        tableColumn_4.setWidth(202);
        tableColumn_4.setText(Messages.getString("PatternMainPanel.Description_19"));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)sashForm, 2560);
        this.editorBeanPropertyPanel = new EditorBeanPropertyPanel((Composite)scrolledComposite, 0);
        this.editorBeanPropertyPanel.setSize(145, 375);
        scrolledComposite.setContent((Control)this.editorBeanPropertyPanel);
        sashForm.setWeights(new int[]{414, 170});
    }

    public void dispose() {
        super.dispose();
        this.editorBeanPropertyPanel.dispose();
    }

    protected void checkSubclass() {
    }

    private void createNewDataTypeDef() {
        String dataTypeDefId;
        String dataTypeId = this.DataTypeCombo.getText();
        String dataTypeDefName = this.dataTypeNameText.getText();
        if (dataTypeId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_3"), (String)Messages.getString("PatternMainPanel.please_select_a_pattern_type_to_create_!_4"));
            return;
        }
        if (dataTypeId.indexOf("[") != -1) {
            int idx1 = dataTypeId.indexOf(91);
            int idx2 = dataTypeId.indexOf(93, idx1);
            dataTypeId = dataTypeId.substring(idx1 + 1, idx2);
        }
        if ((dataTypeDefId = this.dataTypeDefIdText.getText()).length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_1"), (String)Messages.getString("PatternMainPanel.please_input_proper_patternId_!_2"));
            return;
        }
        XMLNode node = this.dataTypeDefNode.findChildNode(dataTypeDefId);
        if (node != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_5"), (String)Messages.getString("PatternMainPanel.Duplicated_pattern_ID_!_6"));
            return;
        }
        Element element = this.getDataTypeElement(dataTypeId);
        if (element == null) {
            return;
        }
        String wizardClass = element.getWizardClassType();
        XMLNode aNode = new XMLNode();
        aNode.setNodeName(dataTypeId);
        aNode.setAttrValue("id", dataTypeDefId);
        aNode.setAttrValue("name", dataTypeDefName);
        if (wizardClass != null) {
            try {
                ECCIDEWizard wizard = (ECCIDEWizard)((Object)Class.forName(wizardClass).newInstance());
                wizard.setDataEditorProfile(this.dataEditorProfile);
                wizard.setDataDictionary(this.dataDictionary);
                wizard.setCommonServiceNode(this.commonServiceNode);
                wizard.setXMLNode(aNode);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    aNode = wizard.getXMLNode();
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Error_30"), (String)(String.valueOf(Messages.getString("ServiceMainPanel.Internal_Error__n_31")) + e));
                e.printStackTrace();
            }
        }
        this.dataTypeDefNode.add(aNode);
        TableItem item = new TableItem(this.DataTypeTable, 0);
        String typeDefId = aNode.getAttrValue("id");
        if (typeDefId != null) {
            item.setText(0, typeDefId);
        }
        if (dataTypeDefName != null) {
            // empty if block
        }
        item.setText(1, dataTypeDefName);
        item.setText(2, aNode.getNodeName());
        Element elmt = this.getDataTypeElement(aNode.getNodeName());
        if (elmt != null && elmt.getImage() != null) {
            item.setImage(elmt.getImage());
        }
        DataTypeItemWrapper wrapper = new DataTypeItemWrapper(aNode, element, item);
        wrapper.setWrapperOwner(this);
        item.setData((Object)wrapper);
    }

    private void deleteSelectedDataTypeDef() {
        if (this.dataTypeDefNode == null || this.curDataTypeDefWrapper == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Are_sure..._7"), (String)Messages.getString("PatternMainPanel.Are_you_sure_to_delete_selected_pattern_define__8"))) {
            return;
        }
        this.dataTypeDefNode.remove(this.curDataTypeDefWrapper.xmlNode);
        this.curItem.dispose();
        this.curDataTypeDefWrapper = null;
        this.curItem = null;
    }

    private void setActivateDataTypeDef() {
        DataTypeItemWrapper typeDefWrapper;
        TableItem item;
        TableItem[] selects = this.DataTypeTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        DataTypeItemWrapper wrapper = (DataTypeItemWrapper)selects[0].getData();
        this.editorBeanPropertyPanel.showWrapperProperties(wrapper);
        this.curItem = item = selects[0];
        this.curDataTypeDefWrapper = typeDefWrapper = (DataTypeItemWrapper)item.getData();
        XMLNode curTypeDefNode = typeDefWrapper.xmlNode;
        String typeDefId = curTypeDefNode.getAttrValue("id");
        String dataType = curTypeDefNode.getNodeName();
        String dataTypeName = curTypeDefNode.getAttrValue("name");
        String docStr = curTypeDefNode.getDocument();
        if (typeDefId != null) {
            this.dataTypeDefIdText.setText(typeDefId);
        } else {
            this.dataTypeDefIdText.setText("");
        }
        if (dataTypeName != null) {
            this.dataTypeNameText.setText(dataTypeName);
        } else {
            this.dataTypeNameText.setText("");
        }
        this.DataTypeCombo.setText(dataType);
        if (docStr != null) {
            this.descText.setText(docStr);
        } else {
            this.descText.setText("");
        }
    }

    private void updateCurDataTypeDef() {
        if (this.curDataTypeDefWrapper == null) {
            return;
        }
        XMLNode curTypeDefNode = this.curDataTypeDefWrapper.xmlNode;
        String typeDefId = this.dataTypeDefIdText.getText();
        String dataTypeName = this.dataTypeNameText.getText();
        String dataType = this.DataTypeCombo.getText();
        if (dataType.indexOf("[") != -1) {
            int idx1 = dataType.indexOf(91);
            int idx2 = dataType.indexOf(93, idx1);
            dataType = dataType.substring(idx1 + 1, idx2);
        }
        if (typeDefId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_9"), (String)Messages.getString("PatternMainPanel.Please_input_proper_pattern_ID_!_10"));
            return;
        }
        XMLNode aNode = this.dataTypeDefNode.findChildNode(curTypeDefNode.getNodeName(), typeDefId);
        if (aNode != null && aNode != curTypeDefNode) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_11"), (String)Messages.getString("PatternMainPanel.Duplicated_pattern_ID_!_12"));
            return;
        }
        String docStr = this.descText.getText();
        curTypeDefNode.setNodeName(dataType);
        curTypeDefNode.setAttrValue("id", typeDefId);
        curTypeDefNode.setDocument(docStr);
        curTypeDefNode.setAttrValue("name", dataTypeName);
        this.curItem.setText(1, dataTypeName);
        this.curItem.setText(2, dataType);
        this.curItem.setText(typeDefId);
        this.curItem.setText(3, docStr);
    }

    private void deleteCurrentDataTypeDef() {
        if (this.dataTypeDefNode == null || this.curDataTypeDefWrapper == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Are_sure..._13"), (String)Messages.getString("PatternMainPanel.Are_you_sure_to_delete_selected_pattern_define__14"))) {
            return;
        }
        this.dataTypeDefNode.remove(this.curDataTypeDefWrapper.xmlNode);
        this.curItem.dispose();
        this.curDataTypeDefWrapper = null;
        this.curItem = null;
    }

    private void editCurrentPatternItem() {
        if (this.curDataTypeDefWrapper == null) {
            return;
        }
        Element element = this.curDataTypeDefWrapper.getElement();
        ObjectEditor objEditor = null;
        if (element.getEditClass() != null) {
            try {
                objEditor = (ObjectEditor)Class.forName(element.getEditClass()).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (objEditor == null) {
            return;
        }
        XMLNode curNode = this.curDataTypeDefWrapper.xmlNode;
        XMLNode clonedNode = (XMLNode)curNode.clone();
        DataTypeItemWrapper wrapper = new DataTypeItemWrapper(clonedNode, this.curDataTypeDefWrapper.element, this.curDataTypeDefWrapper.item);
        wrapper.setWrapperOwner(this);
        Object result = objEditor.editObject(wrapper, this.getShell(), Messages.getString("PatternMainPanel.Pattern_Editing__2"));
        if (result != null) {
            Element elmt;
            if (!objEditor.isChanged()) {
                return;
            }
            this.dataTypeDefNode.remove(this.curDataTypeDefWrapper.xmlNode);
            this.curItem.dispose();
            this.dataTypeDefNode.add(clonedNode);
            XMLNode aTypeDefNode = clonedNode;
            TableItem item = new TableItem(this.DataTypeTable, 0);
            item.setText(aTypeDefNode.getNodeName());
            String svcId = aTypeDefNode.getAttrValue("id");
            if (svcId != null) {
                item.setText(1, svcId);
            }
            if ((elmt = this.getDataTypeElement(aTypeDefNode.getNodeName())) != null && elmt.getImage() != null) {
                item.setImage(elmt.getImage());
            }
            DataTypeItemWrapper aWrapper = new DataTypeItemWrapper(aTypeDefNode, elmt, item);
            aWrapper.setWrapperOwner(this);
            item.setData((Object)aWrapper);
            TableItem[] items = new TableItem[]{item};
            this.DataTypeTable.setSelection(items);
            this.editorBeanPropertyPanel.showWrapperProperties(aWrapper);
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
    }

    public XMLNode getDataDictionary() {
        return this.dataDictionary;
    }

    public EditorProfile getDataEditorProfile() {
        return this.dataEditorProfile;
    }

    public XMLNode getCommonServiceNode() {
        return this.commonServiceNode;
    }

    public XMLNode getSelfDefineNode() {
        return null;
    }

    public String getValue() {
        return this.dataTypeDefIdText.getText();
    }

    public void setValue(String value) {
        if (value != null) {
            this.dataTypeDefIdText.setText(value);
        }
    }

    public XMLNode getExternResource() {
        return this.externResourceNode;
    }

    public void setExternResource(XMLNode node) {
        this.externResourceNode = node;
    }

    public XMLNode getDataType() {
        return this.dataTypeNode;
    }

    public XMLNode getDataTypeDef() {
        return this.dataTypeDefNode;
    }

    public XMLNode getChannelSettings() {
        return this.channelSettings;
    }

    public void setChannelSettings(XMLNode channelSettings) {
        this.channelSettings = channelSettings;
    }
}

