/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.datatype;

import com.ecc.ide.editor.ElementAttributePanel;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.datatype.DataTypePropertyDlg;
import com.ecc.ide.editor.datatype.DataTypePropertyPanel;
import com.ecc.ide.editor.datatype.Messages;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DataTypeEditPanel
extends Composite {
    private Table dataTypeTable;
    private Button createButton;
    private Button deleteButton;
    private Button updateButton;
    private ElementAttributePanel dataTypeAttrPanel;
    private DataTypePropertyPanel propertyPanel;
    private XMLNode dataTypeDefNode;
    private boolean editable;
    private boolean newVersion = false;

    public void setEditable(boolean value) {
        this.editable = value;
        this.createButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.updateButton.setEnabled(false);
    }

    public DataTypeEditPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite_2 = new Composite((Composite)sashForm, 0);
        composite_2.setLayout((Layout)new GridLayout());
        this.dataTypeTable = new Table(composite_2, 67584);
        this.dataTypeTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dataTypeTable.setLinesVisible(true);
        this.dataTypeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeEditPanel.this.setActivateDataType();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DataTypeEditPanel.this.updateCurDataType();
            }
        });
        this.dataTypeTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.dataTypeTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("DataDictionaryPanel.DataTypeID_32"));
        TableColumn tableColumn_1 = new TableColumn(this.dataTypeTable, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("DataDictionaryPanel.Name_33"));
        Menu menu = new Menu((Control)this.dataTypeTable);
        this.dataTypeTable.setMenu(menu);
        MenuItem addMenuItem = new MenuItem(menu, 0);
        addMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeEditPanel.this.createNewDataType();
            }
        });
        addMenuItem.setText("Add");
        MenuItem deleteMenuItem = new MenuItem(menu, 0);
        deleteMenuItem.setText("Delete");
        deleteMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeEditPanel.this.deleteCurDataType();
            }
        });
        new MenuItem(menu, 2);
        MenuItem propertiesMenuItem = new MenuItem(menu, 0);
        propertiesMenuItem.setText("Properties");
        propertiesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeEditPanel.this.updateCurDataType();
            }
        });
        Composite composite = new Composite(composite_2, 0);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 3;
        composite.setLayout((Layout)gridLayout_3);
        this.createButton = new Button(composite, 0);
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeEditPanel.this.createNewDataType();
            }
        });
        GridData gridData_12 = new GridData();
        gridData_12.widthHint = 80;
        this.createButton.setLayoutData((Object)gridData_12);
        this.createButton.setText(Messages.getString("DataDictionaryPanel.Add_28"));
        this.deleteButton = new Button(composite, 0);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeEditPanel.this.deleteCurDataType();
            }
        });
        GridData gridData_13 = new GridData();
        gridData_13.widthHint = 80;
        this.deleteButton.setLayoutData((Object)gridData_13);
        this.deleteButton.setText(Messages.getString("DataDictionaryPanel.Remove_29"));
        this.updateButton = new Button(composite, 0);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypeEditPanel.this.updateCurDataType();
            }
        });
        GridData gridData_17 = new GridData();
        gridData_17.widthHint = 80;
        this.updateButton.setLayoutData((Object)gridData_17);
        this.updateButton.setText(Messages.getString("DataDictionaryPanel.Update_30"));
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        composite_1.setLayout((Layout)new GridLayout());
        CTabFolder tabFolder = new CTabFolder(composite_1, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem item1 = new CTabItem(tabFolder, 0);
        item1.setText(Messages.getString("DataType.propertyLabel"));
        this.propertyPanel = new DataTypePropertyPanel((Composite)tabFolder, false, 0);
        item1.setControl((Control)this.propertyPanel);
        CTabItem item2 = new CTabItem(tabFolder, 0);
        item2.setText(Messages.getString("DataType.appendAttrLabel"));
        this.dataTypeAttrPanel = new ElementAttributePanel((Composite)tabFolder, false, 0);
        item2.setControl((Control)this.dataTypeAttrPanel);
        new Label(composite_1, 0);
        sashForm.setWeights(new int[]{2, 3});
        tabFolder.setSelection(0);
    }

    public void setDataTypeDefNode(XMLNode node) {
        this.dataTypeDefNode = node;
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                if (!this.newVersion && "#comment".equals(aNode.getNodeName())) {
                    String comment = aNode.getAttrValue("value");
                    if ("EMPVersion=2.2".equals(comment)) {
                        this.newVersion = true;
                    }
                } else {
                    TableItem item = new TableItem(this.dataTypeTable, 0);
                    item.setText(aNode.getAttrValue("id"));
                    if (aNode.getAttrValue("name") != null) {
                        item.setText(1, aNode.getAttrValue("name"));
                    }
                    item.setData((Object)aNode);
                }
            }
            ++i;
        }
    }

    private void createNewDataType() {
        DataTypePropertyDlg dlg = new DataTypePropertyDlg(this.getShell());
        dlg.setDataTypeDefNode(this.dataTypeDefNode);
        dlg.setNewVersion(this.newVersion);
        XMLNode node = (XMLNode)dlg.open();
        if (node != null) {
            this.dataTypeDefNode.add(node);
            TableItem item = new TableItem(this.dataTypeTable, 0);
            item.setText(node.getAttrValue("id"));
            if (node.getAttrValue("name") != null) {
                item.setText(1, node.getAttrValue("name"));
            }
            item.setData((Object)node);
            TableItem[] items = new TableItem[]{item};
            this.dataTypeTable.setSelection(items);
            this.propertyPanel.setDataTypeDefXMLNode(node);
            this.dataTypeAttrPanel.setAttributesXMLNode(node.getChild("attributes"));
        }
    }

    private void updateCurDataType() {
        TableItem[] selects = this.dataTypeTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        TableItem item = selects[0];
        XMLNode node = (XMLNode)item.getData();
        DataTypePropertyDlg dlg = new DataTypePropertyDlg(this.getShell());
        dlg.setDataTypeDefNode(this.dataTypeDefNode);
        dlg.setDataTypeNode(node);
        dlg.setNewVersion(this.newVersion);
        XMLNode newNode = (XMLNode)dlg.open();
        if (newNode != null) {
            int idx = this.dataTypeDefNode.getChilds().indexOf(node);
            this.dataTypeDefNode.remove(node);
            this.dataTypeDefNode.add(newNode, idx);
            item.setText(newNode.getAttrValue("id"));
            if (node.getAttrValue("name") != null) {
                item.setText(1, newNode.getAttrValue("name"));
            }
            item.setData((Object)newNode);
            TableItem[] items = new TableItem[]{item};
            this.dataTypeTable.setSelection(items);
            this.propertyPanel.setDataTypeDefXMLNode(newNode);
            this.dataTypeAttrPanel.setAttributesXMLNode(newNode.getChild("attributes"));
        }
    }

    private void deleteCurDataType() {
        TableItem[] selects = this.dataTypeTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("DataDictionaryPanel.Are_you_sure..._14"), (String)Messages.getString("DataDictionaryPanel.Please_make_sure_to_delete_current_data_type_define_!_15"))) {
            return;
        }
        TableItem item = selects[0];
        XMLNode node = (XMLNode)item.getData();
        this.dataTypeDefNode.remove(node);
        this.dataTypeTable.remove(this.dataTypeTable.indexOf(item));
    }

    private void setActivateDataType() {
        TableItem[] selects = this.dataTypeTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        TableItem item = selects[0];
        XMLNode node = (XMLNode)item.getData();
        this.propertyPanel.setNewVersion(this.newVersion);
        this.propertyPanel.setDataTypeDefXMLNode(node);
        this.dataTypeAttrPanel.setAttributesXMLNode(node.getChild("attributes"));
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

