/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.datatype;

import com.ecc.ide.editor.ElementAttributePanel;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.datatype.DataTypePropertyPanel;
import com.ecc.ide.editor.datatype.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DataTypePropertyDlg
extends Dialog {
    protected Object result;
    protected Shell shell;
    private ElementAttributePanel dataTypeAttrPanel;
    private DataTypePropertyPanel propertyPanel;
    private boolean newVersion = false;
    private XMLNode dataTypeNode;
    private XMLNode dataTypeDefNode;
    boolean isNewDataType = false;

    public void setNewVersion(boolean flag) {
        this.newVersion = flag;
    }

    public void setDataTypeDefNode(XMLNode node) {
        this.dataTypeDefNode = node;
    }

    public void setDataTypeNode(XMLNode node) {
        this.dataTypeNode = node;
    }

    public DataTypePropertyDlg(Shell parent, int style) {
        super(parent, style);
    }

    public DataTypePropertyDlg(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.createContents();
        this.init();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 5;
        gridLayout.verticalSpacing = 1;
        gridLayout.marginHeight = 1;
        gridLayout.horizontalSpacing = 1;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setSize(746, 528);
        this.shell.setText("Data Type properties");
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem item1 = new TabItem(tabFolder, 0);
        item1.setText(Messages.getString("DataType.propertyLabel"));
        this.propertyPanel = new DataTypePropertyPanel((Composite)tabFolder, true, 0);
        item1.setControl((Control)this.propertyPanel);
        TabItem item2 = new TabItem(tabFolder, 0);
        item2.setText(Messages.getString("DataType.appendAttrLabel"));
        this.dataTypeAttrPanel = new ElementAttributePanel((Composite)tabFolder, true, 0);
        item2.setControl((Control)this.dataTypeAttrPanel);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(3, 2, true, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        composite.setLayout((Layout)gridLayout_1);
        Button okButton = new Button(composite, 0);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLNode node = DataTypePropertyDlg.this.propertyPanel.getDataTypeDefXMLNode();
                String id = node.getAttrValue("id");
                if (id == null || id.length() == 0) {
                    MessageDialog.openError((Shell)DataTypePropertyDlg.this.shell, (String)"Error", (String)"Please input proper dataType ID!");
                    return;
                }
                String implClassName = node.getAttrValue("implClass");
                if (implClassName == null || implClassName.length() == 0) {
                    MessageDialog.openError((Shell)DataTypePropertyDlg.this.shell, (String)"Error", (String)"Please input proper implement class name !");
                    return;
                }
                XMLNode aNode = DataTypePropertyDlg.this.dataTypeDefNode.findChildNode(id);
                if (DataTypePropertyDlg.this.isNewDataType && aNode != null) {
                    MessageDialog.openError((Shell)DataTypePropertyDlg.this.shell, (String)"Error", (String)"Duplicate Data Type ID !");
                    return;
                }
                if (aNode != null && aNode != DataTypePropertyDlg.this.dataTypeNode) {
                    MessageDialog.openError((Shell)DataTypePropertyDlg.this.shell, (String)"Error", (String)"Duplicate Data Type ID !");
                    return;
                }
                DataTypePropertyDlg.this.result = node;
                DataTypePropertyDlg.this.shell.dispose();
            }
        });
        okButton.setLayoutData((Object)new GridData(100, -1));
        okButton.setText("OK");
        Button cancelButton = new Button(composite, 0);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTypePropertyDlg.this.result = null;
                DataTypePropertyDlg.this.shell.dispose();
            }
        });
        cancelButton.setLayoutData((Object)new GridData(100, -1));
        cancelButton.setText("Cancel");
    }

    private void init() {
        if (this.dataTypeNode == null) {
            this.isNewDataType = true;
            this.dataTypeNode = new XMLNode("dataType");
            XMLNode attrNode = new XMLNode("attributes");
            this.dataTypeNode.add(attrNode);
            this.propertyPanel.setNewVersion(this.newVersion);
            this.propertyPanel.setDataTypeDefXMLNode(this.dataTypeNode);
            this.dataTypeAttrPanel.setAttributesXMLNode(this.dataTypeNode.getChild("attributes"));
        } else {
            XMLNode aNode = (XMLNode)this.dataTypeNode.clone();
            this.propertyPanel.setNewVersion(this.newVersion);
            this.propertyPanel.setDataTypeDefXMLNode(aNode);
            this.dataTypeAttrPanel.setAttributesXMLNode(aNode.getChild("attributes"));
        }
    }
}

