/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.externResource;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.externResource.Messages;
import com.ecc.ide.editor.externResource.ResourcePropertyDialog;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExternResourceEditPanel
extends Composite {
    private Text resourceIdText;
    private Text searchText;
    private Combo languageIdCombo;
    private Combo languageCombo;
    private Table table;
    private Button addLanguageButton;
    private Button deleteLanguageButton;
    private Vector suportLanguageId;
    private XMLNode xmlContent;
    private XMLNode currentNode;

    public ExternResourceEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Composite composite_3 = new Composite((Composite)this, 0);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 5;
        composite_3.setLayout((Layout)gridLayout_3);
        composite_3.setLayoutData((Object)new GridData(256));
        Label label = new Label(composite_3, 0);
        label.setText(Messages.getString("externalResource.External_Resource"));
        this.resourceIdText = new Text(composite_3, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.resourceIdText.setLayoutData((Object)gridData);
        Button button_1 = new Button(composite_3, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.addNewResource();
            }
        });
        GridData gridData_51 = new GridData();
        gridData_51.widthHint = 60;
        button_1.setLayoutData((Object)gridData_51);
        button_1.setText(Messages.getString("externalResource.Add"));
        Button button_2 = new Button(composite_3, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.updateCurrentResource();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 60;
        button_2.setLayoutData((Object)gridData_6);
        button_2.setText(Messages.getString("externalResource.edit"));
        Button button_3 = new Button(composite_3, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.deleteCurrentResource();
            }
        });
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 60;
        button_3.setLayoutData((Object)gridData_7);
        button_3.setText(Messages.getString("externalResource.Delete"));
        Composite composite_2 = new Composite((Composite)this, 0);
        composite_2.setLayoutData((Object)new GridData(256));
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 9;
        composite_2.setLayout((Layout)gridLayout_2);
        Label label_3 = new Label(composite_2, 0);
        label_3.setText(Messages.getString("externalResource.Search1"));
        this.languageIdCombo = new Combo(composite_2, 0);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 120;
        this.languageIdCombo.setLayoutData((Object)gridData_2);
        Label label_1 = new Label(composite_2, 0);
        label_1.setText(Messages.getString("externalResource.value_include"));
        this.searchText = new Text(composite_2, 2048);
        GridData gridData_9 = new GridData();
        gridData_9.widthHint = 120;
        this.searchText.setLayoutData((Object)gridData_9);
        Button button_4 = new Button(composite_2, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.locateResource();
            }
        });
        button_4.setText(Messages.getString("externalResource.locate"));
        Label label_2 = new Label(composite_2, 0);
        label_2.setText(Messages.getString("externalResource.Language"));
        this.languageCombo = new Combo(composite_2, 0);
        this.languageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.changeLanguage();
            }
        });
        Locale[] locales = Locale.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            this.languageCombo.add(String.valueOf(locale.getDisplayName()) + ":" + locale.toString());
            ++i;
        }
        this.addLanguageButton = new Button(composite_2, 0);
        this.addLanguageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.addLanguage();
            }
        });
        this.addLanguageButton.setText(Messages.getString("externalResource.Add_Language_Suport"));
        this.deleteLanguageButton = new Button(composite_2, 0);
        this.deleteLanguageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.deleteLanguage();
            }
        });
        this.deleteLanguageButton.setText(Messages.getString("externalResource.Delete"));
        this.table = new Table((Composite)this, 67584);
        GridData tableGridData = new GridData(1808);
        this.table.setLayoutData((Object)tableGridData);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.setActivateResource();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ExternResourceEditPanel.this.table.setLayoutData((Object)new GridData(1808));
                ExternResourceEditPanel.this.updateCurrentResource();
            }
        });
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(115);
        tableColumn.setText(Messages.getString("externalResource.ResourceId_1"));
    }

    private void changeLanguage() {
        String langStr = this.languageCombo.getText();
        if (langStr == null || langStr.length() == 0) {
            this.addLanguageButton.setEnabled(false);
            this.deleteLanguageButton.setEnabled(false);
            return;
        }
        int idx = langStr.indexOf(58);
        String langId = langStr.substring(idx + 1);
        int i = 0;
        while (i < this.suportLanguageId.size()) {
            String lId = (String)this.suportLanguageId.elementAt(i);
            if (lId.equals(langId)) {
                this.addLanguageButton.setEnabled(false);
                this.deleteLanguageButton.setEnabled(true);
                return;
            }
            ++i;
        }
        this.addLanguageButton.setEnabled(true);
        this.deleteLanguageButton.setEnabled(false);
    }

    private void addLanguage() {
        String langStr = this.languageCombo.getText();
        if (langStr == null || langStr.length() == 0) {
            return;
        }
        int idx = langStr.indexOf(58);
        String langId = langStr.substring(idx + 1);
        String langName = langStr.substring(0, idx);
        XMLNode languageNode = new XMLNode("language");
        languageNode.setAttrValue("id", langId);
        languageNode.setAttrValue("name", langName);
        this.xmlContent.getChild("suportLanguage").add(languageNode);
        this.suportLanguageId.addElement(langId);
        TableColumn column = new TableColumn(this.table, 0);
        column.setWidth(200);
        column.setText(langName);
        this.languageIdCombo.add(langName);
        this.addLanguageButton.setEnabled(false);
        this.deleteLanguageButton.setEnabled(true);
    }

    private void deleteLanguage() {
        String langStr = this.languageCombo.getText();
        if (langStr == null || langStr.length() == 0) {
            return;
        }
        int idx = langStr.indexOf(58);
        String langId = langStr.substring(idx + 1);
        String langName = langStr.substring(0, idx);
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Be sure to", (String)Messages.getString("externalResource.sure_to_Delete_Language_Suport"))) {
            return;
        }
        int i = 0;
        while (i < this.suportLanguageId.size()) {
            String lid = (String)this.suportLanguageId.elementAt(i);
            if (lid.equals(langId)) {
                this.suportLanguageId.remove(i);
                break;
            }
            ++i;
        }
        i = 1;
        while (i < this.table.getColumnCount()) {
            TableColumn column = this.table.getColumn(i);
            if (column.getText().equals(langName)) {
                column.dispose();
                break;
            }
            ++i;
        }
        XMLNode suportLanguageNode = this.xmlContent.getChild("suportLanguage");
        XMLNode childNode = suportLanguageNode.findChildNode(langId);
        suportLanguageNode.remove(childNode);
        int i2 = 0;
        while (i2 < this.languageIdCombo.getItemCount()) {
            if (langName.equals(this.languageIdCombo.getItem(i2))) {
                this.languageIdCombo.remove(i2);
                break;
            }
            ++i2;
        }
        this.addLanguageButton.setEnabled(true);
        this.deleteLanguageButton.setEnabled(false);
    }

    private void addNewResource() {
        XMLNode newNode = new XMLNode("resource");
        ResourcePropertyDialog dlg = new ResourcePropertyDialog(this.getShell(), 0);
        dlg.setXMLContent(newNode);
        dlg.setExternResourceNode(this.xmlContent);
        dlg.setSuportLanguage(this.suportLanguageId);
        XMLNode retNode = (XMLNode)dlg.open();
        if (retNode != null) {
            this.xmlContent.add(retNode);
            TableItem item = new TableItem(this.table, 0);
            this.setTableItemValue(item, retNode);
            TableItem[] items = new TableItem[]{item};
            this.table.setSelection(items);
            this.setActivateResource();
        }
    }

    private void updateCurrentResource() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode selectNode = (XMLNode)items[0].getData();
        if (selectNode == null) {
            selectNode = new XMLNode("resource");
            selectNode.setAttrValue("id", items[0].getText());
        }
        XMLNode newNode = (XMLNode)selectNode.clone();
        ResourcePropertyDialog dlg = new ResourcePropertyDialog(this.getShell(), 0);
        dlg.setExternResourceNode(this.xmlContent);
        dlg.setXMLContent(newNode);
        dlg.setEditingXMLNode(selectNode);
        XMLNode retNode = (XMLNode)dlg.open();
        if (retNode != null) {
            this.xmlContent.replaceNode(selectNode, retNode);
            this.setTableItemValue(items[0], retNode);
        }
    }

    private void deleteCurrentResource() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode curNode = (XMLNode)items[0].getData();
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Be sure to...", (String)Messages.getString("externalResource.be_sure_to_delete"))) {
            return;
        }
        this.xmlContent.remove(curNode);
        items[0].dispose();
    }

    private void setActivateResource() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode selectNode = (XMLNode)items[0].getData();
        if (selectNode == this.currentNode) {
            return;
        }
        this.currentNode = selectNode;
        this.resourceIdText.setText(this.currentNode.getAttrValue("id"));
    }

    public void setResourceId(String resourceId) {
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem item = this.table.getItem(i);
            if (item.getText().equals(resourceId)) {
                this.table.setSelection(i);
                break;
            }
            ++i;
        }
        this.setActivateResource();
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
        if (node == null) {
            return;
        }
        this.table.removeAll();
        if (node.getChild("suportLanguage") == null) {
            XMLNode aNode = new XMLNode("suportLanguage");
            node.add(aNode);
        }
        Vector languages = node.getChild("suportLanguage").getChilds();
        this.suportLanguageId = new Vector();
        int i = 0;
        while (i < languages.size()) {
            XMLNode langNode = (XMLNode)languages.elementAt(i);
            if ("language".equals(langNode.getNodeName())) {
                this.languageIdCombo.add(langNode.getAttrValue("name"));
                TableColumn column = new TableColumn(this.table, 0);
                column.setWidth(220);
                column.setText(langNode.getAttrValue("name"));
                this.suportLanguageId.addElement(langNode.getAttrValue("id"));
            }
            ++i;
        }
        Vector resources = node.getChilds();
        int i2 = 0;
        while (i2 < resources.size()) {
            XMLNode resNode = (XMLNode)resources.elementAt(i2);
            if ("resource".equals(resNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                this.setTableItemValue(item, resNode);
            }
            ++i2;
        }
    }

    private void setTableItemValue(TableItem item, XMLNode resNode) {
        try {
            item.setText(resNode.getAttrValue("id"));
            int k = 0;
            while (k < this.suportLanguageId.size()) {
                String lid = (String)this.suportLanguageId.elementAt(k);
                XMLNode resLangNode = resNode.findChildNode(lid);
                if (resLangNode != null) {
                    item.setText(k + 1, resLangNode.getNodeValue());
                }
                ++k;
            }
            item.setData((Object)resNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void locateResource() {
        int idx = this.languageIdCombo.getSelectionIndex();
        this.setLayout((Layout)new GridLayout());
        if (idx == -1) {
            return;
        }
        String searchStr = this.searchText.getText();
        if (searchStr.length() == 0) {
            return;
        }
        int itemIdx = this.table.getSelectionIndex();
        if (itemIdx == -1) {
            itemIdx = 0;
        }
        int i = itemIdx + 1;
        while (i < this.table.getItemCount()) {
            TableItem item = this.table.getItem(i);
            String txt = item.getText(idx + 1);
            if (txt.indexOf(searchStr) != -1) {
                this.table.select(i);
                this.table.showSelection();
                this.setActivateResource();
                return;
            }
            ++i;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)"message", (String)"Nothing found!");
    }

    public String getResourceId() {
        if (this.currentNode != null) {
            return this.currentNode.getAttrValue("id");
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

