/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.externResource;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.externResource.Messages;
import com.ecc.ide.editor.externResource.ResourcePropertyPanel;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ResourcePropertyDialog
extends Dialog {
    private Object result;
    private Shell shell;
    private int mode;
    private String dataName = null;
    private XMLNode xmlContent;
    private XMLNode editingContent;
    private XMLNode externResourceNode;
    private Vector suportLanguage;
    private ResourcePropertyPanel editPanel;

    public ResourcePropertyDialog(Shell parent, int style) {
        super(parent, style);
    }

    public ResourcePropertyDialog(Shell parent) {
        this(parent, 0);
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
    }

    public void setExternResourceNode(XMLNode node) {
        this.externResourceNode = node;
    }

    public void setMode(int value) {
        this.mode = value;
    }

    public Object open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setText("External resource propert");
        this.editPanel = new ResourcePropertyPanel((Composite)this.shell, 0);
        this.editPanel.setExternResourceNode(this.externResourceNode);
        this.editPanel.setXMLContent(this.xmlContent);
        this.editPanel.setLayoutData(new GridData(1808));
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        GridData gridData = new GridData(128);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ResourcePropertyDialog.this.isOK()) {
                    return;
                }
                ResourcePropertyDialog.this.result = ResourcePropertyDialog.this.editPanel.getXMLContent();
                ResourcePropertyDialog.this.dispose();
            }
        });
        button.setText("OK");
        Button button_1 = new Button(composite, 0);
        GridData gridData_1 = new GridData(128);
        gridData_1.widthHint = 80;
        button_1.setLayoutData((Object)gridData_1);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcePropertyDialog.this.result = null;
                ResourcePropertyDialog.this.dispose();
            }
        });
        button_1.setText("Cancel");
        Rectangle rect = this.shell.getDisplay().getBounds();
        rect.x = (rect.width - 600) / 2;
        rect.y = (rect.height - 250) / 3;
        rect.width = 600;
        rect.height = 250;
        this.shell.setBounds(rect);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    public void setEditingXMLNode(XMLNode node) {
        this.editingContent = node;
    }

    public void setSuportLanguage(Vector suportLanguage) {
        this.suportLanguage = suportLanguage;
    }

    private boolean isOK() {
        String resourceId = this.editPanel.getResourceId();
        if (resourceId.length() == 0) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)Messages.getString("externalResource.properResourceId"));
            return false;
        }
        XMLNode aNode = this.externResourceNode.findChildNode(resourceId);
        if (aNode != null && this.editingContent == null) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)Messages.getString("externalResource.duplicatedResourceId"));
            return false;
        }
        if (aNode != null && this.editingContent != null && aNode != this.editingContent) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)Messages.getString("externalResource.duplicatedResourceId"));
            return false;
        }
        this.xmlContent.setAttrValue("id", resourceId);
        return true;
    }

    public void dispose() {
        this.shell.dispose();
    }
}

