/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.externResource;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.externResource.Messages;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourcePropertyPanel
extends Composite {
    private Text resourceText;
    private Combo languageCombo;
    private Text resourceIdText;
    private String currentLanguageId;
    private XMLNode xmlContent;
    private String[] suportLanguageId;
    private boolean isChanged = false;

    public ResourcePropertyPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("externalResource.ResourceId"));
        this.resourceIdText = new Text((Composite)this, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        this.resourceIdText.setLayoutData((Object)gridData);
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("externalResource.Language"));
        this.languageCombo = new Combo((Composite)this, 0);
        this.languageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcePropertyPanel.this.changeLanguage();
            }
        });
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 120;
        this.languageCombo.setLayoutData((Object)gridData_8);
        Label label_3 = new Label((Composite)this, 0);
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 3;
        label_3.setLayoutData((Object)gridData_2);
        label_3.setText(Messages.getString("externalResource.resourceValue"));
        this.resourceText = new Text((Composite)this, 2626);
        this.resourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourcePropertyPanel.this.isChanged = true;
            }
        });
        GridData gridData_3 = new GridData(1808);
        gridData_3.horizontalSpan = 3;
        this.resourceText.setLayoutData((Object)gridData_3);
    }

    private void changeLanguage() {
        String languageId;
        if (this.isChanged) {
            XMLNode resNode = this.xmlContent.findChildNode(this.currentLanguageId);
            if (resNode == null) {
                resNode = new XMLNode("resourceValue");
                resNode.setAttrValue("id", this.currentLanguageId);
                this.xmlContent.add(resNode);
            }
            resNode.setAttrValue("nodeValue", this.resourceText.getText());
            this.isChanged = false;
        }
        this.currentLanguageId = languageId = this.suportLanguageId[this.languageCombo.getSelectionIndex()];
        XMLNode resNode = this.xmlContent.findChildNode(languageId);
        if (resNode == null) {
            this.resourceText.setText("");
        } else {
            this.resourceText.setText(resNode.getNodeValue());
        }
    }

    public void setExternResourceNode(XMLNode node) {
        Vector languages = node.getChild("suportLanguage").getChilds();
        this.suportLanguageId = new String[languages.size()];
        int idx = 0;
        int i = 0;
        while (i < languages.size()) {
            XMLNode langNode = (XMLNode)languages.elementAt(i);
            if ("language".equalsIgnoreCase(langNode.getNodeName())) {
                this.languageCombo.add(langNode.getAttrValue("name"));
                this.suportLanguageId[idx++] = langNode.getAttrValue("id");
            }
            ++i;
        }
    }

    public void setXMLContent(XMLNode node) {
        String languageId;
        this.xmlContent = node;
        this.languageCombo.select(0);
        this.currentLanguageId = languageId = this.suportLanguageId[0];
        XMLNode resNode = this.xmlContent.findChildNode(languageId);
        String resourceId = node.getAttrValue("id");
        if (resourceId != null) {
            this.resourceIdText.setText(resourceId);
        }
        if (resNode != null && resNode.getNodeValue() != null) {
            this.resourceText.setText(resNode.getNodeValue());
        } else {
            this.resourceText.setText("");
        }
    }

    public XMLNode getXMLContent() {
        if (this.isChanged) {
            XMLNode resNode = this.xmlContent.findChildNode(this.currentLanguageId);
            if (resNode == null) {
                resNode = new XMLNode("resourceValue");
                resNode.setAttrValue("id", this.currentLanguageId);
                this.xmlContent.add(resNode);
            }
            resNode.setAttrValue("nodeValue", this.resourceText.getText());
        }
        this.xmlContent.setAttrValue("id", this.resourceIdText.getText());
        return this.xmlContent;
    }

    public void dispose() {
        super.dispose();
    }

    public String getResourceId() {
        return this.resourceIdText.getText();
    }

    protected void checkSubclass() {
    }
}

