/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.flow;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.business.Messages;
import com.ecc.ide.editor.flow.OpFlowSelectDialog;
import com.ecc.ide.editor.flow.OpFlowWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewOperationDialog
extends Dialog {
    private Object result;
    private Shell shell;
    private Text opIdText;
    private Text opNameText;
    private Combo refOpIdText;
    private Text documentText;
    private EditorProfile flowProfile;
    private XMLNode commonFlowNode;
    private XMLNode trxNode;

    public NewOperationDialog(Shell parent) {
        super(parent, 0);
    }

    public NewOperationDialog(Shell parent, int style) {
        super(parent, style);
    }

    public Object open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setText(Messages.getString("BusinessFlowPanel.operationLabel"));
        Composite mainComp = new Composite((Composite)this.shell, 0);
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        mainComp.setLayout((Layout)new GridLayout(3, false));
        Label operationidLabel = new Label(mainComp, 0);
        operationidLabel.setText(Messages.getString("BusinessFlowPanel.OperationId"));
        this.opIdText = new Text(mainComp, 2048);
        GridData gridData_1 = new GridData(1, 2, true, false, 2, 1);
        gridData_1.widthHint = 220;
        this.opIdText.setLayoutData((Object)gridData_1);
        Label operationnameLabel = new Label(mainComp, 0);
        operationnameLabel.setText(Messages.getString("BusinessFlowPanel.OperationName"));
        this.opNameText = new Text(mainComp, 2048);
        this.opNameText.setLayoutData((Object)gridData_1);
        Label templateLabel = new Label(mainComp, 0);
        templateLabel.setText(Messages.getString("BusinessFlowPanel.refToCommonFlow"));
        this.refOpIdText = new Combo(mainComp, 2056);
        this.refOpIdText.setLayoutData((Object)new GridData(200, -1));
        this.addTemplatCombo();
        Button refFlowButton = new Button(mainComp, 0);
        refFlowButton.setVisible(true);
        refFlowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewOperationDialog.this.selectCommonFlow();
            }
        });
        refFlowButton.setText(">>");
        Label documentLabel = new Label(mainComp, 0);
        documentLabel.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        documentLabel.setText(Messages.getString("BusinessFlowPanel.Document"));
        this.documentText = new Text(mainComp, 2882);
        this.documentText.setLayoutData((Object)new GridData(4, 4, true, true, 3, 4));
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        composite.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 79;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewOperationDialog.this.result = NewOperationDialog.this.createNewOpNode();
                if (NewOperationDialog.this.result == null) {
                    return;
                }
                NewOperationDialog.this.dispose();
            }
        });
        button.setText(Messages.getString("FlowSelectDialog.OK_2"));
        Button button_1 = new Button(composite, 0);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 71;
        button_1.setLayoutData((Object)gridData_2);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewOperationDialog.this.result = null;
                NewOperationDialog.this.dispose();
            }
        });
        button_1.setText(Messages.getString("FlowSelectDialog.Cancel_3"));
        Rectangle rect = this.shell.getDisplay().getBounds();
        rect.x = (rect.width - 1000) / 2;
        rect.y = (rect.height - 600) / 3;
        rect.width = 512;
        rect.height = 384;
        this.shell.setBounds(rect);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    public void dispose() {
        this.shell.dispose();
    }

    private void selectCommonFlow() {
        OpFlowSelectDialog dlg = new OpFlowSelectDialog(this.shell);
        dlg.setProfile(this.flowProfile);
        dlg.setFlowNode(this.commonFlowNode);
        OpFlowWrapper flow = (OpFlowWrapper)dlg.open();
        if (flow != null) {
            XMLNode node = (XMLNode)((XMLNode)flow.getWrappedObject()).clone();
            this.addTemplatCombo();
            this.refOpIdText.setText(node.getAttrValue("id"));
        }
    }

    private void addTemplatCombo() {
        if (this.commonFlowNode != null) {
            this.refOpIdText.removeAll();
            this.refOpIdText.add("");
            int i = 0;
            while (i < this.commonFlowNode.getChilds().size()) {
                XMLNode child = (XMLNode)this.commonFlowNode.getChilds().elementAt(i);
                if ("flow".equals(child.getNodeName())) {
                    this.refOpIdText.add(child.getAttrValue("id"));
                }
                ++i;
            }
        }
    }

    private XMLNode createNewOpNode() {
        String flowId = this.opIdText.getText();
        String flowName = this.opNameText.getText();
        String document = this.documentText.getText();
        String commonFlow = this.refOpIdText.getText();
        if (flowId == null || flowId.length() == 0) {
            MessageDialog.openError((Shell)this.shell, (String)"error", (String)Messages.getString("BusinessFlowPanel.properId"));
            return null;
        }
        if (this.trxNode.findChildNode("operation", flowId) != null) {
            MessageDialog.openError((Shell)this.shell, (String)"error", (String)Messages.getString("BusinessFlowPanel.duplicateId"));
            return null;
        }
        XMLNode opNode = new XMLNode("operation");
        opNode.setAttrValue("id", flowId);
        opNode.setAttrValue("name", flowName);
        opNode.setAttrValue("refFlowId", commonFlow);
        opNode.setDocument(document);
        this.mergeCommonFlow(opNode, commonFlow);
        return opNode;
    }

    private void mergeCommonFlow(XMLNode opNode, String commonFlowId) {
        XMLNode flowNode = new XMLNode("flow");
        flowNode.setAttrValue("x", "10");
        flowNode.setAttrValue("y", "10");
        flowNode.setAttrValue("width", "500");
        flowNode.setAttrValue("height", "400");
        opNode.add(flowNode);
        if (commonFlowId == null || commonFlowId.length() <= 0) {
            XMLNode startNode = new XMLNode("StartAction");
            startNode.setAttrValue("name", "StartAction0");
            startNode.setAttrValue("height", "40");
            startNode.setAttrValue("width", "100");
            startNode.setAttrValue("x", "100");
            startNode.setAttrValue("y", "50");
            XMLNode endNode = new XMLNode("EndAction");
            endNode.setAttrValue("name", "EndAction0");
            endNode.setAttrValue("height", "40");
            endNode.setAttrValue("width", "100");
            endNode.setAttrValue("x", "100");
            endNode.setAttrValue("y", "350");
            flowNode.add(startNode);
            flowNode.add(endNode);
        }
        if (commonFlowId == null || commonFlowId.trim().length() == 0) {
            return;
        }
        XMLNode refFlow = this.commonFlowNode.findChildNode(commonFlowId);
        if (refFlow == null) {
            return;
        }
        int i = 0;
        while (i < refFlow.getChilds().size()) {
            XMLNode extendedAction = (XMLNode)refFlow.getChilds().elementAt(i);
            if ("ExtendedAction".equals(extendedAction.getNodeName())) {
                extendedAction = (XMLNode)extendedAction.clone();
                extendedAction.removeAllChilds();
                flowNode.add(extendedAction);
            }
            ++i;
        }
    }

    public void setCommonFlowNode(XMLNode commonFlowNode) {
        this.commonFlowNode = commonFlowNode;
    }

    public void setFlowProfile(EditorProfile flowProfile) {
        this.flowProfile = flowProfile;
    }

    public void setTrxNode(XMLNode trxNode) {
        this.trxNode = trxNode;
    }
}

