/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.flow;

import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.SearchClass;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.Messages;
import com.ecc.ide.editor.flow.OpFlowSelectDialog;
import com.ecc.ide.editor.flow.OpFlowWrapper;
import com.ecc.ide.editor.flow.RefFlowWrapper;
import com.ecc.ide.editor.visualflow.VisualFlowFramePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import java.util.Vector;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TrxOpFlowPanel
extends Composite {
    private Text flowClassNameText;
    private Text mainFlowIDText;
    private Button refMainFlowButton;
    private Button specialFlowButton;
    private EditorProfile flowProfile;
    private EditorProfile extendFlowProfile;
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private VisualFlowFramePanel extendedVisualFlowFramePanel;
    private VisualFlowFramePanel visualFlowFramePanel;
    private Composite refFlowComposite;
    private Composite specialFlowComposite;
    private StackLayout stackLayout;
    private XMLNode commonFlowNode;
    private XMLNode trxNode;
    private RefFlowWrapper refFlowWrapper;
    private XMLNode extendFlowNode;
    private XMLNode commonSvcNode;
    private XMLNode selfDefNode;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;

    public void setTrxNode(XMLNode node) {
        this.trxNode = node;
        XMLNode flowNode = null;
        flowNode = node.findChildNode("flow", "privateFlow");
        if (flowNode == null) {
            flowNode = node.getChild("flow");
        }
        if (flowNode == null) {
            flowNode = new XMLNode();
            flowNode.setNodeName("flow");
            flowNode.setAttrValue("id", "privateFlow");
            node.add(flowNode);
        } else {
            flowNode.setAttrValue("id", "privateFlow");
        }
        Element element = new Element();
        element.setElementName("flow");
        try {
            this.visualFlowFramePanel.setXMLContent(flowNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        XMLNode extendFlowNode = this.trxNode.findChildNode("flow", "extendFlow");
        if (extendFlowNode == null) {
            extendFlowNode = new XMLNode();
            extendFlowNode.setNodeName("flow");
            extendFlowNode.setAttrValue("id", "extendFlow");
            node.add(extendFlowNode);
        }
        boolean refToMainFlow = "true".equals(node.getAttrValue("refToMainFlow"));
        XMLNode refFlowNode = this.trxNode.getChild("refFlow");
        if (refToMainFlow && refFlowNode != null) {
            String mainFlowId = refFlowNode.getAttrValue("refId");
            this.mainFlowIDText.setText(mainFlowId);
            XMLNode refFlow = this.commonFlowNode.findChildNode(mainFlowId);
            if (refFlow == null) {
                System.out.println("Trx refer to undefined main flow: " + mainFlowId);
            } else {
                XMLNode extendedFlowNode = this.getExtendedFlow(refFlow, extendFlowNode);
                this.setMainFlow(extendedFlowNode);
            }
        }
        this.refMainFlowButton.setSelection(refToMainFlow);
        this.specialFlowButton.setSelection(!refToMainFlow);
        this.setActivateComposite(refToMainFlow);
        String implClassName = flowNode.getAttrValue("implClass");
        if (implClassName != null) {
            this.flowClassNameText.setText(implClassName);
        }
    }

    public TrxOpFlowPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.marginWidth = 2;
        gridLayout_3.marginHeight = 5;
        gridLayout_3.numColumns = 2;
        this.setLayout((Layout)gridLayout_3);
        this.refMainFlowButton = new Button((Composite)this, 16);
        this.refMainFlowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxOpFlowPanel.this.setActivateComposite(TrxOpFlowPanel.this.refMainFlowButton.getSelection());
            }
        });
        this.refMainFlowButton.setSelection(true);
        this.refMainFlowButton.setText(Messages.getString("TrxFlowPanel.Refer_to_common_defined_transaction_flow_8"));
        this.specialFlowButton = new Button((Composite)this, 16);
        this.specialFlowButton.setText(Messages.getString("TrxFlowPanel.Specified_transaction_flow_9"));
        Composite stackComposite = new Composite((Composite)this, 0);
        this.stackLayout = new StackLayout();
        stackComposite.setLayout((Layout)this.stackLayout);
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 2;
        stackComposite.setLayoutData((Object)gridData_1);
        this.specialFlowComposite = new Composite(stackComposite, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.marginWidth = 0;
        gridLayout_1.marginHeight = 0;
        gridLayout_1.horizontalSpacing = 2;
        gridLayout_1.numColumns = 5;
        this.specialFlowComposite.setLayout((Layout)gridLayout_1);
        Label label = new Label(this.specialFlowComposite, 0);
        label.setText(Messages.getString("TrxFlowPanel.Flow_Implement_class__1"));
        this.flowClassNameText = new Text(this.specialFlowComposite, 2048);
        this.flowClassNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.flowClassNameText.setLayoutData((Object)new GridData(768));
        Button button_2 = new Button(this.specialFlowComposite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxOpFlowPanel.this.selectFlowClass();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 53;
        button_2.setLayoutData((Object)gridData_3);
        button_2.setText(">>");
        Button button_1 = new Button(this.specialFlowComposite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxOpFlowPanel.this.selectReferenceFlow();
            }
        });
        GridData gridData_6 = new GridData();
        button_1.setLayoutData((Object)gridData_6);
        button_1.setText(Messages.getString("TrxFlowPanel.Common_flow_reference_2"));
        Button button_3 = new Button(this.specialFlowComposite, 0x800084);
        button_3.setLayoutData((Object)new GridData(128));
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxOpFlowPanel.this.maximizedEditPrivateFlow();
            }
        });
        button_3.setToolTipText("maximize");
        this.visualFlowFramePanel = new VisualFlowFramePanel(this.specialFlowComposite, 0);
        GridData gridData_2 = new GridData(1808);
        gridData_2.horizontalSpan = 5;
        this.visualFlowFramePanel.setLayoutData(gridData_2);
        this.specialFlowComposite.setVisible(false);
        this.refFlowComposite = new Composite(stackComposite, 0);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.marginWidth = 0;
        gridLayout_2.marginHeight = 0;
        gridLayout_2.horizontalSpacing = 2;
        gridLayout_2.numColumns = 4;
        this.refFlowComposite.setLayout((Layout)gridLayout_2);
        Label label_3 = new Label(this.refFlowComposite, 0);
        label_3.setText(Messages.getString("TrxFlowPanel.MainFlowID__12"));
        this.mainFlowIDText = new Text(this.refFlowComposite, 2048);
        this.mainFlowIDText.setLayoutData((Object)new GridData(768));
        Button button = new Button(this.refFlowComposite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxOpFlowPanel.this.referToCommonFlow();
            }
        });
        button.setText(Messages.getString("TrxFlowPanel.select_13"));
        Button button_5 = new Button(this.refFlowComposite, 0x800084);
        button_5.setLayoutData((Object)new GridData(128));
        button_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxOpFlowPanel.this.maximizedEditExtendFlow();
            }
        });
        button_5.setToolTipText("maximize");
        SashForm sashForm_1 = new SashForm(this.refFlowComposite, 0);
        GridData gridData_5 = new GridData(1808);
        gridData_5.horizontalSpan = 4;
        sashForm_1.setLayoutData((Object)gridData_5);
        Composite designComposit = new Composite((Composite)sashForm_1, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 4;
        designComposit.setLayout((Layout)gridLayout);
        this.extendedVisualFlowFramePanel = new VisualFlowFramePanel(designComposit, 0);
        this.extendedVisualFlowFramePanel.setMainFlow(false);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        this.extendedVisualFlowFramePanel.setLayoutData(gridData);
        Composite propertyComposite = new Composite((Composite)sashForm_1, 0);
        GridLayout gridLayout_n1 = new GridLayout();
        gridLayout_n1.numColumns = 1;
        propertyComposite.setLayout((Layout)gridLayout_n1);
        Label propertyLabel = new Label(propertyComposite, 0);
        propertyLabel.setText("Flow properties");
        ScrolledComposite scrolledComposite = new ScrolledComposite(propertyComposite, 2560);
        GridData gridData_n1 = new GridData(1808);
        scrolledComposite.setLayoutData((Object)gridData_n1);
        this.editorBeanPropertyPanel = new EditorBeanPropertyPanel((Composite)scrolledComposite, 0);
        this.editorBeanPropertyPanel.setSize(500, 147);
        scrolledComposite.setContent((Control)this.editorBeanPropertyPanel);
        sashForm_1.setWeights(new int[]{5, 1});
        this.refFlowComposite.setVisible(true);
        this.stackLayout.topControl = this.specialFlowComposite;
    }

    public void setEditorProfile(EditorProfile profile) {
        ElementCatalog catalog = (ElementCatalog)profile.getCagalogs().elementAt(0);
        this.visualFlowFramePanel.setEditorProfile(profile);
        EditorProfile newProfile = (EditorProfile)profile.clone();
        Element flow = newProfile.getElement("flow");
        Element extendFlow = newProfile.getElement("extendFlow");
        this.extendedVisualFlowFramePanel.setEditorProfile(newProfile);
        this.flowProfile = profile;
        this.extendFlowProfile = newProfile;
    }

    public EditorProfile getEditorProfile() {
        return this.flowProfile;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setCommonFlowNode(XMLNode flowNode) {
        this.commonFlowNode = flowNode;
    }

    public void setMainFlow(XMLNode flowNode) {
        if (flowNode == null) {
            return;
        }
        if (this.trxNode != null) {
            XMLNode node = this.trxNode.getChild("refFlow");
            OpFlowWrapper flowWrapper = new OpFlowWrapper(flowNode, null);
            this.refFlowWrapper = new RefFlowWrapper(flowWrapper, node);
            this.editorBeanPropertyPanel.showWrapperProperties(this.refFlowWrapper);
        }
        try {
            this.extendedVisualFlowFramePanel.setXMLContent(flowNode);
            this.extendFlowNode = flowNode;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMainFlow(OpFlowWrapper flow) {
        if (this.trxNode != null) {
            XMLNode node = this.trxNode.getChild("refFlow");
            if (node == null) {
                node = new XMLNode();
                node.setNodeName("refFlow");
                node.setAttrValue("refId", flow.getAttrValue("id"));
                this.trxNode.add(node);
            } else {
                node.setAttrValue("refId", flow.getAttrValue("id"));
            }
            this.refFlowWrapper = new RefFlowWrapper(flow, node);
        } else {
            this.refFlowWrapper = new RefFlowWrapper(flow);
        }
        this.editorBeanPropertyPanel.showWrapperProperties(this.refFlowWrapper);
        String flowId = flow.getAttrValue("id");
        this.mainFlowIDText.setText(flowId);
        try {
            XMLNode extendFlowNode = this.trxNode.findChildNode("flow", "extendFlow");
            if (extendFlowNode != null) {
                this.trxNode.remove(extendFlowNode);
            }
            extendFlowNode = new XMLNode("flow");
            extendFlowNode.setAttrValue("id", "extendFlow");
            this.trxNode.add(extendFlowNode);
            XMLNode extendedFlowNode = this.getExtendedFlow(flow.xmlNode, extendFlowNode);
            this.extendedVisualFlowFramePanel.setXMLContent(extendedFlowNode);
            this.extendFlowNode = extendedFlowNode;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setActivateComposite(boolean showRefComposite) {
        if (showRefComposite) {
            this.refFlowComposite.setVisible(true);
            this.specialFlowComposite.setVisible(false);
            this.stackLayout.topControl = this.refFlowComposite;
        } else {
            this.refFlowComposite.setVisible(false);
            this.specialFlowComposite.setVisible(true);
            this.stackLayout.topControl = this.specialFlowComposite;
        }
        this.trxNode.setAttrValue("refToMainFlow", String.valueOf(showRefComposite));
    }

    private void referToCommonFlow() {
        OpFlowSelectDialog dlg = new OpFlowSelectDialog(this.getShell());
        dlg.setProfile(this.flowProfile);
        dlg.setFlowNode(this.commonFlowNode);
        OpFlowWrapper flow = (OpFlowWrapper)dlg.open();
        if (flow != null) {
            this.setMainFlow(flow);
        }
    }

    private void selectReferenceFlow() {
        OpFlowSelectDialog dlg = new OpFlowSelectDialog(this.getShell());
        dlg.setProfile(this.flowProfile);
        dlg.setFlowNode(this.commonFlowNode);
        OpFlowWrapper flow = (OpFlowWrapper)dlg.open();
        if (flow != null) {
            XMLNode node = (XMLNode)flow.xmlNode.clone();
            node.setAttrValue("id", "privateFlow");
            XMLNode flowNode = this.trxNode.getChild("flow");
            if (flowNode == null) {
                this.trxNode.add(flowNode);
            } else {
                this.trxNode.remove(flowNode);
                this.trxNode.add(node);
            }
            try {
                this.visualFlowFramePanel.setXMLContent(node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonSvcNode = node;
        this.visualFlowFramePanel.setCommonServiceNode(node);
        this.extendedVisualFlowFramePanel.setCommonServiceNode(node);
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefNode = node;
        this.visualFlowFramePanel.setSelfDefineNode(node);
        this.extendedVisualFlowFramePanel.setSelfDefineNode(node);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.visualFlowFramePanel.setDataDictionary(node);
        this.extendedVisualFlowFramePanel.setDataDictionary(node);
    }

    public void setExternResource(XMLNode value) {
        this.visualFlowFramePanel.setExternResource(value);
        this.extendedVisualFlowFramePanel.setExternResource(value);
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.visualFlowFramePanel.setFunctionProfile(profile);
        this.extendedVisualFlowFramePanel.setFunctionProfile(profile);
    }

    public void setFunctionNode(XMLNode node) {
        this.visualFlowFramePanel.setFunctionNode(node);
        this.extendedVisualFlowFramePanel.setFunctionNode(node);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
        this.visualFlowFramePanel.setDataEditorProfile(profile);
        this.extendedVisualFlowFramePanel.setDataEditorProfile(profile);
    }

    private void setFlowImplementClass() {
        XMLNode flowNode = this.trxNode.getChild("flow");
        if (flowNode != null) {
            flowNode.setAttrValue("implClass", this.flowClassNameText.getText());
        }
    }

    private void maximizedEditPrivateFlow() {
        Shell parent = this.getShell();
        Shell shell = new Shell(parent, 67696);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Visual Editor");
        VisualFlowFramePanel visualFlowFramePanel = new VisualFlowFramePanel((Composite)shell, 0);
        visualFlowFramePanel.setEditorProfile(this.flowProfile);
        visualFlowFramePanel.setDataEditorProfile(this.dataEditorProfile);
        visualFlowFramePanel.setDataDictionary(this.dataDictionary);
        visualFlowFramePanel.setSelfDefineNode(this.selfDefNode);
        visualFlowFramePanel.setCommonServiceNode(this.commonSvcNode);
        XMLNode flowNode = this.trxNode.findChildNode("flow", "privateFlow");
        if (flowNode == null && (flowNode = this.trxNode.getChild("flow")) != null && !"privateFlow".equals(flowNode.getAttrValue("id"))) {
            flowNode = null;
        }
        if (flowNode == null) {
            flowNode = new XMLNode();
            flowNode.setNodeName("flow");
            flowNode.setAttrValue("id", "privateFlow");
            this.trxNode.add(flowNode);
        }
        try {
            visualFlowFramePanel.setXMLContent(flowNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle rect = shell.getDisplay().getBounds();
        shell.setBounds(rect);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.visualFlowFramePanel.setSelfDefineNode(this.selfDefNode);
        try {
            this.visualFlowFramePanel.setXMLContent(flowNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void maximizedEditExtendFlow() {
        if (this.extendFlowNode == null) {
            return;
        }
        Shell parent = this.getShell();
        Shell shell = new Shell(parent, 67696);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Visual Editor");
        VisualFlowFramePanel visualFlowFramePanel = new VisualFlowFramePanel((Composite)shell, 0);
        visualFlowFramePanel.setMainFlow(false);
        visualFlowFramePanel.setEditorProfile(this.extendFlowProfile);
        visualFlowFramePanel.setDataEditorProfile(this.dataEditorProfile);
        visualFlowFramePanel.setDataDictionary(this.dataDictionary);
        visualFlowFramePanel.setSelfDefineNode(this.selfDefNode);
        visualFlowFramePanel.setCommonServiceNode(this.commonSvcNode);
        try {
            visualFlowFramePanel.setXMLContent(this.extendFlowNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle rect = shell.getDisplay().getBounds();
        shell.setBounds(rect);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.visualFlowFramePanel.setSelfDefineNode(this.selfDefNode);
        this.extendedVisualFlowFramePanel.setSelfDefineNode(this.selfDefNode);
        try {
            this.extendedVisualFlowFramePanel.setXMLContent(this.extendFlowNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void selectFlowClass() {
        String result = SearchClass.selectClass(this.getShell());
        if (result != null) {
            this.flowClassNameText.setText(result);
            this.setFlowImplementClass();
        }
    }

    private XMLNode getExtendedFlow(XMLNode mainFlowNode, XMLNode extendFlowNode) {
        XMLNode extendedFlowNode = (XMLNode)mainFlowNode.clone();
        Vector childs = extendedFlowNode.getChilds();
        extendedFlowNode.setAttrValue("id", "extendFlow");
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if ("extendFlow".equals(aNode.getNodeName())) {
                XMLNode extendNode;
                String stepId = aNode.getAttrValue("id");
                if (stepId == null) {
                    stepId = aNode.getAttrValue("name");
                }
                if ((extendNode = extendFlowNode.findChildNode("extendFlow", stepId)) == null) {
                    extendNode = extendFlowNode.findChildNodeNamed("extendFlow", stepId);
                }
                if (extendNode == null) {
                    extendFlowNode.add(aNode);
                } else {
                    XMLNode tNode;
                    while ((tNode = extendNode.getChild("transition")) != null) {
                        extendNode.remove(tNode);
                    }
                    int j = 0;
                    while (j < aNode.getChilds().size()) {
                        XMLNode tNode2 = (XMLNode)aNode.getChilds().elementAt(j);
                        if ("transition".equals(tNode2.getNodeName())) {
                            extendNode.add(tNode2);
                        }
                        ++j;
                    }
                    extendedFlowNode.replaceNode(aNode, extendNode);
                }
            }
            ++i;
        }
        XMLNode oldNode = this.trxNode.findChildNode("flow", "extendFlow");
        if (oldNode != null) {
            this.trxNode.remove(oldNode);
        }
        this.trxNode.add(extendedFlowNode);
        return extendedFlowNode;
    }
}

