/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.function;

import com.ecc.ide.editor.SearchClass;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.javascript.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FunctionEditPanel
extends Composite {
    private Text funcNameText;
    private Text functionIDText;
    private Text documentText;
    private Text functionNameText;
    private Text implementClassText;
    private Text funcGroupText;
    private Tree functionGroupTree;
    private XMLNode xmlNode;
    private TreeItem currentGroupItem;
    private TreeItem currentFuncItem;
    private XMLNode currentFunction = null;
    private XMLNode currentGroup = null;
    private EditorProfile profile;
    Object result = null;
    static Image folderImage;
    static Image funcImage;
    static /* synthetic */ Class class$0;

    public FunctionEditPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite_3 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_3.setLayout((Layout)gridLayout_1);
        Label label_1 = new Label(composite_3, 0);
        label_1.setText(Messages.getString("FunctionEditPanel.FunctionGroup__1"));
        this.funcGroupText = new Text(composite_3, 2048);
        GridData gridData_3 = new GridData(768);
        gridData_3.horizontalSpan = 2;
        this.funcGroupText.setLayoutData((Object)gridData_3);
        Composite composite_4 = new Composite(composite_3, 0);
        GridData gridData_5 = new GridData(640);
        gridData_5.horizontalSpan = 3;
        composite_4.setLayoutData((Object)gridData_5);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        composite_4.setLayout((Layout)gridLayout_2);
        Button button_3 = new Button(composite_4, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionEditPanel.this.addNewFunctionGroup();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 80;
        button_3.setLayoutData((Object)gridData_6);
        button_3.setText(Messages.getString("FunctionEditPanel.New_2"));
        Button button_4 = new Button(composite_4, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionEditPanel.this.deleteFunctionGroup();
            }
        });
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 80;
        button_4.setLayoutData((Object)gridData_7);
        button_4.setText(Messages.getString("FunctionEditPanel.Delete_3"));
        Button button_5 = new Button(composite_4, 0);
        button_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionEditPanel.this.updateFunctionGroup();
            }
        });
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 80;
        button_5.setLayoutData((Object)gridData_8);
        button_5.setText(Messages.getString("FunctionEditPanel.Update_4"));
        this.functionGroupTree = new Tree(composite_3, 2048);
        this.functionGroupTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionEditPanel.this.setActiveFunctionGroup();
            }
        });
        GridData gridData_4 = new GridData(1808);
        gridData_4.horizontalSpan = 3;
        this.functionGroupTree.setLayoutData((Object)gridData_4);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 3;
        composite.setLayout((Layout)gridLayout_3);
        Label label_4 = new Label(composite, 0);
        label_4.setText(Messages.getString("FunctionEditPanel.FunctionID__1"));
        this.functionIDText = new Text(composite, 2048);
        GridData gridData_13 = new GridData(512);
        gridData_13.widthHint = 140;
        gridData_13.horizontalSpan = 2;
        this.functionIDText.setLayoutData((Object)gridData_13);
        Label label_5 = new Label(composite, 0);
        label_5.setVisible(false);
        label_5.setText(Messages.getString("FunctionEditPanel.funcName"));
        this.funcNameText = new Text(composite, 2048);
        this.funcNameText.setVisible(false);
        GridData gridData_15 = new GridData();
        gridData_15.widthHint = 109;
        gridData_15.horizontalSpan = 2;
        this.funcNameText.setLayoutData((Object)gridData_15);
        Label label_2 = new Label(composite, 0);
        label_2.setVisible(false);
        label_2.setText(Messages.getString("FunctionEditPanel.FunctionName__2"));
        this.functionNameText = new Text(composite, 2048);
        this.functionNameText.setVisible(false);
        GridData gridData_14 = new GridData(768);
        gridData_14.horizontalSpan = 2;
        this.functionNameText.setLayoutData((Object)gridData_14);
        Label label_3 = new Label(composite, 0);
        label_3.setText(Messages.getString("FunctionEditPanel.ImplementClass__3"));
        this.implementClassText = new Text(composite, 2048);
        GridData gridData_9 = new GridData(770);
        this.implementClassText.setLayoutData((Object)gridData_9);
        Button button_6 = new Button(composite, 0);
        button_6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionEditPanel.this.setImplementClass();
            }
        });
        button_6.setText(Messages.getString("FunctionEditPanel.>>_4"));
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_10 = new GridData(128);
        gridData_10.horizontalSpan = 3;
        composite_2.setLayoutData((Object)gridData_10);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout);
        Button button = new Button(composite_2, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionEditPanel.this.createNewFunction();
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.getString("FunctionEditPanel.New_9"));
        Button button_1 = new Button(composite_2, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionEditPanel.this.deleteSelectedFunction();
            }
        });
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 80;
        button_1.setLayoutData((Object)gridData_1);
        button_1.setText(Messages.getString("FunctionEditPanel.Delete_10"));
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FunctionEditPanel.this.updateSelectedFunction();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 80;
        button_2.setLayoutData((Object)gridData_2);
        button_2.setText(Messages.getString("FunctionEditPanel.Update_4"));
        Label label = new Label(composite, 0);
        GridData gridData_11 = new GridData();
        gridData_11.horizontalSpan = 3;
        label.setLayoutData((Object)gridData_11);
        label.setText(Messages.getString("FunctionEditPanel.Document_5"));
        this.documentText = new Text(composite, 2818);
        GridData gridData_12 = new GridData(1296);
        gridData_12.horizontalSpan = 3;
        this.documentText.setLayoutData((Object)gridData_12);
        sashForm.setWeights(new int[]{170, 327});
        this.setSize(780, 450);
    }

    private void addNewFunctionGroup() {
        if (this.xmlNode == null) {
            return;
        }
        if (this.currentGroup == null) {
            return;
        }
        String groupName = this.funcGroupText.getText();
        if (groupName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_16"), (String)Messages.getString("FunctionEditPanel.Please_input_the_function_group_name_!_17"));
            return;
        }
        XMLNode node = new XMLNode();
        node.setNodeName("FuncGroup");
        node.setAttrValue("id", groupName);
        this.currentGroup.add(node);
        TreeItem item = new TreeItem(this.currentGroupItem, 0);
        item.setText(groupName);
        item.setData((Object)node);
        item.setImage(this.getGroupImage());
    }

    private void deleteFunctionGroup() {
        if (this.xmlNode == null) {
            return;
        }
        if (this.currentFunction != null) {
            return;
        }
        TreeItem[] items = this.functionGroupTree.getSelection();
        if (items.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Are_you_sure_20"), (String)Messages.getString("FunctionEditPanel.Be_sure_to_delete_the_selected_function_group,_it_will_delete_all_elements_under_such_group_!_21"))) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        XMLNode pNode = this.xmlNode;
        TreeItem pItem = items[0].getParentItem();
        if (pItem != null) {
            pNode = (XMLNode)pItem.getData();
        }
        pNode.remove(node);
        items[0].dispose();
        this.functionNameText.setText("");
        this.implementClassText.setText("");
        this.documentText.setText("");
    }

    private void updateFunctionGroup() {
        TreeItem[] items = this.functionGroupTree.getSelection();
        if (items.length != 1) {
            return;
        }
        if (this.currentFunction != null) {
            return;
        }
        String groupName = this.funcGroupText.getText();
        if (groupName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_22"), (String)Messages.getString("FunctionEditPanel.Please_input_the_function_group_name_!_23"));
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        node.setAttrValue("id", groupName);
        items[0].setText(groupName);
    }

    private void setActiveFunctionGroup() {
        if (this.xmlNode == null) {
            return;
        }
        TreeItem[] items = this.functionGroupTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (node.getNodeName().equals("FuncGroup")) {
            this.currentGroupItem = items[0];
            this.currentFuncItem = null;
            this.funcGroupText.setText(node.getAttrValue("id"));
            this.currentFunction = null;
            this.currentGroup = node;
            this.functionIDText.setText("");
            this.functionNameText.setText("");
            this.implementClassText.setText("");
            this.documentText.setText("");
        } else {
            this.currentFunction = node;
            this.currentGroup = node.getParent();
            this.currentFuncItem = items[0];
            this.currentGroupItem = this.currentFuncItem.getParentItem();
            this.funcGroupText.setText("");
            String funcName = node.getAttrValue("name");
            if (funcName == null) {
                funcName = "";
            }
            this.funcNameText.setText(funcName);
            this.functionIDText.setText(node.getAttrValue("id"));
            String funcDefName = node.getAttrValue("defineName");
            if (funcDefName == null) {
                funcDefName = "";
            }
            this.functionNameText.setText(funcDefName);
            String implClassName = node.getAttrValue("className");
            if (implClassName == null) {
                implClassName = "";
            }
            this.implementClassText.setText(implClassName);
            String docStr = node.getDocument();
            if (docStr == null) {
                docStr = "";
            }
            this.documentText.setText(docStr);
        }
    }

    private void createNewFunction() {
        if (this.currentGroup == null) {
            return;
        }
        String funcName = this.funcNameText.getText();
        String funcDefName = this.functionNameText.getText();
        String funcId = this.functionIDText.getText();
        String implClassName = this.implementClassText.getText();
        String document = this.documentText.getText();
        if (!this.checkInput()) {
            return;
        }
        funcDefName = funcId;
        funcName = funcId;
        if (this.xmlNode.findChildNode(funcId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_6"), (String)Messages.getString("FunctionEditPanel.Duplicated_function_ID_!_7"));
            return;
        }
        if (this.xmlNode.findChildNodeNamed("func", funcName) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_6"), (String)Messages.getString("FunctionEditPanel.Duplicated_function_ID_!_7"));
            return;
        }
        XMLNode node = new XMLNode();
        node.setAttrValue("name", funcName);
        node.setNodeName("Func");
        node.setAttrValue("id", funcId);
        node.setAttrValue("defineName", funcDefName);
        if (implClassName.length() > 0) {
            node.setAttrValue("className", implClassName);
        }
        if (document.length() > 0) {
            node.setDocument(document);
        }
        this.currentGroup.add(node);
        TreeItem item = new TreeItem(this.currentGroupItem, 0);
        item.setText(funcId);
        item.setData((Object)node);
        item.setImage(this.getFuncImage());
        this.currentFunction = node;
        TreeItem[] items = new TreeItem[]{item};
        this.functionGroupTree.setSelection(items);
        this.funcGroupText.setText("");
    }

    private void updateSelectedFunction() {
        if (this.currentFunction == null) {
            return;
        }
        String funcName = this.funcNameText.getText();
        String funcDefName = this.functionNameText.getText();
        String funcId = this.functionIDText.getText();
        String implClassName = this.implementClassText.getText();
        String document = this.documentText.getText();
        if (!this.checkInput()) {
            return;
        }
        funcDefName = funcId;
        funcName = funcId;
        XMLNode aNode = this.xmlNode.findChildNode(funcId);
        if (aNode != null && aNode != this.currentFunction) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_10"), (String)Messages.getString("FunctionEditPanel.Duplicated_function_ID_!_11"));
            return;
        }
        aNode = this.xmlNode.findChildNodeNamed("func", funcName);
        if (aNode != null && aNode != this.currentFunction) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_10"), (String)Messages.getString("FunctionEditPanel.Duplicated_function_ID_!_11"));
            return;
        }
        XMLNode node = this.currentFunction;
        node.setAttrValue("id", funcId);
        node.setAttrValue("name", funcName);
        node.setAttrValue("defineName", funcDefName);
        node.setAttrValue("className", implClassName);
        node.setDocument(document);
        TreeItem[] items = this.functionGroupTree.getSelection();
        items[0].setText(funcId);
    }

    private void deleteSelectedFunction() {
        if (this.currentFunction == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Are_you_sure..._15"), (String)Messages.getString("FunctionEditPanel.Be_sure_to_delete_current_function_define__16"))) {
            return;
        }
        this.currentGroup.remove(this.currentFunction);
        this.currentFuncItem.dispose();
    }

    public void setXMLContent(XMLNode node) {
        this.xmlNode = node;
        if (node == null) {
            return;
        }
        TreeItem item = new TreeItem(this.functionGroupTree, 0);
        item.setText(node.getAttrValue("id"));
        item.setData((Object)node);
        item.setImage(this.getGroupImage());
        this.loadFunctionTreeInfo(item, node);
    }

    private Image getGroupImage() {
        if (this.profile == null) {
            if (folderImage == null) {
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.ecc.ide.editor.function.FunctionEditPanel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ImageData source = new ImageData(clazz.getResourceAsStream("/images/openFolder.gif"));
                    ImageData mask = source.getTransparencyMask();
                    folderImage = new Image(null, source, mask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return folderImage;
        }
        if (this.profile.getElement("FuncGroup") != null) {
            return this.profile.getElement("FuncGroup").getImage();
        }
        return null;
    }

    private Image getFuncImage() {
        if (this.profile == null) {
            if (funcImage == null) {
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.ecc.ide.editor.function.FunctionEditPanel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ImageData source = new ImageData(clazz.getResourceAsStream("/images/function.gif"));
                    ImageData mask = source.getTransparencyMask();
                    funcImage = new Image(null, source, mask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return funcImage;
        }
        if (this.profile.getElement("Func") != null) {
            return this.profile.getElement("Func").getImage();
        }
        return null;
    }

    private void loadFunctionTreeInfo(TreeItem pItem, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            TreeItem item;
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if ("FuncGroup".equals(aNode.getNodeName())) {
                item = new TreeItem(pItem, 0);
                item.setText(aNode.getAttrValue("id"));
                item.setData((Object)aNode);
                item.setImage(this.getGroupImage());
                this.loadFunctionTreeInfo(item, aNode);
            } else if ("Func".equals(aNode.getNodeName())) {
                item = new TreeItem(pItem, 0);
                item.setText(aNode.getAttrValue("id"));
                item.setData((Object)aNode);
                item.setImage(this.getFuncImage());
            }
            ++i;
        }
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
    }

    public String getSelectedFunctionString() {
        if (this.currentFunction != null) {
            return this.currentFunction.getAttrValue("defineName");
        }
        return "";
    }

    private boolean checkInput() {
        String functionName = this.functionNameText.getText();
        String funcId = this.functionIDText.getText();
        if (functionName.length() == 0) {
            functionName = funcId;
        }
        if (functionName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_21"), (String)Messages.getString("FunctionEditPanel.Please_input_proper_function_Define_name_!_22"));
            return false;
        }
        return true;
    }

    public Object getSelectedFunctionNode() {
        return this.currentFunction;
    }

    private void setImplementClass() {
        String result = SearchClass.selectClass(this.getShell());
        if (result != null) {
            this.implementClassText.setText(result);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

