/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.javascript;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.externResource.ExternResourceEditPanel;
import com.ecc.ide.editor.externResource.Messages;
import com.ecc.ide.editor.javascript.JavaScriptFunctionSelectDialog;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import java.util.Vector;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class JavaScriptEditPanel
extends Composite {
    private Tree jspTree;
    private Text privateJSText;
    private Text functionText;
    private Combo eventCombo;
    private Text scriptText;
    private Button asPrivateButton;
    private XMLNode externResourceNode;
    private XMLNode functionNode;
    private EditorProfile htmlProfile = null;
    private XMLNode scriptNode;
    private XMLNode jspNode;
    private XMLNode jspScriptNode;
    private XMLNode refJSFunctionNode = null;
    private boolean asPrivate = false;
    private String[] event = new String[]{"onmousedown", "onmouseup", "onclick", "ondblclick", "onmouseover", "onmouseout", "onmousemove", "oncontextmenu", "onkeydown", "onkeyup", "onkeypress", "onfocus", "onblur", "onload", "onunload", "onabort", "onerror", "onsubmit", "onreset", "onchange", "onselect"};
    private String[] eventStrs = new String[]{"mouse button is pressed down.", "mouse button is released.", "event raised when mouse is clicked.", "mouse is double-clicked.", "mouse cursor moves over the target.", "mouse cursor leaves target.", "mouse cursor moves.", "context menu is created.", "a key has been pressed.", "a key has been released.", "a key has been pressed.", "focus has been set on the target.", "focus has moved away from the target.", "the element/window has loaded.", "the element/window has been unloaded.", "the action has been aborted.", "there has been an error.", "a form has been submitted.", "a form has been reset.", "a value in a form has been changed.", "an element has been selected."};

    public void setHTMLProfile(EditorProfile profile) {
        this.htmlProfile = profile;
    }

    public void setJSPNode(XMLNode node) {
        this.jspNode = node;
        if (this.jspNode == null) {
            return;
        }
        this.jspScriptNode = this.jspNode.getChild("javaScript");
        if (this.jspScriptNode == null) {
            this.jspScriptNode = new XMLNode();
            this.jspScriptNode.setNodeName("javaScript");
            this.jspNode.add(this.jspScriptNode);
        }
        try {
            TreeItem item = new TreeItem(this.jspTree, 0);
            item.setText(String.valueOf(this.jspNode.getNodeName()) + "[" + this.jspNode.getAttrValue("name") + "]");
            item.setImage(this.getElementImage(this.jspNode.getNodeName()));
            this.addElementTree(item, this.jspNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addElementTree(TreeItem parent, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!("#text".equals(aNode.getNodeName()) || this.htmlProfile != null && this.htmlProfile.getElement(aNode.getNodeName()) == null)) {
                TreeItem item = new TreeItem(parent, 0);
                item.setText(String.valueOf(aNode.getNodeName()) + "[" + aNode.getAttrValue("name") + "]");
                item.setImage(this.getElementImage(aNode.getNodeName()));
                this.addElementTree(item, aNode);
            }
            ++i;
        }
    }

    private Image getElementImage(String elementName) {
        if (this.htmlProfile == null) {
            return null;
        }
        Element element = this.htmlProfile.getElement(elementName);
        if (element == null) {
            return null;
        }
        return element.getImage();
    }

    public void setFunctionNode(XMLNode node) {
        this.functionNode = node;
    }

    public void setScriptNode(XMLNode node) {
        XMLNode funcDefNode;
        this.scriptNode = node;
        if (this.scriptNode == null) {
            return;
        }
        XMLNode scriptDefNode = this.scriptNode.getChild("scriptDef");
        if (scriptDefNode != null && scriptDefNode.getAttrValue("nodeValue") != null) {
            this.scriptText.setText(scriptDefNode.getAttrValue("nodeValue"));
        }
        if ((funcDefNode = this.scriptNode.getChild("funcDef")) != null && funcDefNode.getAttrValue("nodeValue") != null) {
            this.privateJSText.setText(funcDefNode.getAttrValue("nodeValue"));
        }
    }

    public JavaScriptEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        GridData gridData_5 = new GridData();
        gridData_5.horizontalSpan = 4;
        label.setLayoutData((Object)gridData_5);
        label.setText(Messages.getString("JavaScriptEditPanel.Defined_javaScript__51"));
        this.scriptText = new Text((Composite)this, 2818);
        this.scriptText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JavaScriptEditPanel.this.scriptNode != null) {
                    XMLNode scriptDefNode = JavaScriptEditPanel.this.scriptNode.getChild("scriptDef");
                    if (scriptDefNode == null) {
                        scriptDefNode = new XMLNode();
                        scriptDefNode.setNodeName("scriptDef");
                        JavaScriptEditPanel.this.scriptNode.add(scriptDefNode);
                    }
                    scriptDefNode.setAttrValue("nodeValue", JavaScriptEditPanel.this.scriptText.getText());
                }
            }
        });
        GridData gridData = new GridData(768);
        gridData.heightHint = 50;
        gridData.horizontalSpan = 4;
        this.scriptText.setLayoutData((Object)gridData);
        Composite composite_2 = new Composite((Composite)this, 0);
        GridData gridData_1 = new GridData(768);
        gridData_1.horizontalSpan = 4;
        composite_2.setLayoutData((Object)gridData_1);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 6;
        composite_2.setLayout((Layout)gridLayout_1);
        Label label_2 = new Label(composite_2, 0);
        label_2.setText(Messages.getString("JavaScriptEditPanel.event__55"));
        this.eventCombo = new Combo(composite_2, 0);
        GridData gridData_2 = new GridData();
        this.eventCombo.setLayoutData((Object)gridData_2);
        this.eventCombo.setItems(this.eventStrs);
        Label label_3 = new Label(composite_2, 0);
        label_3.setText(Messages.getString("JavaScriptEditPanel.Function__56"));
        this.functionText = new Text(composite_2, 2048);
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 189;
        this.functionText.setLayoutData((Object)gridData_3);
        Button button = new Button(composite_2, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptEditPanel.this.selectJSFunction();
            }
        });
        button.setText(">>");
        Button button_1 = new Button(composite_2, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptEditPanel.this.addScript();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 71;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("JavaScriptEditPanel.Add_63"));
        this.asPrivateButton = new Button((Composite)this, 32);
        this.asPrivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JavaScriptEditPanel.this.asPrivateButton.getSelection()) {
                    JavaScriptEditPanel.this.asPrivate = true;
                    JavaScriptEditPanel.this.addRefFunctionToPrivate();
                } else {
                    JavaScriptEditPanel.this.asPrivate = false;
                }
            }
        });
        GridData gridData_7 = new GridData();
        gridData_7.horizontalSpan = 4;
        this.asPrivateButton.setLayoutData((Object)gridData_7);
        this.asPrivateButton.setText(Messages.getString("JavaScriptEditPanel.add_this_ref_function_to_private_58"));
        SashForm sashForm = new SashForm((Composite)this, 0);
        GridData gridData_8 = new GridData(1808);
        gridData_8.horizontalSpan = 4;
        sashForm.setLayoutData((Object)gridData_8);
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label_4 = new Label(composite, 0);
        label_4.setText(Messages.getString("JavaScriptEditPanel.Private_Function_Define__59"));
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptEditPanel.this.addExternalResource();
            }
        });
        button_2.setText(Messages.getString("JavaScriptEditPanel.add_External_resource"));
        this.privateJSText = new Text(composite, 2818);
        this.privateJSText.setLayoutData((Object)new GridData(1808));
        this.privateJSText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JavaScriptEditPanel.this.scriptNode != null) {
                    XMLNode funcDefNode = JavaScriptEditPanel.this.scriptNode.getChild("funcDef");
                    if (funcDefNode == null) {
                        funcDefNode = new XMLNode();
                        funcDefNode.setNodeName(Messages.getString("JavaScriptEditPanel.funcDef_61"));
                        JavaScriptEditPanel.this.scriptNode.add(funcDefNode);
                    }
                    funcDefNode.setAttrValue("nodeValue", JavaScriptEditPanel.this.privateJSText.getText());
                }
            }
        });
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        composite_1.setLayout((Layout)new GridLayout());
        Label label_1 = new Label(composite_1, 0);
        label_1.setText(Messages.getString("JavaScriptEditPanel.JSP_Components_reference_1"));
        this.jspTree = new Tree(composite_1, 2048);
        this.jspTree.setLayoutData((Object)new GridData(1808));
        sashForm.setWeights(new int[]{3, 1});
    }

    private void selectJSFunction() {
        JavaScriptFunctionSelectDialog dlg = new JavaScriptFunctionSelectDialog(this.getShell(), 0);
        dlg.setFunctionNode(this.functionNode);
        XMLNode refNode = (XMLNode)dlg.open();
        if (refNode != null) {
            this.refJSFunctionNode = refNode;
            this.functionText.setText(refNode.getAttrValue("defineName"));
        }
    }

    private void addScript() {
        int idx = this.eventCombo.getSelectionIndex();
        String event = " ";
        if (idx != -1) {
            event = " " + this.event[idx] + "=";
        }
        if (this.refJSFunctionNode != null) {
            String str = String.valueOf(event) + "\"javascript:" + this.functionText.getText() + "\" ";
            this.scriptText.append(str);
            if (this.jspScriptNode != null && !this.asPrivate && this.jspScriptNode.findChildNode(this.refJSFunctionNode.getAttrValue("id")) == null) {
                XMLNode refJSNode = new XMLNode();
                refJSNode.setNodeName("refJS");
                refJSNode.setAttrValue("id", this.refJSFunctionNode.getAttrValue("id"));
                this.jspScriptNode.add(refJSNode);
            }
        } else {
            this.scriptText.append(event);
        }
        this.refJSFunctionNode = null;
        this.functionText.setText("");
        this.eventCombo.setText("");
        this.asPrivateButton.setSelection(false);
    }

    private void addRefFunctionToPrivate() {
        XMLNode jsFuncDefNode;
        if (this.refJSFunctionNode != null && (jsFuncDefNode = this.refJSFunctionNode.getChild("funcDef")) != null && jsFuncDefNode.getAttrValue("nodeValue") != null) {
            this.privateJSText.append(jsFuncDefNode.getAttrValue("nodeValue"));
        }
    }

    private void addExternalResource() {
        Shell parent = this.getShell();
        final Shell shell = new Shell(parent, 67696);
        shell.setLayout((Layout)new GridLayout());
        shell.setText(Messages.getString("externalResource.External_resource_propert"));
        final ExternResourceEditPanel editPanel = new ExternResourceEditPanel((Composite)shell, 0);
        editPanel.setXMLContent(this.externResourceNode);
        editPanel.setLayoutData(new GridData(1808));
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        GridData gridData = new GridData(128);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (editPanel.getResourceId() != null) {
                    JavaScriptEditPanel.this.privateJSText.insert("<ctp:label text=\"@" + editPanel.getResourceId() + "\"/>");
                }
                shell.dispose();
            }
        });
        button.setText("OK");
        Button button_1 = new Button(composite, 0);
        GridData gridData_1 = new GridData(128);
        gridData_1.widthHint = 80;
        button_1.setLayoutData((Object)gridData_1);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.dispose();
            }
        });
        button_1.setText("Cancel");
        Rectangle rect = shell.getDisplay().getBounds();
        rect.x = (rect.width - 800) / 2;
        rect.y = (rect.height - 500) / 3;
        rect.width = 800;
        rect.height = 500;
        shell.setBounds(rect);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void setExternResource(XMLNode node) {
        this.externResourceNode = node;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

