/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.javascript;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.externResource.ExternResourceEditPanel;
import com.ecc.ide.editor.externResource.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class JavaScriptFunctionEditPanel
extends Composite {
    private Text functionIDText;
    private Text documentText;
    private Text functionNameText;
    private Text functionDefineText;
    private Text funcGroupText;
    private Tree functionGroupTree;
    private TreeItem currentGroupItem;
    private TreeItem currentFuncItem;
    private XMLNode xmlNode;
    private XMLNode currentFunction = null;
    private XMLNode currentGroup = null;
    private EditorProfile profile;
    Object result = null;
    static Image folderImage;
    static Image funcImage;
    private XMLNode externResourceNode;
    static /* synthetic */ Class class$0;

    public JavaScriptFunctionEditPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite_3 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_3.setLayout((Layout)gridLayout_1);
        Label label_1 = new Label(composite_3, 0);
        label_1.setText(Messages.getString("FunctionEditPanel.FunctionGroup__1"));
        this.funcGroupText = new Text(composite_3, 2048);
        GridData gridData_3 = new GridData(768);
        gridData_3.horizontalSpan = 2;
        this.funcGroupText.setLayoutData((Object)gridData_3);
        Composite composite_4 = new Composite(composite_3, 0);
        GridData gridData_5 = new GridData(640);
        gridData_5.horizontalSpan = 3;
        composite_4.setLayoutData((Object)gridData_5);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        composite_4.setLayout((Layout)gridLayout_2);
        Button button_3 = new Button(composite_4, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptFunctionEditPanel.this.addNewFunctionGroup();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 80;
        button_3.setLayoutData((Object)gridData_6);
        button_3.setText(Messages.getString("FunctionEditPanel.New_2"));
        Button button_4 = new Button(composite_4, 0);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptFunctionEditPanel.this.deleteFunctionGroup();
            }
        });
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 80;
        button_4.setLayoutData((Object)gridData_7);
        button_4.setText(Messages.getString("FunctionEditPanel.Delete_3"));
        Button button_5 = new Button(composite_4, 0);
        button_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptFunctionEditPanel.this.updateFunctionGroup();
            }
        });
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 80;
        button_5.setLayoutData((Object)gridData_8);
        button_5.setText(Messages.getString("FunctionEditPanel.Update_4"));
        this.functionGroupTree = new Tree(composite_3, 2048);
        this.functionGroupTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptFunctionEditPanel.this.setActiveFunctionGroup();
            }
        });
        GridData gridData_4 = new GridData(1808);
        gridData_4.horizontalSpan = 3;
        this.functionGroupTree.setLayoutData((Object)gridData_4);
        SashForm sashForm_1 = new SashForm((Composite)sashForm, 512);
        Composite composite = new Composite((Composite)sashForm_1, 0);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 2;
        composite.setLayout((Layout)gridLayout_3);
        Label label_4 = new Label(composite, 0);
        label_4.setText(Messages.getString("JavaScriptFunctionEditPanel.FunctionID__1"));
        this.functionIDText = new Text(composite, 2048);
        this.functionIDText.setLayoutData((Object)new GridData(768));
        Label label_2 = new Label(composite, 0);
        label_2.setText(Messages.getString("JavaScriptFunctionEditPanel.FunctionName__2"));
        this.functionNameText = new Text(composite, 2048);
        this.functionNameText.setLayoutData((Object)new GridData(768));
        Label label_3 = new Label(composite, 0);
        label_3.setText(Messages.getString("JavaScriptFunctionEditPanel.FunctionDefine__3"));
        this.functionDefineText = new Text(composite, 2818);
        GridData gridData_9 = new GridData(1808);
        gridData_9.horizontalSpan = 2;
        this.functionDefineText.setLayoutData((Object)gridData_9);
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_10 = new GridData(128);
        gridData_10.horizontalSpan = 2;
        composite_2.setLayoutData((Object)gridData_10);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout);
        Button button_6 = new Button(composite_2, 0);
        button_6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptFunctionEditPanel.this.addExternalResource();
            }
        });
        GridData gridData_11 = new GridData();
        gridData_11.widthHint = 80;
        button_6.setLayoutData((Object)gridData_11);
        button_6.setText(Messages.getString("JavaScriptFunctionEditPanel.add_External_Resource"));
        Button button = new Button(composite_2, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptFunctionEditPanel.this.createNewFunction();
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.getString("FunctionEditPanel.New_9"));
        Button button_1 = new Button(composite_2, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptFunctionEditPanel.this.deleteSelectedFunction();
            }
        });
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 80;
        button_1.setLayoutData((Object)gridData_1);
        button_1.setText(Messages.getString("FunctionEditPanel.Delete_10"));
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptFunctionEditPanel.this.updateSelectedFunction();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 80;
        button_2.setLayoutData((Object)gridData_2);
        button_2.setText(Messages.getString("FunctionEditPanel.Edit_11"));
        Composite composite_1 = new Composite((Composite)sashForm_1, 0);
        composite_1.setLayout((Layout)new GridLayout());
        Label label = new Label(composite_1, 0);
        label.setText(Messages.getString("FunctionEditPanel.Document_8"));
        this.documentText = new Text(composite_1, 2818);
        this.documentText.setLayoutData((Object)new GridData(1808));
        sashForm_1.setWeights(new int[]{219, 153});
        sashForm.setWeights(new int[]{170, 327});
        this.setSize(780, 450);
    }

    private void addNewFunctionGroup() {
        if (this.xmlNode == null) {
            return;
        }
        if (this.currentGroup == null) {
            return;
        }
        String groupName = this.funcGroupText.getText();
        if (groupName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_16"), (String)Messages.getString("FunctionEditPanel.Please_input_the_function_group_name_!_17"));
            return;
        }
        XMLNode node = new XMLNode();
        node.setNodeName("FuncGroup");
        node.setAttrValue("id", groupName);
        this.currentGroup.add(node);
        TreeItem item = new TreeItem(this.currentGroupItem, 0);
        item.setText(groupName);
        item.setData((Object)node);
        item.setImage(this.getGroupImage());
    }

    private void deleteFunctionGroup() {
        if (this.xmlNode == null) {
            return;
        }
        if (this.currentFunction != null) {
            return;
        }
        TreeItem[] items = this.functionGroupTree.getSelection();
        if (items.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Are_you_sure_20"), (String)Messages.getString("FunctionEditPanel.Be_sure_to_delete_the_selected_function_group,_it_will_delete_all_elements_under_such_group_!_21"))) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        XMLNode pNode = this.xmlNode;
        TreeItem pItem = items[0].getParentItem();
        if (pItem != null) {
            pNode = (XMLNode)pItem.getData();
        }
        pNode.remove(node);
        items[0].dispose();
        this.functionNameText.setText("");
        this.functionDefineText.setText("");
        this.documentText.setText("");
    }

    private void updateFunctionGroup() {
        TreeItem[] items = this.functionGroupTree.getSelection();
        if (items.length != 1) {
            return;
        }
        if (this.currentFunction != null) {
            return;
        }
        String groupName = this.funcGroupText.getText();
        if (groupName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FunctionEditPanel.Warning_22"), (String)Messages.getString("FunctionEditPanel.Please_input_the_function_group_name_!_23"));
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        node.setAttrValue("id", groupName);
        items[0].setText(groupName);
    }

    private void setActiveFunctionGroup() {
        if (this.xmlNode == null) {
            return;
        }
        TreeItem[] items = this.functionGroupTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (node.getNodeName().equals("FuncGroup")) {
            this.currentGroupItem = items[0];
            this.currentFuncItem = null;
            this.funcGroupText.setText(node.getAttrValue("id"));
            this.currentFunction = null;
            this.currentGroup = node;
            this.functionIDText.setText("");
            this.functionNameText.setText("");
            this.functionDefineText.setText("");
            this.documentText.setText("");
        } else {
            this.currentFunction = node;
            this.currentGroup = node.getParent();
            this.currentGroupItem = items[0].getParentItem();
            this.currentFuncItem = items[0];
            this.funcGroupText.setText("");
            this.functionIDText.setText(node.getAttrValue("id"));
            String funcName = node.getAttrValue("defineName");
            if (funcName == null) {
                funcName = "";
            }
            this.functionNameText.setText(funcName);
            XMLNode child = node.getChild("funcDef");
            String funcDefStr = null;
            if (child != null) {
                funcDefStr = child.getAttrValue("nodeValue");
            }
            if (funcDefStr == null) {
                funcDefStr = "";
            }
            this.functionDefineText.setText(funcDefStr);
            String docStr = node.getDocument();
            if (docStr == null) {
                docStr = "";
            }
            this.documentText.setText(docStr);
        }
    }

    private void createNewFunction() {
        if (this.currentGroup == null) {
            return;
        }
        String functionName = this.functionNameText.getText();
        String funcId = this.functionIDText.getText();
        String funcDef = this.functionDefineText.getText();
        String document = this.documentText.getText();
        if (!this.checkInput()) {
            return;
        }
        if (this.xmlNode.findChildNode(funcId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("JavaScriptFunctionEditPanel.Warning_4"), (String)Messages.getString("JavaScriptFunctionEditPanel.Duplicated_function_ID_!_5"));
            return;
        }
        XMLNode node = new XMLNode();
        node.setNodeName("Func");
        node.setAttrValue("id", funcId);
        node.setAttrValue("defineName", functionName);
        if (funcDef.length() > 0) {
            XMLNode defNode = new XMLNode();
            defNode.setNodeName("funcDef");
            defNode.setAttrValue("nodeValue", funcDef);
            node.add(defNode);
        }
        node.setDocument(document);
        this.currentGroup.add(node);
        TreeItem item = new TreeItem(this.currentGroupItem, 0);
        item.setText(funcId);
        item.setData((Object)node);
        item.setImage(this.getFuncImage());
        this.currentFunction = node;
        TreeItem[] items = new TreeItem[]{item};
        this.functionGroupTree.setSelection(items);
        this.funcGroupText.setText("");
    }

    private void updateSelectedFunction() {
        if (this.currentFunction == null) {
            return;
        }
        String functionName = this.functionNameText.getText();
        String funcId = this.functionIDText.getText();
        String funcDef = this.functionDefineText.getText();
        String document = this.documentText.getText();
        if (!this.checkInput()) {
            return;
        }
        XMLNode aNode = this.xmlNode.findChildNode(funcId);
        if (aNode != null && aNode != this.currentFunction) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("JavaScriptFunctionEditPanel.Warning_12"), (String)Messages.getString("JavaScriptFunctionEditPanel.Duplicated_function_ID_!_13"));
            return;
        }
        XMLNode node = this.currentFunction;
        node.setAttrValue("id", funcId);
        node.setAttrValue("defineName", functionName);
        if (funcDef.length() > 0) {
            XMLNode defNode = node.getChild("funcDef");
            if (defNode == null) {
                defNode = new XMLNode();
                defNode.setNodeName("funcDef");
                node.add(defNode);
            }
            defNode.setAttrValue("nodeValue", funcDef);
        }
        if (document.length() > 0) {
            node.setDocument(document);
        }
        TreeItem[] items = this.functionGroupTree.getSelection();
        items[0].setText(funcId);
    }

    private void deleteSelectedFunction() {
        if (this.currentFunction == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("JavaScriptFunctionEditPanel.Are_you_sure..._22"), (String)Messages.getString("JavaScriptFunctionEditPanel.Be_sure_to_delete_current_function_define__23"))) {
            return;
        }
        this.currentGroup.remove(this.currentFunction);
        this.currentFuncItem.dispose();
    }

    public void setXMLContent(XMLNode node) {
        this.xmlNode = node;
        if (node == null) {
            return;
        }
        TreeItem item = new TreeItem(this.functionGroupTree, 0);
        item.setText(node.getAttrValue("id"));
        item.setData((Object)node);
        item.setImage(this.getGroupImage());
        this.loadFunctionTreeInfo(item, node);
    }

    private Image getGroupImage() {
        if (this.profile == null) {
            if (folderImage == null) {
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.ecc.ide.editor.javascript.JavaScriptFunctionEditPanel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ImageData source = new ImageData(clazz.getResourceAsStream("/images/openFolder.gif"));
                    ImageData mask = source.getTransparencyMask();
                    folderImage = new Image(null, source, mask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return folderImage;
        }
        if (this.profile.getElement("FuncGroup") != null) {
            return this.profile.getElement("FuncGroup").getImage();
        }
        return null;
    }

    private Image getFuncImage() {
        if (this.profile == null) {
            if (funcImage == null) {
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.ecc.ide.editor.javascript.JavaScriptFunctionEditPanel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ImageData source = new ImageData(clazz.getResourceAsStream("/images/function.gif"));
                    ImageData mask = source.getTransparencyMask();
                    funcImage = new Image(null, source, mask);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return funcImage;
        }
        if (this.profile.getElement("Func") != null) {
            return this.profile.getElement("Func").getImage();
        }
        return null;
    }

    private void loadFunctionTreeInfo(TreeItem pItem, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            TreeItem item;
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if ("FuncGroup".equals(aNode.getNodeName())) {
                item = new TreeItem(pItem, 0);
                item.setText(aNode.getAttrValue("id"));
                item.setData((Object)aNode);
                item.setImage(this.getGroupImage());
                this.loadFunctionTreeInfo(item, aNode);
            } else if ("Func".equals(aNode.getNodeName())) {
                item = new TreeItem(pItem, 0);
                item.setText(aNode.getAttrValue("id"));
                item.setData((Object)aNode);
                item.setImage(this.getFuncImage());
            }
            ++i;
        }
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
    }

    public String getSelectedFunctionString() {
        if (this.currentFunction != null) {
            return this.currentFunction.getAttrValue("defineName");
        }
        return "";
    }

    private boolean checkInput() {
        String functionName = this.functionNameText.getText();
        String funcId = this.functionIDText.getText();
        if (funcId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("JavaScriptFunctionEditPanel.Warning_26"), (String)Messages.getString("JavaScriptFunctionEditPanel.Please_input_proper_function_ID_!_27"));
            return false;
        }
        if (functionName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("JavaScriptFunctionEditPanel.Warning_28"), (String)Messages.getString("JavaScriptFunctionEditPanel.Please_input_proper_function_Define_name_!_29"));
            return false;
        }
        return true;
    }

    private void addExternalResource() {
        Shell parent = this.getShell();
        final Shell shell = new Shell(parent, 67696);
        shell.setLayout((Layout)new GridLayout());
        shell.setText(Messages.getString("externalResource.External_resource_propert"));
        final ExternResourceEditPanel editPanel = new ExternResourceEditPanel((Composite)shell, 0);
        editPanel.setXMLContent(this.externResourceNode);
        editPanel.setLayoutData(new GridData(1808));
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        GridData gridData = new GridData(128);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (editPanel.getResourceId() != null) {
                    JavaScriptFunctionEditPanel.this.functionDefineText.insert("<ctp:label text=\"@" + editPanel.getResourceId() + "\"/>");
                }
                shell.dispose();
            }
        });
        button.setText("OK");
        Button button_1 = new Button(composite, 0);
        GridData gridData_1 = new GridData(128);
        gridData_1.widthHint = 80;
        button_1.setLayoutData((Object)gridData_1);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.dispose();
            }
        });
        button_1.setText("Cancel");
        Rectangle rect = shell.getDisplay().getBounds();
        rect.x = (rect.width - 800) / 2;
        rect.y = (rect.height - 500) / 3;
        rect.width = 800;
        rect.height = 500;
        shell.setBounds(rect);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void setExternResource(XMLNode node) {
        this.externResourceNode = node;
    }

    public Object getSelectedFunctionNode() {
        return this.currentFunction;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

