/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.pattern;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CurrencyPatternEditPanel
extends Composite {
    private Text delimLenText;
    private Text delimCharText;
    private Text scaleText;
    private Text precisionText;
    private Button allowNagetiveButton;
    private Button linkToCurrButton;
    private Button reserveDotButton;
    private int precision = 15;
    private int scale = 2;
    private boolean needDot = false;
    private boolean linkToCurr = false;
    private boolean allowNagetive = false;
    char delimChar = (char)44;
    int delimLen = 3;

    public CurrencyPatternEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.setSize(250, 300);
        Label label_2 = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label_2.setLayoutData((Object)gridData);
        label_2.setText(Messages.getString("CurrencyPatternEditPanel.General_info__1"));
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("CurrencyPatternEditPanel.characters_befor_dot__2"));
        this.precisionText = new Text((Composite)this, 2048);
        this.precisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (CurrencyPatternEditPanel.this.precisionText.getText().length() == 0) {
                        return;
                    }
                    CurrencyPatternEditPanel.this.precision = Integer.parseInt(CurrencyPatternEditPanel.this.precisionText.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 100;
        this.precisionText.setLayoutData((Object)gridData_3);
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("CurrencyPatternEditPanel.Characters_after_dot__3"));
        this.scaleText = new Text((Composite)this, 2048);
        this.scaleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    CurrencyPatternEditPanel.this.scale = Integer.parseInt(CurrencyPatternEditPanel.this.scaleText.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 100;
        this.scaleText.setLayoutData((Object)gridData_4);
        Label label_4 = new Label((Composite)this, 0);
        label_4.setText(Messages.getString("CurrencyPatternEditPanel.DelimeterChar__4"));
        this.delimCharText = new Text((Composite)this, 2048);
        this.delimCharText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CurrencyPatternEditPanel.this.delimCharText.getText().length() > 0) {
                    CurrencyPatternEditPanel.this.delimChar = CurrencyPatternEditPanel.this.delimCharText.getText().charAt(0);
                }
            }
        });
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 32;
        this.delimCharText.setLayoutData((Object)gridData_7);
        this.delimCharText.setText(",");
        Label label_5 = new Label((Composite)this, 0);
        label_5.setText(Messages.getString("CurrencyPatternEditPanel.DelimLen__6"));
        this.delimLenText = new Text((Composite)this, 2048);
        this.delimLenText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    CurrencyPatternEditPanel.this.delimLen = Integer.parseInt(CurrencyPatternEditPanel.this.delimLenText.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 32;
        this.delimLenText.setLayoutData((Object)gridData_8);
        this.delimLenText.setText("3");
        this.allowNagetiveButton = new Button((Composite)this, 32);
        this.allowNagetiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrencyPatternEditPanel.this.allowNagetive = CurrencyPatternEditPanel.this.allowNagetiveButton.getSelection();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.horizontalSpan = 2;
        this.allowNagetiveButton.setLayoutData((Object)gridData_5);
        this.allowNagetiveButton.setText(Messages.getString("CurrencyPatternEditPanel.Allow_nagetive_8"));
        this.linkToCurrButton = new Button((Composite)this, 32);
        this.linkToCurrButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrencyPatternEditPanel.this.linkToCurr = CurrencyPatternEditPanel.this.linkToCurrButton.getSelection();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.horizontalSpan = 2;
        this.linkToCurrButton.setLayoutData((Object)gridData_6);
        this.linkToCurrButton.setText(Messages.getString("CurrencyPatternEditPanel.Link_with_currency_define_9"));
        Label label_3 = new Label((Composite)this, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData_1);
        label_3.setText(Messages.getString("CurrencyPatternEditPanel.Out_put_value_Info__10"));
        this.reserveDotButton = new Button((Composite)this, 32);
        this.reserveDotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrencyPatternEditPanel.this.needDot = CurrencyPatternEditPanel.this.reserveDotButton.getSelection();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 2;
        this.reserveDotButton.setLayoutData((Object)gridData_2);
        this.reserveDotButton.setText(Messages.getString("CurrencyPatternEditPanel.reserve_the_dot_11"));
    }

    public void setXMLContent(XMLNode node) {
        String allNagetiveStr;
        String valueFormat = node.getAttrValue("valueFormat");
        if (valueFormat == null) {
            return;
        }
        int idx = valueFormat.indexOf(46);
        if (idx != -1) {
            this.needDot = true;
            this.reserveDotButton.setSelection(true);
            this.precision = idx;
            this.scale = valueFormat.length() - idx - 1;
        } else {
            idx = valueFormat.indexOf("1");
            if (idx != -1) {
                this.precision = idx;
                this.scale = valueFormat.length() - idx;
            }
        }
        this.scaleText.setText(String.valueOf(this.scale));
        this.precisionText.setText(String.valueOf(this.precision));
        String linkToCurrStr = node.getAttrValue("linkCurrCode");
        if ("true".equals(linkToCurrStr)) {
            this.linkToCurr = true;
            this.linkToCurrButton.setSelection(true);
        }
        if ("true".equals(allNagetiveStr = node.getAttrValue("allowNegative"))) {
            this.allowNagetive = true;
            this.allowNagetiveButton.setSelection(true);
        }
    }

    public void setValueToXMLContent(XMLNode node) {
        int len = this.precision + this.scale;
        if (this.needDot) {
            ++len;
        }
        char[] valueChars = new char[len];
        int i = 0;
        while (i < this.precision) {
            valueChars[i] = 48;
            ++i;
        }
        int scaleBeg = this.precision;
        if (this.needDot) {
            valueChars[this.precision] = 46;
            ++scaleBeg;
        }
        int i2 = 0;
        while (i2 < this.scale) {
            valueChars[scaleBeg++] = 49;
            ++i2;
        }
        if (this.delimLen == 0) {
            this.delimLen = 3;
        }
        len = this.precision / this.delimLen + this.precision + 1 + this.scale;
        if (this.precision % this.delimLen == 0) {
            --len;
        }
        char[] fmtChars = new char[len];
        int curPos = len - 1;
        int i3 = 0;
        while (i3 < this.scale) {
            fmtChars[curPos--] = 49;
            ++i3;
        }
        fmtChars[curPos--] = 46;
        int count = 0;
        int i4 = 0;
        while (i4 < this.precision) {
            if (count == this.delimLen) {
                fmtChars[curPos--] = this.delimChar;
                count = 0;
            }
            fmtChars[curPos--] = 48;
            ++count;
            ++i4;
        }
        String fmtStr = new String(fmtChars);
        node.setAttrValue("focusOutTextFormat", fmtStr);
        node.setAttrValue("focusInTextFormat", fmtStr);
        String valueStr = new String(valueChars);
        node.setAttrValue("valueFormat", valueStr);
        if (this.linkToCurr) {
            node.setAttrValue("linkCurrCode", "true");
        } else {
            node.setAttrValue("linkCurrCode", null);
        }
        if (this.allowNagetive) {
            node.setAttrValue("allowNegative", "true");
        } else {
            node.setAttrValue("allowNegative", null);
        }
        node.setAttrValue("restrict", "true");
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

