/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.pattern;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.pattern.Messages;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DatePatternEditPanel
extends Composite {
    private Combo delimCombo;
    private Combo fmtStrCombo;
    private Text sampleText;
    private Button reserveDelimButton;
    private boolean reserveDelim = false;
    String formatStr;
    String delimCharStr;

    public DatePatternEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.setLayout((Layout)gridLayout_1);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("DatePatternEditPanel.Sample__1"));
        this.sampleText = new Text((Composite)this, 2056);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.sampleText.setLayoutData((Object)gridData);
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("DatePatternEditPanel.Date_Format__2"));
        this.fmtStrCombo = new Combo((Composite)this, 0);
        this.fmtStrCombo.setItems(new String[]{"yyyy-MM-dd", "yyyy-M-d", "yy-MM-dd", "yy-M-d", Messages.getString("DatePatternEditPanel.yyyy_u5E74MM_u6708dd_u65E5_7")});
        this.fmtStrCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatePatternEditPanel.this.setDateFormat();
            }
        });
        this.fmtStrCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePatternEditPanel.this.setDateFormat();
            }
        });
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 200;
        this.fmtStrCombo.setLayoutData((Object)gridData_1);
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("DatePatternEditPanel.DelimChar__8"));
        this.delimCombo = new Combo((Composite)this, 0);
        this.delimCombo.setItems(new String[]{"/", "-", "=", ".", ":"});
        this.delimCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatePatternEditPanel.this.setDateFormat();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 50;
        this.delimCombo.setLayoutData((Object)gridData_2);
        Label label_3 = new Label((Composite)this, 0);
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 2;
        label_3.setLayoutData((Object)gridData_3);
        label_3.setText(Messages.getString("DatePatternEditPanel.Value_pattern__14"));
        this.reserveDelimButton = new Button((Composite)this, 32);
        this.reserveDelimButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePatternEditPanel.this.reserveDelim = DatePatternEditPanel.this.reserveDelimButton.getSelection();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.horizontalSpan = 2;
        this.reserveDelimButton.setLayoutData((Object)gridData_4);
        this.reserveDelimButton.setText(Messages.getString("DatePatternEditPanel.Reserve_the_delim_char_15"));
        Label label_4 = new Label((Composite)this, 64);
        GridData gridData_5 = new GridData(256);
        gridData_5.horizontalSpan = 2;
        gridData_5.heightHint = 37;
        gridData_5.widthHint = 204;
        label_4.setLayoutData((Object)gridData_5);
        label_4.setText(Messages.getString("DatePatternEditPanel.Date_format_remark__n__y__Year_M__Month_d_day_16"));
    }

    private void setDateFormat() {
        String fmtStr = this.fmtStrCombo.getText();
        if (fmtStr.length() == 0) {
            return;
        }
        String delimCharStr = this.delimCombo.getText();
        if (delimCharStr.length() > 0) {
            fmtStr = fmtStr.replace('-', delimCharStr.charAt(0));
        }
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(fmtStr);
            String dateStr = fmt.format(Calendar.getInstance().getTime());
            this.sampleText.setText(dateStr);
            this.formatStr = fmtStr;
            this.delimCharStr = delimCharStr;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXMLContent(XMLNode node) {
        String fmtStr = node.getAttrValue("focusOutTextFormat");
        if (fmtStr != null) {
            this.formatStr = fmtStr;
            this.fmtStrCombo.setText(fmtStr);
            this.setDateFormat();
        }
    }

    public void setValueToXMLContent(XMLNode node) {
        node.setAttrValue("focusOutTextFormat", this.formatStr);
        if (this.reserveDelim) {
            node.setAttrValue("valueFormat", this.formatStr);
            node.setAttrValue("focusInTextFormat", this.formatStr);
        } else {
            char[] chars = new char[this.formatStr.length()];
            int len = 0;
            int i = 0;
            while (i < this.formatStr.length()) {
                char ch = this.formatStr.charAt(i);
                if (ch == 'y' || ch == 'M' || ch == 'd') {
                    chars[len++] = ch;
                }
                ++i;
            }
            String fmtStr = new String(chars, 0, len);
            node.setAttrValue("valueFormat", fmtStr);
            node.setAttrValue("focusInTextFormat", fmtStr);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

