/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.pattern;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExternalizeStringPatternEditPanel
extends Composite {
    private Table valueListTable;
    private Text valueText;
    private Text displayText;
    private Text inputValueText;
    private Vector valueLists = new Vector(20);

    public ExternalizeStringPatternEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("ExternalizeStringPatternEditPanel.Value__1"));
        this.valueText = new Text((Composite)this, 2048);
        this.valueText.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("ExternalizeStringPatternEditPanel.InputValue__2"));
        this.inputValueText = new Text((Composite)this, 2048);
        this.inputValueText.setLayoutData((Object)new GridData(768));
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("ExternalizeStringPatternEditPanel.DisplayValue__3"));
        this.displayText = new Text((Composite)this, 2048);
        GridData gridData_5 = new GridData(768);
        gridData_5.horizontalSpan = 3;
        this.displayText.setLayoutData((Object)gridData_5);
        Composite composite = new Composite((Composite)this, 0);
        GridData gridData = new GridData(640);
        gridData.horizontalSpan = 4;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeStringPatternEditPanel.this.addNewValueItem();
            }
        });
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 80;
        button.setLayoutData((Object)gridData_1);
        button.setText(Messages.getString("ExternalizeStringPatternEditPanel.Add_4"));
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeStringPatternEditPanel.this.deleteSelectedItem();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 80;
        button_1.setLayoutData((Object)gridData_2);
        button_1.setText(Messages.getString("ExternalizeStringPatternEditPanel.Delete_5"));
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeStringPatternEditPanel.this.updateSeletedItem();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 80;
        button_2.setLayoutData((Object)gridData_3);
        button_2.setText(Messages.getString("ExternalizeStringPatternEditPanel.Update_6"));
        this.valueListTable = new Table((Composite)this, 67584);
        this.valueListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeStringPatternEditPanel.this.setActivateItem();
            }
        });
        GridData gridData_4 = new GridData(1808);
        gridData_4.horizontalSpan = 4;
        this.valueListTable.setLayoutData((Object)gridData_4);
        this.valueListTable.setLinesVisible(true);
        this.valueListTable.setHeaderVisible(true);
        TableColumn tableColumn_1 = new TableColumn(this.valueListTable, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("ExternalizeStringPatternEditPanel.Value_7"));
        TableColumn tableColumn = new TableColumn(this.valueListTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("ExternalizeStringPatternEditPanel.Input_Value_8"));
        TableColumn tableColumn_2 = new TableColumn(this.valueListTable, 0);
        tableColumn_2.setWidth(257);
        tableColumn_2.setText(Messages.getString("ExternalizeStringPatternEditPanel.Display_Value_9"));
    }

    private void addNewValueItem() {
        String value = this.valueText.getText();
        String valueStr = this.inputValueText.getText();
        String displayStr = this.displayText.getText();
        if (value.length() == 0 || valueStr.length() == 0 || displayStr.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ExternalizeStringPatternEditPanel.Warning_10"), (String)Messages.getString("ExternalizeStringPatternEditPanel.All_input_Items_are_not_allow_to_set_to_empty._11"));
            return;
        }
        ValueList aValueList = new ValueList(valueStr, displayStr, value);
        this.valueLists.addElement(aValueList);
        this.addTableItem(aValueList);
    }

    private void deleteSelectedItem() {
        TableItem[] items = this.valueListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        ValueList aValueList = (ValueList)items[0].getData();
        this.valueLists.remove(aValueList.value);
        items[0].dispose();
    }

    private void updateSeletedItem() {
        TableItem[] items = this.valueListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        String value = this.valueText.getText();
        String valueStr = this.inputValueText.getText();
        String displayStr = this.displayText.getText();
        if (value.length() == 0 || valueStr.length() == 0 || displayStr.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ExternalizeStringPatternEditPanel.Warning_12"), (String)Messages.getString("ExternalizeStringPatternEditPanel.All_input_Items_are_not_allow_to_set_to_empty._13"));
            return;
        }
        ValueList aValueList = (ValueList)items[0].getData();
        aValueList.value = value;
        aValueList.valueStr = valueStr;
        aValueList.displayStr = displayStr;
        items[0].setText(value);
        items[0].setText(1, valueStr);
        items[0].setText(2, displayStr);
    }

    private void setActivateItem() {
        TableItem[] items = this.valueListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        ValueList aValueList = (ValueList)items[0].getData();
        this.displayText.setText(aValueList.displayStr);
        this.valueText.setText(aValueList.value);
        this.inputValueText.setText(aValueList.valueStr);
    }

    public void setXMLNode(XMLNode node) {
        ValueList aValueList;
        String dStr;
        String fStr;
        String vStr;
        String valueStr = node.getAttrValue("valueFormat");
        String focusInStr = node.getAttrValue("focusInTextFormat");
        String displayStr = node.getAttrValue("focusOutTextFormat");
        if (valueStr == null || focusInStr == null || displayStr == null) {
            return;
        }
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        int offset1 = 0;
        int offset2 = 0;
        int offset3 = 0;
        while (true) {
            idx1 = valueStr.indexOf(44, offset1);
            idx2 = focusInStr.indexOf(44, offset2);
            idx3 = displayStr.indexOf(44, offset3);
            if (idx1 == -1 || idx2 == -1 || idx3 == -1) break;
            vStr = valueStr.substring(offset1, idx1);
            fStr = focusInStr.substring(offset2, idx2);
            dStr = displayStr.substring(offset3, idx3);
            aValueList = new ValueList(fStr, dStr, vStr);
            this.valueLists.addElement(aValueList);
            this.addTableItem(aValueList);
            offset1 = idx1 + 1;
            offset2 = idx2 + 1;
            offset3 = idx3 + 1;
        }
        vStr = valueStr.substring(offset1);
        fStr = focusInStr.substring(offset2);
        dStr = displayStr.substring(offset3);
        aValueList = new ValueList(fStr, dStr, vStr);
        this.valueLists.addElement(aValueList);
        this.addTableItem(aValueList);
    }

    public void setValueToXMLNodeAttr(XMLNode node) {
        String valueStr = "";
        String displayStr = "";
        String focusStr = "";
        int i = 0;
        while (i < this.valueLists.size()) {
            ValueList aValueList = (ValueList)this.valueLists.elementAt(i);
            if (valueStr.length() == 0) {
                valueStr = String.valueOf(valueStr) + aValueList.value;
                displayStr = String.valueOf(displayStr) + aValueList.displayStr;
                focusStr = String.valueOf(focusStr) + aValueList.valueStr;
            } else {
                valueStr = String.valueOf(valueStr) + "," + aValueList.value;
                displayStr = String.valueOf(displayStr) + "," + aValueList.displayStr;
                focusStr = String.valueOf(focusStr) + "," + aValueList.valueStr;
            }
            ++i;
        }
        node.setAttrValue("valueFormat", valueStr);
        node.setAttrValue("focusInTextFormat", focusStr);
        node.setAttrValue("focusOutTextFormat", displayStr);
    }

    private void addTableItem(ValueList aValueList) {
        TableItem item = new TableItem(this.valueListTable, 0);
        item.setText(aValueList.value);
        item.setText(1, aValueList.valueStr);
        item.setText(2, aValueList.displayStr);
        item.setData((Object)aValueList);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public class ValueList {
        String valueStr;
        String displayStr;
        String value;

        public ValueList(String valueStr, String displayStr, String value) {
            this.valueStr = valueStr;
            this.value = value;
            this.displayStr = displayStr;
        }
    }
}

