/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.pattern;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MaskPatternEditPanel
extends Composite {
    private Text padCharText;
    private Combo aligmentSelector;
    private Combo characterTypeSelector;
    private Text formatText;
    private String formatStr;
    private String padCharStr;
    private String aligment = "LEFT";
    private boolean reserveDelim = false;
    private boolean autoComplete = false;
    private Button reserveDelimButton;
    private Button autoCompleteButton;

    public MaskPatternEditPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("MaskPatternEditPanel.Display_Patterns__2"));
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("MaskPatternEditPanel.Pattern_String__3"));
        this.formatText = new Text((Composite)this, 2048);
        this.formatText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MaskPatternEditPanel.this.formatStr = MaskPatternEditPanel.this.formatText.getText();
            }
        });
        GridData gridData_1 = new GridData(768);
        gridData_1.horizontalSpan = 3;
        this.formatText.setLayoutData((Object)gridData_1);
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("MaskPatternEditPanel.Input_Char__4"));
        this.characterTypeSelector = new Combo((Composite)this, 0);
        this.characterTypeSelector.setItems(new String[]{Messages.getString("MaskPatternEditPanel.Digital_Characters_5"), Messages.getString("MaskPatternEditPanel.lowercase_Characters_6"), Messages.getString("MaskPatternEditPanel.upcase_Characters_7"), Messages.getString("MaskPatternEditPanel.Characters_8"), Messages.getString("MaskPatternEditPanel.ASCII_characters_9"), Messages.getString("MaskPatternEditPanel.Binary_Digital_10"), Messages.getString("MaskPatternEditPanel.Hex_Digital_11")});
        Button button = new Button((Composite)this, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskPatternEditPanel.this.insertSelectedCharacter();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        button.setLayoutData((Object)gridData_5);
        button.setText(Messages.getString("MaskPatternEditPanel.Insert_12"));
        Label label_3 = new Label((Composite)this, 0);
        Label label_4 = new Label((Composite)this, 0);
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 4;
        label_4.setLayoutData((Object)gridData_2);
        label_4.setText(Messages.getString("MaskPatternEditPanel.ValuePatterns__13"));
        this.reserveDelimButton = new Button((Composite)this, 32);
        this.reserveDelimButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskPatternEditPanel.this.reserveDelim = MaskPatternEditPanel.this.reserveDelimButton.getSelection();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 4;
        this.reserveDelimButton.setLayoutData((Object)gridData_3);
        this.reserveDelimButton.setText(Messages.getString("MaskPatternEditPanel.Reserve_the_delimeter_14"));
        this.autoCompleteButton = new Button((Composite)this, 32);
        this.autoCompleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskPatternEditPanel.this.autoComplete = MaskPatternEditPanel.this.autoCompleteButton.getSelection();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.horizontalSpan = 4;
        this.autoCompleteButton.setLayoutData((Object)gridData_4);
        this.autoCompleteButton.setText(Messages.getString("MaskPatternEditPanel.Auto_complete_the_input_15"));
        Label label_5 = new Label((Composite)this, 0);
        label_5.setText(Messages.getString("MaskPatternEditPanel.Aligment__16"));
        this.aligmentSelector = new Combo((Composite)this, 0);
        this.aligmentSelector.setItems(new String[]{Messages.getString("MaskPatternEditPanel.Left_17"), Messages.getString("MaskPatternEditPanel.Center_18"), Messages.getString("MaskPatternEditPanel.Right_19")});
        this.aligmentSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = MaskPatternEditPanel.this.aligmentSelector.getSelectionIndex();
                if (idx == 0) {
                    MaskPatternEditPanel.this.aligment = "LEFT";
                } else if (idx == 1) {
                    MaskPatternEditPanel.this.aligment = "CENTER";
                } else if (idx == 2) {
                    MaskPatternEditPanel.this.aligment = "RIGHT";
                }
            }
        });
        Label label_6 = new Label((Composite)this, 0);
        label_6.setText(Messages.getString("MaskPatternEditPanel.padChar__23"));
        this.padCharText = new Text((Composite)this, 2048);
        this.padCharText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MaskPatternEditPanel.this.padCharStr = MaskPatternEditPanel.this.padCharText.getText();
            }
        });
    }

    private void insertSelectedCharacter() {
        int idx = this.characterTypeSelector.getSelectionIndex();
        if (idx == -1) {
            return;
        }
        String insertChar = "9";
        if (idx == 0) {
            insertChar = "9";
        } else if (idx == 1) {
            insertChar = "a";
        } else if (idx == 2) {
            insertChar = "A";
        } else if (idx == 3) {
            insertChar = "Z";
        } else if (idx == 4) {
            insertChar = "$";
        } else if (idx == 5) {
            insertChar = "B";
        } else if (idx == 6) {
            insertChar = "H";
        }
        this.formatText.insert(insertChar);
    }

    public void setXMLContent(XMLNode node) {
        if (node == null) {
            return;
        }
        String fmtStr = node.getAttrValue("focusOutTextFormat");
        if (fmtStr == null) {
            return;
        }
        this.formatStr = fmtStr;
        this.formatText.setText(this.formatStr);
        String autoCompleteStr = node.getAttrValue("autoComplete");
        if ("true".equals(autoCompleteStr)) {
            this.autoCompleteButton.setSelection(true);
            this.autoComplete = true;
        }
        this.padCharStr = node.getAttrValue("padChar");
        if (this.padCharStr != null) {
            this.padCharText.setText(this.padCharStr);
        }
        this.aligment = node.getAttrValue("aligment");
        if ("LEFT".equals(this.aligment)) {
            this.aligmentSelector.setText(this.aligmentSelector.getItem(0));
        } else if ("CENTER".equals(this.aligment)) {
            this.aligmentSelector.setText(this.aligmentSelector.getItem(1));
        } else if ("RIGHT".equals(this.aligment)) {
            this.aligmentSelector.setText(this.aligmentSelector.getItem(2));
        }
    }

    public void setValueToXMLContent(XMLNode node) {
        node.setAttrValue("focusOutTextFormat", this.formatStr);
        node.setAttrValue("restrict", "true");
        if (this.reserveDelim) {
            node.setAttrValue("focusInTextFormat", this.formatStr);
            node.setAttrValue("valueFormat", this.formatStr);
        } else {
            char[] chars = new char[this.formatStr.length()];
            int len = 0;
            int i = 0;
            while (i < this.formatStr.length()) {
                char aCh = this.formatStr.charAt(i);
                if (aCh == '9' || aCh == 'a' || aCh == 'A' || aCh == 'Z' || aCh == '$' || aCh == 'B' || aCh == 'H') {
                    chars[len++] = aCh;
                }
                ++i;
            }
            String valueFmtStr = new String(chars, 0, len);
            node.setAttrValue("focusInTextFormat", valueFmtStr);
            node.setAttrValue("valueFormat", valueFmtStr);
        }
        if (this.autoComplete) {
            node.setAttrValue("autoComplete", "true");
            node.setAttrValue("aligment", this.aligment);
            node.setAttrValue("padChar", this.padCharStr);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

