/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.pattern;

import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.WrapperOwner;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.Messages;
import com.ecc.ide.editor.objectEditor.ObjectEditor;
import com.ecc.ide.editor.objectEditor.XMLObjectEditor;
import com.ecc.ide.editor.pattern.PatternItemWrapper;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementChild;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PatternMainPanel
extends Composite
implements WrapperOwner {
    private Table patternTable;
    private Text descText;
    private Text patternIdText;
    private Combo patternTypeCombo;
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private XMLNode patternsNode;
    private EditorProfile patternEditorProfile;
    private XMLNode channelSettings;
    private PatternItemWrapper curSvcWrapper;
    private TableItem curItem;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private XMLNode commonServiceNode;
    private XMLNode externResourceNode;

    public void setPatternXMLNode(XMLNode node) {
        this.patternsNode = node;
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aPattern = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(aPattern.getNodeName())) {
                Element elmt;
                TableItem item = new TableItem(this.patternTable, 0);
                item.setText(aPattern.getNodeName());
                String svcId = aPattern.getAttrValue("id");
                if (svcId != null) {
                    item.setText(1, svcId);
                }
                if ((elmt = this.patternEditorProfile.getElement(aPattern.getNodeName())) != null) {
                    item.setImage(elmt.getImage());
                }
                if (aPattern.getAttrValue("focusOutTextFormat") != null) {
                    item.setText(2, aPattern.getAttrValue("focusOutTextFormat"));
                }
                if (aPattern.getAttrValue("inputShowMessage") != null) {
                    item.setText(3, aPattern.getAttrValue("inputShowMessage"));
                }
                PatternItemWrapper wrapper = new PatternItemWrapper(aPattern, this.patternEditorProfile.getElement(aPattern.getNodeName()), item);
                item.setData((Object)wrapper);
            }
            ++i;
        }
    }

    public void setPatternEditorProfile(EditorProfile profile) {
        this.patternEditorProfile = profile;
        Element patterns = profile.getElement("Patterns");
        if (patterns == null) {
            return;
        }
        Vector childElements = patterns.getChilds();
        if (childElements == null) {
            return;
        }
        this.patternTypeCombo.removeAll();
        int i = 0;
        while (i < childElements.size()) {
            ElementChild eChild = (ElementChild)childElements.elementAt(i);
            this.patternTypeCombo.add(eChild.getChildElementId());
            ++i;
        }
    }

    public PatternMainPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("PatternMainPanel.PATTERN_ID_8"));
        this.patternIdText = new Text(composite, 2048);
        GridData gridData_7 = new GridData();
        gridData_7.horizontalSpan = 3;
        gridData_7.widthHint = 156;
        this.patternIdText.setLayoutData((Object)gridData_7);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("PatternMainPanel.PATTERN_TYPE__9"));
        this.patternTypeCombo = new Combo(composite, 0);
        this.patternTypeCombo.setLayoutData((Object)new GridData(768));
        Label label_3 = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData);
        label_3.setText(Messages.getString("PatternMainPanel.DESCRIPTION_10"));
        this.descText = new Text(composite, 2818);
        GridData gridData_1 = new GridData(768);
        gridData_1.heightHint = 48;
        gridData_1.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_1);
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 4;
        composite_1.setLayoutData((Object)gridData_2);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite_1, 0);
        button.setToolTipText(Messages.getString("PatternMainPanel.Create_new_Service__11"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternMainPanel.this.createNewPattern();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 80;
        button.setLayoutData((Object)gridData_3);
        button.setText(Messages.getString("PatternMainPanel.Create_12"));
        Button button_1 = new Button(composite_1, 0);
        button_1.setToolTipText(Messages.getString("PatternMainPanel.delete_the_selected_pattern_13"));
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternMainPanel.this.deleteSelectedPattern();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("PatternMainPanel.Delete_14"));
        Button button_2 = new Button(composite_1, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternMainPanel.this.updateCurPattern();
            }
        });
        button_2.setToolTipText(Messages.getString("PatternMainPanel.update_the_service_15"));
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        button_2.setLayoutData((Object)gridData_5);
        button_2.setText(Messages.getString("PatternMainPanel.Update_16"));
        Button button_3 = new Button(composite_1, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternMainPanel.this.editCurrentPatternItem();
            }
        });
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 80;
        button_3.setLayoutData((Object)gridData_8);
        button_3.setText(Messages.getString("PatternMainPanel.Edit_1"));
        this.patternTable = new Table(composite, 67584);
        GridData gridData_6 = new GridData(1808);
        gridData_6.horizontalSpan = 4;
        this.patternTable.setLayoutData((Object)gridData_6);
        this.patternTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternMainPanel.this.setActivatePattern();
            }
        });
        this.patternTable.setHeaderVisible(true);
        this.patternTable.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.patternTable, 0);
        tableColumn.setWidth(146);
        tableColumn.setText(Messages.getString("PatternMainPanel.Pattern_Type_17"));
        TableColumn tableColumn_1 = new TableColumn(this.patternTable, 0);
        tableColumn_1.setWidth(165);
        tableColumn_1.setText(Messages.getString("PatternMainPanel.Pattern_Id_18"));
        TableColumn tableColumn_2 = new TableColumn(this.patternTable, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("PatternMainPanel.Format_1"));
        TableColumn tableColumn_4 = new TableColumn(this.patternTable, 0);
        tableColumn_4.setWidth(202);
        tableColumn_4.setText(Messages.getString("PatternMainPanel.Description_19"));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)sashForm, 2560);
        this.editorBeanPropertyPanel = new EditorBeanPropertyPanel((Composite)scrolledComposite, 0);
        this.editorBeanPropertyPanel.setSize(145, 375);
        scrolledComposite.setContent((Control)this.editorBeanPropertyPanel);
        sashForm.setWeights(new int[]{414, 170});
    }

    public void dispose() {
        super.dispose();
        this.editorBeanPropertyPanel.dispose();
    }

    protected void checkSubclass() {
    }

    private void createNewPattern() {
        String patternType = this.patternTypeCombo.getText();
        String patternId = this.patternIdText.getText();
        if (patternId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_1"), (String)Messages.getString("PatternMainPanel.please_input_proper_patternId_!_2"));
            return;
        }
        if (patternType.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_3"), (String)Messages.getString("PatternMainPanel.please_select_a_pattern_type_to_create_!_4"));
            return;
        }
        XMLNode node = this.patternsNode.findChildNode(patternId);
        if (node != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_5"), (String)Messages.getString("PatternMainPanel.Duplicated_pattern_ID_!_6"));
            return;
        }
        Element element = this.patternEditorProfile.getElement(patternType);
        if (element == null) {
            return;
        }
        String wizardClass = element.getWizardClassType();
        if (wizardClass == null || wizardClass.length() == 0) {
            wizardClass = "com.ecc.ide.editor.wizards.ServiceXMLDefineWizard";
        }
        try {
            ECCIDEWizard wizard = (ECCIDEWizard)((Object)Class.forName(wizardClass).newInstance());
            wizard.setEditorProfile(this.patternEditorProfile);
            wizard.setDataEditorProfile(this.dataEditorProfile);
            wizard.setDataDictionary(this.dataDictionary);
            wizard.setCommonServiceNode(this.commonServiceNode);
            XMLNode aNode = new XMLNode();
            aNode.setNodeName(patternType);
            aNode.setAttrValue("id", patternId);
            aNode.setAttrValue("inputShowMessage", this.descText.getText());
            wizard.setXMLNode(aNode);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                Element elmt;
                aNode = wizard.getXMLNode();
                this.patternsNode.add(aNode);
                XMLNode aPattern = aNode;
                TableItem item = new TableItem(this.patternTable, 0);
                item.setText(aPattern.getNodeName());
                String svcId = aPattern.getAttrValue("id");
                if (svcId != null) {
                    item.setText(1, svcId);
                }
                if ((elmt = this.patternEditorProfile.getElement(aPattern.getNodeName())) != null) {
                    item.setImage(elmt.getImage());
                }
                if (aPattern.getAttrValue("focusOutTextFormat") != null) {
                    item.setText(2, aPattern.getAttrValue("focusOutTextFormat"));
                }
                if (aPattern.getAttrValue("inputShowMessage") != null) {
                    item.setText(3, aPattern.getAttrValue("inputShowMessage"));
                }
                PatternItemWrapper wrapper = new PatternItemWrapper(aPattern, this.patternEditorProfile.getElement(aPattern.getNodeName()), item);
                wrapper.setWrapperOwner(this);
                item.setData((Object)wrapper);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Error_30"), (String)(String.valueOf(Messages.getString("ServiceMainPanel.Internal_Error__n_31")) + e));
            e.printStackTrace();
        }
    }

    private void deleteSelectedPattern() {
        if (this.patternsNode == null || this.curSvcWrapper == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Are_sure..._7"), (String)Messages.getString("PatternMainPanel.Are_you_sure_to_delete_selected_pattern_define__8"))) {
            return;
        }
        this.patternsNode.remove(this.curSvcWrapper.xmlNode);
        this.curItem.dispose();
        this.curSvcWrapper = null;
        this.curItem = null;
    }

    private void setActivatePattern() {
        PatternItemWrapper svcWrapper;
        TableItem item;
        TableItem[] selects = this.patternTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        PatternItemWrapper wrapper = (PatternItemWrapper)selects[0].getData();
        this.editorBeanPropertyPanel.showWrapperProperties(wrapper);
        this.curItem = item = selects[0];
        this.curSvcWrapper = svcWrapper = (PatternItemWrapper)item.getData();
        XMLNode curSvcNode = svcWrapper.xmlNode;
        String svcId = curSvcNode.getAttrValue("id");
        String svcType = curSvcNode.getNodeName();
        String docStr = curSvcNode.getAttrValue("inputShowMessage");
        if (svcId != null) {
            this.patternIdText.setText(svcId);
        } else {
            this.patternIdText.setText("");
        }
        this.patternTypeCombo.setText(svcType);
        if (docStr != null) {
            this.descText.setText(docStr);
        } else {
            this.descText.setText("");
        }
    }

    private void updateCurPattern() {
        if (this.curSvcWrapper == null) {
            return;
        }
        XMLNode curSvcNode = this.curSvcWrapper.xmlNode;
        String svcId = this.patternIdText.getText();
        if (svcId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_9"), (String)Messages.getString("PatternMainPanel.Please_input_proper_pattern_ID_!_10"));
            return;
        }
        XMLNode aNode = this.patternsNode.findChildNode(curSvcNode.getNodeName(), svcId);
        if (aNode != null && aNode != curSvcNode) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Warning_11"), (String)Messages.getString("PatternMainPanel.Duplicated_pattern_ID_!_12"));
            return;
        }
        String docStr = this.descText.getText();
        curSvcNode.setAttrValue("id", svcId);
        curSvcNode.setAttrValue("inputShowMessage", docStr);
        this.curItem.setText(1, svcId);
        this.curItem.setText(2, docStr);
    }

    private void deleteCurrentPattern() {
        if (this.patternsNode == null || this.curSvcWrapper == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("PatternMainPanel.Are_sure..._13"), (String)Messages.getString("PatternMainPanel.Are_you_sure_to_delete_selected_pattern_define__14"))) {
            return;
        }
        this.patternsNode.remove(this.curSvcWrapper.xmlNode);
        this.curItem.dispose();
        this.curSvcWrapper = null;
        this.curItem = null;
    }

    private void editCurrentPatternItem() {
        if (this.curSvcWrapper == null) {
            return;
        }
        Element element = this.curSvcWrapper.getElement();
        ObjectEditor objEditor = null;
        if (element.getEditClass() != null) {
            try {
                objEditor = (ObjectEditor)Class.forName(element.getEditClass()).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (objEditor == null) {
            objEditor = new XMLObjectEditor();
        }
        XMLNode curNode = this.curSvcWrapper.xmlNode;
        XMLNode clonedNode = (XMLNode)curNode.clone();
        PatternItemWrapper wrapper = new PatternItemWrapper(clonedNode, this.curSvcWrapper.element, this.curSvcWrapper.item);
        wrapper.setWrapperOwner(this);
        Object result = objEditor.editObject(wrapper, this.getShell(), Messages.getString("PatternMainPanel.Pattern_Editing__2"));
        if (result != null) {
            Element elmt;
            if (!objEditor.isChanged()) {
                return;
            }
            this.patternsNode.remove(this.curSvcWrapper.xmlNode);
            this.curItem.dispose();
            this.patternsNode.add(clonedNode);
            XMLNode aPattern = clonedNode;
            TableItem item = new TableItem(this.patternTable, 0);
            item.setText(aPattern.getNodeName());
            String svcId = aPattern.getAttrValue("id");
            if (svcId != null) {
                item.setText(1, svcId);
            }
            if ((elmt = this.patternEditorProfile.getElement(aPattern.getNodeName())) != null) {
                item.setImage(elmt.getImage());
            }
            if (aPattern.getAttrValue("focusOutTextFormat") != null) {
                item.setText(2, aPattern.getAttrValue("focusOutTextFormat"));
            }
            if (aPattern.getAttrValue("inputShowMessage") != null) {
                item.setText(3, aPattern.getAttrValue("inputShowMessage"));
            }
            PatternItemWrapper aWrapper = new PatternItemWrapper(aPattern, this.patternEditorProfile.getElement(aPattern.getNodeName()), item);
            aWrapper.setWrapperOwner(this);
            item.setData((Object)aWrapper);
            TableItem[] items = new TableItem[]{item};
            this.patternTable.setSelection(items);
            this.editorBeanPropertyPanel.showWrapperProperties(aWrapper);
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
    }

    public XMLNode getDataDictionary() {
        return this.dataDictionary;
    }

    public EditorProfile getDataEditorProfile() {
        return this.dataEditorProfile;
    }

    public XMLNode getCommonServiceNode() {
        return this.commonServiceNode;
    }

    public XMLNode getSelfDefineNode() {
        return null;
    }

    public XMLNode getExternResource() {
        return this.externResourceNode;
    }

    public void setExternResource(XMLNode node) {
        this.externResourceNode = node;
    }

    public XMLNode getChannelSettings() {
        return this.channelSettings;
    }

    public void setChannelSettings(XMLNode channelSettings) {
        this.channelSettings = channelSettings;
    }

    public XMLNode getDataType() {
        return null;
    }

    public XMLNode getDataTypeDef() {
        return null;
    }
}

