/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.project;

import com.ecc.emp.ide.biz.service.AddChannelWizard;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDicSelectPanel;
import com.ecc.ide.editor.data.Messages;
import com.ecc.ide.editor.service.RefServicePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class BizSessionNodePanel
extends Composite {
    private Tree ctxNodeTree;
    private Text documentText;
    private Text channelIDText;
    private DataDicSelectPanel sessionDataPanel;
    private RefServicePanel servicePanel;
    private EditorProfile dataProfile;
    private XMLNode dataDictionary;
    private EditorProfile serviceProfile;
    private XMLNode serviceNode;
    private XMLNode xmlContent;
    private XMLNode channelSettingsNode;

    public BizSessionNodePanel(Composite parent, boolean editable, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite leftComp = new Composite((Composite)sashForm, 0);
        leftComp.setLayout((Layout)new GridLayout(3, false));
        Label label_1 = new Label(leftComp, 0);
        label_1.setText("\u8282\u70b9\u5b9a\u4e49");
        this.ctxNodeTree = new Tree(leftComp, 2048);
        this.ctxNodeTree.setLayoutData((Object)new GridData(4, 4, true, true, 3, 50));
        this.ctxNodeTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BizSessionNodePanel.this.setActivateChannel();
            }
        });
        Button button = new Button(leftComp, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BizSessionNodePanel.this.createNewChannel();
            }
        });
        button.setText("\u6dfb\u52a0\u5e94\u7528");
        Button button_1 = new Button(leftComp, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BizSessionNodePanel.this.deleteSelectedChannel();
            }
        });
        button_1.setText("\u5220\u9664\u5e94\u7528");
        SashForm sashForm_1 = new SashForm((Composite)sashForm, 512);
        Composite editComp = new Composite((Composite)sashForm_1, 2048);
        editComp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(editComp, 0);
        label.setText("\u5e94\u7528ID");
        label.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.channelIDText = new Text(editComp, 2048);
        this.channelIDText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label_2 = new Label(editComp, 0);
        label_2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        label_2.setText(Messages.getString("MCIChannelDefinePanel.Document__2"));
        this.documentText = new Text(editComp, 2818);
        this.documentText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 3));
        Button button_2 = new Button(editComp, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BizSessionNodePanel.this.updateSelectedChannel();
            }
        });
        GridData gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
        button_2.setLayoutData((Object)gridData);
        button_2.setText("\u66f4\u65b0ID\u548c\u63cf\u8ff0");
        SashForm sashForm_2 = new SashForm((Composite)sashForm_1, 0);
        this.sessionDataPanel = new DataDicSelectPanel((Composite)sashForm_2, editable, true, 2048);
        this.servicePanel = new RefServicePanel((Composite)sashForm_2, true, 2048);
        this.servicePanel.setLayoutData(new GridData(1808));
        this.sessionDataPanel.setLayoutData(new GridData(1808));
        this.sessionDataPanel.setAccessMode(new String[]{"session", "common"});
        this.sessionDataPanel.creatDictDropTarget();
        sashForm_2.setWeights(new int[]{3, 2});
        sashForm_1.setWeights(new int[]{1, 3});
        sashForm.setWeights(new int[]{1, 4});
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void setActivateChannel() {
        TreeItem[] items = this.ctxNodeTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        XMLNode datasNode = null;
        XMLNode refSvcNode = null;
        if ("root".equals(node.getNodeName())) {
            datasNode = node.getChild("datas");
            this.servicePanel.setAccess(false);
            this.channelIDText.setEnabled(false);
            this.channelIDText.setText("");
            this.documentText.setEnabled(false);
            this.documentText.setText("");
        } else {
            this.sessionDataPanel.setAccess(true);
            this.servicePanel.setAccess(true);
            datasNode = node.getChild("sessionDatas");
            this.channelIDText.setEnabled(true);
            this.documentText.setEnabled(true);
            this.channelIDText.setText(node.getAttrValue("id"));
            this.documentText.setText(String.valueOf(node.getDocument()));
        }
        refSvcNode = node.getChild("refServices");
        if (refSvcNode == null) {
            refSvcNode = new XMLNode();
            refSvcNode.setNodeName("refServices");
            node.add(refSvcNode);
        }
        this.sessionDataPanel.setDataXMLNode(datasNode);
        try {
            this.servicePanel.setRefServiceNode(refSvcNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createNewChannel() {
        AddChannelWizard wizard = new AddChannelWizard();
        XMLNode node = wizard.getXMLNode(IDEContent.getCurrentProject(), this.channelSettingsNode);
        this.channelSettingsNode.add(node);
        XMLNode dataNode = new XMLNode();
        dataNode.setNodeName("sessionDatas");
        node.add(dataNode);
        XMLNode refServiceNode = new XMLNode();
        refServiceNode.setNodeName("refServices");
        node.add(refServiceNode);
        TreeItem item = new TreeItem(this.ctxNodeTree.getItems()[0], 0);
        item.setData((Object)node);
        String itemLabel = node.getAttrValue("id");
        String doc = node.getDocument();
        if (doc != null && doc.length() != 0) {
            itemLabel = String.valueOf(itemLabel) + "[" + doc + "]";
        }
        item.setText(itemLabel);
        this.ctxNodeTree.setSelection(new TreeItem[]{item});
        this.sessionDataPanel.setAccess(true);
        this.sessionDataPanel.setDataXMLNode(dataNode);
        this.channelIDText.setText(node.getAttrValue("id"));
        this.documentText.setText(node.getDocument());
    }

    private void deleteSelectedChannel() {
        TreeItem[] items = this.ctxNodeTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if ("root".equals(node.getNodeName())) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("MCIChannelDefinePanel.Are_you_sure..._22"), (String)Messages.getString("MCIChannelDefinePanel.Be_sure_to_delete_the_selected_channel_define__23"))) {
            return;
        }
        this.channelSettingsNode.remove(node);
        this.channelIDText.setText("");
        this.documentText.setText("");
        this.sessionDataPanel.setDataXMLNode(null);
        this.servicePanel.setRefServiceNode(null);
        items[0].dispose();
        if (this.ctxNodeTree.getItemCount() > 0) {
            this.ctxNodeTree.setSelection(new TreeItem[]{this.ctxNodeTree.getItems()[0]});
            this.setActivateChannel();
        }
    }

    private void updateSelectedChannel() {
        TreeItem[] items = this.ctxNodeTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if ("root".equals(node.getNodeName())) {
            return;
        }
        String channelId = this.channelIDText.getText();
        String doc = this.documentText.getText();
        if (channelId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("MCIChannelDefinePanel.Warning_26"), (String)Messages.getString("MCIChannelDefinePanel.Please_input_proper_Channel_ID_!_27"));
            return;
        }
        XMLNode childNode = this.channelSettingsNode.findChildNode(channelId);
        if (childNode != null && childNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("MCIChannelDefinePanel.Warning_28"), (String)Messages.getString("MCIChannelDefinePanel.Duplicated_Channel_ID_!_29"));
            return;
        }
        node.setAttrValue("id", channelId);
        node.setDocument(doc);
        String itemLabel = channelId;
        if (doc != null && doc.length() != 0) {
            itemLabel = String.valueOf(itemLabel) + "[" + doc + "]";
        }
        items[0].setText(itemLabel);
    }

    public void setNodeDefine(XMLNode sessionNode) {
        this.xmlContent = sessionNode;
        if (sessionNode == null || sessionNode.getChilds() == null) {
            return;
        }
        XMLNode rootNode = sessionNode.findChild("root");
        this.channelSettingsNode = sessionNode.findChild("channelSettings");
        this.ctxNodeTree.removeAll();
        TreeItem pItem = new TreeItem(this.ctxNodeTree, 0);
        pItem.setText(rootNode.getNodeName());
        pItem.setData((Object)rootNode);
        int i = 0;
        while (i < this.channelSettingsNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)this.channelSettingsNode.getChilds().elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                TreeItem item = new TreeItem(pItem, 0);
                String itemLabel = aNode.getAttrValue("id");
                if (aNode.getDocument() != null) {
                    itemLabel = String.valueOf(itemLabel) + "[" + aNode.getDocument() + "]";
                }
                item.setText(itemLabel);
                item.setData((Object)aNode);
            }
            ++i;
        }
        pItem.setExpanded(true);
        this.ctxNodeTree.setSelection(new TreeItem[]{pItem});
        this.setActivateChannel();
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataProfile = profile;
        this.sessionDataPanel.setDataDictionaryEditorProfile(profile);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.sessionDataPanel.setDataDictionary(node);
    }

    public void setServiceProfile(EditorProfile profile) {
        this.serviceProfile = profile;
        this.servicePanel.setServiceProfile(profile);
    }

    public void setServiceNode(XMLNode node) {
        this.serviceNode = node;
        this.servicePanel.setServiceNode(node);
    }

    public void setRootPath(String rootPath) {
        this.servicePanel.setRootPath(rootPath);
    }

    public Vector getSelectDatas() {
        return this.sessionDataPanel.getSelectedDatas();
    }
}

