/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.project;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDicSelectPanel;
import com.ecc.ide.editor.data.Messages;
import com.ecc.ide.editor.service.RefServicePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ChannelDefinePanel
extends Composite {
    private Table channelListTable;
    private Text documentText;
    private Text channelIDText;
    private DataDicSelectPanel sessionDataPanel;
    private RefServicePanel servicePanel;
    private EditorProfile dataProfile;
    private XMLNode dataDictionary;
    private EditorProfile serviceProfile;
    private XMLNode serviceNode;
    private XMLNode xmlContent;

    public ChannelDefinePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("\u5e94\u7528ID");
        this.channelIDText = new Text(composite, 2048);
        this.channelIDText.setLayoutData((Object)new GridData(768));
        Label label_1 = new Label(composite, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 2;
        label_1.setLayoutData((Object)gridData_1);
        label_1.setText(Messages.getString("MCIChannelDefinePanel.Document__2"));
        this.documentText = new Text(composite, 2818);
        GridData gridData_2 = new GridData(256);
        gridData_2.heightHint = 50;
        gridData_2.horizontalSpan = 2;
        this.documentText.setLayoutData((Object)gridData_2);
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite_1.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite_1, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelDefinePanel.this.createNewChannel();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 60;
        button.setLayoutData((Object)gridData_4);
        button.setText(Messages.getString("MCIChannelDefinePanel.Create_3"));
        Button button_1 = new Button(composite_1, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelDefinePanel.this.deleteSelectedChannel();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 60;
        button_1.setLayoutData((Object)gridData_5);
        button_1.setText(Messages.getString("MCIChannelDefinePanel.Delete_4"));
        Button button_2 = new Button(composite_1, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelDefinePanel.this.updateSelectedChannel();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 60;
        button_2.setLayoutData((Object)gridData_6);
        button_2.setText(Messages.getString("MCIChannelDefinePanel.Update_5"));
        this.channelListTable = new Table(composite, 67584);
        this.channelListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelDefinePanel.this.setActivateChannel();
            }
        });
        GridData gridData_3 = new GridData(1808);
        gridData_3.horizontalSpan = 2;
        this.channelListTable.setLayoutData((Object)gridData_3);
        this.channelListTable.setLinesVisible(true);
        this.channelListTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.channelListTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText("\u5e94\u7528ID");
        TableColumn tableColumn_1 = new TableColumn(this.channelListTable, 0);
        tableColumn_1.setWidth(161);
        tableColumn_1.setText(Messages.getString("MCIChannelDefinePanel.Document_7"));
        TabFolder tabFolder = new TabFolder((Composite)sashForm, 0);
        TabItem tabItem_1 = new TabItem(tabFolder, 0);
        tabItem_1.setText("\u6570\u636e\u5f15\u7528");
        this.sessionDataPanel = new DataDicSelectPanel((Composite)tabFolder, true, true, 0);
        this.sessionDataPanel.setLayoutData(new GridData(1808));
        tabItem_1.setControl((Control)this.sessionDataPanel);
        this.sessionDataPanel.setAccessMode(new String[]{"session", "common"});
        this.sessionDataPanel.creatDictDropTarget();
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("\u670d\u52a1\u5f15\u7528");
        this.servicePanel = new RefServicePanel((Composite)tabFolder, true, 0);
        this.servicePanel.setLayoutData(new GridData(1808));
        tabItem.setControl((Control)this.servicePanel);
        sashForm.setWeights(new int[]{1, 3});
    }

    private void setActivateChannel() {
        TableItem[] items = this.channelListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        this.channelIDText.setText(node.getAttrValue("id"));
        if (node.getDocument() != null) {
            this.documentText.setText(node.getDocument());
        } else {
            this.documentText.setText("");
        }
        this.sessionDataPanel.setDataXMLNode(node.getChild("sessionDatas"));
        XMLNode refSvcNode = node.getChild("refServices");
        if (refSvcNode == null) {
            refSvcNode = new XMLNode();
            refSvcNode.setNodeName("refServices");
            node.add(refSvcNode);
        }
        this.servicePanel.setRefServiceNode(refSvcNode);
    }

    private void createNewChannel() {
        String channelId = this.channelIDText.getText();
        String doc = this.documentText.getText();
        if (channelId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("MCIChannelDefinePanel.Warning_14"), (String)Messages.getString("MCIChannelDefinePanel.Please_input_proper_Channel_ID_!_15"));
            return;
        }
        if (this.xmlContent.findChildNode(channelId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("MCIChannelDefinePanel.Warning_16"), (String)Messages.getString("MCIChannelDefinePanel.Duplicated_Channel_ID_!_17"));
            return;
        }
        XMLNode node = new XMLNode();
        node.setNodeName("channel");
        node.setAttrValue("id", channelId);
        node.setDocument(doc);
        this.xmlContent.add(node);
        XMLNode dataNode = new XMLNode();
        dataNode.setNodeName("sessionDatas");
        node.add(dataNode);
        XMLNode refServiceNode = new XMLNode();
        refServiceNode.setNodeName("refServices");
        node.add(refServiceNode);
        TableItem item = new TableItem(this.channelListTable, 0);
        item.setData((Object)node);
        item.setText(channelId);
        item.setText(1, doc);
        TableItem[] items = new TableItem[]{item};
        this.channelListTable.setSelection(items);
        this.sessionDataPanel.setDataXMLNode(dataNode);
    }

    private void deleteSelectedChannel() {
        TableItem[] items = this.channelListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("MCIChannelDefinePanel.Are_you_sure..._22"), (String)Messages.getString("MCIChannelDefinePanel.Be_sure_to_delete_the_selected_channel_define__23"))) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        this.xmlContent.remove(node);
        this.channelIDText.setText("");
        this.documentText.setText("");
        this.sessionDataPanel.setDataXMLNode(null);
        this.servicePanel.setRefServiceNode(null);
        items[0].dispose();
        if (this.channelListTable.getItemCount() > 0) {
            this.channelListTable.setSelection(0);
            this.setActivateChannel();
        }
    }

    private void updateSelectedChannel() {
        TableItem[] items = this.channelListTable.getSelection();
        if (items.length != 1) {
            return;
        }
        String channelId = this.channelIDText.getText();
        String doc = this.documentText.getText();
        if (channelId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("MCIChannelDefinePanel.Warning_26"), (String)Messages.getString("MCIChannelDefinePanel.Please_input_proper_Channel_ID_!_27"));
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        XMLNode childNode = this.xmlContent.findChildNode(channelId);
        if (childNode != null && childNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("MCIChannelDefinePanel.Warning_28"), (String)Messages.getString("MCIChannelDefinePanel.Duplicated_Channel_ID_!_29"));
            return;
        }
        node.setAttrValue("id", channelId);
        node.setDocument(doc);
        items[0].setText(channelId);
        items[0].setText(1, doc);
    }

    public void setXMLContent(XMLNode node) {
        this.xmlContent = node;
        if (node == null || node.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode aNode = (XMLNode)node.getChilds().elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                TableItem item = new TableItem(this.channelListTable, 0);
                item.setText(aNode.getAttrValue("id"));
                if (aNode.getDocument() != null) {
                    item.setText(1, aNode.getDocument());
                }
                item.setData((Object)aNode);
            }
            ++i;
        }
        if (node.getChilds().size() > 0) {
            this.channelListTable.setSelection(0);
            this.setActivateChannel();
        }
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataProfile = profile;
        this.sessionDataPanel.setDataDictionaryEditorProfile(profile);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.sessionDataPanel.setDataDictionary(node);
    }

    public void setServiceProfile(EditorProfile profile) {
        this.serviceProfile = profile;
        this.servicePanel.setServiceProfile(profile);
    }

    public void setServiceNode(XMLNode node) {
        this.serviceNode = node;
        this.servicePanel.setServiceNode(node);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setRootPath(String rootPath) {
        this.servicePanel.setRootPath(rootPath);
    }
}

