/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.project;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.project.Messages;
import com.ecc.ide.editor.transaction.DataSelector;
import com.ecc.ide.editor.transaction.HostDataPanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HostAccessProfilePanel
extends Composite
implements DataSelector {
    private Text descText;
    private Text hostIdText;
    private Table hostListTable;
    private XMLNode pkgTypeNode;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private HostDataPanel hostReqDataPanel;
    private HostDataPanel hostRepDataPanel;
    private XMLNode hostSettings;

    public void setDataDictionaryEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.hostRepDataPanel.setDataDictionary(node);
        this.hostReqDataPanel.setDataDictionary(node);
    }

    public void setPkgTypeXMLNode(XMLNode node) {
        this.pkgTypeNode = node;
        this.hostRepDataPanel.setPkgTypeXMLNode(node);
        this.hostReqDataPanel.setPkgTypeXMLNode(node);
    }

    public HostAccessProfilePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        composite.setLayout((Layout)gridLayout_2);
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("HostAccessProfilePanel.HostID__1"));
        this.hostIdText = new Text(composite, 2048);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 2;
        this.hostIdText.setLayoutData((Object)gridData_2);
        Label label_3 = new Label(composite, 0);
        label_3.setText(Messages.getString("HostAccessProfilePanel.Documnet__2"));
        this.descText = new Text(composite, 2818);
        GridData gridData_3 = new GridData(256);
        gridData_3.heightHint = 40;
        gridData_3.horizontalSpan = 3;
        this.descText.setLayoutData((Object)gridData_3);
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData_7 = new GridData();
        gridData_7.horizontalSpan = 3;
        composite_1.setLayoutData((Object)gridData_7);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout);
        Button button = new Button(composite_1, 0);
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button.setLayoutData((Object)gridData_4);
        button.setText(Messages.getString("HostAccessProfilePanel.Create_3"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessProfilePanel.this.createNewHost();
            }
        });
        Button button_2 = new Button(composite_1, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessProfilePanel.this.deleteSelectedHost();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 80;
        button_2.setLayoutData((Object)gridData_6);
        button_2.setText(Messages.getString("HostAccessProfilePanel.Remove_5"));
        Button button_1 = new Button(composite_1, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessProfilePanel.this.updateHostAccessItem();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        button_1.setLayoutData((Object)gridData_5);
        button_1.setText(Messages.getString("HostAccessProfilePanel.Update_4"));
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("HostAccessProfilePanel.Host_List_6"));
        this.hostListTable = new Table(composite, 67584);
        this.hostListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostAccessProfilePanel.this.setActivateHost();
            }
        });
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 3;
        this.hostListTable.setLayoutData((Object)gridData_1);
        this.hostListTable.setLinesVisible(true);
        this.hostListTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.hostListTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("HostAccessProfilePanel.Host_ID_7"));
        TableColumn tableColumn_1 = new TableColumn(this.hostListTable, 0);
        tableColumn_1.setWidth(165);
        tableColumn_1.setText(Messages.getString("HostAccessProfilePanel.Description_8"));
        GridData gridData2_5 = new GridData();
        gridData2_5.widthHint = 90;
        TabFolder tabFolder_1 = new TabFolder((Composite)sashForm, 0);
        TabItem tabItem_4 = new TabItem(tabFolder_1, 0);
        tabItem_4.setText(Messages.getString("HostAccessProfilePanel.Request_Head_9"));
        this.hostReqDataPanel = new HostDataPanel((Composite)tabFolder_1, 0);
        tabItem_4.setControl((Control)this.hostReqDataPanel);
        TabItem tabItem_5 = new TabItem(tabFolder_1, 0);
        tabItem_5.setText(Messages.getString("HostAccessProfilePanel.Reply_Head_10"));
        this.hostRepDataPanel = new HostDataPanel((Composite)tabFolder_1, 0);
        tabItem_5.setControl((Control)this.hostRepDataPanel);
        this.hostReqDataPanel.setDataSelector(this);
        this.hostRepDataPanel.setDataSelector(this);
        sashForm.setWeights(new int[]{100, 300});
    }

    public void dispose() {
        super.dispose();
    }

    private void createNewHost() {
        String hostId = this.hostIdText.getText();
        if (hostId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessProfilePanel.Warning_1"), (String)Messages.getString("HostAccessProfilePanel.Please_input_proper_Host_ID_!_2"));
            return;
        }
        int i = 0;
        while (i < this.hostSettings.getChilds().size()) {
            XMLNode aHost = (XMLNode)this.hostSettings.getChilds().elementAt(i);
            if (!"#text".equals(aHost.getNodeName()) && hostId.equals(aHost.getAttrValue("id"))) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessProfilePanel.Warning_3"), (String)Messages.getString("HostAccessProfilePanel.Duplicated_Host_ID_!_4"));
                return;
            }
            ++i;
        }
        String desc = this.descText.getText();
        XMLNode node = new XMLNode();
        node.setNodeName("host");
        node.setAttrValue("id", hostId);
        node.setDocument(desc);
        this.hostSettings.add(node);
        TableItem item = new TableItem(this.hostListTable, 0);
        item.setText(hostId);
        item.setText(1, desc);
        item.setData((Object)node);
        XMLNode reqNode = new XMLNode();
        reqNode.setNodeName("request");
        node.add(reqNode);
        XMLNode reqDatasNode = new XMLNode();
        reqDatasNode.setNodeName("datas");
        reqNode.add(reqDatasNode);
        XMLNode repNode = new XMLNode();
        repNode.setNodeName("reply");
        node.add(repNode);
        XMLNode repDatasNode = new XMLNode();
        repDatasNode.setNodeName("datas");
        repNode.add(repDatasNode);
    }

    private void setActivateHost() {
        TableItem[] selects = this.hostListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode host = (XMLNode)selects[0].getData();
        XMLNode req = host.getChild("request");
        XMLNode rep = host.getChild("reply");
        this.hostIdText.setText(host.getAttrValue("id"));
        if (host.getDocument() != null) {
            this.descText.setText(host.getDocument());
        } else {
            this.descText.setText("");
        }
        XMLNode reqDataNode = req.getChild("datas");
        this.hostReqDataPanel.setHostAccessDataNode(reqDataNode);
        XMLNode repDataNode = rep.getChild("datas");
        this.hostRepDataPanel.setHostAccessDataNode(repDataNode);
    }

    private void updateHostAccessItem() {
        TableItem[] selects = this.hostListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        String hostId = this.hostIdText.getText();
        if (hostId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessProfilePanel.Warning_1"), (String)Messages.getString("HostAccessProfilePanel.Please_input_proper_host_ID._2"));
            return;
        }
        XMLNode host = (XMLNode)selects[0].getData();
        XMLNode aNode = this.hostSettings.findChildNode(hostId);
        if (aNode != null && aNode != host) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostAccessProfilePanel.Warning_3"), (String)Messages.getString("HostAccessProfilePanel.Duplicated_host_ID._4"));
            return;
        }
        if (!host.getAttrValue("id").equals(hostId) && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("HostAccessProfilePanel.Warning_6"), (String)Messages.getString("HostAccessProfilePanel.You_have_change_the_host_ID,_Please_make_sure_that_you_have_manually_changed_the_all_MCI_Trx_define_that_refer_to_this_host_access_profile._7"))) {
            return;
        }
        host.setDocument(this.descText.getText());
        host.setAttrValue("id", hostId);
        selects[0].setText(hostId);
        selects[0].setText(1, this.descText.getText());
    }

    private void deleteSelectedHost() {
        TableItem[] selects = this.hostListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("HostAccessProfilePanel.Are_you_sure..._10"), (String)Messages.getString("HostAccessProfilePanel.Please_make_sure_to_delete_the_selected_Host_access_profile_define_._11"))) {
            return;
        }
        XMLNode host = (XMLNode)selects[0].getData();
        this.hostSettings.remove(host);
        selects[0].dispose();
    }

    public void setHostSettings(XMLNode node) {
        this.hostSettings = node;
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode host = (XMLNode)node.getChilds().elementAt(i);
            if (!"#text".equals(host.getNodeName())) {
                TableItem item = new TableItem(this.hostListTable, 0);
                item.setText(host.getAttrValue("id"));
                if (host.getDocument() != null) {
                    item.setText(1, host.getDocument());
                }
                item.setData((Object)host);
            }
            ++i;
        }
        if (node.getChilds().size() > 0) {
            this.hostListTable.setSelection(0);
            this.setActivateHost();
        }
    }

    protected void checkSubclass() {
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(Messages.getString("HostAccessProfilePanel.MCI_Transaction_Define_Test_Frame_30"));
        HostAccessProfilePanel test = new HostAccessProfilePanel((Composite)shell, 2048);
        XMLNode hostNode = null;
        try {
            String fileName = "/profiles/dataDictionaryEditorProfile.xml";
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            test.setDataDictionaryEditorProfile(profile);
            XMLLoader xmlLoader1 = new XMLLoader();
            xmlLoader1.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader1.loadXMLFile("/dataDictionary.xml");
            test.setDataDictionary(node);
            XMLNode pkgSettings = (XMLNode)xmlLoader1.loadXMLFile("/profiles/hostPackageProfile.xml");
            test.setPkgTypeXMLNode(pkgSettings);
            XMLLoader xmlLoader2 = new XMLLoader();
            xmlLoader2.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            hostNode = (XMLNode)xmlLoader2.loadXMLFile("/profiles/hostProfiles.xml");
            test.setHostSettings(hostNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test.layout();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        StringBuffer strBuf = new StringBuffer();
        hostNode.toXMLContent(0, strBuf);
        try {
            FileWriter fw = new FileWriter("/hostProfiles.xml");
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector getSelectedDatas() {
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        Vector result = (Vector)dialog.open();
        if (result != null) {
            result.addAll(dialog.getSelectedCommonDatas());
        }
        return result;
    }
}

