/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.project;

import com.ecc.ide.editor.ElementAttributePanel;
import com.ecc.ide.editor.SearchClass;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.project.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class HostPackageTypePanel
extends Composite {
    private Table table;
    private Text documentText;
    private Text fmtGenText;
    private Text pkgIdText;
    private final ElementAttributePanel fmtAttributePanel;
    private final ElementAttributePanel fmtDataAttributePanel;
    private final ElementAttributePanel fmtiCollAttributePanel;
    private final ElementAttributePanel fmtGrpAttributePanel;
    private XMLNode pkgSettingsXMLNode;

    public void setPkgSettingsXMLNode(XMLNode node) {
        this.pkgSettingsXMLNode = node;
        if (node.getChilds() == null) {
            return;
        }
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode child = (XMLNode)node.getChilds().elementAt(i);
            if (!"#text".equals(child.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(child.getAttrValue("id"));
                if (child.getAttrValue("fmtGenClass") != null) {
                    item.setText(1, child.getAttrValue("fmtGenClass"));
                }
                if (child.getDocument() != null) {
                    item.setText(2, child.getDocument());
                }
                item.setData((Object)child);
            }
            ++i;
        }
        if (node.getChilds().size() > 0) {
            this.table.setSelection(0);
            this.setActivatePkgType();
        }
    }

    private void createNewPackageType() {
        String packageTypeId = this.pkgIdText.getText();
        if (packageTypeId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostPackageTypePanel.Warning_6"), (String)Messages.getString("HostPackageTypePanel.Please_input_a_package_Type_ID_7"));
            return;
        }
        XMLNode aNode = this.pkgSettingsXMLNode.findChildNode(packageTypeId);
        if (aNode != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostPackageTypePanel.Warning_9"), (String)Messages.getString("HostPackageTypePanel.Duplicated_package_Type_ID_10"));
            return;
        }
        String desc = this.documentText.getText();
        String fmtGenClass = this.fmtGenText.getText();
        if (fmtGenClass.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostPackageTypePanel.Warning_9"), (String)Messages.getString("HostPackageTypePanel.Please_input_proper_fmt_generator_Class_name_!_1"));
            return;
        }
        XMLNode node = new XMLNode();
        node.setNodeName("package");
        node.setAttrValue("id", packageTypeId);
        node.setDocument(desc);
        if (fmtGenClass.length() > 0) {
            node.setAttrValue("fmtGenClass", fmtGenClass);
        }
        XMLNode attrNode = new XMLNode();
        attrNode.setNodeName("attributes");
        node.add(attrNode);
        XMLNode dataAttrNode = new XMLNode();
        dataAttrNode.setNodeName("dataAttributes");
        node.add(dataAttrNode);
        this.pkgSettingsXMLNode.add(node);
        TableItem item = new TableItem(this.table, 0);
        item.setText(packageTypeId);
        item.setText(1, fmtGenClass);
        item.setText(2, desc);
        item.setData((Object)node);
    }

    private void setActivatePkgType() {
        XMLNode iCollAttrNode;
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode pkg = (XMLNode)selects[0].getData();
        XMLNode reqAttrNode = pkg.getChild("attributes");
        XMLNode reqDataAttrNode = pkg.getChild("dataAttributes");
        XMLNode grpAttrNode = pkg.getChild("groupAttributes");
        if (grpAttrNode == null) {
            grpAttrNode = new XMLNode("groupAttributes");
            pkg.add(grpAttrNode);
        }
        if ((iCollAttrNode = pkg.getChild("iCollAttributes")) == null) {
            iCollAttrNode = new XMLNode("iCollAttributes");
            pkg.add(iCollAttrNode);
        }
        this.fmtAttributePanel.setAttributesXMLNode(reqAttrNode);
        this.fmtDataAttributePanel.setAttributesXMLNode(reqDataAttrNode);
        this.fmtiCollAttributePanel.setAttributesXMLNode(iCollAttrNode);
        this.fmtGrpAttributePanel.setAttributesXMLNode(grpAttrNode);
        this.pkgIdText.setText(pkg.getAttrValue("id"));
        if (pkg.getAttrValue("id") != null) {
            this.fmtGenText.setText(pkg.getAttrValue("fmtGenClass"));
        } else {
            this.fmtGenText.setText("");
        }
        if (pkg.getDocument() != null) {
            this.documentText.setText(pkg.getDocument());
        } else {
            this.documentText.setText("");
        }
    }

    private void updatePkgType() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode pkg = (XMLNode)selects[0].getData();
        String packageTypeId = this.pkgIdText.getText();
        if (packageTypeId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostPackageTypePanel.Warning_26"), (String)Messages.getString("HostPackageTypePanel.Please_input_a_package_Type_ID_27"));
            return;
        }
        XMLNode aNode = this.pkgSettingsXMLNode.findChildNode(packageTypeId);
        if (aNode != null && aNode != pkg) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("HostPackageTypePanel.Warning_29"), (String)Messages.getString("HostPackageTypePanel.Duplicated_package_Type_ID_30"));
            return;
        }
        if (!pkg.getAttrValue("id").equals(packageTypeId) && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("HostPackageTypePanel.Warning_2"), (String)Messages.getString("HostPackageTypePanel.You_have_change_the_packageTypeID_property,_please_make_sure_you_have_manually_change_all_host_access_that_refer_to_this_package_Type_!_3"))) {
            return;
        }
        String fmtGenStr = this.fmtGenText.getText();
        String doc = this.documentText.getText();
        pkg.setAttrValue("id", packageTypeId);
        pkg.setDocument(doc);
        pkg.setAttrValue("fmtGenClass", fmtGenStr);
        selects[0].setText(1, fmtGenStr);
        selects[0].setText(2, doc);
    }

    private void deletePackageType() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("HostPackageTypePanel.Are_you_sure..._4"), (String)Messages.getString("HostPackageTypePanel.Are_you_sure_to_delete_the_selected_package_type_define__5"))) {
            return;
        }
        XMLNode pkg = (XMLNode)selects[0].getData();
        this.pkgSettingsXMLNode.remove(pkg);
        this.table.remove(this.table.indexOf(selects[0]));
        this.fmtAttributePanel.setAttributesXMLNode(null);
        this.fmtDataAttributePanel.setAttributesXMLNode(null);
        this.fmtiCollAttributePanel.setAttributesXMLNode(null);
        this.fmtGrpAttributePanel.setAttributesXMLNode(null);
    }

    public HostPackageTypePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("HostPackageTypePanel.PackageID__34"));
        this.pkgIdText = new Text(composite, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 108;
        gridData.horizontalSpan = 2;
        this.pkgIdText.setLayoutData((Object)gridData);
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("HostPackageTypePanel.FormatGenerator__35"));
        this.fmtGenText = new Text(composite, 2048);
        this.fmtGenText.setLayoutData((Object)new GridData(768));
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = SearchClass.selectClass(HostPackageTypePanel.this.getShell());
                if (result != null) {
                    HostPackageTypePanel.this.fmtGenText.setText(result);
                }
            }
        });
        button.setText(Messages.getString("HostPackageTypePanel.>>_36"));
        Label label_2 = new Label(composite, 0);
        label_2.setText(Messages.getString("HostPackageTypePanel.Document__37"));
        this.documentText = new Text(composite, 2818);
        GridData gridData_1 = new GridData(768);
        gridData_1.heightHint = 50;
        gridData_1.horizontalSpan = 3;
        this.documentText.setLayoutData((Object)gridData_1);
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData_5 = new GridData();
        gridData_5.horizontalSpan = 3;
        composite_1.setLayoutData((Object)gridData_5);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout_1);
        Button button_1 = new Button(composite_1, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostPackageTypePanel.this.createNewPackageType();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 80;
        button_1.setLayoutData((Object)gridData_2);
        button_1.setText(Messages.getString("HostPackageTypePanel.Create_38"));
        Button button_2 = new Button(composite_1, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostPackageTypePanel.this.deletePackageType();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 80;
        button_2.setLayoutData((Object)gridData_3);
        button_2.setText(Messages.getString("HostPackageTypePanel.Delete_39"));
        Button button_3 = new Button(composite_1, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostPackageTypePanel.this.updatePkgType();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_3.setLayoutData((Object)gridData_4);
        button_3.setText(Messages.getString("HostPackageTypePanel.Update_40"));
        this.table = new Table(composite, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostPackageTypePanel.this.setActivatePkgType();
            }
        });
        GridData gridData_6 = new GridData(1808);
        gridData_6.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData_6);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(82);
        tableColumn.setText(Messages.getString("HostPackageTypePanel.PackageID_41"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("HostPackageTypePanel.Format_generator_42"));
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("HostPackageTypePanel.Document_43"));
        TabFolder tabFolder = new TabFolder((Composite)sashForm, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("HostPackageTypePanel.PackageAttributes_44"));
        this.fmtAttributePanel = new ElementAttributePanel((Composite)tabFolder, 0);
        tabItem.setControl((Control)this.fmtAttributePanel);
        TabItem tabItem_1 = new TabItem(tabFolder, 0);
        tabItem_1.setText(Messages.getString("HostPackageTypePanel.Data_Element_Attributes_45"));
        this.fmtDataAttributePanel = new ElementAttributePanel((Composite)tabFolder, 0);
        tabItem_1.setControl((Control)this.fmtDataAttributePanel);
        TabItem tabItem_2 = new TabItem(tabFolder, 0);
        tabItem_2.setText(Messages.getString("HostPackageTypePanel.dataiCollAttrLabel"));
        this.fmtiCollAttributePanel = new ElementAttributePanel((Composite)tabFolder, 0);
        tabItem_2.setControl((Control)this.fmtiCollAttributePanel);
        TabItem tabItem_3 = new TabItem(tabFolder, 0);
        tabItem_3.setText(Messages.getString("HostPackageTypePanel.dataGroupAttrLabel"));
        this.fmtGrpAttributePanel = new ElementAttributePanel((Composite)tabFolder, 0);
        tabItem_3.setControl((Control)this.fmtGrpAttributePanel);
        sashForm.setWeights(new int[]{100, 300});
    }

    public void setDefinedClassType(XMLNode definedClassTypeNode) {
        this.fmtAttributePanel.setDefinedClassType(definedClassTypeNode);
        this.fmtDataAttributePanel.setDefinedClassType(definedClassTypeNode);
        this.fmtiCollAttributePanel.setDefinedClassType(definedClassTypeNode);
        this.fmtGrpAttributePanel.setDefinedClassType(definedClassTypeNode);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

