/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.receipt;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ReceiptItemWrapper
extends VisualElementWrapper {
    public ReceiptItemWrapper() {
    }

    public ReceiptItemWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        Color bkColor = gc.getBackground();
        String fieldName = this.element.getVisualType();
        if (fieldName == null) {
            fieldName = this.node.getNodeName();
        }
        if (fieldName.equals("Label")) {
            String text = this.node.getAttrValue("text");
            if (text != null) {
                this.drawReceiptText(gc, text, x, y);
            }
        } else if (fieldName.indexOf("Field") != -1) {
            gc.setBackground(Display.getDefault().getSystemColor(1));
            gc.fillRectangle(x, y, this.width, this.height);
            gc.setForeground(Display.getDefault().getSystemColor(2));
            if (this.getAttrValue("testText") != null) {
                this.drawReceiptText(gc, this.getAttrValue("testText"), x, y);
            }
            gc.setBackground(bkColor);
            gc.setForeground(Display.getDefault().getSystemColor(15));
            gc.drawLine(x, y, x + this.width, y);
            gc.drawLine(x, y, x, y + this.height);
            gc.drawLine(x + 1, y + this.height - 1, x + this.width - 1, y + this.height - 1);
            gc.drawLine(x + this.width - 1, y + 1, x + this.width - 1, y + this.height - 1);
            gc.setForeground(Display.getDefault().getSystemColor(16));
            gc.drawLine(x + 1, y + 1, x + this.width - 1, y + 1);
            gc.drawLine(x + 1, y + 1, x + 1, y + this.height - 1);
        }
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        gc.setClipping(parentClipRect);
    }

    private void drawReceiptText(GC gc, String text, int x, int y) {
        String widthAttr;
        String heightAttr;
        int fontHeight = 8;
        int fontWidth = 8;
        String cpi = this.getAttrValue("cpi");
        if ("2".equals(cpi)) {
            fontHeight = 12;
            fontWidth = 12;
        }
        if ("3".equals(cpi)) {
            fontHeight = 16;
            fontWidth = 16;
        }
        if ("1".equals(heightAttr = this.getAttrValue("heightAttr"))) {
            fontHeight *= 2;
        }
        if ("2".equals(heightAttr)) {
            fontHeight *= 3;
        }
        if ("1".equals(widthAttr = this.getAttrValue("widthAttr"))) {
            fontWidth *= 2;
        }
        if ("2".equals(widthAttr)) {
            fontWidth *= 3;
        }
        int style = 8;
        if ("true".equals(this.getAttrValue("bold"))) {
            style = 1;
        }
        Font svFont = gc.getFont();
        int fontSize = fontHeight;
        if (fontSize < fontWidth) {
            fontSize = fontWidth;
        }
        FontData fontData = new FontData();
        fontData.setHeight(fontSize);
        fontData.setName(svFont.getFontData()[0].getName());
        fontData.setStyle(style);
        Font font = new Font((Device)Display.getDefault(), fontData);
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        int avWidth = fm.getAverageCharWidth();
        int fh = fm.getHeight();
        Image image = new Image((Device)Display.getDefault(), avWidth * text.getBytes().length, fh + 2);
        GC gc1 = new GC((Drawable)image);
        gc1.setFont(font);
        gc1.setBackground(gc.getBackground());
        gc1.fillRectangle(image.getBounds());
        gc1.drawText(text, 0, 0);
        if ("true".equals(this.getAttrValue("underLine"))) {
            if (fontWidth > fontHeight) {
                gc1.setLineWidth(2);
            }
            gc1.drawLine(3, fh, 3 + avWidth * text.getBytes().length, fh);
        }
        int dstWidth = image.getBounds().width;
        int dstHeight = image.getBounds().height;
        if (fontHeight > fontWidth) {
            float scale = (float)fontWidth / (float)fontHeight;
            dstWidth = (int)((float)dstWidth * scale);
        } else if (fontWidth > fontHeight) {
            float scale = (float)fontHeight / (float)fontWidth;
            dstHeight = (int)((float)dstHeight * scale);
        }
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, x + 3, y + 2, dstWidth, dstHeight);
        gc.setFont(svFont);
        font.dispose();
        gc1.dispose();
        image.dispose();
    }
}

