/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.service;

import com.ecc.emp.ide.biz.service.AddServiceWizard;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.Messages;
import com.ecc.ide.editor.objectEditor.ObjectEditor;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.refactor.editor.XMLElementWrapper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RefServicePanel
extends Composite {
    private Combo accessModeCombo;
    private Button setButton;
    private Label accessLabel;
    private XMLNode serviceNode;
    private EditorProfile serviceProfile;
    private XMLNode refServiceNode;
    private Table serviceTable;
    private boolean access = true;
    private String rootPath;

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setServiceNode(XMLNode node) {
        this.serviceNode = node;
    }

    public void setServiceProfile(EditorProfile profile) {
        this.serviceProfile = profile;
    }

    public void setRefServiceNode(XMLNode node) {
        this.refServiceNode = node;
        this.serviceTable.removeAll();
        if (node == null) {
            return;
        }
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode aNode = (XMLNode)node.getChilds().elementAt(i);
            if (!"#text".equals(aNode.getNodeName())) {
                TableItem item;
                XMLNode svcNode;
                String svcId = aNode.getAttrValue("id");
                String access = aNode.getAttrValue("access");
                if (access == null || access.length() == 0) {
                    access = "common";
                    aNode.setAttrValue("access", access);
                }
                if ((svcNode = this.serviceNode.findChildNode(svcId)) == null || svcNode.getParent() != this.serviceNode) {
                    item = new TableItem(this.serviceTable, 0);
                    item.setText(1, svcId);
                    item.setText(3, Messages.getString("RefServicePanel.Service_not_found_in_the_common_service_define_1"));
                    item.setData((Object)aNode);
                } else {
                    item = new TableItem(this.serviceTable, 0);
                    item.setText(svcNode.getNodeName());
                    item.setText(1, svcNode.getAttrValue("id"));
                    item.setText(2, access);
                    if (svcNode.getAttrValue("desc") != null) {
                        item.setText(3, svcNode.getAttrValue("desc"));
                    }
                    item.setData((Object)aNode);
                }
            }
            ++i;
        }
    }

    public RefServicePanel(Composite parent, boolean access, int style) {
        super(parent, style);
        this.access = access;
        this.setLayout((Layout)new GridLayout());
        Label label_6 = new Label((Composite)this, 0);
        GridData labelgridData = new GridData();
        label_6.setLayoutData((Object)labelgridData);
        label_6.setText("\u670d\u52a1\u5b9a\u4e49");
        this.serviceTable = new Table((Composite)this, 67584);
        this.serviceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RefServicePanel.this.editService();
            }
        });
        this.serviceTable.setLayoutData((Object)new GridData(1808));
        this.serviceTable.setLinesVisible(true);
        this.serviceTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.serviceTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("RefServicePanel.ServiceType_2"));
        TableColumn tableColumn_1 = new TableColumn(this.serviceTable, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("RefServicePanel.ServiceID_3"));
        TableColumn tableColumn_3 = new TableColumn(this.serviceTable, 0);
        tableColumn_3.setWidth(100);
        tableColumn_3.setText(Messages.getString("DataDictionaryPanel.Access_Mode_3"));
        TableColumn tableColumn_2 = new TableColumn(this.serviceTable, 0);
        tableColumn_2.setWidth(204);
        tableColumn_2.setText(Messages.getString("RefServicePanel.Document_4"));
        Composite composite_1 = new Composite((Composite)this, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout_1);
        this.accessLabel = new Label(composite_1, 0);
        this.accessLabel.setText(String.valueOf(Messages.getString("DataDictionaryPanel.Access_Mode_3")) + ":");
        this.accessLabel.setVisible(access);
        this.accessModeCombo = new Combo(composite_1, 0);
        this.accessModeCombo.setVisible(access);
        this.accessModeCombo.add("common");
        this.accessModeCombo.add("session");
        this.setButton = new Button(composite_1, 0);
        this.setButton.setVisible(access);
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefServicePanel.this.setServiceAccessMode();
            }
        });
        this.setButton.setText(Messages.getString("DataDicSelectPanel.Set_5"));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(640));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefServicePanel.this.addRefService();
            }
        });
        GridData gridData = new GridData(80, -1);
        button.setLayoutData((Object)gridData);
        button.setText("\u6dfb\u52a0\u670d\u52a1\u5b9a\u4e49");
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefServicePanel.this.editService();
            }
        });
        button_2.setText("\u7f16\u8f91\u9009\u4e2d\u670d\u52a1");
        Button button_3 = new Button(composite, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefServicePanel.this.renameService();
            }
        });
        button_3.setText("\u670d\u52a1\u91cd\u547d\u540d");
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefServicePanel.this.deleteRefService();
            }
        });
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 60;
        button_1.setLayoutData((Object)gridData_1);
        button_1.setText(Messages.getString("RefServicePanel.Delete_6"));
    }

    private void deleteRefService() {
        TableItem[] items = this.serviceTable.getSelection();
        if (items.length == 0) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"WARN", (String)"\u5220\u9664\u670d\u52a1\u5b9a\u4e49?")) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            XMLNode refNode = (XMLNode)items[i].getData();
            try {
                XMLNode service = this.serviceNode.findChildNode(refNode.getAttrValue("id"));
                this.serviceNode.remove(service);
            }
            catch (Exception exception) {
                // empty catch block
            }
            items[i].dispose();
            this.refServiceNode.remove(refNode);
            ++i;
        }
    }

    private void editService() {
        block8: {
            TableItem item = null;
            try {
                item = this.serviceTable.getSelection()[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (item == null) {
                return;
            }
            XMLNode node = (XMLNode)item.getData();
            String id = node.getAttrValue("id");
            XMLElementWrapper wrapper = new XMLElementWrapper(this.serviceNode.getChildNode(id), this.serviceProfile);
            Element aelement = wrapper.getElement();
            aelement.setEditorProfile(this.serviceProfile);
            String editClass = "com.ecc.emp.ide.mvc.editor.XMLObjectEditor";
            if (aelement.getEditClass() != null && aelement.getEditClass().length() > 0) {
                editClass = aelement.getEditClass();
            }
            try {
                ObjectEditor objEditor = (ObjectEditor)Class.forName(editClass).newInstance();
                Object result = objEditor.editObject(wrapper, this.getShell(), "\u670d\u52a1\u7ec4\u4ef6\u7f16\u8f91");
                if (result == null || !objEditor.isChanged()) break block8;
                try {
                    node.setAttrValue("id", ((XMLNode)((XMLElementWrapper)result).getWrappedObject()).getAttrValue("id"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.serviceNode.fireContentChangedEvent();
                this.redraw();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addRefService() {
        AddServiceWizard wizard = new AddServiceWizard();
        XMLNode node = wizard.getXMLNode(IDEContent.getCurrentProject(), this.serviceNode, null, null);
        if (node == null) {
            return;
        }
        this.serviceNode.add(node);
        String accessFlag = "session";
        if (!this.access) {
            accessFlag = "root";
        }
        XMLNode refNode = new XMLNode();
        refNode.setNodeName("refService");
        refNode.setAttrValue("id", node.getAttrValue("id"));
        refNode.setAttrValue("access", accessFlag);
        this.refServiceNode.add(refNode);
        TableItem item = new TableItem(this.serviceTable, 0);
        item.setText(node.getNodeName());
        item.setText(1, node.getAttrValue("id"));
        item.setText(2, accessFlag);
        if (node.getAttrValue("desc") != null) {
            item.setText(3, node.getAttrValue("desc"));
        }
        item.setData((Object)refNode);
    }

    private void setActivateService() {
        TableItem[] items = this.serviceTable.getSelection();
        if (items.length != 1) {
            this.accessModeCombo.setText("");
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        String access = node.getAttrValue("access");
        if (access == null) {
            access = "";
        }
        this.accessModeCombo.setText(access);
    }

    private void setServiceAccessMode() {
        TableItem[] items = this.serviceTable.getSelection();
        if (items.length != 1) {
            return;
        }
        String access = this.accessModeCombo.getText();
        if (access.length() == 0) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        node.setAttrValue("access", access);
        items[0].setText(2, access);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setAccess(boolean access) {
        this.access = access;
        this.accessModeCombo.setVisible(access);
        this.setButton.setVisible(access);
        this.accessLabel.setVisible(access);
    }

    private void renameService() {
        TableItem item = null;
        try {
            item = this.serviceTable.getSelection()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (item == null) {
            return;
        }
        XMLNode node = (XMLNode)item.getData();
        AddServiceWizard wizard = new AddServiceWizard();
        XMLNode newNode = wizard.renameXMLNode(IDEContent.getCurrentProject(), this.serviceNode, node);
        if (newNode == null) {
            return;
        }
        String oldId = node.getAttrValue("id");
        String id = newNode.getAttrValue("id");
        node.setAttrValue("id", id);
        XMLNode service = this.serviceNode.getChildNode(oldId);
        service.setAttrValue("id", id);
        item.setText(1, id);
    }
}

