/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.service;

import com.ecc.emp.ide.biz.service.AddServiceWizard;
import com.ecc.emp.ide.mbean.MbeanAction;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.WrapperOwner;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.objectEditor.ObjectEditor;
import com.ecc.ide.editor.objectEditor.XMLObjectEditor;
import com.ecc.ide.editor.service.ServiceItemWrapper;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.visualeditor.Messages;
import com.swtdesigner.PalletePanel;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ServiceMainPanel
extends Composite
implements WrapperOwner {
    private TableTree tableTree;
    private Text descText;
    private Combo serviceAccessCombo;
    private Text serviceIdText;
    private Text serviceTypeCombo;
    private String filterStr;
    private boolean editable = true;
    private Button createButton;
    private Button deleteButton;
    private Button editButton;
    private Button updateButton;
    private String bizGrup;
    private int[] weights;
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private XMLNode servicesNode;
    private EditorProfile serviceEditorProfile;
    private XMLNode dataDictionary;
    private XMLNode channelSettings;
    private EditorProfile dataEditorProfile;
    private String rootPath;
    private ServiceItemWrapper curSvcWrapper;
    private TableTreeItem curItem;
    private XMLNode commonServiceNode;
    public IProject project = null;
    XMLNode selfDefineNode = null;
    private XMLNode externResourceNode;

    public void setRootPath(String value) {
        this.rootPath = value;
    }

    public void setEditable(boolean value) {
        this.editable = value;
        this.createButton.setEnabled(value);
        this.deleteButton.setEnabled(value);
        this.updateButton.setEnabled(value);
        this.editButton.setEnabled(value);
    }

    public void setFilterStr(String value) {
        this.filterStr = value;
    }

    public void setServiceXMLNode(XMLNode node) {
        final int selectIdx = this.tableTree.getTable().getSelectionIndex();
        this.tableTree.removeAll();
        this.servicesNode = node;
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aService = (XMLNode)childs.elementAt(i);
            if (!(this.filterStr != null && this.filterStr.indexOf(aService.getNodeName()) == -1 || "document".equals(aService.getNodeName()) || "#text".equals(aService.getNodeName()) || "#comment".equals(aService.getNodeName()))) {
                Element element;
                TableTreeItem item = new TableTreeItem(this.tableTree, 0);
                item.setText(aService.getNodeName());
                item.setText(1, aService.getAttributesString());
                if (aService.getDocument() != null) {
                    item.setText(2, aService.getDocument());
                }
                if ((element = this.serviceEditorProfile.getElement(aService.getNodeName())) != null) {
                    if (element.getEditorProfile() == null) {
                        element.setProfile(this.serviceEditorProfile);
                    }
                    ServiceItemWrapper wrapper = new ServiceItemWrapper(aService, element, item);
                    wrapper.setWrapperOwner(this);
                    item.setData((Object)wrapper);
                    this.setServiceChildToTable(item, aService);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                ServiceMainPanel.this.tableTree.getTable().select(selectIdx);
                                ServiceMainPanel.this.setActivateService();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    this.getDisplay().asyncExec(runnable);
                }
            }
            ++i;
        }
    }

    private void setServiceChildToTable(TableTreeItem item, XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!("document".equals(aNode.getNodeName()) || "#text".equals(aNode.getNodeName()) || "#comment".equals(aNode.getNodeName()))) {
                TableTreeItem anItem = new TableTreeItem(item, 0);
                anItem.setText(aNode.getNodeName());
                anItem.setText(1, aNode.getAttributesString());
                if (aNode.getDocument() != null) {
                    anItem.setText(2, aNode.getDocument());
                }
                ServiceItemWrapper wrapper = new ServiceItemWrapper(aNode, this.serviceEditorProfile.getElement(aNode.getNodeName()), anItem);
                wrapper.setWrapperOwner(this);
                anItem.setData((Object)wrapper);
                this.setServiceChildToTable(anItem, aNode);
            }
            ++i;
        }
    }

    public void setServiceEditorProfile(EditorProfile profile) {
        this.serviceEditorProfile = profile;
        Element services = profile.getElement("Services");
        if (services == null) {
            return;
        }
        Vector childElements = services.getChilds();
        if (childElements == null) {
            return;
        }
    }

    public ServiceMainPanel(Composite parent, int style, String bizGrup) {
        super(parent, style);
        this.createControl(parent, style, 0);
        this.bizGrup = bizGrup;
    }

    public ServiceMainPanel(Composite parent, int style, int tableMode) {
        super(parent, style);
        this.createControl(parent, style, tableMode);
    }

    private void createControl(Composite parent, int style, int tableMode) {
        this.setLayout((Layout)new FillLayout());
        final SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Label label_1 = new Label(composite, 0);
        label_1.setText(Messages.getString("ServiceMainPanel.ServiceID_6"));
        this.serviceIdText = new Text(composite, 2048);
        GridData gridData_7 = new GridData();
        gridData_7.horizontalSpan = 3;
        gridData_7.widthHint = 156;
        this.serviceIdText.setLayoutData((Object)gridData_7);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("ServiceMainPanel.ServiceType__7"));
        this.serviceTypeCombo = new Text(composite, 2049);
        this.serviceTypeCombo.setEditable(false);
        this.serviceTypeCombo.setLayoutData((Object)new GridData(768));
        Label label_2 = new Label(composite, 0);
        label_2.setText(Messages.getString("ServiceMainPanel.accessType__8"));
        label_2.setVisible(false);
        this.serviceAccessCombo = new Combo(composite, 0);
        this.serviceAccessCombo.setItems(new String[]{"common", "session", "private"});
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 80;
        this.serviceAccessCombo.setLayoutData((Object)gridData_8);
        this.serviceAccessCombo.setVisible(false);
        Label label_3 = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData);
        label_3.setText(Messages.getString("ServiceMainPanel.Document__12"));
        this.descText = new Text(composite, 2818);
        GridData gridData_1 = new GridData(768);
        gridData_1.heightHint = 48;
        gridData_1.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_1);
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 4;
        composite_1.setLayoutData((Object)gridData_2);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 5;
        composite_1.setLayout((Layout)gridLayout_1);
        this.createButton = new Button(composite_1, 0);
        this.createButton.setToolTipText(Messages.getString("ServiceMainPanel.Create_new_Service__13"));
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServiceMainPanel.this.createNewService();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 80;
        this.createButton.setLayoutData((Object)gridData_3);
        this.createButton.setText(Messages.getString("ServiceMainPanel.Create_14"));
        this.deleteButton = new Button(composite_1, 0);
        this.deleteButton.setToolTipText(Messages.getString("ServiceMainPanel.delete_the_selected_service_15"));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServiceMainPanel.this.deleteSelectedService();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        this.deleteButton.setLayoutData((Object)gridData_4);
        this.deleteButton.setText(Messages.getString("ServiceMainPanel.Delete_16"));
        this.updateButton = new Button(composite_1, 0);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServiceMainPanel.this.updateCurService();
            }
        });
        this.updateButton.setToolTipText(Messages.getString("ServiceMainPanel.update_the_service_17"));
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        this.updateButton.setLayoutData((Object)gridData_5);
        this.updateButton.setText(Messages.getString("ServiceMainPanel.Update_18"));
        this.editButton = new Button(composite_1, 0);
        this.editButton.setToolTipText(Messages.getString("ServiceMainPanel.edit_the_selected_service_19"));
        GridData gridData_9 = new GridData();
        gridData_9.widthHint = 80;
        this.editButton.setLayoutData((Object)gridData_9);
        this.editButton.setText(Messages.getString("ServiceMainPanel.Edit_20"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServiceMainPanel.this.editable) {
                    ServiceMainPanel.this.editCurrentService();
                }
            }
        });
        this.tableTree = new TableTree(composite, 0x10800 | tableMode);
        this.tableTree.setToolTipText("\u53cc\u51fb\u6253\u5f00\u7f16\u8f91\u670d\u52a1\u5b9a\u4e49");
        GridData gridData_6 = new GridData(1808);
        gridData_6.horizontalSpan = 4;
        this.tableTree.setLayoutData((Object)gridData_6);
        Table table = this.tableTree.getTable();
        this.fillContextMenu((IMenuManager)new MenuManager(), table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServiceMainPanel.this.setActivateService();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (ServiceMainPanel.this.editable) {
                    ServiceMainPanel.this.editCurrentService();
                }
            }
        });
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(120);
        tableColumn.setText(Messages.getString("ServiceMainPanel.ServiceType_21"));
        TableColumn tableColumn_1 = new TableColumn(table, 0);
        tableColumn_1.setWidth(207);
        tableColumn_1.setText(Messages.getString("ServiceMainPanel.Service_Attributes_22"));
        TableColumn tableColumn_4 = new TableColumn(table, 0);
        tableColumn_4.setWidth(202);
        tableColumn_4.setText(Messages.getString("ServiceMainPanel.Document_23"));
        Composite stackComposite = new Composite((Composite)sashForm, 0);
        final StackLayout stackLayout = new StackLayout();
        stackComposite.setLayout((Layout)stackLayout);
        final Composite beanTreeComposite = new Composite(stackComposite, 0);
        final Composite beanTreeToolComposite = new Composite(stackComposite, 0);
        beanTreeToolComposite.setLayout((Layout)new GridLayout());
        stackLayout.topControl = beanTreeComposite;
        GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 2;
        beanTreeComposite.setLayout((Layout)gridLayout_5);
        Button button = new Button(beanTreeComposite, 8519684);
        button.setToolTipText(Messages.getString("hide"));
        PalletePanel panel3 = new PalletePanel(beanTreeComposite, 0);
        panel3.setTitle(Messages.getString("Properties"));
        panel3.setLayoutData(new GridData(768));
        Button button_1 = new Button(beanTreeToolComposite, 0x804004);
        button_1.setToolTipText(Messages.getString("show"));
        PalletePanel panel4 = new PalletePanel(beanTreeToolComposite, 0);
        panel4.setLayoutData(new GridData(1040));
        panel4.setTitle(Messages.getString("Properties"));
        panel4.setDirection(1);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServiceMainPanel.this.weights = sashForm.getWeights();
                Point size = sashForm.getSize();
                int[] ws = new int[]{size.x - 25, 25};
                stackLayout.topControl = beanTreeToolComposite;
                sashForm.setWeights(ws);
                sashForm.layout(true);
                ServiceMainPanel.this.layout();
            }
        });
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                stackLayout.topControl = beanTreeComposite;
                sashForm.setWeights(ServiceMainPanel.this.weights);
                sashForm.layout(true);
                ServiceMainPanel.this.layout();
            }
        });
        ScrolledComposite scrolledComposite = new ScrolledComposite(beanTreeComposite, 2560);
        GridData sgridData = new GridData(1808);
        sgridData.horizontalSpan = 2;
        scrolledComposite.setLayoutData((Object)sgridData);
        this.editorBeanPropertyPanel = new EditorBeanPropertyPanel((Composite)scrolledComposite, 0);
        this.editorBeanPropertyPanel.setSize(145, 375);
        scrolledComposite.setContent((Control)this.editorBeanPropertyPanel);
        this.weights = new int[2];
        this.weights[0] = 4;
        this.weights[1] = 1;
        sashForm.setWeights(this.weights);
    }

    public void dispose() {
        super.dispose();
        this.editorBeanPropertyPanel.dispose();
    }

    protected void checkSubclass() {
    }

    public void createNewService() {
        AddServiceWizard wizard = new AddServiceWizard();
        XMLNode aService = wizard.getXMLNode(IDEContent.getCurrentProject(), this.servicesNode, this.commonServiceNode, null);
        if (aService == null) {
            return;
        }
        this.servicesNode.add(aService);
        TableTreeItem item = new TableTreeItem(this.tableTree, 0);
        item.setText(aService.getNodeName());
        item.setText(1, aService.getAttributesString());
        if (aService.getDocument() != null) {
            item.setText(2, aService.getDocument());
        }
        ServiceItemWrapper wrapper = new ServiceItemWrapper(aService, this.serviceEditorProfile.getElement(aService.getNodeName()), item);
        wrapper.setWrapperOwner(this);
        item.setData((Object)wrapper);
        this.setServiceChildToTable(item, aService);
    }

    private void openWizard() {
        String wizardClass;
        String serviceType = this.serviceTypeCombo.getText();
        if (serviceType.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_1"), (String)Messages.getString("ServiceMainPanel.Please_select_a_serviceType_!_2"));
            return;
        }
        String serviceId = this.serviceIdText.getText();
        if (serviceId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_3"), (String)Messages.getString("ServiceMainPanel.Please_input_proper_Service_ID_!_4"));
            return;
        }
        XMLNode node = this.servicesNode.findChildNode(serviceId);
        if (node != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_5"), (String)Messages.getString("ServiceMainPanel.Duplicated_Service_ID_!_6"));
            return;
        }
        if (this.commonServiceNode != null && this.commonServiceNode.findChildNode(serviceId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_5"), (String)Messages.getString("ServiceMainPanel.Duplicated_Service_ID_!_6"));
            return;
        }
        Element element = this.serviceEditorProfile.getElement(serviceType);
        if (element == null) {
            return;
        }
        if (element.getEditorProfile() == null) {
            element.setProfile(this.serviceEditorProfile);
        }
        if ((wizardClass = element.getWizardClassType()) == null || wizardClass.length() == 0) {
            wizardClass = "com.ecc.ide.editor.wizard.ServiceXMLDefineWizard";
        }
        try {
            ECCIDEWizard wizard = (ECCIDEWizard)((Object)Class.forName(wizardClass).newInstance());
            wizard.setEditorProfile(this.serviceEditorProfile);
            wizard.setDataEditorProfile(this.dataEditorProfile);
            wizard.setDataDictionary(this.dataDictionary);
            wizard.setCommonServiceNode(this.commonServiceNode);
            wizard.setRootPath(this.rootPath);
            wizard.setSelfDefineNode(this.selfDefineNode);
            XMLNode aNode = new XMLNode();
            aNode.setNodeName(serviceType);
            aNode.setAttrValue("id", serviceId);
            aNode.setDocument(this.descText.getText());
            this.setDefaultAttributes(element, aNode);
            wizard.setXMLNode(aNode);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                aNode = wizard.getXMLNode();
                this.servicesNode.add(aNode);
                XMLNode aService = aNode;
                TableTreeItem item = new TableTreeItem(this.tableTree, 0);
                item.setText(aService.getNodeName());
                item.setText(1, aService.getAttributesString());
                if (aService.getDocument() != null) {
                    item.setText(2, aService.getDocument());
                }
                ServiceItemWrapper wrapper = new ServiceItemWrapper(aService, this.serviceEditorProfile.getElement(aService.getNodeName()), item);
                wrapper.setWrapperOwner(this);
                item.setData((Object)wrapper);
                this.setServiceChildToTable(item, aService);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Error_30"), (String)(String.valueOf(Messages.getString("ServiceMainPanel.Internal_Error__n_31")) + e));
            e.printStackTrace();
        }
    }

    private void deleteSelectedService() {
        if (this.servicesNode == null || this.curSvcWrapper == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Are_you_sure..._1"), (String)Messages.getString("ServiceMainPanel.Are_you_sure_to_delete_the_selected_Service_define__2"))) {
            return;
        }
        this.servicesNode.remove(this.curSvcWrapper.xmlNode);
        this.curItem.dispose();
        this.curSvcWrapper = null;
        this.curItem = null;
    }

    private void setActivateService() {
        ServiceItemWrapper svcWrapper;
        TableTreeItem[] selects = this.tableTree.getSelection();
        if (selects.length != 1) {
            return;
        }
        ServiceItemWrapper wrapper = (ServiceItemWrapper)selects[0].getData();
        this.editorBeanPropertyPanel.showWrapperProperties(wrapper);
        TableTreeItem item = selects[0];
        while (item.getParentItem() != null) {
            item = item.getParentItem();
        }
        this.curItem = item;
        this.curSvcWrapper = svcWrapper = (ServiceItemWrapper)item.getData();
        XMLNode curSvcNode = svcWrapper.xmlNode;
        String svcId = curSvcNode.getAttrValue("id");
        String svcType = curSvcNode.getNodeName();
        String accessType = curSvcNode.getAttrValue("access");
        String docStr = curSvcNode.getDocument();
        String implClass = curSvcNode.getAttrValue("implClass");
        if (svcId != null) {
            this.serviceIdText.setText(svcId);
        } else {
            this.serviceIdText.setText("");
        }
        this.serviceTypeCombo.setText(svcType);
        if (docStr != null) {
            this.descText.setText(docStr);
        } else {
            this.descText.setText("");
        }
        if (accessType != null) {
            this.serviceAccessCombo.setText(accessType);
        } else {
            this.serviceAccessCombo.setText("");
        }
    }

    private void updateCurService() {
        if (this.curSvcWrapper == null) {
            return;
        }
        XMLNode curSvcNode = this.curSvcWrapper.xmlNode;
        String svcId = this.serviceIdText.getText();
        if (svcId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_3"), (String)Messages.getString("ServiceMainPanel.Please_input_proper_ServiceID_!_4"));
            return;
        }
        XMLNode aNode = this.servicesNode.findChildNode(curSvcNode.getNodeName(), svcId);
        if (aNode != null && aNode != curSvcNode) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_7"), (String)Messages.getString("ServiceMainPanel.Duplicated_Service_ID_!_8"));
            return;
        }
        if (this.commonServiceNode != null && (aNode = this.commonServiceNode.findChildNode(curSvcNode.getNodeName(), svcId)) != null && aNode != curSvcNode) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_7"), (String)Messages.getString("ServiceMainPanel.Duplicated_Service_ID_!_8"));
            return;
        }
        if (svcId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_9"), (String)Messages.getString("ServiceMainPanel.Please_input_proper_Service_ID_!_10"));
            return;
        }
        String accessType = this.serviceAccessCombo.getText();
        String docStr = this.descText.getText();
        curSvcNode.setAttrValue("id", svcId);
        curSvcNode.setAttrValue("access", accessType);
        curSvcNode.setDocument(docStr);
        this.curItem.setText(1, curSvcNode.getAttributesString());
        this.curItem.setText(2, docStr);
    }

    private void editCurrentService() {
        if (this.curSvcWrapper == null) {
            return;
        }
        Element element = this.curSvcWrapper.getElement();
        ObjectEditor objEditor = null;
        if (element != null && element.getEditClass() != null) {
            try {
                objEditor = (ObjectEditor)Class.forName(element.getEditClass()).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (objEditor == null) {
            objEditor = new XMLObjectEditor();
        }
        XMLNode curNode = this.curSvcWrapper.xmlNode;
        XMLNode clonedNode = (XMLNode)curNode.clone();
        ServiceItemWrapper wrapper = new ServiceItemWrapper(clonedNode, this.curSvcWrapper.element, this.curSvcWrapper.item);
        wrapper.setWrapperOwner(this);
        Object result = objEditor.editObject(wrapper, this.getShell(), Messages.getString("ServiceMainPanel.Sevice_Editing__1"));
        if (result != null) {
            TableTreeItem item;
            if (!objEditor.isChanged()) {
                return;
            }
            this.servicesNode.remove(this.curSvcWrapper.xmlNode);
            this.curItem.dispose();
            this.servicesNode.add(clonedNode);
            XMLNode aService = clonedNode;
            this.curItem = item = new TableTreeItem(this.tableTree, 0);
            item.setText(aService.getNodeName());
            item.setText(1, aService.getAttributesString());
            if (aService.getDocument() != null) {
                item.setText(2, aService.getDocument());
            }
            ServiceItemWrapper aWrapper = new ServiceItemWrapper(aService, this.serviceEditorProfile.getElement(aService.getNodeName()), item);
            aWrapper.setWrapperOwner(this);
            item.setData((Object)aWrapper);
            this.setServiceChildToTable(item, aService);
            TableTreeItem[] items = new TableTreeItem[]{item};
            this.tableTree.setSelection(items);
            this.editorBeanPropertyPanel.showWrapperProperties(aWrapper);
        }
    }

    private void deleteCurrentService() {
        if (this.servicesNode == null || this.curSvcWrapper == null) {
            return;
        }
        this.curSvcWrapper = null;
        this.curItem = null;
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Are_you_sure..._5"), (String)Messages.getString("ServiceMainPanel.Are_you_sure_to_delete_the_selected_Service_define__6"))) {
            return;
        }
        this.servicesNode.remove(this.curSvcWrapper.xmlNode);
        this.curItem.dispose();
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
    }

    public XMLNode getDataDictionary() {
        return this.dataDictionary;
    }

    public EditorProfile getDataEditorProfile() {
        return this.dataEditorProfile;
    }

    public XMLNode getCommonServiceNode() {
        return this.commonServiceNode;
    }

    public XMLNode getSelectedServiceNode() {
        TableTreeItem[] items = this.tableTree.getSelection();
        if (items.length != 1) {
            return null;
        }
        ServiceItemWrapper wrapper = (ServiceItemWrapper)items[0].getData();
        return wrapper.xmlNode;
    }

    public Vector getSelectedServices() {
        Vector<XMLNode> ret = new Vector<XMLNode>(10);
        TableTreeItem[] items = this.tableTree.getSelection();
        if (items.length == 0) {
            return ret;
        }
        int i = 0;
        while (i < items.length) {
            ServiceItemWrapper wrapper = (ServiceItemWrapper)items[i].getData();
            ret.addElement(wrapper.xmlNode);
            ++i;
        }
        return ret;
    }

    public XMLNode getSelfDefineNode() {
        return this.selfDefineNode;
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefineNode = node;
    }

    public XMLNode getExternResource() {
        return this.externResourceNode;
    }

    public void setExternResource(XMLNode node) {
        this.externResourceNode = node;
    }

    public void setDefaultAttributes(Element element, XMLNode node) {
        if (element == null || node == null) {
            return;
        }
        Vector attrs = element.getAttributes();
        if (attrs == null) {
            return;
        }
        int i = 0;
        while (i < attrs.size()) {
            ElementAttribute attr = (ElementAttribute)attrs.elementAt(i);
            String dftValue = attr.getDefaultValue();
            String attrId = attr.getAttrID();
            if (attrId != null && dftValue != null) {
                node.setAttrValue(attrId, dftValue);
            }
            ++i;
        }
    }

    public XMLNode getDataType() {
        return null;
    }

    public XMLNode getDataTypeDef() {
        return null;
    }

    public XMLNode getChannelSettings() {
        return this.channelSettings;
    }

    public void setChannelSettings(XMLNode channelSettings) {
        this.channelSettings = channelSettings;
    }

    public void fillContextMenu(IMenuManager mgr, Table table) {
        MenuManager menuManager = (MenuManager)mgr;
        menuManager.add((IAction)new produceMbeanAction(table));
        Menu menu = menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    public void setDataSource() {
        String wizardClass;
        String serviceId = "dataSource";
        String serviceType = "JDBCDriverDataSource";
        XMLNode node = this.servicesNode.getChildNode(serviceId);
        if (node != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Warning_5"), (String)Messages.getString("ServiceMainPanel.Duplicated_Service_ID_!_6"));
            return;
        }
        Element element = this.serviceEditorProfile.getElement(serviceType);
        if (element == null) {
            return;
        }
        if (element.getEditorProfile() == null) {
            element.setProfile(this.serviceEditorProfile);
        }
        if ((wizardClass = element.getWizardClassType()) == null || wizardClass.length() == 0) {
            wizardClass = "com.ecc.ide.editor.wizard.ServiceXMLDefineWizard";
        }
        try {
            ECCIDEWizard wizard = (ECCIDEWizard)((Object)Class.forName(wizardClass).newInstance());
            wizard.setEditorProfile(this.serviceEditorProfile);
            wizard.setDataEditorProfile(this.dataEditorProfile);
            wizard.setDataDictionary(this.dataDictionary);
            wizard.setCommonServiceNode(this.commonServiceNode);
            wizard.setRootPath(this.rootPath);
            wizard.setSelfDefineNode(this.selfDefineNode);
            XMLNode aNode = new XMLNode();
            aNode.setNodeName(serviceType);
            aNode.setAttrValue("id", serviceId);
            aNode.setDocument(this.descText.getText());
            this.setDefaultAttributes(element, aNode);
            wizard.setXMLNode(aNode);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                aNode = wizard.getXMLNode();
                this.servicesNode.add(aNode);
                XMLNode aService = aNode;
                TableTreeItem item = new TableTreeItem(this.tableTree, 0);
                item.setText(aService.getNodeName());
                item.setText(1, aService.getAttributesString());
                if (aService.getDocument() != null) {
                    item.setText(2, aService.getDocument());
                }
                ServiceItemWrapper wrapper = new ServiceItemWrapper(aService, this.serviceEditorProfile.getElement(aService.getNodeName()), item);
                wrapper.setWrapperOwner(this);
                item.setData((Object)wrapper);
                this.setServiceChildToTable(item, aService);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ServiceMainPanel.Error_30"), (String)(String.valueOf(Messages.getString("ServiceMainPanel.Internal_Error__n_31")) + e));
            e.printStackTrace();
        }
    }

    private class produceMbeanAction
    extends Action {
        final Table table;

        public produceMbeanAction(Table table) {
            this.table = table;
            this.setText("\u751f\u6210Mbean");
        }

        public void run() {
            TableItem[] item = this.table.getSelection();
            if (item.length > 1) {
                return;
            }
            MbeanAction mbeanAction = new MbeanAction(ServiceMainPanel.this.project, item[0].getText(), ServiceMainPanel.this.bizGrup);
            mbeanAction.run();
        }
    }
}

