/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.service;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.service.Messages;
import java.util.Vector;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ServiceSelectPanel
extends Composite {
    private Table serviceListTable;
    private XMLNode commonServiceNode;
    private XMLNode selfDefineNode;
    private String filterStr;

    public ServiceSelectPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(Messages.getString("ServiceSelectPanel.Please_select_the_service_1"));
        this.serviceListTable = new Table((Composite)this, 67584);
        this.serviceListTable.setLayoutData((Object)new GridData(1808));
        this.serviceListTable.setLinesVisible(true);
        this.serviceListTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.serviceListTable, 0);
        tableColumn.setWidth(136);
        tableColumn.setText(Messages.getString("ServiceSelectPanel.ServiceType_2"));
        TableColumn tableColumn_1 = new TableColumn(this.serviceListTable, 0);
        tableColumn_1.setWidth(167);
        tableColumn_1.setText(Messages.getString("ServiceSelectPanel.ServiceID_3"));
        TableColumn tableColumn_2 = new TableColumn(this.serviceListTable, 0);
        tableColumn_2.setWidth(256);
        tableColumn_2.setText(Messages.getString("ServiceSelectPanel.Document_4"));
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
        this.showCommonServiceToTable();
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefineNode = node;
        this.showSelfDefinedServiceToTable();
    }

    private void showCommonServiceToTable() {
        if (this.commonServiceNode != null) {
            Vector services = this.commonServiceNode.getChilds();
            int i = 0;
            while (services != null && i < services.size()) {
                XMLNode aNode = (XMLNode)services.elementAt(i);
                if (!("#text".equals(aNode.getNodeName()) || this.filterStr != null && this.filterStr.indexOf(aNode.getNodeName()) == -1)) {
                    TableItem item = new TableItem(this.serviceListTable, 0);
                    item.setText(aNode.getNodeName());
                    item.setText(1, aNode.getAttrValue("id"));
                    if (aNode.getAttrValue("desc") != null) {
                        item.setText(2, aNode.getAttrValue("desc"));
                    }
                    item.setData((Object)aNode);
                }
                ++i;
            }
        }
    }

    private void showSelfDefinedServiceToTable() {
        if (this.selfDefineNode == null || this.selfDefineNode.getChild("services") == null) {
            return;
        }
        XMLNode servicesNode = this.selfDefineNode.getChild("services");
        Vector services = servicesNode.getChilds();
        if (services == null) {
            return;
        }
        int i = 0;
        while (services != null && i < services.size()) {
            XMLNode aNode = (XMLNode)services.elementAt(i);
            if (!("#text".equals(aNode.getNodeName()) || this.filterStr != null && this.filterStr.indexOf(aNode.getNodeName()) == -1)) {
                TableItem item = new TableItem(this.serviceListTable, 0);
                item.setText(aNode.getNodeName());
                item.setText(1, aNode.getAttrValue("id"));
                if (aNode.getAttrValue("desc") != null) {
                    item.setText(2, aNode.getAttrValue("desc"));
                }
                item.setData((Object)aNode);
            }
            ++i;
        }
    }

    public XMLNode getSelectedService() {
        TableItem[] items = this.serviceListTable.getSelection();
        if (items.length != 1) {
            return null;
        }
        return (XMLNode)items[0].getData();
    }

    public void setFilter(String filterStr) {
        this.filterStr = filterStr;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

