/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.statemachine;

import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.flow.Messages;
import com.ecc.ide.editor.statemachine.StateMachineVisualPanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CommonStateMachinePanel
extends Composite
implements ContentChangedListener {
    private Table table;
    private Text descText;
    private Text flowNameText;
    private Text flowIDText;
    private boolean isCommonStatesChanged = false;
    private StateMachineVisualPanel visualFlowPanel;
    private XMLNode curState;
    private EditorProfile stateMachineProfile;
    private EditorProfile stateProfile;
    private XMLNode commonStates;
    private int[] weights = new int[2];
    private XMLNode flowNode;
    private Vector stateAttrs;
    private XMLNode commonServiceNode;
    private XMLNode selfDefineNode;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;

    public CommonStateMachinePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        final SashForm sashForm_1 = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm_1, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("CommonStateMachinePanel.StateMachineID__1"));
        this.flowIDText = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.flowIDText.setLayoutData((Object)gridData);
        Label label_1 = new Label(composite, 0);
        GridData gridData_1 = new GridData(256);
        gridData_1.horizontalSpan = 3;
        label_1.setLayoutData((Object)gridData_1);
        label_1.setText(Messages.getString("CommonStateMachinePanel.StateMachineName__2"));
        this.flowNameText = new Text(composite, 2048);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 3;
        this.flowNameText.setLayoutData((Object)gridData_2);
        Label label_2 = new Label(composite, 0);
        GridData gridData_3 = new GridData(256);
        gridData_3.horizontalSpan = 3;
        label_2.setLayoutData((Object)gridData_3);
        label_2.setText(Messages.getString("FlowFramePanel.Document__3"));
        this.descText = new Text(composite, 2818);
        GridData gridData_4 = new GridData(768);
        gridData_4.heightHint = 68;
        gridData_4.horizontalSpan = 3;
        this.descText.setLayoutData((Object)gridData_4);
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_6 = new GridData();
        gridData_6.horizontalSpan = 3;
        composite_2.setLayoutData((Object)gridData_6);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_2.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite_2, 0);
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 80;
        button.setLayoutData((Object)gridData_7);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonStateMachinePanel.this.addNewFlow();
            }
        });
        button.setText(Messages.getString("FlowFramePanel.Add_4"));
        Button button_1 = new Button(composite_2, 0);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 80;
        button_1.setLayoutData((Object)gridData_8);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonStateMachinePanel.this.deleteFlow();
            }
        });
        button_1.setText(Messages.getString("FlowFramePanel.Remove_5"));
        Button button_2 = new Button(composite_2, 0);
        GridData gridData_9 = new GridData();
        gridData_9.widthHint = 80;
        button_2.setLayoutData((Object)gridData_9);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonStateMachinePanel.this.updateFlow();
            }
        });
        button_2.setText(Messages.getString("FlowFramePanel.Update_6"));
        this.table = new Table(composite, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonStateMachinePanel.this.setActiveFlow();
            }
        });
        GridData gridData_5 = new GridData(1808);
        gridData_5.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData_5);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(64);
        tableColumn.setText(Messages.getString("CommonStateMachinePanel.StateMachineID_3"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(77);
        tableColumn_1.setText(Messages.getString("CommonStateMachinePanel.StateMachineName_4"));
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(81);
        tableColumn_2.setText(Messages.getString("CommonStateMachinePanel.Document_5"));
        Composite composite_1 = new Composite((Composite)sashForm_1, 0);
        composite_1.setLayout((Layout)new FillLayout());
        CTabFolder tabFolder = new CTabFolder(composite_1, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                int[] ws = sashForm_1.getWeights();
                if (ws[0] == 0) {
                    sashForm_1.setWeights(CommonStateMachinePanel.this.weights);
                    CommonStateMachinePanel.this.layout(true);
                } else {
                    int[] nArray = new int[2];
                    nArray[1] = 400;
                    sashForm_1.setWeights(nArray);
                    CommonStateMachinePanel.this.layout(true);
                    ((CommonStateMachinePanel)CommonStateMachinePanel.this).weights[0] = ws[0];
                    ((CommonStateMachinePanel)CommonStateMachinePanel.this).weights[1] = ws[1];
                }
            }
        });
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("visualDesign"));
        this.visualFlowPanel = new StateMachineVisualPanel((Composite)tabFolder, 0);
        tabItem.setControl((Control)this.visualFlowPanel);
        tabFolder.setSelection(0);
        gridLayout.numColumns = 3;
        this.weights[0] = 100;
        this.weights[1] = 400;
        sashForm_1.setWeights(this.weights);
    }

    public void dispose() {
        super.dispose();
        this.commonStates.removeContentChangedListener(this);
    }

    protected void checkSubclass() {
    }

    public Object getSelectedStateMachine() {
        return this.curState;
    }

    private void addNewFlow() {
        if (this.flowNode == null) {
            return;
        }
        String flowId = this.flowIDText.getText();
        if (flowId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_1"), (String)Messages.getString("CommonStateMachinePanel.Please_input_proper_StateMachine_ID_!_6"));
            return;
        }
        if (this.flowNode.findChildNode(flowId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_3"), (String)Messages.getString("CommonStateMachinePanel.Duplicated_StateMachine_ID_!_7"));
            return;
        }
        String flowName = this.flowNameText.getText();
        if (flowName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_5"), (String)Messages.getString("CommonStateMachinePanel.Please_input_proper_StateMachine_Name_!_8"));
            return;
        }
        String desc = this.descText.getText();
        XMLNode node = new XMLNode();
        node.setNodeName("StateMachine");
        node.setAttrValue("id", flowId);
        node.setAttrValue("name", flowName);
        node.setDocument(desc);
        this.flowNode.add(node);
        TableItem item = new TableItem(this.table, 0);
        item.setText(flowId);
        item.setData((Object)node);
        item.setText(1, flowName);
        item.setText(2, desc);
        TableItem[] items = new TableItem[]{item};
        this.table.setSelection(items);
        this.setActiveFlow();
    }

    private void deleteFlow() {
        TableItem[] selects = this.table.getSelection();
        if (selects == null || selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_1"), (String)Messages.getString("FlowFramePanel.Are_you_sure_to_delete_the_selected_flow_define__2"))) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        this.flowNode.remove(node);
        selects[0].dispose();
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(0);
            this.setActiveFlow();
        } else {
            try {
                this.visualFlowPanel.setXMLContent(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateFlow() {
        TableItem[] selects = this.table.getSelection();
        if (selects == null || selects.length != 1) {
            return;
        }
        this.curState = (XMLNode)selects[0].getData();
        try {
            String flowId = this.flowIDText.getText();
            String flowName = this.flowNameText.getText();
            String docStr = this.descText.getText();
            if (flowId.length() == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_1"), (String)Messages.getString("FlowFramePanel.Please__input_proper_Flow_ID_!_2"));
                return;
            }
            XMLNode aNode = this.flowNode.findChildNode(flowId);
            if (aNode != null && aNode != this.curState) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_3"), (String)Messages.getString("CommonStateMachinePanel.Duplicated_StateMachine_ID_!_9"));
                return;
            }
            if (flowName.length() == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_5"), (String)Messages.getString("CommonStateMachinePanel.Please_input_proper_StateMachine_Name_!_10"));
                return;
            }
            if (!flowId.equals(this.curState.getAttrValue("id")) && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Are_you_sure..._1"), (String)Messages.getString("CommonStateMachinePanel.You_have_change_the_stateMachine_ID,_so_you_have_to_change_all_the_Operation_refer_to_this_stateMachine_manually_!_11"))) {
                return;
            }
            this.curState.setAttrValue("id", flowId);
            this.curState.setAttrValue("name", flowName);
            this.curState.setDocument(docStr);
            selects[0].setText(flowId);
            selects[0].setText(1, flowName);
            selects[0].setText(2, docStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setActiveFlow() {
        TableItem[] selects = this.table.getSelection();
        if (selects == null || selects.length != 1) {
            return;
        }
        if ((XMLNode)selects[0].getData() == this.curState) {
            return;
        }
        this.curState = (XMLNode)selects[0].getData();
        try {
            this.visualFlowPanel.setXMLContent(this.curState);
            this.flowIDText.setText(this.curState.getAttrValue("id"));
            this.flowNameText.setText(this.curState.getAttrValue("name"));
            this.descText.setText(this.curState.getDocument());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXMLNode(XMLNode node) {
        this.flowNode = node;
        Vector childs = node.getChilds();
        this.table.removeAll();
        int i = 0;
        while (i < childs.size()) {
            XMLNode stateNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(stateNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(stateNode.getAttrValue("id"));
                if (stateNode.getAttrValue("name") != null) {
                    item.setText(1, stateNode.getAttrValue("name"));
                }
                if (stateNode.getDocument() != null) {
                    item.setText(2, stateNode.getDocument());
                }
                item.setData((Object)stateNode);
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.table.setSelection(0);
            this.setActiveFlow();
        }
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Teller client common flow test");
        CommonStateMachinePanel test = new CommonStateMachinePanel((Composite)shell, 2048);
        XMLNode node = null;
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/stateMachineProfile.xml");
            test.setStateMachineEditorProfile(profile);
            EditorProfile stateProfile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/tellerStatesProfile.xml");
            test.setStateProfile(stateProfile);
            XMLLoader xmlLoader1 = new XMLLoader();
            xmlLoader1.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode commStates = (XMLNode)xmlLoader1.loadXMLFile("/tellerStates.xml");
            test.setCommonStates(commStates);
            node = (XMLNode)xmlLoader1.loadXMLFile("/tellerFlows.xml");
            test.setXMLNode(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test.layout();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        StringBuffer strBuf = new StringBuffer();
        node.toXMLContent(0, strBuf);
        try {
            FileWriter fw = new FileWriter("tellerFlows.xml");
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        if (this.visualFlowPanel != null) {
            this.visualFlowPanel.setDataDictionary(node);
        }
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
        if (this.visualFlowPanel != null) {
            this.visualFlowPanel.setDataEditorProfile(profile);
        }
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
        if (this.visualFlowPanel != null) {
            this.visualFlowPanel.setCommonServiceNode(node);
        }
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefineNode = node;
        if (this.visualFlowPanel != null) {
            this.visualFlowPanel.setSelfDefineNode(node);
        }
    }

    public void setStateMachineEditorProfile(EditorProfile profile) {
        this.stateMachineProfile = profile;
    }

    public void setStateProfile(EditorProfile profile) {
        this.stateProfile = profile;
    }

    public void setCommonStates(XMLNode states) {
        this.commonStates = states;
        this.commonStates.addContentChangedListener(this, null, 0);
        this.visualFlowPanel.setCommonStates(states);
        if (this.stateMachineProfile == null) {
            System.out.println("Please set the profile first!");
            return;
        }
        EditorProfile newStateMachineProfile = (EditorProfile)this.stateMachineProfile.clone();
        Element processorElement = newStateMachineProfile.getElement("StateMachine");
        if (processorElement == null) {
            System.out.println(Messages.getString("CommonStateMachinePanel.Valid_Profile_file_for_common_flow_define_!,_Element_StateMachine_not_defined_!_16"));
            return;
        }
        ElementCatalog catalog = null;
        int i = 0;
        while (i < newStateMachineProfile.getCagalogs().size()) {
            ElementCatalog aCatalog = (ElementCatalog)newStateMachineProfile.getCagalogs().elementAt(i);
            if ("commonStates".equals(aCatalog.getCatalogName())) {
                catalog = aCatalog;
                break;
            }
            ++i;
        }
        if (catalog == null) {
            System.out.println("Valid Profile file for common flow define!");
            return;
        }
        Element stateElement = catalog.getElement("virtualState");
        catalog.deleteElement(stateElement);
        this.stateAttrs = stateElement.getAttributes();
        Vector childs = states.getChilds();
        int i2 = 0;
        while (i2 < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i2);
            if (!"#text".equals(node.getNodeName())) {
                Element element = new Element();
                element.setElementName(node.getAttrValue("id"));
                element.setLabel(node.getAttrValue("name"));
                element.setIconName("/images/db_obj.gif");
                element.setWrapperClassType("com.ecc.ide.editor.statemachine.StateElementWrapper");
                String statesStr = node.getAttrValue("states");
                if (statesStr != null) {
                    Vector<Object> attrs;
                    ElementAttribute attr = new ElementAttribute();
                    attr.setAttrID("states");
                    attr.setValueListStr(statesStr);
                    if (this.stateAttrs != null) {
                        attrs = (Vector<Object>)this.stateAttrs.clone();
                        attrs.addElement(attr);
                        element.setAttributes(attrs);
                    } else {
                        attrs = new Vector<Object>(10);
                        attrs.addElement(attrs);
                        element.setAttributes(attrs);
                    }
                } else if (this.stateAttrs != null) {
                    element.setAttributes((Vector)this.stateAttrs.clone());
                }
                catalog.addElement(element);
                ElementChild child = new ElementChild();
                child.setChildElementId(element.getElementName());
                child.setAllowCount("1");
                processorElement.addChild(child);
            }
            ++i2;
        }
        ElementChild child = new ElementChild();
        child.setChildElementId("State");
        child.setAllowCount("*");
        processorElement.addChild(child);
        if (this.stateProfile != null) {
            EditorProfile profile = (EditorProfile)this.stateProfile.clone();
            int i3 = 0;
            while (i3 < profile.getCagalogs().size()) {
                ElementCatalog aCatalog = (ElementCatalog)profile.getCagalogs().elementAt(i3);
                if ("Flow".equals(aCatalog.getCatalogName())) {
                    aCatalog.deleteElement(aCatalog.getElement("transition"));
                    aCatalog.deleteElement(aCatalog.getElement("flow"));
                    aCatalog.getElement("State").setWrapperClassType("com.ecc.ide.editor.statemachine.StateElementWrapper");
                    aCatalog.setLabel("Self Defined State");
                }
                aCatalog.setShowInToolPanel(true);
                newStateMachineProfile.addElementCatalog(aCatalog);
                ++i3;
            }
        }
        this.visualFlowPanel.setEditorProfile(newStateMachineProfile);
    }

    public void updateCommonStates() {
        if (this.stateMachineProfile == null) {
            return;
        }
        EditorProfile newStateMachineProfile = (EditorProfile)this.stateMachineProfile.clone();
        Element processorElement = newStateMachineProfile.getElement("StateMachine");
        if (processorElement == null) {
            System.out.println("Valid Profile file for common flow define!, Element StateMachine not defined!");
            return;
        }
        ElementCatalog catalog = null;
        int i = 0;
        while (i < newStateMachineProfile.getCagalogs().size()) {
            ElementCatalog aCatalog = (ElementCatalog)newStateMachineProfile.getCagalogs().elementAt(i);
            if ("commonStates".equals(aCatalog.getCatalogName())) {
                catalog = aCatalog;
                break;
            }
            ++i;
        }
        if (catalog == null) {
            System.out.println("Valid Profile file for common flow define!");
            return;
        }
        Element stateElement = catalog.getElement("virtualState");
        catalog.deleteElement(stateElement);
        this.stateAttrs = stateElement.getAttributes();
        Vector childs = this.commonStates.getChilds();
        int i2 = 0;
        while (i2 < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i2);
            if (!"#text".equals(node.getNodeName())) {
                Element element = new Element();
                element.setElementName(node.getAttrValue("id"));
                element.setLabel(node.getAttrValue("name"));
                element.setIconName("/images/db_obj.gif");
                element.setWrapperClassType("com.ecc.ide.editor.statemachine.StateElementWrapper");
                String statesStr = node.getAttrValue("states");
                if (statesStr != null) {
                    Vector<Object> attrs;
                    ElementAttribute attr = new ElementAttribute();
                    attr.setAttrID("states");
                    attr.setValueListStr(statesStr);
                    if (this.stateAttrs != null) {
                        attrs = (Vector<Object>)this.stateAttrs.clone();
                        attrs.addElement(attr);
                        element.setAttributes(attrs);
                    } else {
                        attrs = new Vector<Object>(10);
                        attrs.addElement(attrs);
                        element.setAttributes(attrs);
                    }
                } else if (this.stateAttrs != null) {
                    element.setAttributes((Vector)this.stateAttrs.clone());
                }
                catalog.addElement(element);
                ElementChild child = new ElementChild();
                child.setChildElementId(element.getElementName());
                child.setAllowCount("1");
                processorElement.addChild(child);
            }
            ++i2;
        }
        ElementChild child = new ElementChild();
        child.setChildElementId("State");
        child.setAllowCount("*");
        processorElement.addChild(child);
        if (this.stateProfile != null) {
            EditorProfile profile = (EditorProfile)this.stateProfile.clone();
            int i3 = 0;
            while (i3 < profile.getCagalogs().size()) {
                ElementCatalog aCatalog = (ElementCatalog)profile.getCagalogs().elementAt(i3);
                if ("Flow".equals(aCatalog.getCatalogName())) {
                    aCatalog.deleteElement(aCatalog.getElement("transition"));
                    aCatalog.deleteElement(aCatalog.getElement("flow"));
                    aCatalog.getElement("State").setWrapperClassType("com.ecc.ide.editor.statemachine.StateElementWrapper");
                    aCatalog.setLabel("Self Defined State");
                }
                aCatalog.setShowInToolPanel(true);
                newStateMachineProfile.addElementCatalog(aCatalog);
                ++i3;
            }
        }
        this.visualFlowPanel.setEditorProfile(newStateMachineProfile);
    }

    public void updateStateMachineProfile() {
        if (this.isCommonStatesChanged) {
            this.updateCommonStates();
            this.isCommonStatesChanged = false;
            this.curState = null;
            this.setActiveFlow();
        }
    }

    public void contentChanged(ContentChangedEvent event) {
        this.isCommonStatesChanged = true;
    }
}

