/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.statemachine;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.statemachine.Messages;
import com.ecc.ide.editor.statemachine.StateMachineVisualPanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.FileWriter;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CommonStatePanel
extends Composite {
    private Table table;
    private Text descText;
    private Text flowNameText;
    private Text flowIDText;
    private StateMachineVisualPanel visualFlowPanel;
    private int[] weights = new int[2];
    private XMLNode curState;
    private EditorProfile flowProfile;
    private Vector flowAttributes = new Vector();
    private XMLNode flowNode;
    private XMLNode commonServiceNode;
    private XMLNode selfDefineNode;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;

    public CommonStatePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        final SashForm sashForm_1 = new SashForm((Composite)this, 0);
        Composite composite = new Composite((Composite)sashForm_1, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("CommonStatePanel.StateID__1"));
        this.flowIDText = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.flowIDText.setLayoutData((Object)gridData);
        Label label_1 = new Label(composite, 0);
        GridData gridData_1 = new GridData(256);
        gridData_1.horizontalSpan = 3;
        label_1.setLayoutData((Object)gridData_1);
        label_1.setText(Messages.getString("CommonStatePanel.StateName__2"));
        this.flowNameText = new Text(composite, 2048);
        GridData gridData_2 = new GridData(768);
        gridData_2.horizontalSpan = 3;
        this.flowNameText.setLayoutData((Object)gridData_2);
        Label label_2 = new Label(composite, 0);
        GridData gridData_3 = new GridData(256);
        gridData_3.horizontalSpan = 3;
        label_2.setLayoutData((Object)gridData_3);
        label_2.setText(Messages.getString("FlowFramePanel.Document__3"));
        this.descText = new Text(composite, 2818);
        GridData gridData_4 = new GridData(768);
        gridData_4.heightHint = 68;
        gridData_4.horizontalSpan = 3;
        this.descText.setLayoutData((Object)gridData_4);
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_6 = new GridData();
        gridData_6.horizontalSpan = 3;
        composite_2.setLayoutData((Object)gridData_6);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_2.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite_2, 0);
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 80;
        button.setLayoutData((Object)gridData_7);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonStatePanel.this.addNewFlow();
            }
        });
        button.setText(Messages.getString("FlowFramePanel.Add_4"));
        Button button_1 = new Button(composite_2, 0);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 80;
        button_1.setLayoutData((Object)gridData_8);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonStatePanel.this.deleteFlow();
            }
        });
        button_1.setText(Messages.getString("FlowFramePanel.Remove_5"));
        Button button_2 = new Button(composite_2, 0);
        GridData gridData_9 = new GridData();
        gridData_9.widthHint = 80;
        button_2.setLayoutData((Object)gridData_9);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonStatePanel.this.updateFlow();
            }
        });
        button_2.setText(Messages.getString("FlowFramePanel.Update_6"));
        this.table = new Table(composite, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonStatePanel.this.setActiveFlow();
            }
        });
        GridData gridData_5 = new GridData(1808);
        gridData_5.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData_5);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(64);
        tableColumn.setText(Messages.getString("CommonStatePanel.StateID_3"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(77);
        tableColumn_1.setText(Messages.getString("CommonStatePanel.StateName_4"));
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(81);
        tableColumn_2.setText(Messages.getString("CommonStatePanel.Document_5"));
        Composite composite_1 = new Composite((Composite)sashForm_1, 0);
        composite_1.setLayout((Layout)new FillLayout());
        CTabFolder tabFolder = new CTabFolder(composite_1, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                int[] ws = sashForm_1.getWeights();
                if (ws[0] == 0) {
                    sashForm_1.setWeights(CommonStatePanel.this.weights);
                    CommonStatePanel.this.layout(true);
                } else {
                    int[] nArray = new int[2];
                    nArray[1] = 400;
                    sashForm_1.setWeights(nArray);
                    CommonStatePanel.this.layout(true);
                    ((CommonStatePanel)CommonStatePanel.this).weights[0] = ws[0];
                    ((CommonStatePanel)CommonStatePanel.this).weights[1] = ws[1];
                }
            }
        });
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("visualDesign"));
        this.visualFlowPanel = new StateMachineVisualPanel((Composite)tabFolder, 0);
        tabItem.setControl((Control)this.visualFlowPanel);
        tabFolder.setSelection(0);
        gridLayout.numColumns = 3;
        this.weights[0] = 100;
        this.weights[1] = 400;
        sashForm_1.setWeights(this.weights);
    }

    public void setEditorProfile(EditorProfile profile) {
        this.visualFlowPanel.setEditorProfile(profile);
        this.flowProfile = profile;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Object getSelectedDatas() {
        return this.curState;
    }

    private void addNewFlow() {
        if (this.flowNode == null) {
            return;
        }
        String flowId = this.flowIDText.getText();
        if (flowId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_1"), (String)Messages.getString("CommonStatePanel.Please_input_proper_State_ID_!_6"));
            return;
        }
        if (this.flowNode.findChildNode(flowId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_3"), (String)Messages.getString("CommonStatePanel.Duplicated_State_ID_!_7"));
            return;
        }
        String flowName = this.flowNameText.getText();
        if (flowName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_5"), (String)Messages.getString("CommonStatePanel.Please_input_proper_State_Name_!_8"));
            return;
        }
        String desc = this.descText.getText();
        XMLNode node = new XMLNode();
        node.setNodeName("State");
        node.setAttrValue("id", flowId);
        node.setAttrValue("name", flowName);
        node.setDocument(desc);
        this.flowNode.add(node);
        TableItem item = new TableItem(this.table, 0);
        item.setText(flowId);
        item.setData((Object)node);
        item.setText(1, flowName);
        item.setText(2, desc);
        TableItem[] items = new TableItem[]{item};
        this.table.setSelection(items);
        this.setActiveFlow();
    }

    private void deleteFlow() {
        TableItem[] selects = this.table.getSelection();
        if (selects == null || selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_1"), (String)Messages.getString("FlowFramePanel.Are_you_sure_to_delete_the_selected_flow_define__2"))) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        this.flowNode.remove(node);
        selects[0].dispose();
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(0);
            this.setActiveFlow();
        } else {
            try {
                this.visualFlowPanel.setXMLContent(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateFlow() {
        TableItem[] selects = this.table.getSelection();
        if (selects == null || selects.length != 1) {
            return;
        }
        this.curState = (XMLNode)selects[0].getData();
        try {
            String flowId = this.flowIDText.getText();
            String flowName = this.flowNameText.getText();
            String docStr = this.descText.getText();
            if (flowId.length() == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_1"), (String)Messages.getString("FlowFramePanel.Please__input_proper_Flow_ID_!_2"));
                return;
            }
            XMLNode aNode = this.flowNode.findChildNode(flowId);
            if (aNode != null && aNode != this.curState) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_3"), (String)Messages.getString("CommonStatePanel.Duplicated_State_ID_!_9"));
                return;
            }
            if (flowName.length() == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Warning_5"), (String)Messages.getString("CommonStatePanel.Please_input_proper_State_Name_!_10"));
                return;
            }
            if (!flowId.equals(this.curState.getAttrValue("id")) && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("FlowFramePanel.Are_you_sure..._1"), (String)Messages.getString("CommonStatePanel.You_have_change_the_state_ID,_so_you_have_to_change_all_the_common_flow_refer_to_this_state_manually_!_11"))) {
                return;
            }
            this.curState.setAttrValue("id", flowId);
            this.curState.setAttrValue("name", flowName);
            this.curState.setDocument(docStr);
            selects[0].setText(flowId);
            selects[0].setText(1, flowName);
            selects[0].setText(2, docStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setActiveFlow() {
        TableItem[] selects = this.table.getSelection();
        if (selects == null || selects.length != 1) {
            return;
        }
        if ((XMLNode)selects[0].getData() == this.curState) {
            return;
        }
        this.curState = (XMLNode)selects[0].getData();
        try {
            this.visualFlowPanel.setXMLContent(this.curState);
            this.flowIDText.setText(this.curState.getAttrValue("id"));
            this.flowNameText.setText(this.curState.getAttrValue("name"));
            this.descText.setText(this.curState.getDocument());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXMLNode(XMLNode node) {
        this.flowNode = node;
        Vector childs = node.getChilds();
        this.table.removeAll();
        int i = 0;
        while (i < childs.size()) {
            XMLNode stateNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(stateNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(stateNode.getAttrValue("id"));
                if (stateNode.getAttrValue("name") != null) {
                    item.setText(1, stateNode.getAttrValue("name"));
                }
                if (stateNode.getDocument() != null) {
                    item.setText(2, stateNode.getDocument());
                }
                item.setData((Object)stateNode);
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.table.setSelection(0);
            this.setActiveFlow();
        }
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Teller Common States define");
        CommonStatePanel test = new CommonStatePanel((Composite)shell, 2048);
        XMLNode node = null;
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/tellerStatesProfile.xml");
            test.setEditorProfile(profile);
            XMLLoader xmlLoader1 = new XMLLoader();
            xmlLoader1.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            node = (XMLNode)xmlLoader1.loadXMLFile("/tellerStates.xml");
            test.setXMLNode(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test.layout();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        StringBuffer strBuf = new StringBuffer();
        node.toXMLContent(0, strBuf);
        try {
            FileWriter fw = new FileWriter("tellerStates.xml");
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        if (this.visualFlowPanel != null) {
            this.visualFlowPanel.setDataDictionary(node);
        }
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
        if (this.visualFlowPanel != null) {
            this.visualFlowPanel.setDataEditorProfile(profile);
        }
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
        if (this.visualFlowPanel != null) {
            this.visualFlowPanel.setCommonServiceNode(node);
        }
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefineNode = node;
        if (this.visualFlowPanel != null) {
            this.visualFlowPanel.setSelfDefineNode(node);
        }
    }
}

