/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.statemachine;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.statemachine.StateMachineViewer;
import com.ecc.ide.editor.statemachine.StateMachineVisualPanel;
import com.ecc.ide.editor.visualflow.ActionElementWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class StateElementWrapper
extends ActionElementWrapper {
    XMLNode stateNode = null;

    public StateElementWrapper() {
    }

    public StateElementWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        int i;
        if (this.stateNode == null) {
            if (this.editor instanceof StateMachineVisualPanel) {
                try {
                    this.stateNode = ((StateMachineVisualPanel)this.editor).getCommonStates().findChildNode(this.element.getElementName());
                }
                catch (Exception exception) {}
            } else if (this.editor instanceof StateMachineViewer) {
                try {
                    this.stateNode = ((StateMachineViewer)this.editor).getCommonStates().findChildNode(this.element.getElementName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        gc.fillRectangle(x, y, this.width, this.height);
        gc.setForeground(Display.getDefault().getSystemColor(2));
        Image image = this.element.getImage();
        int txtY = y + 3;
        if (image != null) {
            int imWidth = image.getBounds().width;
            gc.drawImage(image, x + (this.width - imWidth) / 2, y + 3);
            txtY = txtY + image.getBounds().height + 2;
        }
        String label = this.getElement().getLabel();
        int w = gc.getFontMetrics().getAverageCharWidth() * label.getBytes().length;
        int h = gc.getFontMetrics().getHeight();
        gc.drawText(label, x + (this.width - w) / 2, txtY);
        gc.drawLine(x, txtY + h + 3, x + this.width, txtY + h + 3);
        txtY += h + 10;
        if (this.stateNode != null) {
            i = 0;
            while (i < this.stateNode.getChilds().size()) {
                XMLNode node = (XMLNode)this.stateNode.getChilds().elementAt(i);
                if (!"document".equals(node.getNodeName()) && !"#text".equals(node.getNodeName())) {
                    gc.drawText(node.getNodeName(), x + 10, txtY);
                    txtY += h + 3;
                }
                ++i;
            }
        }
        gc.drawRoundRectangle(x, y, this.width, this.height, 10, 10);
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.paintControl(gc, x, y);
            ++i;
        }
        gc.setClipping(parentClipRect);
    }
}

