/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.statemachine;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.statemachine.CommonStateMachinePanel;
import com.ecc.ide.editor.statemachine.CommonStatePanel;
import com.ecc.ide.editor.statemachine.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.FileWriter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class StateMachineFramePanel
extends Composite {
    private CommonStatePanel statePanel;
    private CommonStateMachinePanel stateMachinePanel;
    private XMLNode commonServiceNode;
    private XMLNode selfDefineNode;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;

    public StateMachineFramePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        final TabFolder tabFolder = new TabFolder((Composite)this, 0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StateMachineFramePanel.this.setActivateTabFolder(tabFolder.getSelectionIndex());
            }
        });
        TabItem tabItem_1 = new TabItem(tabFolder, 0);
        tabItem_1.setText(Messages.getString("StateMachineFramePanel.StateMachine_1"));
        this.stateMachinePanel = new CommonStateMachinePanel((Composite)tabFolder, 0);
        tabItem_1.setControl((Control)this.stateMachinePanel);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("StateMachineFramePanel.Common_States_2"));
        this.statePanel = new CommonStatePanel((Composite)tabFolder, 0);
        tabItem.setControl((Control)this.statePanel);
    }

    private void setActivateTabFolder(int idx) {
        if (idx == 0 && this.stateMachinePanel != null) {
            this.stateMachinePanel.updateStateMachineProfile();
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.stateMachinePanel.setDataDictionary(node);
        this.statePanel.setDataDictionary(node);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
        this.stateMachinePanel.setDataEditorProfile(profile);
        this.statePanel.setDataEditorProfile(profile);
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonServiceNode = node;
        this.stateMachinePanel.setCommonServiceNode(node);
        this.statePanel.setCommonServiceNode(node);
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefineNode = node;
        this.stateMachinePanel.setSelfDefineNode(node);
        this.statePanel.setSelfDefineNode(node);
    }

    public void setStateMachineEditorProfile(EditorProfile profile) {
        this.stateMachinePanel.setStateMachineEditorProfile(profile);
    }

    public void setStateEditorProfile(EditorProfile profile) {
        this.statePanel.setEditorProfile(profile);
        this.stateMachinePanel.setStateProfile(profile);
    }

    public void setCommonStates(XMLNode states) {
        this.statePanel.setXMLNode(states);
        this.stateMachinePanel.setCommonStates(states);
    }

    public void setCommonStateMachine(XMLNode flow) {
        this.stateMachinePanel.setXMLNode(flow);
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Teller client common flow test");
        StateMachineFramePanel test = new StateMachineFramePanel((Composite)shell, 2048);
        XMLNode node = null;
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/stateMachineProfile.xml");
            test.setStateMachineEditorProfile(profile);
            EditorProfile stateProfile = (EditorProfile)xmlLoader.loadXMLFile("/profiles/tellerStatesProfile.xml");
            test.setStateEditorProfile(stateProfile);
            XMLLoader xmlLoader1 = new XMLLoader();
            xmlLoader1.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode commStates = (XMLNode)xmlLoader1.loadXMLFile("/tellerStates.xml");
            test.setCommonStates(commStates);
            node = (XMLNode)xmlLoader1.loadXMLFile("/tellerFlows.xml");
            test.setCommonStateMachine(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test.layout();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        StringBuffer strBuf = new StringBuffer();
        node.toXMLContent(0, strBuf);
        try {
            FileWriter fw = new FileWriter("tellerFlows.xml");
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

