/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.statemachine;

import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.SearchClass;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.statemachine.Messages;
import com.ecc.ide.editor.statemachine.StateMachineSelectDialog;
import com.ecc.ide.editor.statemachine.StateMachineViewer;
import com.ecc.ide.editor.statemachine.StateMachineVisualPanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import java.util.Vector;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TrxStateMachinePanel
extends Composite
implements ContentChangedListener {
    private Text flowClassNameText;
    private Text mainFlowIDText;
    private Button refMainFlowButton;
    private Button specialFlowButton;
    private boolean isCommonChanged = false;
    private EditorProfile stateMachineProfile;
    private EditorProfile stateProfile;
    private XMLNode commonStates;
    private XMLNode commonStateMachineNode;
    private StateMachineViewer visualEditorContentViewer;
    private StateMachineVisualPanel visualFramePanel;
    private Composite refFlowComposite;
    private Composite specialFlowComposite;
    private StackLayout stackLayout;
    private Vector stateAttrs;
    private XMLNode trxNode;
    private XMLNode commonSvcNode;
    private XMLNode selfDefNode;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;

    public void setTrxNode(XMLNode node) {
        XMLNode refFlow;
        this.trxNode = node;
        XMLNode stateMachineNode = node.getChild("StateMachine");
        if (stateMachineNode == null) {
            stateMachineNode = new XMLNode();
            stateMachineNode.setNodeName("StateMachine");
            node.add(stateMachineNode);
        }
        Element element = new Element();
        element.setElementName("StateMachine");
        try {
            this.visualFramePanel.setXMLContent(stateMachineNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        XMLNode refFlowNode = this.trxNode.getChild("refStateMachine");
        if (refFlowNode != null && (refFlow = this.commonStateMachineNode.findChildNode(refFlowNode.getAttrValue("refId"))) != null) {
            this.setMainStateMachine(refFlow);
        }
        boolean refToMainFlow = "true".equals(node.getAttrValue("refToStateMachine"));
        this.refMainFlowButton.setSelection(refToMainFlow);
        this.specialFlowButton.setSelection(!refToMainFlow);
        this.setActivateComposite(refToMainFlow);
    }

    public TrxStateMachinePanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.marginWidth = 2;
        gridLayout_3.marginHeight = 5;
        gridLayout_3.numColumns = 2;
        this.setLayout((Layout)gridLayout_3);
        this.refMainFlowButton = new Button((Composite)this, 16);
        this.refMainFlowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxStateMachinePanel.this.setActivateComposite(TrxStateMachinePanel.this.refMainFlowButton.getSelection());
            }
        });
        this.refMainFlowButton.setSelection(true);
        this.refMainFlowButton.setText(Messages.getString("TrxFlowPanel.Refer_to_common_defined_transaction_flow_8"));
        this.specialFlowButton = new Button((Composite)this, 16);
        this.specialFlowButton.setText(Messages.getString("TrxFlowPanel.Specified_transaction_flow_9"));
        Composite stackComposite = new Composite((Composite)this, 0);
        this.stackLayout = new StackLayout();
        stackComposite.setLayout((Layout)this.stackLayout);
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 2;
        stackComposite.setLayoutData((Object)gridData_1);
        this.specialFlowComposite = new Composite(stackComposite, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.marginWidth = 0;
        gridLayout_1.marginHeight = 0;
        gridLayout_1.horizontalSpacing = 2;
        gridLayout_1.numColumns = 5;
        this.specialFlowComposite.setLayout((Layout)gridLayout_1);
        Label label = new Label(this.specialFlowComposite, 0);
        label.setText(Messages.getString("TrxFlowPanel.Flow_Implement_class__1"));
        this.flowClassNameText = new Text(this.specialFlowComposite, 2048);
        this.flowClassNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.flowClassNameText.setLayoutData((Object)new GridData(768));
        Button button_2 = new Button(this.specialFlowComposite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxStateMachinePanel.this.selectFlowClass();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 53;
        button_2.setLayoutData((Object)gridData_3);
        button_2.setText(">>");
        Button button_1 = new Button(this.specialFlowComposite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxStateMachinePanel.this.selectReferenceFlow();
            }
        });
        GridData gridData_6 = new GridData();
        button_1.setLayoutData((Object)gridData_6);
        button_1.setText(Messages.getString("TrxFlowPanel.Common_flow_reference_2"));
        Button button_3 = new Button(this.specialFlowComposite, 0x800084);
        button_3.setLayoutData((Object)new GridData(128));
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxStateMachinePanel.this.maximizedEdit();
            }
        });
        button_3.setToolTipText("maximize");
        this.visualFramePanel = new StateMachineVisualPanel(this.specialFlowComposite, 0);
        GridData gridData_2 = new GridData(1808);
        gridData_2.horizontalSpan = 5;
        this.visualFramePanel.setLayoutData(gridData_2);
        this.specialFlowComposite.setVisible(false);
        this.refFlowComposite = new Composite(stackComposite, 0);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.marginWidth = 0;
        gridLayout_2.marginHeight = 0;
        gridLayout_2.horizontalSpacing = 2;
        gridLayout_2.numColumns = 4;
        this.refFlowComposite.setLayout((Layout)gridLayout_2);
        Label label_3 = new Label(this.refFlowComposite, 0);
        label_3.setText(Messages.getString("TrxFlowPanel.MainFlowID__12"));
        this.mainFlowIDText = new Text(this.refFlowComposite, 2048);
        this.mainFlowIDText.setLayoutData((Object)new GridData(768));
        Button button = new Button(this.refFlowComposite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TrxStateMachinePanel.this.referToCommonStateMachine();
            }
        });
        button.setText(Messages.getString("TrxFlowPanel.select_13"));
        this.visualEditorContentViewer = new StateMachineViewer(this.refFlowComposite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        this.visualEditorContentViewer.setLayoutData(gridData);
        this.refFlowComposite.setVisible(true);
        this.stackLayout.topControl = this.specialFlowComposite;
    }

    public void dispose() {
        super.dispose();
        if (this.commonStates != null) {
            this.commonStates.removeContentChangedListener(this);
        }
    }

    protected void checkSubclass() {
    }

    public void setMainStateMachine(XMLNode stateMachine) {
        String machineId = stateMachine.getAttrValue("id");
        if (this.trxNode != null) {
            XMLNode node = this.trxNode.getChild("refStateMachine");
            if (node == null) {
                node = new XMLNode();
                node.setNodeName("refStateMachine");
                this.trxNode.add(node);
            }
            node.setAttrValue("refId", machineId);
        }
        this.mainFlowIDText.setText(machineId);
        try {
            this.visualEditorContentViewer.setXMLContent(stateMachine);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setActivateComposite(boolean showRefComposite) {
        if (showRefComposite) {
            this.refFlowComposite.setVisible(true);
            this.specialFlowComposite.setVisible(false);
            this.stackLayout.topControl = this.refFlowComposite;
        } else {
            this.refFlowComposite.setVisible(false);
            this.specialFlowComposite.setVisible(true);
            this.stackLayout.topControl = this.specialFlowComposite;
        }
        this.trxNode.setAttrValue("refToStateMachine", String.valueOf(showRefComposite));
    }

    private XMLNode selectStateMachine() {
        try {
            StateMachineSelectDialog dlg = new StateMachineSelectDialog(this.getShell());
            dlg.setStateMachineEditorProfile(this.stateMachineProfile);
            dlg.setStateEditorProfile(this.stateProfile);
            dlg.setCommonStates(this.commonStates);
            dlg.setCommonStateMachine(this.commonStateMachineNode);
            XMLNode StateMachine = (XMLNode)dlg.open();
            return StateMachine;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void referToCommonStateMachine() {
        XMLNode stateMachine = this.selectStateMachine();
        if (stateMachine != null) {
            this.setMainStateMachine(stateMachine);
        }
    }

    private void selectReferenceFlow() {
        XMLNode stateMachine = this.selectStateMachine();
        if (stateMachine != null) {
            XMLNode node = (XMLNode)stateMachine.clone();
            XMLNode flowNode = this.trxNode.getChild("StateMachine");
            if (flowNode == null) {
                this.trxNode.add(node);
            } else {
                this.trxNode.remove(flowNode);
                this.trxNode.add(node);
            }
            try {
                this.visualFramePanel.setXMLContent(node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setCommonServiceNode(XMLNode node) {
        this.commonSvcNode = node;
        this.visualFramePanel.setCommonServiceNode(node);
    }

    public void setSelfDefineNode(XMLNode node) {
        this.selfDefNode = node;
        this.visualFramePanel.setSelfDefineNode(node);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.visualFramePanel.setDataDictionary(node);
    }

    public void setExternResource(XMLNode value) {
        this.visualFramePanel.setExternResource(value);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
        this.visualFramePanel.setDataEditorProfile(profile);
    }

    private void setFlowImplementClass() {
        XMLNode flowNode = this.trxNode.getChild("flow");
        if (flowNode != null) {
            flowNode.setAttrValue("implClass", this.flowClassNameText.getText());
        }
    }

    private void selectFlowClass() {
        String result = SearchClass.selectClass(this.getShell());
        if (result != null) {
            this.flowClassNameText.setText(result);
            this.setFlowImplementClass();
        }
    }

    public void setStateEditorProfile(EditorProfile profile) {
        this.stateProfile = profile;
    }

    public void setCommonStates(XMLNode states) {
        this.commonStates = states;
        this.commonStates.addContentChangedListener(this, null, 0);
        this.visualFramePanel.setCommonStates(states);
        this.visualEditorContentViewer.setCommonStates(states);
        if (this.stateMachineProfile == null) {
            System.out.println("Please set the profile first!");
            return;
        }
        EditorProfile profile = (EditorProfile)this.stateMachineProfile.clone();
        Element processorElement = profile.getElement("StateMachine");
        if (processorElement == null) {
            System.out.println("Valid Profile file for common flow define!, Element StateMachine not defined!");
            return;
        }
        ElementCatalog catalog = null;
        int i = 0;
        while (i < profile.getCagalogs().size()) {
            ElementCatalog aCatalog = (ElementCatalog)profile.getCagalogs().elementAt(i);
            if ("commonStates".equals(aCatalog.getCatalogName())) {
                catalog = aCatalog;
                break;
            }
            ++i;
        }
        if (catalog == null) {
            System.out.println("Valid Profile file for common flow define!");
            return;
        }
        Element stateElement = catalog.getElement("virtualState");
        catalog.deleteElement(stateElement);
        this.stateAttrs = stateElement.getAttributes();
        Vector childs = states.getChilds();
        int i2 = 0;
        while (i2 < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i2);
            if (!"#text".equals(node.getNodeName())) {
                Element element = new Element();
                element.setElementName(node.getAttrValue("id"));
                element.setLabel(node.getAttrValue("name"));
                element.setIconName("/images/db_obj.gif");
                element.setWrapperClassType("com.ecc.ide.editor.statemachine.StateElementWrapper");
                String statesStr = node.getAttrValue("states");
                if (statesStr != null) {
                    Vector<Object> attrs;
                    ElementAttribute attr = new ElementAttribute();
                    attr.setAttrID("states");
                    attr.setValueListStr(statesStr);
                    if (this.stateAttrs != null) {
                        attrs = (Vector<Object>)this.stateAttrs.clone();
                        attrs.addElement(attr);
                        element.setAttributes(attrs);
                    } else {
                        attrs = new Vector<Object>(10);
                        attrs.addElement(attrs);
                        element.setAttributes(attrs);
                    }
                } else if (this.stateAttrs != null) {
                    element.setAttributes((Vector)this.stateAttrs.clone());
                }
                catalog.addElement(element);
                ElementChild child = new ElementChild();
                child.setChildElementId(element.getElementName());
                child.setAllowCount("1");
                processorElement.addChild(child);
            }
            ++i2;
        }
        ElementChild child = new ElementChild();
        child.setChildElementId("State");
        child.setAllowCount("*");
        processorElement.addChild(child);
        if (this.stateProfile != null) {
            EditorProfile profile1 = (EditorProfile)this.stateProfile.clone();
            int i3 = 0;
            while (i3 < profile1.getCagalogs().size()) {
                ElementCatalog aCatalog = (ElementCatalog)profile1.getCagalogs().elementAt(i3);
                if ("Flow".equals(aCatalog.getCatalogName())) {
                    aCatalog.deleteElement(aCatalog.getElement("transition"));
                    aCatalog.deleteElement(aCatalog.getElement("flow"));
                    aCatalog.getElement("State").setWrapperClassType("com.ecc.ide.editor.statemachine.StateElementWrapper");
                    aCatalog.setLabel("Self Defined State");
                }
                aCatalog.setShowInToolPanel(true);
                profile.addElementCatalog(aCatalog);
                ++i3;
            }
        }
        this.visualFramePanel.setEditorProfile(profile);
        this.visualEditorContentViewer.setEditorProfile(profile);
    }

    public void setCommonStateMachine(XMLNode node) {
        this.commonStateMachineNode = node;
    }

    public void setStateMachineEditorProfile(EditorProfile profile) {
        this.stateMachineProfile = profile;
    }

    public void updateCommonStates() {
        if (this.stateMachineProfile == null) {
            return;
        }
        EditorProfile newStateMachineProfile = (EditorProfile)this.stateMachineProfile.clone();
        Element processorElement = newStateMachineProfile.getElement("StateMachine");
        if (processorElement == null) {
            System.out.println("Valid Profile file for common flow define!, Element StateMachine not defined!");
            return;
        }
        ElementCatalog catalog = null;
        int i = 0;
        while (i < newStateMachineProfile.getCagalogs().size()) {
            ElementCatalog aCatalog = (ElementCatalog)newStateMachineProfile.getCagalogs().elementAt(i);
            if ("commonStates".equals(aCatalog.getCatalogName())) {
                catalog = aCatalog;
                break;
            }
            ++i;
        }
        if (catalog == null) {
            System.out.println("Valid Profile file for common flow define!");
            return;
        }
        Element stateElement = catalog.getElement("virtualState");
        catalog.deleteElement(stateElement);
        this.stateAttrs = stateElement.getAttributes();
        Vector childs = this.commonStates.getChilds();
        int i2 = 0;
        while (i2 < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i2);
            if (!"#text".equals(node.getNodeName())) {
                Element element = new Element();
                element.setElementName(node.getAttrValue("id"));
                element.setLabel(node.getAttrValue("name"));
                element.setIconName("/images/db_obj.gif");
                element.setWrapperClassType("com.ecc.ide.editor.statemachine.StateElementWrapper");
                String statesStr = node.getAttrValue("states");
                if (statesStr != null) {
                    Vector<Object> attrs;
                    ElementAttribute attr = new ElementAttribute();
                    attr.setAttrID("states");
                    attr.setValueListStr(statesStr);
                    if (this.stateAttrs != null) {
                        attrs = (Vector<Object>)this.stateAttrs.clone();
                        attrs.addElement(attr);
                        element.setAttributes(attrs);
                    } else {
                        attrs = new Vector<Object>(10);
                        attrs.addElement(attrs);
                        element.setAttributes(attrs);
                    }
                } else if (this.stateAttrs != null) {
                    element.setAttributes((Vector)this.stateAttrs.clone());
                }
                catalog.addElement(element);
                ElementChild child = new ElementChild();
                child.setChildElementId(element.getElementName());
                child.setAllowCount("1");
                processorElement.addChild(child);
            }
            ++i2;
        }
        ElementChild child = new ElementChild();
        child.setChildElementId("State");
        child.setAllowCount("*");
        processorElement.addChild(child);
        if (this.stateProfile != null) {
            EditorProfile profile = (EditorProfile)this.stateProfile.clone();
            int i3 = 0;
            while (i3 < profile.getCagalogs().size()) {
                ElementCatalog aCatalog = (ElementCatalog)profile.getCagalogs().elementAt(i3);
                if ("Flow".equals(aCatalog.getCatalogName())) {
                    aCatalog.deleteElement(aCatalog.getElement("transition"));
                    aCatalog.deleteElement(aCatalog.getElement("flow"));
                    aCatalog.getElement("State").setWrapperClassType("com.ecc.ide.editor.statemachine.StateElementWrapper");
                    aCatalog.setLabel("Self Defined State");
                }
                aCatalog.setShowInToolPanel(true);
                newStateMachineProfile.addElementCatalog(aCatalog);
                ++i3;
            }
        }
        this.visualFramePanel.setEditorProfile(newStateMachineProfile);
        this.visualEditorContentViewer.setEditorProfile(newStateMachineProfile);
        this.setTrxNode(this.trxNode);
    }

    private void maximizedEdit() {
        Shell parent = this.getShell();
        Shell shell = new Shell(parent, 67696);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Visual Editor");
        StateMachineVisualPanel visualFramePanel = new StateMachineVisualPanel((Composite)shell, 0);
        visualFramePanel.setEditorProfile(this.visualFramePanel.getEditorProfile());
        visualFramePanel.setDataEditorProfile(this.dataEditorProfile);
        visualFramePanel.setDataDictionary(this.dataDictionary);
        visualFramePanel.setSelfDefineNode(this.selfDefNode);
        visualFramePanel.setCommonServiceNode(this.commonSvcNode);
        XMLNode flowNode = this.trxNode.getChild("flow");
        if (flowNode == null) {
            flowNode = new XMLNode();
            flowNode.setNodeName("flow");
            this.trxNode.add(flowNode);
        }
        try {
            visualFramePanel.setXMLContent(flowNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle rect = shell.getDisplay().getBounds();
        shell.setBounds(rect);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        try {
            this.visualFramePanel.setXMLContent(flowNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void contentChanged(ContentChangedEvent event) {
        this.isCommonChanged = true;
    }

    public void editorFocusGained() {
        if (this.isCommonChanged) {
            this.updateCommonStates();
            this.isCommonChanged = false;
        }
    }
}

