/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.teller.msr;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.flow.Messages;
import com.ecc.ide.editor.transaction.DataProvider;
import com.ecc.ide.editor.xml.XMLEditorFramePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TellerMSRDefinePanel
extends Composite {
    private Table table;
    private Text msrIdText;
    private Text msrNameText;
    private Text descText;
    int[] weights;
    private XMLEditorFramePanel visualViewPanel;
    private EditorProfile editorProfile;
    private XMLNode contentNode;
    private XMLNode curmsrNode;
    private String rootPath;
    private XMLNode dataDictionary;
    private XMLNode patternNode;
    private XMLNode functionNode;
    private XMLNode taskNode;
    private DataProvider dataProvider;
    private BuildProblemReporter reporter;

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.visualViewPanel.setDataDictionary(node);
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.visualViewPanel.setDataEditorProfile(profile);
    }

    public void setViewEditorProfile(EditorProfile profile) {
        this.editorProfile = profile;
        this.visualViewPanel.setEditorProfile(profile);
    }

    public TellerMSRDefinePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)this, 0);
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout);
        Label label = new Label(composite_1, 0);
        label.setText(Messages.getString("TellerMSRDefinePanel.MSRID"));
        this.msrIdText = new Text(composite_1, 2048);
        GridData gridData_9 = new GridData(768);
        gridData_9.horizontalSpan = 3;
        this.msrIdText.setLayoutData((Object)gridData_9);
        Label label_2 = new Label(composite_1, 0);
        label_2.setText(Messages.getString("TellerMSRDefinePanel.MSRName"));
        this.msrNameText = new Text(composite_1, 2048);
        GridData gridData_10 = new GridData(768);
        gridData_10.horizontalSpan = 3;
        this.msrNameText.setLayoutData((Object)gridData_10);
        Label label_3 = new Label(composite_1, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 4;
        label_3.setLayoutData((Object)gridData_1);
        label_3.setText(Messages.getString("TellerViewDefinePanel.Document__6"));
        this.descText = new Text(composite_1, 2818);
        GridData gridData_2 = new GridData(768);
        gridData_2.heightHint = 50;
        gridData_2.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_2);
        Composite composite_2 = new Composite(composite_1, 0);
        GridData gridData_3 = new GridData(256);
        gridData_3.horizontalSpan = 4;
        composite_2.setLayoutData((Object)gridData_3);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_1);
        Button button_1 = new Button(composite_2, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerMSRDefinePanel.this.createNewmsr();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("TellerViewDefinePanel.Create_7"));
        Button button_2 = new Button(composite_2, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerMSRDefinePanel.this.deleteCurrentmsr();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 80;
        button_2.setLayoutData((Object)gridData_5);
        button_2.setText(Messages.getString("TellerViewDefinePanel.Delete_8"));
        Button button_3 = new Button(composite_2, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerMSRDefinePanel.this.updateCurrentmsr();
            }
        });
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 80;
        button_3.setLayoutData((Object)gridData_6);
        button_3.setText(Messages.getString("TellerViewDefinePanel.Update_1"));
        this.table = new Table(composite_1, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TellerMSRDefinePanel.this.setActivateView();
            }
        });
        GridData gridData_7 = new GridData(1808);
        gridData_7.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData_7);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(63);
        tableColumn.setText(Messages.getString("TellerMSRDefinePanel.MSRID1"));
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(79);
        tableColumn_1.setText(Messages.getString("TellerMSRDefinePanel.MSRName1"));
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(280);
        tableColumn_3.setText(Messages.getString("TellerViewDefinePanel.Document_11"));
        this.visualViewPanel = new XMLEditorFramePanel((Composite)sashForm, 0);
        this.weights = new int[2];
        this.weights[0] = 1;
        this.weights[1] = 4;
        sashForm.setWeights(this.weights);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setXMLContent(XMLNode node) {
        this.contentNode = node;
        this.table.removeAll();
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode msrNode = (XMLNode)childs.elementAt(i);
            if (!"#text".equals(msrNode.getNodeName())) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(msrNode.getAttrValue("id"));
                item.setData((Object)msrNode);
                if (msrNode.getAttrValue("message") != null) {
                    item.setText(1, msrNode.getAttrValue("message"));
                }
                if (msrNode.getDocument() != null) {
                    item.setText(2, msrNode.getDocument());
                }
            }
            ++i;
        }
        if (childs.size() > 0) {
            this.table.setSelection(0);
            this.setActivateView();
        }
    }

    private void createNewmsr() {
        String msrId = this.msrIdText.getText();
        if (!this.checkmsrName(msrId)) {
            return;
        }
        if (this.contentNode.getChilds() != null && this.contentNode.findChildNode(msrId) != null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"warrning", (String)Messages.getString("TellerMSRDefinePanel.duplicatedIDInfo"));
            return;
        }
        XMLNode msrNode = new XMLNode("Msr");
        msrNode.setAttrValue("id", msrId);
        msrNode.setAttrValue("message", this.msrNameText.getText());
        msrNode.setDocument(this.descText.getText());
        this.contentNode.add(msrNode);
        TableItem item = new TableItem(this.table, 0);
        item.setText(msrId);
        item.setText(1, this.msrNameText.getText());
        item.setText(2, this.descText.getText());
        item.setData((Object)msrNode);
    }

    private void setActivateView() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        if (this.curmsrNode == node) {
            return;
        }
        try {
            this.visualViewPanel.setXMLContent(node);
            this.curmsrNode = node;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.msrIdText.setText(node.getAttrValue("id"));
        if (node.getAttrValue("message") != null) {
            this.msrNameText.setText(node.getAttrValue("message"));
        } else {
            this.msrNameText.setText("");
        }
        if (node.getDocument() != null) {
            this.descText.setText(node.getDocument());
        } else {
            this.descText.setText("");
        }
    }

    private void updateCurrentmsr() {
        TableItem[] selects = this.table.getSelection();
        if (selects.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)selects[0].getData();
        String msrId = this.msrIdText.getText();
        if (!this.checkmsrName(msrId)) {
            return;
        }
        XMLNode aNode = this.contentNode.findChildNode(msrId);
        if (aNode != null && aNode != node) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"warrning", (String)Messages.getString("TellerMSRDefinePanel.duplicatedIDInfo"));
            return;
        }
        node.setAttrValue("id", msrId);
        node.setAttrValue("message", this.msrNameText.getText());
        node.setDocument(this.descText.getText());
        selects[0].setText(msrId);
        selects[0].setText(1, this.msrNameText.getText());
        selects[0].setText(2, this.descText.getText());
    }

    private void deleteCurrentmsr() {
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("TellerMSRDefinePanel.sureToInfo"), (String)Messages.getString("TellerMSRDefinePanel.deleteInfo"))) {
            XMLNode viewNode = (XMLNode)items[0].getData();
            this.contentNode.remove(viewNode);
            items[0].dispose();
            if (this.table.getItemCount() > 0) {
                this.table.setSelection(0);
                this.setActivateView();
            } else {
                try {
                    this.visualViewPanel.setXMLContent(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setProblemReporter(BuildProblemReporter reporter) {
        this.reporter = reporter;
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (this.reporter != null) {
            this.reporter.reportProblem(type, msg, location, fileName, e);
        } else {
            System.out.println("[" + type + "]" + msg + ":" + location);
        }
    }

    public String getSelectedMSRId() {
        if (this.curmsrNode != null) {
            return this.curmsrNode.getAttrValue("id");
        }
        return null;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
        this.visualViewPanel.setRootPath(path);
    }

    private boolean checkmsrName(String name) {
        if (name.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("TellerViewDefinePanel.Warning_18"), (String)Messages.getString("TellerMSRDefinePanel.MSRIdInfo"));
            return false;
        }
        return true;
    }
}

