/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.teller.passbook;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.teller.passbook.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.math.BigDecimal;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class PassbookWrapper
extends VisualElementWrapper {
    private VisualElementWrapper activateColumn;
    private static int MARGIN = 35;

    public PassbookWrapper() {
    }

    public PassbookWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        Color bkColor = gc.getBackground();
        int topMargin = this.getIntValueByResolution(this.getXMLNode(), "topMargin", 1);
        int leftMargin = this.getIntValueByResolution(this.getXMLNode(), "leftMargin", 0);
        int buttonMargin = this.getIntValueByResolution(this.getXMLNode(), "bottomMargin", 1);
        int rightMargin = this.getIntValueByResolution(this.getXMLNode(), "rightMargin", 0);
        int midMargin = this.getIntValueByResolution(this.getXMLNode(), "midMargin", 0);
        int yOff = (this.height - 3 * MARGIN) / 3 + 2 * MARGIN;
        gc.drawText(Messages.getString("PassbookWrapper.cover"), x + MARGIN, y + MARGIN - 25);
        gc.drawText(Messages.getString("PassbookWrapper.passbookLine"), x + MARGIN, y + yOff - 25);
        gc.drawRectangle(x + MARGIN, y + yOff, this.width - 2 * MARGIN, 2 * (this.height - 3 * MARGIN) / 3);
        gc.drawLine(x + MARGIN, y + yOff + (this.height - 3 * MARGIN) / 3, x + this.width - MARGIN, y + yOff + (this.height - 3 * MARGIN) / 3);
        int pageLineNum = this.getXMLNode().getIntAttrValue("pageLineNum");
        if (pageLineNum == 0) {
            pageLineNum = 10;
        }
        int pageHeight = (this.height - 3 * MARGIN) / 3;
        int lineHeight = ((this.height - 3 * MARGIN) / 3 - topMargin - midMargin / 2) / pageLineNum;
        gc.setLineStyle(3);
        int i = 0;
        while (i < pageLineNum) {
            gc.drawLine(x + MARGIN + leftMargin, y + yOff + i * lineHeight + topMargin, x + this.width - MARGIN - rightMargin, y + yOff + i * lineHeight + topMargin);
            gc.drawLine(x + MARGIN + leftMargin, y + yOff + pageHeight + midMargin + i * lineHeight, x + this.width - MARGIN - rightMargin, y + yOff + pageHeight + midMargin + i * lineHeight);
            ++i;
        }
        gc.setLineStyle(1);
        i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i);
            aChild.paintControl(gc, x, y);
            ++i;
        }
        gc.setClipping(clipRect);
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        gc.setClipping(parentClipRect);
    }

    public boolean getIsCanSetTabOrder() {
        return false;
    }

    public void setBounds(int x, int y, int width, int height) {
        int x1 = this.x;
        int y1 = this.y;
        int w1 = this.width;
        int h1 = this.height;
        Rectangle rec = new Rectangle(0, 0, 10, 10);
        if (this.getParentWrapper() != null) {
            Rectangle rec1 = this.getParentWrapper().getRectangle();
            rec.x = rec1.x;
            rec.y = rec1.y;
        }
        this.x = x - rec.x;
        this.y = y - rec.y;
        this.width = width;
        this.height = height;
        int pageHeight = (height - 3 * MARGIN) / 3;
        int pageWidth = width - 2 * MARGIN;
        if (x1 == this.x && y1 == this.y && h1 == this.height && w1 == this.width) {
            return;
        }
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            XMLNode node = wrapper.getXMLNode();
            if ("PassbookCover".equals(node.getNodeName())) {
                wrapper.setBounds(x + MARGIN, y + MARGIN, width - 2 * MARGIN, (height - 3 * MARGIN) / 3);
            } else if ("PassbookLine".equals(node.getNodeName())) {
                int topMargin = this.getIntValueByResolution(this.getXMLNode(), "topMargin", 1);
                int leftMargin = this.getIntValueByResolution(this.getXMLNode(), "leftMargin", 0);
                int buttonMargin = this.getIntValueByResolution(this.getXMLNode(), "bottomMargin", 1);
                int rightMargin = this.getIntValueByResolution(this.getXMLNode(), "rightMargin", 0);
                int midMargin = this.getIntValueByResolution(this.getXMLNode(), "midMargin", 0);
                int pageLineNum = this.getXMLNode().getIntAttrValue("pageLineNum");
                if (pageLineNum == 0) {
                    pageLineNum = 10;
                }
                int lineHeight = ((height - 3 * MARGIN) / 3 - topMargin - midMargin / 2) / pageLineNum;
                int yOff = (height - 3 * MARGIN) / 3 + 2 * MARGIN;
                wrapper.setBounds(x + MARGIN + leftMargin, y + yOff + topMargin, width - 2 * MARGIN - leftMargin - rightMargin, lineHeight);
            }
            ++i;
        }
        this.node.setAttrValue("x", String.valueOf(this.x));
        this.node.setAttrValue("y", String.valueOf(this.y));
        this.node.setAttrValue("width", String.valueOf(width));
        this.node.setAttrValue("height", String.valueOf(height));
        double h = (double)pageHeight / this.editor.getYResolution();
        double w = (double)pageWidth / this.editor.getXResolution();
        BigDecimal bdH = new BigDecimal(h);
        bdH = bdH.setScale(2, 4);
        BigDecimal bdW = new BigDecimal(w);
        bdW = bdW.setScale(2, 4);
        this.node.setAttrValue("pageHeight", bdH.toString());
        this.node.setAttrValue("pageWidth", bdW.toString());
    }

    public void setAttrValue(String key, Object value) {
        if ("pageHeight".equals(key)) {
            double h = Float.parseFloat(value.toString());
            h = 3.0 * h * this.editor.getYResolution() + (double)(3 * MARGIN);
            this.setBounds(this.x, this.y, this.width, (int)h);
        } else if ("pageWidth".equals(key)) {
            this.editor.getXResolution();
            double w = Float.parseFloat(value.toString());
            w = w * this.editor.getXResolution() + (double)(2 * MARGIN);
            this.setBounds(this.x, this.y, (int)w, this.height);
        } else {
            super.setAttrValue(key, value);
        }
    }

    public void addChild(VisualElementWrapper child) {
        super.addChild(child);
        child.setMoveable(false);
        child.setResizable(false);
    }

    public int getIntValueByResolution(XMLNode node, String attrName, int dir) {
        double dValue;
        String attrValue = node.getAttrValue(attrName);
        if (attrValue == null) {
            return 0;
        }
        try {
            dValue = Float.parseFloat(attrValue);
        }
        catch (Exception e) {
            return 0;
        }
        if (dir == 0) {
            return (int)(dValue * this.editor.getXResolution());
        }
        return (int)(dValue * this.editor.getYResolution());
    }
}

